/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.expressao.parser;

import jalis.util.expressao.parser.Arvore;
import jalis.util.expressao.parser.ExpressaoException;
import jalis.util.expressao.parser.Lexico;
import jalis.util.expressao.parser.Token;
import java.util.ArrayList;

public class Sintatico {
    private Lexico lex;
    private Token tok;
    private ArrayList<String> identificadores = null;

    public Arvore analisar(String expressao) throws ExpressaoException {
        this.identificadores = new ArrayList();
        Arvore arvore = null;
        this.lex = new Lexico(expressao, 8);
        this.tok = null;
        this.proximoToken();
        arvore = this.analisarInstrucao();
        this.aceitar(34);
        return arvore;
    }

    public Arvore analisarCondicao(String expressao) throws ExpressaoException {
        this.identificadores = new ArrayList();
        Arvore arvore = null;
        this.lex = new Lexico(expressao, 8);
        this.tok = null;
        this.proximoToken();
        arvore = this.analisarInstrucao();
        return arvore;
    }

    public ArrayList<String> getIdentificadores() {
        return this.identificadores;
    }

    private Arvore analisarInstrucao() {
        int pos = this.tok.pos;
        Arvore arvore = this.analisarFator();
        if (this.tok.operadorMatematico()) {
            Arvore esq = arvore;
            int op = this.tok.id;
            this.proximoToken();
            this.validarTermo();
            Arvore dir = this.analisarFator();
            while (this.tok.operadorMatematico()) {
                esq = new Arvore.Operacao(pos, esq, dir, op);
                op = this.tok.id;
                this.proximoToken();
                this.validarTermo();
                dir = this.analisarFator();
            }
            arvore = new Arvore.Operacao(pos, esq, dir, op);
        }
        return arvore;
    }

    private Arvore analisarFator() {
        Arvore arvore = null;
        if (this.tok.id == 34) {
            arvore = new Arvore.Nulo();
        } else if (this.tok.id == 0) {
            this.identificadores.add(this.tok.lexema);
            arvore = new Arvore.Ident(this.tok.pos, this.tok.lexema);
            this.proximoToken();
        } else if (this.tok.literal()) {
            arvore = new Arvore.Literal(this.tok.pos, this.tok.instancia());
            this.proximoToken();
        } else if (this.tok.id == 21) {
            this.proximoToken();
            arvore = this.analisarInstrucao();
            this.aceitar(22);
        } else if (this.tok.id == 7) {
            arvore = this.analisarSe();
        } else if (this.tok.id == 8) {
            arvore = this.analisarCopia();
        } else if (this.tok.id == 9) {
            arvore = this.analisarVazio();
        } else if (this.tok.id == 10) {
            arvore = this.analisarZero();
        } else if (this.tok.id == 11) {
            arvore = this.analisarData();
        } else if (this.tok.id == 12) {
            arvore = this.analisarExtenso();
        } else if (this.tok.id == 13) {
            arvore = this.analisarNumero();
        } else if (this.tok.id == 14) {
            arvore = this.analisarSomaData();
        } else if (this.tok.id == 15) {
            arvore = this.analisarTamanho();
        } else if (this.tok.id == 16) {
            arvore = this.analisarSomatorio();
        } else if (this.tok.id == 37) {
            arvore = this.analisarSomatorioAvancado();
        } else if (this.tok.id == 17) {
            arvore = this.analisarMedia();
        } else if (this.tok.id == 18) {
            arvore = this.analisarContem();
        } else if (this.tok.id == 35) {
            arvore = this.analisarCaracter();
        } else if (this.tok.id == 36) {
            arvore = this.analisarCaracterESC();
        }
        return arvore;
    }

    private Arvore analisarSe() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore cond = this.analisarLogico();
        this.aceitar(33);
        Arvore exp1 = this.analisarInstrucao();
        this.aceitar(33);
        Arvore exp2 = this.analisarInstrucao();
        this.aceitar(22);
        return new Arvore.Se(pos, cond, exp1, exp2);
    }

    private Arvore analisarCopia() {
        int posicao = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore exp = this.analisarInstrucao();
        this.aceitar(33);
        Arvore pos = this.analisarInstrucao();
        this.aceitar(33);
        Arvore qtde = this.analisarInstrucao();
        this.aceitar(22);
        return new Arvore.Copia(posicao, exp, pos, qtde);
    }

    private Arvore analisarVazio() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore exp = this.analisarInstrucao();
        this.aceitar(33);
        Arvore tam = this.analisarInstrucao();
        this.aceitar(33);
        Token alin = this.tok;
        this.aceitar(2);
        this.aceitar(22);
        return new Arvore.Vazio(pos, exp, tam, alin.instancia().toString().charAt(0));
    }

    private Arvore analisarZero() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore exp = this.analisarInstrucao();
        this.aceitar(33);
        Arvore tam = this.analisarInstrucao();
        this.aceitar(22);
        return new Arvore.Zero(pos, exp, tam);
    }

    private Arvore analisarData() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore exp = this.analisarInstrucao();
        this.aceitar(33);
        Token masc = this.tok;
        this.aceitar(1);
        this.aceitar(22);
        return new Arvore.Data(pos, exp, masc.instancia().toString());
    }

    private Arvore analisarExtenso() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore exp = this.analisarInstrucao();
        this.aceitar(22);
        return new Arvore.Extenso(pos, exp);
    }

    private Arvore analisarNumero() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore exp = this.analisarInstrucao();
        this.aceitar(33);
        Token masc = this.tok;
        this.aceitar(1);
        this.aceitar(22);
        return new Arvore.Numero(pos, exp, masc.instancia().toString());
    }

    private Arvore analisarSomaData() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore exp = this.analisarInstrucao();
        this.aceitar(33);
        Arvore dias = this.analisarInstrucao();
        this.aceitar(22);
        return new Arvore.SomaData(pos, exp, dias);
    }

    private Arvore analisarTamanho() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore exp = this.analisarInstrucao();
        this.aceitar(22);
        return new Arvore.Tamanho(pos, exp);
    }

    private Arvore analisarSomatorio() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Token campo = this.tok;
        this.identificadores.add(campo.lexema);
        this.aceitar(0);
        this.aceitar(22);
        return new Arvore.Somatorio(pos, campo.lexema);
    }

    private Arvore analisarSomatorioAvancado() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Token campo = this.tok;
        this.identificadores.add(campo.lexema);
        this.aceitar(0);
        this.aceitar(33);
        Token casas = this.tok;
        this.aceitar(4);
        this.aceitar(22);
        return new Arvore.SomatorioAvancado(pos, campo.lexema, Integer.parseInt(casas.lexema));
    }

    private Arvore analisarCaracterESC() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Token campo = this.tok;
        this.identificadores.add(campo.lexema);
        this.aceitar(1);
        this.aceitar(22);
        return new Arvore.CaracterESC(pos, campo.lexema);
    }

    private Arvore analisarCaracter() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Token campo = this.tok;
        this.identificadores.add(campo.lexema);
        this.aceitar(4);
        this.aceitar(22);
        return new Arvore.Caracter(pos, campo.lexema);
    }

    private Arvore analisarMedia() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Token campo = this.tok;
        this.aceitar(0);
        this.aceitar(22);
        return new Arvore.Media(pos, campo.lexema);
    }

    private Arvore analisarContem() {
        int pos = this.tok.pos;
        this.proximoToken();
        this.aceitar(21);
        Arvore exp = this.analisarInstrucao();
        this.aceitar(33);
        Token item = this.tok;
        this.aceitar(1);
        this.aceitar(22);
        return new Arvore.Contem(pos, exp, item.instancia().toString());
    }

    private Arvore analisarLogico() {
        int pos = this.tok.pos;
        Arvore arvore = this.analisarRelacional();
        if (this.tok.operadorLogico()) {
            Arvore esq = arvore;
            int op = this.tok.id;
            this.proximoToken();
            this.validarTermo();
            Arvore dir = this.analisarRelacional();
            while (this.tok.operadorLogico()) {
                esq = new Arvore.Operacao(pos, esq, dir, op);
                op = this.tok.id;
                this.proximoToken();
                this.validarTermo();
                dir = this.analisarRelacional();
            }
            arvore = new Arvore.Operacao(pos, esq, dir, op);
        }
        return arvore;
    }

    private Arvore analisarRelacional() {
        int pos = this.tok.pos;
        Arvore arvore = this.analisarInstrucao();
        if (!this.tok.operadorRelacional()) {
            throw new ExpressaoException("Erro: Operador relacional esperado.", this.tok.pos);
        }
        Arvore esq = arvore;
        int op = this.tok.id;
        this.proximoToken();
        this.validarTermo();
        Arvore dir = this.analisarInstrucao();
        while (this.tok.operadorRelacional()) {
            esq = new Arvore.Operacao(pos, esq, dir, op);
            op = this.tok.id;
            this.proximoToken();
            this.validarTermo();
            dir = this.analisarInstrucao();
        }
        arvore = new Arvore.Operacao(pos, esq, dir, op);
        return arvore;
    }

    private void aceitar(int token) {
        if (this.tok.id == token) {
            if (token != 34) {
                this.proximoToken();
            }
        } else {
            if (token == 34) {
                throw new ExpressaoException("Erro: Operador aritm\u00e9tico esperado.", this.tok.pos);
            }
            throw new ExpressaoException("Erro: \"" + Token.getIdStr(token) + "\" esperado.", this.tok.pos);
        }
    }

    private void proximoToken() {
        if (this.tok != null && this.tok.id == 34) {
            throw new ExpressaoException("Campo, Texto, N\u00famero, Fun\u00e7\u00e3o ou '(' esperado", this.tok.pos);
        }
        this.tok = this.lex.getProxToken();
    }

    private void validarTermo() {
        if (this.tok.id == 34 || this.tok.id != 0 && !this.tok.literal() && !this.tok.funcao() && this.tok.id != 21) {
            throw new ExpressaoException("Campo, Texto, N\u00famero, Fun\u00e7\u00e3o ou '(' esperado", this.tok.pos);
        }
    }
}

