/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.expressao.parser;

import jalis.util.expressao.parser.Token;

public class Lexico {
    private static final int q0 = 0;
    private static final int q1 = 1;
    private static final int q2 = 2;
    private static final int q3 = 3;
    private static final int q4 = 4;
    private static final int q5 = 5;
    private static final int q6 = 6;
    private static final int q7 = 7;
    private static final int q8 = 8;
    private static final int q9 = 9;
    private static final int q10 = 10;
    private static final int q11 = 11;
    private static final int q12 = 12;
    private static final int q13 = 13;
    private static final int q14 = 14;
    private static final int q15 = 15;
    private static final int q16 = 16;
    private static final int q17 = 17;
    private static final int q18 = 18;
    private static final int q19 = 19;
    private static final int q20 = 20;
    private static final int q21 = 21;
    private static final int q22 = 22;
    private static final int q23 = 23;
    private static final int q24 = 24;
    private static final int q25 = 25;
    private static final int q26 = 26;
    private static final int q27 = 27;
    private static final int q28 = 28;
    private static final int q29 = 29;
    private char[] exp;
    private int pos = 0;
    private int estado;
    private boolean erro;
    private String erroDesc;
    private int tamTab;

    public Lexico(String exp, int tamTab) {
        this.exp = exp.toCharArray();
        this.tamTab = tamTab;
    }

    public Token getProxToken() {
        char ch;
        String lex = "";
        this.estado = 0;
        this.erro = false;
        while (Character.isWhitespace(ch = this.getChar())) {
        }
        int posicao = this.pos;
        while (!this.estadoFinal() && !this.erro) {
            this.automato(ch);
            if (this.erro) continue;
            if (!this.estadoEspecial() && ch != '\u0000') {
                lex = lex + ch;
            }
            if (this.estadoFinal()) continue;
            ch = this.getChar();
        }
        if (this.estadoEspecial() && ch != '\u0000') {
            this.recuar();
        }
        Token tok = new Token();
        if (this.estado == 29) {
            tok.id = 34;
            tok.pos = posicao;
        } else {
            if (this.erro) {
                tok.erro = this.erro;
                tok.tipoErro = 0;
                tok.erroDesc = this.erroDesc;
            }
            tok.id = this.getId(lex);
            tok.lexema = lex;
            tok.pos = posicao - 1;
        }
        return tok;
    }

    private void automato(char ch) {
        switch (this.estado) {
            case 0: {
                if (Character.isLetter(ch) || ch == '_') {
                    this.estado = 1;
                    break;
                }
                if (ch == '\"') {
                    this.estado = 3;
                    break;
                }
                if (ch == '\'') {
                    this.estado = 6;
                    break;
                }
                if (Character.isDigit(ch)) {
                    this.estado = 9;
                    break;
                }
                if (ch == '(') {
                    this.estado = 14;
                    break;
                }
                if (ch == ')') {
                    this.estado = 15;
                    break;
                }
                if (ch == '+') {
                    this.estado = 16;
                    break;
                }
                if (ch == '-') {
                    this.estado = 17;
                    break;
                }
                if (ch == '*') {
                    this.estado = 18;
                    break;
                }
                if (ch == '/') {
                    this.estado = 19;
                    break;
                }
                if (ch == ';') {
                    this.estado = 20;
                    break;
                }
                if (ch == '=') {
                    this.estado = 21;
                    break;
                }
                if (ch == '>') {
                    this.estado = 22;
                    break;
                }
                if (ch == '<') {
                    this.estado = 25;
                    break;
                }
                if (ch == '\u0000') {
                    this.estado = 29;
                    break;
                }
                this.erro = true;
                this.erroDesc = "Caractere inv\u00e1lido";
                break;
            }
            case 1: {
                if (Character.isLetterOrDigit(ch) || ch == '_') break;
                this.estado = 2;
                break;
            }
            case 3: {
                if (ch == '\"') {
                    this.estado = 5;
                    break;
                }
                if (ch == '\u0000') {
                    this.erro = true;
                    this.erroDesc = "Texto n\u00e3o terminado";
                    break;
                }
                this.estado = 4;
                break;
            }
            case 4: {
                if (ch == '\"') {
                    this.estado = 5;
                    break;
                }
                if (ch != '\u0000') break;
                this.erro = true;
                this.erroDesc = "Texto n\u00e3o terminado";
                break;
            }
            case 6: {
                if (ch == '\u0000') {
                    this.erro = true;
                    this.erroDesc = "Caractere n\u00e3o terminado";
                    break;
                }
                this.estado = 7;
                break;
            }
            case 7: {
                if (ch == '\'') {
                    this.estado = 8;
                    break;
                }
                this.erro = true;
                this.erroDesc = "";
                break;
            }
            case 9: {
                if (ch == ',') {
                    this.estado = 10;
                    break;
                }
                if (Character.isDigit(ch)) break;
                this.estado = 13;
                break;
            }
            case 10: {
                if (Character.isDigit(ch)) {
                    this.estado = 11;
                    break;
                }
                this.erro = true;
                this.erroDesc = "N\u00famero decimal inv\u00e1lido";
                break;
            }
            case 11: {
                if (Character.isDigit(ch)) break;
                this.estado = 12;
                break;
            }
            case 22: {
                if (ch == '=') {
                    this.estado = 24;
                    break;
                }
                this.estado = 23;
                break;
            }
            case 25: {
                this.estado = ch == '=' ? 27 : (ch == '>' ? 28 : 26);
            }
        }
    }

    private boolean estadoFinal() {
        switch (this.estado) {
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    private boolean estadoEspecial() {
        switch (this.estado) {
            case 2: 
            case 12: 
            case 13: 
            case 23: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    private int getId(String lex) {
        switch (this.estado) {
            case 2: {
                return this.lexParaId(lex);
            }
            case 5: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 12: {
                return 3;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 21;
            }
            case 15: {
                return 22;
            }
            case 16: {
                return 32;
            }
            case 17: {
                return 31;
            }
            case 18: {
                return 29;
            }
            case 19: {
                return 30;
            }
            case 20: {
                return 33;
            }
            case 21: {
                return 27;
            }
            case 23: {
                return 24;
            }
            case 24: {
                return 26;
            }
            case 26: {
                return 23;
            }
            case 27: {
                return 25;
            }
            case 28: {
                return 28;
            }
            case 29: {
                return 34;
            }
        }
        return -1;
    }

    private int lexParaId(String lex) {
        if (lex.equalsIgnoreCase("se")) {
            return 7;
        }
        if (lex.equalsIgnoreCase("copia")) {
            return 8;
        }
        if (lex.equalsIgnoreCase("vazio")) {
            return 9;
        }
        if (lex.equalsIgnoreCase("zero")) {
            return 10;
        }
        if (lex.equalsIgnoreCase("data")) {
            return 11;
        }
        if (lex.equalsIgnoreCase("extenso")) {
            return 12;
        }
        if (lex.equalsIgnoreCase("numero")) {
            return 13;
        }
        if (lex.equalsIgnoreCase("somadata")) {
            return 14;
        }
        if (lex.equalsIgnoreCase("tamanho")) {
            return 15;
        }
        if (lex.equalsIgnoreCase("somatorio")) {
            return 16;
        }
        if (lex.equalsIgnoreCase("somatorioavancado")) {
            return 37;
        }
        if (lex.equalsIgnoreCase("media")) {
            return 17;
        }
        if (lex.equalsIgnoreCase("contem")) {
            return 18;
        }
        if (lex.equalsIgnoreCase("caracter")) {
            return 35;
        }
        if (lex.equalsIgnoreCase("caracteresc")) {
            return 36;
        }
        if (lex.equalsIgnoreCase("verdadeiro") || lex.equalsIgnoreCase("true") || lex.equalsIgnoreCase("verdade")) {
            return 5;
        }
        if (lex.equalsIgnoreCase("falso") || lex.equalsIgnoreCase("false")) {
            return 6;
        }
        if (lex.equalsIgnoreCase("e")) {
            return 19;
        }
        if (lex.equalsIgnoreCase("ou")) {
            return 20;
        }
        return 0;
    }

    private char getChar() {
        char ch = '\u0000';
        if (this.pos < this.exp.length) {
            ch = this.exp[this.pos++];
        }
        return ch;
    }

    private void recuar() {
        if (this.pos >= 0) {
            --this.pos;
        }
    }
}

