/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.expressao.parser;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.Arvore;
import jalis.util.expressao.parser.ExpUtil;
import jalis.util.expressao.parser.ExpressaoException;
import jalis.util.expressao.parser.Sintatico;
import jalis.util.expressao.parser.Visitor;
import jalis.util.impressao.matricial.CharImpressao;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Interpretador
implements Visitor {
    private Object[] campoValor = new Object[0];

    public void setCampos(Object[] campos) {
        if (campos != null && campos.length % 2 == 0) {
            this.campoValor = campos;
        }
    }

    public Object resolver(String expressao) throws ExpressaoException {
        Sintatico s = new Sintatico();
        Arvore exp = s.analisar(expressao);
        this.visitar(exp);
        return this.valor(exp);
    }

    public Arvore resolverCondicao(String condicao) throws ExpressaoException {
        Sintatico s = new Sintatico();
        Arvore exp = s.analisarCondicao(condicao);
        this.visitar(exp);
        return exp;
    }

    @Override
    public void visitarContem(Arvore.Contem arvore) {
        this.visitar(arvore.exp);
        Object valor = this.valor(arvore.exp);
        if (valor instanceof String) {
            arvore.valor = valor.toString().toLowerCase().contains(arvore.item.toLowerCase());
            return;
        }
        if (valor instanceof Object[]) {
            for (String item : StringUtil.getArrayString(valor)) {
                if (!item.equalsIgnoreCase(arvore.item)) continue;
                arvore.valor = Boolean.TRUE;
                return;
            }
        }
        arvore.valor = Boolean.FALSE;
    }

    @Override
    public void visitarCopia(Arvore.Copia arvore) {
        this.visitar(arvore.exp);
        this.visitar(arvore.pos);
        this.visitar(arvore.qtde);
        Object valor = this.valor(arvore.exp);
        if (valor == null) {
            arvore.valor = "";
        } else {
            String str = valor.toString();
            int pos = ExpUtil.valorInt(this.valor(arvore.pos));
            int qtd = ExpUtil.valorInt(this.valor(arvore.qtde));
            if (pos > 0 && pos <= str.length()) {
                qtd = pos + qtd - 1 > str.length() ? str.length() - pos + 1 : qtd;
                arvore.valor = str.substring(pos - 1, pos + qtd - 1);
            }
        }
    }

    @Override
    public void visitarData(Arvore.Data arvore) {
        this.visitar(arvore.exp);
        Object valor = this.valor(arvore.exp);
        if (valor == null) {
            arvore.valor = "";
        } else {
            String masc = arvore.masc.replace('a', 'y').replace('h', 'k');
            if (valor != null && (valor = ExpUtil.valorData(valor)) != null) {
                arvore.valor = new SimpleDateFormat(masc).format((Date)valor);
            }
        }
    }

    @Override
    public void visitarExtenso(Arvore.Extenso arvore) {
        this.visitar(arvore.exp);
        Object valor = arvore.exp.valor;
        if (valor == null) {
            arvore.valor = "";
        } else if (valor instanceof Number) {
            arvore.valor = StringUtil.extenso(((Number)valor).floatValue());
        } else if (StringUtil.validaNumero(valor.toString())) {
            arvore.valor = StringUtil.extenso(Float.parseFloat(StringUtil.strDecimal(valor.toString())));
        }
    }

    @Override
    public void visitarIdent(Arvore.Ident arvore) {
        arvore.valor = this.getValorCampo(arvore.ident);
    }

    @Override
    public void visitarNulo(Arvore.Nulo arvore) {
        arvore.valor = null;
    }

    @Override
    public void visitarNumero(Arvore.Numero arvore) {
        this.visitar(arvore.exp);
        Object tmp = this.valor(arvore.exp);
        if (tmp == null) {
            arvore.valor = "";
            return;
        }
        double valor = 0.0;
        if (tmp instanceof Number) {
            valor = ((Number)tmp).doubleValue();
        } else if (StringUtil.validaNumero(tmp.toString())) {
            valor = Double.parseDouble(StringUtil.strDecimal(tmp.toString()));
        }
        String masc = StringUtil.trocarCaractere(arvore.masc, ',', '.');
        arvore.valor = StringUtil.validaMascaraNumero(masc) ? new DecimalFormat(masc).format(valor) : new DecimalFormat().format(valor);
    }

    @Override
    public void visitarOperacao(Arvore.Operacao arvore) {
        this.visitar(arvore.esq);
        this.visitar(arvore.dir);
        Object esq = this.valor(arvore.esq);
        Object dir = this.valor(arvore.dir);
        switch (arvore.op) {
            case 32: {
                arvore.valor = ExpUtil.somar(esq, dir);
                break;
            }
            case 31: {
                arvore.valor = ExpUtil.subtrair(esq, dir);
                break;
            }
            case 30: {
                arvore.valor = ExpUtil.dividir(esq, dir);
                break;
            }
            case 29: {
                arvore.valor = ExpUtil.multiplicar(esq, dir);
                break;
            }
            default: {
                arvore.valor = ExpUtil.compara(esq, dir, arvore.op);
            }
        }
    }

    @Override
    public void visitarSe(Arvore.Se arvore) {
        this.visitar(arvore.cond);
        this.visitar(arvore.exp1);
        this.visitar(arvore.exp2);
        Object valor = this.valor(arvore.cond);
        arvore.valor = valor instanceof Boolean && (Boolean)valor != false ? this.valor(arvore.exp1) : this.valor(arvore.exp2);
    }

    @Override
    public void visitarSomaData(Arvore.SomaData arvore) {
        this.visitar(arvore.exp);
        this.visitar(arvore.dias);
        Calendar calendario = Calendar.getInstance();
        Date data = ExpUtil.valorData(arvore.exp.valor);
        calendario.setTime(data == null ? new Date() : data);
        calendario.add(5, ExpUtil.valorInt(arvore.dias.valor));
        arvore.valor = calendario.getTime();
    }

    @Override
    public void visitarTamanho(Arvore.Tamanho arvore) {
        this.visitar(arvore.exp);
        Object valor = this.valor(arvore.exp);
        arvore.valor = valor == null ? new Long(0L) : new Long(valor.toString().length());
    }

    @Override
    public void visitarVazio(Arvore.Vazio arvore) {
        this.visitar(arvore.exp);
        this.visitar(arvore.tam);
        Object valor = this.valor(arvore.exp);
        int tam = ExpUtil.valorInt(this.valor(arvore.tam));
        if (valor == null) {
            arvore.valor = "";
        } else {
            StringBuilder bui = new StringBuilder(valor.toString());
            switch (arvore.alin) {
                case 'e': {
                    while (bui.length() < tam) {
                        bui.append(' ');
                    }
                    break;
                }
                case 'd': {
                    while (bui.length() < tam) {
                        bui.insert(0, ' ');
                    }
                    break;
                }
                case 'c': {
                    while (bui.length() < tam) {
                        bui.append(' ');
                        bui.insert(0, ' ');
                    }
                    if (bui.length() <= tam) break;
                    bui.setLength(tam);
                }
            }
            arvore.valor = bui.toString();
        }
    }

    @Override
    public void visitarZero(Arvore.Zero arvore) {
        this.visitar(arvore.exp);
        this.visitar(arvore.tam);
        Object valor = this.valor(arvore.exp);
        int tam = ExpUtil.valorInt(this.valor(arvore.tam));
        if (valor == null) {
            arvore.valor = "";
        } else {
            StringBuilder bui = new StringBuilder(valor.toString());
            while (bui.length() < tam) {
                bui.insert(0, '0');
            }
            arvore.valor = bui.toString();
        }
    }

    protected void visitar(Arvore arvore) {
        if (arvore != null) {
            arvore.aceitar(this);
        }
    }

    protected Object valor(Arvore arvore) {
        return arvore == null ? null : arvore.valor;
    }

    protected Object getValorCampo(String campo) {
        for (int i = 0; i <= this.campoValor.length - 2; i += 2) {
            if (!(this.campoValor[i] instanceof String) || !((String)this.campoValor[i]).equalsIgnoreCase(campo)) continue;
            return this.campoValor[i + 1];
        }
        return null;
    }

    @Override
    public void visitarSomatorio(Arvore.Somatorio arvore) {
        arvore.valor = "";
    }

    @Override
    public void visitarSomatorioAvancado(Arvore.SomatorioAvancado arvore) {
        arvore.valor = "";
    }

    @Override
    public void visitarMedia(Arvore.Media arvore) {
        arvore.valor = "";
    }

    @Override
    public void visitarCaracter(Arvore.Caracter arvore) {
        String valor = arvore.codigo;
        if (Funcoes.isNumeric(valor)) {
            int c = Integer.valueOf(valor.toString());
            arvore.valor = Character.valueOf((char)c);
        } else {
            arvore.valor = "";
        }
    }

    @Override
    public void visitarCaracterESC(Arvore.CaracterESC arvore) {
        String valor = arvore.codigo;
        arvore.valor = valor != null ? CharImpressao.ESC + valor.toString().replaceAll("\"", "").toCharArray()[0] : "";
    }
}

