/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.expressao.parser;

import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;

public class ExpUtil {
    public static final String TAG_ABRE = "[";
    public static final String TAG_FECHA = "]";

    public static Object somar(Object a, Object b) {
        if (a == null || b == null) {
            return a == null ? b : a;
        }
        if (a instanceof String || b instanceof String) {
            return a.toString() + b.toString();
        }
        if (a instanceof Number && b instanceof Number) {
            return new BigDecimal(a.toString()).add(new BigDecimal(b.toString()));
        }
        return null;
    }

    public static Object subtrair(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return new Float(((Number)a).floatValue() - ((Number)b).floatValue());
        }
        return null;
    }

    public static Object multiplicar(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return new Float(((Number)a).floatValue() * ((Number)b).floatValue());
        }
        return null;
    }

    public static Object dividir(Object a, Object b) {
        if (a instanceof Number && b instanceof Number && ((Number)b).doubleValue() != 0.0) {
            return new Float(((Number)a).floatValue() / ((Number)b).floatValue());
        }
        return null;
    }

    public static boolean compara(Object a, Object b, int opRel) {
        if (a != null && b != null) {
            String strA = a.toString();
            String strB = b.toString();
            switch (opRel) {
                case 27: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) == 0;
                        }
                        return strA.equalsIgnoreCase(strB);
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).doubleValue() == ((Number)b).doubleValue();
                    }
                    return a.equals(b);
                }
                case 28: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) != 0;
                        }
                        return !strA.equalsIgnoreCase(strB);
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).doubleValue() != ((Number)b).doubleValue();
                    }
                    return !a.equals(b);
                }
                case 24: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) > 0;
                        }
                        return strA.compareToIgnoreCase(strB) > 0;
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).doubleValue() > ((Number)b).doubleValue();
                    }
                }
                case 26: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) >= 0;
                        }
                        return strA.compareToIgnoreCase(strB) >= 0;
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).doubleValue() >= ((Number)b).doubleValue();
                    }
                }
                case 23: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) < 0;
                        }
                        return strA.compareToIgnoreCase(strB) < 0;
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).doubleValue() < ((Number)b).doubleValue();
                    }
                }
                case 25: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) <= 0;
                        }
                        return strA.compareToIgnoreCase(strB) <= 0;
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).doubleValue() <= ((Number)b).doubleValue();
                    }
                }
                case 19: {
                    if (a instanceof Boolean && b instanceof Boolean) {
                        return (Boolean)a != false && (Boolean)b != false;
                    }
                }
                case 20: {
                    if (!(a instanceof Boolean) || !(b instanceof Boolean)) break;
                    return (Boolean)a != false || (Boolean)b != false;
                }
            }
        }
        return false;
    }

    public static long valorLong(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o != null && StringUtil.validaNumero(o.toString())) {
            return new Float(StringUtil.strDecimal(o.toString())).longValue();
        }
        return 0L;
    }

    public static int valorInt(Object o) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o != null && StringUtil.validaNumero(o.toString())) {
            return new Float(StringUtil.strDecimal(o.toString())).intValue();
        }
        return 0;
    }

    public static float valorFloat(Object o) {
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof String && StringUtil.validaNumero(o.toString())) {
            return new Float(StringUtil.strDecimal(o.toString())).floatValue();
        }
        return 0.0f;
    }

    public static Date valorData(Object o) {
        try {
            if (o instanceof Date) {
                return (Date)o;
            }
            if (o instanceof String && o.toString().trim().length() > 0) {
                return DateFormat.getDateInstance().parse(o.toString());
            }
            if (o instanceof Number) {
                return new Date(((Number)o).longValue());
            }
            if (o instanceof Timestamp) {
                return DateFormat.getDateInstance().parse(o.toString());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExpUtil: 249");
        }
        return null;
    }

    public static String getStringObject(Object o) {
        if (o instanceof Object[]) {
            return StringUtil.arrayParaString(StringUtil.getArrayString(o));
        }
        return StringUtil.notNull(o);
    }
}

