/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.expressao.parser;

import jalis.util.expressao.parser.Visitor;

public abstract class Arvore {
    public Object valor;
    public int pos;

    public Arvore(int pos) {
        this.pos = pos;
    }

    public abstract void aceitar(Visitor var1);

    public static class Literal
    extends Arvore {
        Literal(int pos, Object valor) {
            super(pos);
            this.valor = valor;
        }

        @Override
        public void aceitar(Visitor v) {
        }
    }

    public static class Ident
    extends Arvore {
        public String ident;

        Ident(int pos, String ident) {
            super(pos);
            this.ident = ident;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarIdent(this);
        }
    }

    public static class Contem
    extends Arvore {
        public Arvore exp;
        public String item;

        Contem(int pos, Arvore exp, String item) {
            super(pos);
            this.exp = exp;
            this.item = item;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarContem(this);
        }
    }

    public static class Media
    extends Arvore {
        public String campo;

        Media(int pos, String campo) {
            super(pos);
            this.campo = campo == null ? "" : campo.toLowerCase();
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarMedia(this);
        }
    }

    public static class CaracterESC
    extends Arvore {
        public String codigo;

        CaracterESC(int pos, String caracter) {
            super(pos);
            this.codigo = caracter == null ? "" : caracter.toLowerCase();
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarCaracterESC(this);
        }
    }

    public static class Caracter
    extends Arvore {
        public String codigo;

        Caracter(int pos, String caracter) {
            super(pos);
            this.codigo = caracter == null ? "" : caracter.toLowerCase();
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarCaracter(this);
        }
    }

    public static class SomatorioAvancado
    extends Arvore {
        public String campo;
        public int casas = 2;

        SomatorioAvancado(int pos, String campo, int casas) {
            super(pos);
            this.campo = campo == null ? "" : campo.toLowerCase();
            this.casas = casas;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarSomatorioAvancado(this);
        }
    }

    public static class Somatorio
    extends Arvore {
        public String campo;

        Somatorio(int pos, String campo) {
            super(pos);
            this.campo = campo == null ? "" : campo.toLowerCase();
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarSomatorio(this);
        }
    }

    public static class Tamanho
    extends Arvore {
        public Arvore exp;

        Tamanho(int pos, Arvore exp) {
            super(pos);
            this.exp = exp;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarTamanho(this);
        }
    }

    public static class SomaData
    extends Arvore {
        public Arvore exp;
        public Arvore dias;

        SomaData(int pos, Arvore exp, Arvore dias) {
            super(pos);
            this.exp = exp;
            this.dias = dias;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarSomaData(this);
        }
    }

    public static class Numero
    extends Arvore {
        public Arvore exp;
        public String masc;

        Numero(int pos, Arvore exp, String masc) {
            super(pos);
            this.exp = exp;
            this.masc = masc;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarNumero(this);
        }
    }

    public static class Extenso
    extends Arvore {
        public Arvore exp;

        Extenso(int pos, Arvore exp) {
            super(pos);
            this.exp = exp;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarExtenso(this);
        }
    }

    public static class Data
    extends Arvore {
        public Arvore exp;
        public String masc;

        Data(int pos, Arvore exp, String masc) {
            super(pos);
            this.exp = exp;
            this.masc = masc;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarData(this);
        }
    }

    public static class Zero
    extends Arvore {
        public Arvore exp;
        public Arvore tam;

        Zero(int pos, Arvore exp, Arvore tam) {
            super(pos);
            this.exp = exp;
            this.tam = tam;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarZero(this);
        }
    }

    public static class Vazio
    extends Arvore {
        public Arvore exp;
        public Arvore tam;
        public char alin;

        Vazio(int pos, Arvore exp, Arvore tam, char alin) {
            super(pos);
            this.exp = exp;
            this.tam = tam;
            this.alin = alin;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarVazio(this);
        }
    }

    public static class Copia
    extends Arvore {
        public Arvore exp;
        public Arvore pos;
        public Arvore qtde;

        Copia(int posicao, Arvore exp, Arvore pos, Arvore qtde) {
            super(posicao);
            this.exp = exp;
            this.pos = pos;
            this.qtde = qtde;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarCopia(this);
        }
    }

    public static class Se
    extends Arvore {
        public Arvore cond;
        public Arvore exp1;
        public Arvore exp2;

        Se(int pos, Arvore cond, Arvore exp1, Arvore exp2) {
            super(pos);
            this.cond = cond;
            this.exp1 = exp1;
            this.exp2 = exp2;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarSe(this);
        }
    }

    public static class Operacao
    extends Arvore {
        public Arvore esq;
        public Arvore dir;
        public int op;

        Operacao(int pos, Arvore esq, Arvore dir, int op) {
            super(pos);
            this.esq = esq;
            this.dir = dir;
            this.op = op;
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarOperacao(this);
        }
    }

    public static class Nulo
    extends Arvore {
        Nulo() {
            super(-1);
        }

        @Override
        public void aceitar(Visitor v) {
            v.visitarNulo(this);
        }
    }
}

