/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.expressao;

import jalis.util.expressao.parser.Token;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class AbstractEstiloDocumento
extends DefaultStyledDocument {
    protected SimpleAttributeSet erro = new SimpleAttributeSet();
    protected SimpleAttributeSet simples = new SimpleAttributeSet();
    protected SimpleAttributeSet simbolo = new SimpleAttributeSet();
    protected SimpleAttributeSet string = new SimpleAttributeSet();
    protected SimpleAttributeSet numero = new SimpleAttributeSet();
    protected SimpleAttributeSet funcao = new SimpleAttributeSet();
    protected SimpleAttributeSet bool = new SimpleAttributeSet();
    protected JTextComponent textComponent;
    private ChangeEvent evento = new ChangeEvent(this);

    public AbstractEstiloDocumento(JTextComponent text) {
        this.textComponent = text;
        StyleConstants.setBold(this.funcao, true);
        StyleConstants.setBold(this.bool, true);
        StyleConstants.setForeground(this.bool, Color.blue);
        StyleConstants.setForeground(this.string, Color.red);
        StyleConstants.setForeground(this.numero, Color.blue);
        StyleConstants.setForeground(this.simbolo, Color.magenta);
        StyleConstants.setBold(this.simbolo, true);
        StyleConstants.setBackground(this.erro, Color.red);
    }

    public void setTextComponent(JTextComponent text) {
        this.textComponent = text;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, this.simples);
        this.destacarTokens();
        this.fireStateChanged();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.destacarTokens();
        this.fireStateChanged();
    }

    public abstract void destacarTokens() throws BadLocationException;

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public void destacarErro(int pos) {
        try {
            if (pos >= this.getLength()) {
                super.insertString(pos, " ", this.erro);
            } else {
                String ident = this.getIdentErro(pos);
                this.setCharacterAttributes(pos, ident.length(), this.erro, true);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractEstiloDocumento: 112");
        }
    }

    protected String getIdentErro(int pos) throws BadLocationException {
        String str = this.getText(pos, this.getLength() - pos + 1);
        int tam = 1;
        if (Character.isJavaIdentifierPart(str.charAt(0)) || str.charAt(0) == '\"') {
            for (int i = 1; i < str.length() && (Character.isJavaIdentifierPart(str.charAt(i)) || str.charAt(i) == '\"'); ++i) {
                ++tam;
            }
        }
        return this.getText(pos, tam);
    }

    protected AttributeSet estilo(Token tok) {
        if (this.funcao(tok.id)) {
            return this.funcao;
        }
        if (this.simbolo(tok.id)) {
            return this.simbolo;
        }
        if (this.numero(tok.id)) {
            return this.numero;
        }
        if (this.string(tok.id)) {
            return this.string;
        }
        return this.booleano(tok.lexema) ? this.bool : this.simples;
    }

    protected boolean funcao(int id) {
        return id == 7 || id == 8 || id == 9 || id == 10 || id == 11 || id == 12 || id == 13 || id == 14 || id == 15 || id == 16 || id == 37 || id == 17 || id == 18 || id == 35 || id == 19 || id == 20;
    }

    protected boolean simbolo(int id) {
        return id == 21 || id == 22 || id == 32 || id == 31 || id == 29 || id == 30 || id == 33 || id == 24 || id == 23 || id == 26 || id == 25 || id == 27 || id == 28;
    }

    protected boolean numero(int id) {
        return id == 4 || id == 3;
    }

    protected boolean string(int id) {
        return id == 1 || id == 2;
    }

    protected boolean booleano(String lex) {
        return lex.equalsIgnoreCase("verdadeiro") || lex.equalsIgnoreCase("falso");
    }

    protected void fireStateChanged() {
        ChangeListener[] ouvintes = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = 0; i < ouvintes.length; ++i) {
            ouvintes[i].stateChanged(this.evento);
        }
    }
}

