/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.expressao;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.relatorio.gerador.Variaveis;
import jalis.util.DialogoLista;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.expressao.AcaoBotao;
import jalis.util.expressao.BarraBotao;
import jalis.util.expressao.DialogoFuncao;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

abstract class AbstractDialogo
extends JDialog
implements ActionListener,
DialogoFuncao,
DisposeListener {
    private JPanel panelDescricao = new JPanel(new GridBagLayout());
    private JPanel panelParametros = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder(""));
    private JPanel panelBotoes = new JPanel(new GridBagLayout());
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelBarra = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private GridBagConstraints consDescricao = new GridBagConstraints();
    private GridBagConstraints consParametros = new GridBagConstraints();
    private GridBagConstraints consBotoes = new GridBagConstraints();
    private boolean ok = false;
    private Map<String, JComponent> parametros = new HashMap<String, JComponent>();
    protected String[] camposBanco = new String[0];
    protected String[] variaveis = new String[0];
    protected AcaoBotao acaoBanco = new AcaoBotao(){

        @Override
        public String acionouBotao(DialogoFuncao pai) {
            DialogoLista dl = DialogoLista.novaInstancia(pai, "Campos do banco");
            dl.setItens(AbstractDialogo.this.camposBanco);
            dl.setVisible(true);
            if (dl.ok()) {
                return dl.getItemSelecionado();
            }
            return "";
        }
    };
    protected AcaoBotao acaoVariaveis = new AcaoBotao(){

        @Override
        public String acionouBotao(DialogoFuncao pai) {
            DialogoLista dl = DialogoLista.novaInstancia(pai, "Vari\u00e1veis");
            dl.setItens(AbstractDialogo.this.variaveis);
            dl.setVisible(true);
            if (dl.ok()) {
                return dl.getItemSelecionado();
            }
            return "";
        }
    };
    protected AcaoBotao acaoRelatorio = new AcaoBotao(){

        @Override
        public String acionouBotao(DialogoFuncao pai) {
            DialogoLista dl = DialogoLista.novaInstancia(pai, "Vari\u00e1veis de impress\u00e3o");
            dl.setItens(Variaveis.getVariaveis());
            dl.setVisible(true);
            if (dl.ok()) {
                return dl.getItemSelecionado();
            }
            return "";
        }
    };

    AbstractDialogo(Frame pai, String titulo) {
        super(pai, titulo, true);
        this.iniciar(pai, titulo);
    }

    AbstractDialogo(Dialog pai, String titulo) {
        super(pai, titulo, true);
        this.iniciar(pai, titulo);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.dispose();
        }
    }

    @Override
    public boolean ok() {
        return this.ok;
    }

    @Override
    public void setCamposBanco(String[] campos) {
        if (campos != null) {
            this.camposBanco = campos;
        }
    }

    @Override
    public void setVariaveis(String[] campos) {
        if (campos != null) {
            this.variaveis = campos;
        }
    }

    protected void addDescricao(String descricao) {
        ++this.consDescricao.gridy;
        this.consDescricao.weightx = 0.0;
        this.consDescricao.gridx = 0;
        this.panelDescricao.add((Component)ComponenteFactory.novoJPanel(new Dimension(120, 25)), this.consDescricao);
        this.consDescricao.weightx = 0.5;
        this.consDescricao.gridx = 1;
        this.panelDescricao.add((Component)new JLabel(descricao), this.consDescricao);
    }

    protected void addParametro(String chave, String titulo) {
        this.addParametro(chave, titulo, null);
    }

    protected void addParametro(String chave, String titulo, String[] valores) {
        JComponent comp;
        if (valores != null) {
            comp = new JComboBox<String>(valores);
        } else {
            comp = new JTextField();
            comp.setMinimumSize(new Dimension(10, 20));
            comp.setBorder(BorderFactory.createTitledBorder(""));
        }
        this.consParametros.weightx = 0.0;
        this.consParametros.gridx = 0;
        this.panelParametros.add((Component)ComponenteFactory.novoJLabel(titulo, new Dimension(120, 25)), this.consParametros);
        this.consParametros.weightx = 0.5;
        this.consParametros.gridx = 1;
        this.panelParametros.add((Component)comp, this.consParametros);
        ++this.consParametros.gridy;
        this.parametros.put(chave, comp);
    }

    protected String getValorParametro(String chave) {
        if (chave != null) {
            Object tmp;
            JComponent comp = this.parametros.get(chave);
            if (comp instanceof JTextField) {
                return ((JTextField)comp).getText();
            }
            if (comp instanceof JComboBox && (tmp = ((JComboBox)comp).getSelectedItem()) != null) {
                return tmp.toString();
            }
        }
        return "";
    }

    protected BarraBotao addBarraBotao() {
        BarraBotao barra = new BarraBotao(this);
        this.panelBotoes.add((Component)barra, this.consBotoes);
        ++this.consBotoes.gridy;
        return barra;
    }

    private void iniciar(Object pai, String titulo) {
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        Funcoes.montaEnter((JComponent)this.getContentPane());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.getContentPane().add((Component)this.panelBarra, "South");
        this.setResizable(false);
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(3, 0, 3, 0);
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.fill = 1;
        this.panelCentro.add((Component)this.panelDescricao, cons);
        cons.gridy = 1;
        this.panelCentro.add((Component)this.panelParametros, cons);
        cons.gridy = 2;
        this.panelCentro.add((Component)this.panelBotoes, cons);
        this.panelBarra.add(this.buttonOk);
        this.panelBarra.add(this.buttonCancelar);
        this.consDescricao.fill = 1;
        this.consDescricao.insets = new Insets(2, 0, 2, 0);
        this.consDescricao.gridx = 0;
        this.consDescricao.gridy = 0;
        this.consDescricao.weightx = 0.5;
        this.consDescricao.weighty = 0.5;
        this.consDescricao.gridwidth = 2;
        this.panelDescricao.add((Component)new JLabel(titulo), this.consDescricao);
        this.consDescricao.gridwidth = 1;
        this.consParametros.fill = 1;
        this.consParametros.gridx = 0;
        this.consParametros.gridy = 0;
        this.consParametros.insets = new Insets(1, 1, 1, 1);
        this.consParametros.weightx = 0.5;
        this.consParametros.weighty = 0.5;
        this.consBotoes.fill = 1;
        this.consBotoes.gridx = 0;
        this.consBotoes.gridy = 0;
        this.consBotoes.weightx = 0.5;
        this.consBotoes.weighty = 0.5;
    }
}

