/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.excel;

import jalis.util.ArraysUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel {
    public static int NUMERIC = 0;
    public static int STRING = 1;
    public static int FORMULA = 2;
    public static int BLANK = 3;
    public static int BOOLEAN = 4;
    public static int ERROR = 5;

    public static List<List<Object>> ler(String url) throws IOException {
        return Excel.ler(url, "Plan1");
    }

    public static List<List<Object>> ler(String url, String planilha) throws IOException {
        return Excel.ler(new File(url), planilha);
    }

    public static List<List<Object>> ler(File file) throws IOException {
        return Excel.ler(file, "Plan1");
    }

    public static void escrever(String url) throws IOException {
    }

    public static List<List<Object>> ler(File file, String planilha) throws IOException {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        HSSFWorkbook rb = new HSSFWorkbook((InputStream)new FileInputStream(file));
        HSSFSheet plan1 = rb.getSheet(planilha);
        for (int i = 0; i <= plan1.getLastRowNum(); ++i) {
            linhas.add(Excel.getCelulaValorXls(plan1.getRow(i), new Integer[0]));
        }
        return linhas;
    }

    public static List<List<Object>> lerAt(File file, int planilha) throws IOException {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        HSSFWorkbook rb = new HSSFWorkbook((InputStream)new FileInputStream(file));
        HSSFSheet plan1 = rb.getSheetAt(planilha);
        for (int i = 0; i <= plan1.getLastRowNum(); ++i) {
            linhas.add(Excel.getCelulaValorXls(plan1.getRow(i), new Integer[0]));
        }
        return linhas;
    }

    public static List<List<Object>> ler(File file, int planilha, Integer ... columDate) throws IOException {
        List<Object> linhas = new ArrayList();
        if (file.getName().toLowerCase().endsWith("xls")) {
            linhas = Excel.lerArquivoXls(file, planilha, columDate);
        }
        if (file.getName().toLowerCase().endsWith("xlsx")) {
            linhas = Excel.lerArquivoXlsx(file, planilha, columDate);
        }
        return linhas;
    }

    public static HSSFWorkbook lerAllPlans(File file) throws IOException {
        HSSFWorkbook rb = new HSSFWorkbook((InputStream)new FileInputStream(file));
        return rb;
    }

    private static List<List<Object>> lerArquivoXlsx(File file, int planilha, Integer ... columDate) throws IOException {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        XSSFWorkbook wb = new XSSFWorkbook((InputStream)new FileInputStream(file));
        XSSFSheet plan1 = wb.getSheetAt(planilha);
        for (int i = 0; i <= plan1.getLastRowNum(); ++i) {
            linhas.add(Excel.getCelulaValorXlsx(plan1.getRow(i), columDate));
        }
        return linhas;
    }

    private static List<List<Object>> lerArquivoXls(File file, int planilha, Integer ... columDate) throws IOException {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        HSSFWorkbook rb = new HSSFWorkbook((InputStream)new FileInputStream(file));
        HSSFSheet plan1 = rb.getSheetAt(planilha);
        for (int i = 0; i <= plan1.getLastRowNum(); ++i) {
            linhas.add(Excel.getCelulaValorXls(plan1.getRow(i), columDate));
        }
        return linhas;
    }

    public static List<Object> getCelulaValorXls(HSSFRow row, Integer ... columDate) {
        ArrayList<Object> colunas = new ArrayList<Object>();
        block8: for (Cell cell : row) {
            switch (cell.getCellType()) {
                case 3: {
                    colunas.add("");
                    continue block8;
                }
                case 4: {
                    colunas.add(new Boolean(cell.getBooleanCellValue()));
                    continue block8;
                }
                case 5: {
                    colunas.add(cell.getErrorCellValue());
                    continue block8;
                }
                case 2: {
                    colunas.add(cell.getCellFormula());
                    continue block8;
                }
                case 0: {
                    colunas.add(ArraysUtil.indice((Object[])columDate, cell.getColumnIndex()) > -1 ? cell.getDateCellValue() : new Double(cell.getNumericCellValue()));
                    continue block8;
                }
                case 1: {
                    colunas.add(cell.getStringCellValue());
                    continue block8;
                }
            }
            colunas.add(cell.getStringCellValue());
        }
        return colunas;
    }

    public static List<Object> getCelulaValorXlsx(XSSFRow row, Integer ... columDate) {
        ArrayList<Object> colunas = new ArrayList<Object>();
        block8: for (Cell cell : row) {
            switch (cell.getCellType()) {
                case 3: {
                    colunas.add("");
                    continue block8;
                }
                case 4: {
                    colunas.add(new Boolean(cell.getBooleanCellValue()));
                    continue block8;
                }
                case 5: {
                    colunas.add(cell.getErrorCellValue());
                    continue block8;
                }
                case 2: {
                    colunas.add(cell.getCellFormula());
                    continue block8;
                }
                case 0: {
                    colunas.add(ArraysUtil.indice((Object[])columDate, cell.getColumnIndex()) > -1 ? cell.getDateCellValue() : new Double(cell.getNumericCellValue()));
                    continue block8;
                }
                case 1: {
                    colunas.add(cell.getStringCellValue());
                    continue block8;
                }
            }
            colunas.add(cell.getStringCellValue());
        }
        return colunas;
    }

    public static Object lerCelulaXlsx(File file, String planilha, String celula) throws IOException {
        XSSFWorkbook rb = new XSSFWorkbook((InputStream)new FileInputStream(file));
        XSSFSheet plan1 = rb.getSheet(planilha);
        CellReference cellReference = new CellReference(celula);
        XSSFRow row = plan1.getRow(cellReference.getRow());
        Cell cell = row.getCell((int)cellReference.getCol());
        switch (cell.getCellType()) {
            case 3: {
                break;
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 5: {
                return cell.getErrorCellValue();
            }
            case 2: {
                return cell.getCellFormula();
            }
            case 0: {
                return (int)Math.round(cell.getNumericCellValue());
            }
            case 1: {
                return cell.getStringCellValue();
            }
            default: {
                return cell.getStringCellValue();
            }
        }
        return cell;
    }

    public static List<List<Object>> lerXlsx(File file, String planilha, boolean retornaValor) throws Exception {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        XSSFWorkbook rb = new XSSFWorkbook((InputStream)new FileInputStream(file));
        XSSFSheet plan1 = rb.getSheet(planilha);
        for (int i = 0; i <= plan1.getLastRowNum(); ++i) {
            linhas.add(Excel.getCelulaValorXlsx(plan1.getRow(i), retornaValor));
        }
        return linhas;
    }

    public static List<List<Object>> lerXlsxAt(File file, int planilha, boolean retornaValor) throws Exception {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        XSSFWorkbook rb = new XSSFWorkbook((InputStream)new FileInputStream(file));
        XSSFSheet plan1 = rb.getSheetAt(planilha);
        for (int i = 0; i <= plan1.getLastRowNum(); ++i) {
            linhas.add(Excel.getCelulaValorXlsx(plan1.getRow(i), retornaValor));
        }
        return linhas;
    }

    private static List<Object> getCelulaValorXlsx(XSSFRow xssfRow, boolean retornaValor) throws Exception {
        ArrayList<Object> colunas = new ArrayList<Object>();
        block8: for (Cell cell : xssfRow) {
            switch (cell.getCellType()) {
                case 3: {
                    colunas.add("");
                    continue block8;
                }
                case 4: {
                    colunas.add(new Boolean(cell.getBooleanCellValue()));
                    continue block8;
                }
                case 5: {
                    colunas.add(cell.getErrorCellValue());
                    continue block8;
                }
                case 2: {
                    colunas.add(retornaValor ? Double.valueOf(cell.getNumericCellValue()) : cell.getCellFormula());
                    continue block8;
                }
                case 0: {
                    colunas.add(new Double(cell.getNumericCellValue()));
                    continue block8;
                }
                case 1: {
                    colunas.add(cell.getStringCellValue());
                    continue block8;
                }
            }
            colunas.add(cell.getStringCellValue());
        }
        return colunas;
    }

    public static int getNumeroDePlanilhas(File file) throws FileNotFoundException, IOException {
        int num = new HSSFWorkbook((InputStream)new FileInputStream(file)).getNumberOfSheets();
        return num;
    }
}

