/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.excel;

import jalis.util.excel.Excel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class EscreverArquivoXls {
    private HSSFWorkbook wb = new HSSFWorkbook();
    private List<HSSFSheet> abas = new ArrayList<HSSFSheet>();

    public int addAba(String nome) {
        this.abas.add(this.wb.createSheet(nome));
        return this.abas.size() - 1;
    }

    public void addLinha(int planilha, Object[] celulas) {
        HSSFRow row = this.abas.get(planilha).createRow(this.abas.get(planilha).getLastRowNum() + 1);
        for (int i = 0; i < celulas.length; ++i) {
            this.setCelula((Cell)row.createCell(i), celulas[i]);
        }
    }

    public void setLinha(int planilha, int linha, Object[] celulas) {
        HSSFRow row = this.abas.get(planilha).createRow(linha);
        for (int i = 0; i < celulas.length; ++i) {
            this.setCelula((Cell)row.createCell(i), celulas[i]);
        }
    }

    private void setCelula(Cell celula, Object obj) {
        if (obj instanceof Double) {
            celula.setCellType(Excel.NUMERIC);
            celula.setCellValue(((Double)obj).doubleValue());
        } else if (obj instanceof String) {
            celula.setCellType(Excel.STRING);
            celula.setCellValue((String)obj);
        } else if (obj instanceof Boolean) {
            celula.setCellType(Excel.BOOLEAN);
            celula.setCellValue(((Boolean)obj).booleanValue());
        } else if (obj instanceof Date) {
            celula.setCellType(Excel.NUMERIC);
            celula.setCellValue((Date)obj);
        } else if (obj instanceof Integer) {
            celula.setCellType(Excel.NUMERIC);
            celula.setCellValue(Double.parseDouble(String.valueOf(obj)));
        }
    }

    public void escreverArquivo(String url) throws IOException {
        FileOutputStream stream = new FileOutputStream(url);
        this.wb.write((OutputStream)stream);
        stream.close();
    }

    public void ajustarLarguraColunasAutomaticamente() {
        for (HSSFSheet aba : this.abas) {
            int colunasPorAba = this.contarColunasPreenchidasPorAba(aba);
            for (int coluna = 0; coluna < colunasPorAba; ++coluna) {
                aba.autoSizeColumn(coluna);
            }
        }
    }

    private int contarColunasPreenchidasPorAba(HSSFSheet aba) {
        int colunas = 0;
        block0: for (Row row : aba) {
            ArrayList celulas = new ArrayList();
            Iterator celIterator = row.cellIterator();
            while (celIterator.hasNext()) {
                celulas.add(celIterator.next());
            }
            for (int i = celulas.size(); i >= 0; --i) {
                Cell celula = (Cell)celulas.get(i - 1);
                if (!celula.toString().trim().isEmpty()) {
                    colunas = celulas.size() > colunas ? celulas.size() : colunas;
                    continue block0;
                }
                celulas.remove(i - 1);
            }
        }
        return colunas;
    }
}

