/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.estacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.estacao.NovaEstacao;
import jalis.util.logger.ErrorLogger;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Random;

public class ValidaEstacao {
    private static void escreverLog(BufferedWriter log, String mensagem) {
        try {
            if (log != null) {
                log.write(Funcoes.formataData("dd/MM/yy HH:mm", new Date()) + "==" + mensagem + "\n");
                log.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean validaEstacao(Frame owner, BufferedWriter log) {
        String codigo = ParametrosLocais.getParametro("codigoEstacao");
        boolean pedirCodigo = true;
        boolean retorno = true;
        Statement st = Conexao.getStatement();
        if (codigo != null && !Funcoes.textoVazio(codigo)) {
            Variaveis.codigoEstacao = ValidaEstacao.descriptografa(codigo);
            ValidaEstacao.escreverLog(log, "Validando estacao " + Variaveis.codigoEstacao);
            try {
                StringBuilder query = new StringBuilder();
                query.append("select est_descricao, est_web, est_expfiliais, est_integrar, est_pathintegracao, est_tempointegrar, est_sms, fil_codigo, est_exportaemail, est_aplicativo, NULLIF(est_tamanhomensagemweb, 1024) est_tamanhomensagemweb, est_tamanhointegracao ");
                query.append("from estacoes where est_codigo = ").append(Variaveis.codigoEstacao);
                ResultSet rs = Conexao.executeQuery(st, query.toString());
                ValidaEstacao.escreverLog(log, "Buscando dados estacao " + Variaveis.codigoEstacao);
                if (rs.next()) {
                    Variaveis.nomeEstacao = rs.getString("est_descricao");
                    Variaveis.estacaoExportaWeb = rs.getBoolean("est_web");
                    Variaveis.estacaoExportaFiliais = rs.getBoolean("est_expfiliais");
                    Variaveis.estacaoExportaIntegracao = rs.getBoolean("est_integrar");
                    Variaveis.estacaoExportaSms = rs.getBoolean("est_sms");
                    Variaveis.estacaoExportaEmail = rs.getBoolean("est_exportaemail");
                    Variaveis.estacaoExportaAplicativo = rs.getBoolean("est_aplicativo");
                    Variaveis.estacaoTempoIntegracao = (!DBUtil.campoNull(rs.getString("est_tempointegrar")) ? rs.getInt("est_tempointegrar") : 300) * 1000;
                    Variaveis.estacaoFilialIntegracao = !DBUtil.campoNull(rs.getString("fil_codigo")) ? rs.getInt("fil_codigo") : -1;
                    Variaveis.tamanhoMensagemWeb = !DBUtil.campoNull(rs.getString("est_tamanhomensagemweb")) && !Funcoes.textoVazio(rs.getString("est_tamanhomensagemweb")) ? rs.getInt("est_tamanhomensagemweb") : Variaveis.tamanhoMensagemWeb;
                    Variaveis.estacaoTamanhoIntegracao = !DBUtil.campoNull(rs.getString("est_tamanhointegracao")) ? rs.getInt("est_tamanhointegracao") : 512;
                    ValidaEstacao.atribuiVariavelPath(rs);
                    retorno = true;
                } else {
                    pedirCodigo = true;
                    retorno = false;
                }
            }
            catch (SQLException ex) {
                retorno = false;
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ValidaEstacao (66)");
            }
            ValidaEstacao.escreverLog(log, "Retornando estacao");
            return retorno;
        }
        if (pedirCodigo) {
            ValidaEstacao.escreverLog(log, "Criando nova estacao");
            NovaEstacao nova = new NovaEstacao(owner);
            nova.setLocationRelativeTo(owner);
            nova.setVisible(true);
            String nome = nova.getDescricao();
            String filial = nova.getFilial();
            String codigoGerado = null;
            try {
                codigoGerado = ValidaEstacao.geraCodigoEstacao(filial);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel gerar sequencia.\n" + ex.getMessage(), ex.getStackTrace());
                return false;
            }
            codigo = ValidaEstacao.descriptografa(codigoGerado);
            if (Funcoes.textoVazio(nome)) {
                nome = "Esta\u00e7\u00e3o " + codigo;
            }
            Variaveis.codigoEstacao = ValidaEstacao.descriptografa(codigoGerado);
            Variaveis.nomeEstacao = nome;
            Variaveis.filialPadrao = filial;
            ParametrosLocais.setParametro("codigoEstacao", codigoGerado);
            if (!ParametrosLocais.salvaParametros()) {
                Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel salvar os par\u00e2metros do sistema", 1);
                ValidaEstacao.escreverLog(log, "N\u00e3o foi poss\u00edvel salvar os parametros do sistema para a estacao");
            }
            try {
                String nomeHosp = "";
                String campoXml = "";
                String parametroGeralHospital = "";
                Boolean isIntegracaoHospital = false;
                Statement stHosp = Conexao.getStatement();
                StringBuilder qParam = new StringBuilder();
                qParam.append("select par_integracaohospital from parametros");
                ResultSet rsParam = Conexao.executeQuery(stHosp, qParam);
                if (rsParam.next()) {
                    String string = parametroGeralHospital = !Funcoes.textoVazio(rsParam.getString("par_integracaohospital")) ? rsParam.getString("par_integracaohospital") : "";
                }
                if (parametroGeralHospital.equals(ProtocoloIntegracaoHospital.SIGH.getCodigo())) {
                    StringBuilder qhosp = new StringBuilder();
                    qhosp.append("select est_integracaohospital, est_xmlhospital from estacoes where (est_xmlhospital is not null and  est_xmlhospital <> '') limit 1 ");
                    ResultSet rsHosp = Conexao.executeQuery(stHosp, qhosp);
                    if (rsHosp.next() && rsHosp.getBoolean("est_integracaohospital")) {
                        campoXml = rsHosp.getString("est_xmlhospital");
                        StringBuilder buf = new StringBuilder();
                        buf.append(StringUtil.getValor(campoXml, "NomeIntegracaoHospital"));
                        nomeHosp = buf.toString();
                        nomeHosp = nomeHosp.trim();
                        if (nomeHosp.equals(ProtocoloIntegracaoHospital.SIGH.getNome())) {
                            campoXml = DBUtil.bdText(campoXml);
                            ParametrosLocais.setParametro("buscarDadosBaseHospital", String.valueOf(1));
                            campoXml = DBUtil.bdText(campoXml);
                            ParametrosLocais.setParametro("xmlHospital", campoXml);
                        }
                    }
                } else {
                    campoXml = DBUtil.bdText("");
                }
                String comando = "insert into estacoes(est_codigo, est_descricao) values (" + codigo + ", '" + nome + "' )";
                Conexao.execute(filial, st, comando, true);
                ValidaEstacao.escreverLog(log, "Gravando nova estacao");
                if (!ParametrosGerais.getTipoIntegracao().equals("N")) {
                    String[] filiais = IntegracaoUtil.filiaisParaIntegrar(st);
                    ValidaEstacao.escreverLog(log, "Integrando nova estacao");
                    if (ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W")) {
                        IntegracaoUtil.insereComandoLog(st, filial, filial, comando);
                    } else if (ParametrosGerais.getTipoIntegracao().equals("M")) {
                        for (String f : filiais) {
                            if (!Funcoes.isNumeric(f) || f.equalsIgnoreCase(Variaveis.filialPadrao)) continue;
                            IntegracaoUtil.insereComandoLog(st, f, f, comando);
                        }
                    }
                }
                Conexao.arquivaSQL();
                retorno = true;
            }
            catch (SQLException sqlex) {
                retorno = false;
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, sqlex.getMessage(), sqlex.getStackTrace(), "ValidaEstacao (97)");
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private static void atribuiVariavelPath(ResultSet rs) {
        try {
            new Integer(rs.getString("est_pathintegracao"));
            Variaveis.estacaoTimeoutIntegracao = rs.getInt("est_pathintegracao") * 1000;
        }
        catch (Exception e) {
            Variaveis.estacaoTimeoutIntegracao = 1800000;
        }
    }

    private static String geraCodigoEstacao(String filial) throws Exception {
        Statement st = Conexao.getStatement();
        String codigo = DBUtil.getSequencia(st, "estacoes");
        Conexao.fecharStatement(st);
        if (!Funcoes.textoVazio(filial)) {
            codigo = filial + Funcoes.preencheZero(Integer.parseInt(codigo), 3);
        }
        return ValidaEstacao.criptografa(codigo);
    }

    public static String criptografa(String codigo) {
        StringBuffer temp = new StringBuffer("");
        Random random = new Random();
        temp.append(String.valueOf(Math.abs(random.nextInt())));
        if (temp.length() > 10) {
            temp.delete(10, temp.length());
        } else {
            while (temp.length() < 10) {
                temp.insert(0, "0");
            }
        }
        temp.append(codigo);
        return temp.toString();
    }

    public static String descriptografa(String codigo) {
        return StringUtil.removeZerosEsquerda(codigo.substring(10));
    }

    public static String getCodigoEstacao() {
        return ValidaEstacao.descriptografa(ParametrosLocais.getParametro("codigoEstacao"));
    }
}

