/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.estacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.apache.commons.net.ntp.TimeStamp;

class RestaurarEstacao
extends JDialog
implements ActionListener {
    private ModeloResultSet modelo = new ModeloResultSet("C\u00f3digo", "est_codigo", "Descri\u00e7\u00e3o", "est_descricao", "Usu\u00e1rio", "est_ultimousuario", "MAC", "est_enderecomac", "Atualiza\u00e7\u00e3o", "est_ultimoacesso");
    private JTable tabela = new JTable(this.modelo);
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_DESCRICAO = 1;
    private static final int COLUNA_USUARIO = 2;
    private static final int COLUNA_MAC = 3;
    private static final int COLUNA_ATUALIZACAO = 4;
    private JButton buttonSelecionar = ComponenteFactory.novoJButton("Selecionar", 'S', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JCheckBox checkFiltrarMAC = new JCheckBox("Filtrar MAC da esta\u00e7\u00e3o");
    private Registro reg;
    private String macAtual = Laboratorio.getEnderecoMac();
    private boolean isRestaurado = false;

    public RestaurarEstacao(Frame pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    public RestaurarEstacao(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    private void montarTela() {
        JPanel panel = new JPanel(new BorderLayout());
        this.tabela.getTableHeader().setReorderingAllowed(false);
        panel.add((Component)new JScrollPane(this.ajustarColunas(this.tabela)), "Center");
        JPanel panelBotoes = new JPanel(new BorderLayout());
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.checkFiltrarMAC), "West");
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonSelecionar, this.buttonCancelar), "East");
        this.checkFiltrarMAC.setSelected(true);
        this.setSize(600, 500);
        panel.add((Component)panelBotoes, "South");
        this.add((Component)panel, "Center");
        this.buttonSelecionar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestaurarEstacao.this.restaurarConfiguracoesBackup();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestaurarEstacao.this.dispose();
            }
        });
        this.checkFiltrarMAC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestaurarEstacao.this.carregarEstacoes();
            }
        });
        this.carregarEstacoes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregarEstacoes() {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder buf = new StringBuilder("select est_codigo, est_descricao, est_ultimoacesso, est_enderecomac, est_backup from estacoes ");
                if (this.checkFiltrarMAC.isSelected()) {
                    buf.append(" where est_enderecomac = '").append(this.macAtual).append("' ");
                }
                buf.append(" order by est_codigo ");
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                this.modelo.limpar(true);
                while (res.next()) {
                    Registro reg = new Registro();
                    reg.setValor("est_codigo", res.getString("est_codigo"));
                    reg.setValor("est_descricao", res.getString("est_descricao"));
                    reg.setValor("est_ultimoacesso", !DBUtil.campoNull(res.getString("est_ultimoacesso")) ? Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new TimeStamp((Date)res.getTimestamp("est_ultimoacesso")).getDate()) : "");
                    reg.setValor("est_enderecomac", res.getString("est_enderecomac"));
                    reg.setValor("est_backup", !DBUtil.campoNull(res.getString("est_backup")) ? res.getString("est_backup") : "");
                    reg.setValor("ultimoacesso", !DBUtil.campoNull(res.getString("est_ultimoacesso")) ? new TimeStamp((Date)res.getTimestamp("est_ultimoacesso")).getDate() : "");
                    String ultimoUsuario = res.getString("est_backup");
                    if (!Funcoes.textoVazio(ultimoUsuario)) {
                        ultimoUsuario = StringUtil.getValor(ultimoUsuario, "parametros");
                        ultimoUsuario = StringUtil.getValor(ultimoUsuario, "ultimoUsuario");
                    }
                    reg.setValor("est_ultimousuario", ultimoUsuario);
                    this.modelo.addRegistro(reg);
                }
                this.selecionarDataAutomatica();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private void selecionarDataAutomatica() {
        Date dataAtual = new Date();
        try {
            int proximoDia = -1;
            int proximoHora = -1;
            int index = 0;
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                Registro reg = this.modelo.getRegistro(i);
                if (reg.getDate("ultimoacesso") == null || !reg.getString("est_enderecomac").equalsIgnoreCase(this.macAtual)) continue;
                int intervaloDia = Funcoes.daysBetween(reg.getDate("ultimoacesso"), dataAtual);
                int intervaloHora = Funcoes.minutesBetween(reg.getDate("ultimoacesso"), dataAtual);
                if (proximoDia != -1 && intervaloDia >= proximoDia && intervaloHora >= proximoHora) continue;
                proximoDia = intervaloDia;
                proximoHora = intervaloHora;
                index = i;
            }
            if (this.tabela.getRowCount() > 0) {
                this.tabela.getSelectionModel().addSelectionInterval(this.tabela.convertRowIndexToView(index), this.tabela.convertRowIndexToView(index));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void restaurarConfiguracoesBackup() {
        Registro reg = this.modelo.getRegistro(this.tabela.convertRowIndexToModel(this.tabela.getSelectedRow()));
        if (reg != null) {
            String xml = reg.getString("est_backup");
            if (Funcoes.textoVazio(xml)) {
                Funcoes.mensagem(this, "A esta\u00e7\u00e3o n\u00e3o possui backup de configura\u00e7\u00f5es", 1);
                return;
            }
            if (Funcoes.mensagem(this, "A configura\u00e7\u00e3o ser\u00e1 restaurada para a m\u00e1quina atual.\nConfirma a restaura\u00e7\u00e3o das configura\u00e7\u00f5es?", 4) == 0) {
                ParametrosLocais.setXML(xml);
                ParametrosLocais.removerParametro("chaveConexaoEstacao");
                ParametrosLocais.setParametro("executandoSistema", "0");
                ParametrosLocais.salvaParametros();
                Funcoes.mensagem(this, "Configura\u00e7\u00f5es restauradas com sucesso!\nReinicie a esta\u00e7\u00e3o para que as configura\u00e7\u00f5es entrem em vigor", 2);
                System.exit(0);
            }
        }
    }

    private JTable ajustarColunas(JTable table) {
        TableColumnModel cols = table.getColumnModel();
        cols.getColumn(0).setMaxWidth(150);
        cols.getColumn(1).setMinWidth(0);
        cols.getColumn(2).setMinWidth(40);
        cols.getColumn(3).setMinWidth(40);
        cols.getColumn(4).setMinWidth(20);
        return table;
    }

    @Override
    public void actionPerformed(ActionEvent a) {
    }
}

