/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.estacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ManualFocusPolicy;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.estacao.ObjetoFilial;
import jalis.util.estacao.RestaurarEstacao;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class NovaEstacao
extends AbstractDialogoOKCancelar
implements WindowFocusListener {
    private JComboBox comboFiliais = new JComboBox();
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'l', null, this.comboFiliais);
    private TTextField textDescricao = new TTextField(100);
    private JLabel labelDescricao = ComponenteFactory.novoJLabel("Nome:", 'N', null, this.textDescricao);
    private JButton buttonRestaurar = ComponenteFactory.novoJButton("Restaurar", 'R', this);

    public NovaEstacao(Frame owner) {
        super(owner, "Nova esta\u00e7\u00e3o");
        this.getPanelBotoesEsquerda().remove(this.buttonOK);
        this.getPanelBotoesDireita().add(this.buttonRestaurar);
        this.getPanelBotoesDireita().add(this.buttonOK);
        this.montaTela(owner);
    }

    private void montaTela(Frame owner) {
        this.addWindowFocusListener(this);
        this.getBotaoCancelar().setVisible(false);
        int altura = 125;
        JPanel panelBotaoRestaurar = this.getPanelBotoesEsquerda();
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        panel.add((Component)this.labelDescricao, c);
        ++c.gridy;
        this.textDescricao.setPreferredSize(new Dimension(100, 20));
        panel.add((Component)this.textDescricao, c);
        if (ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W")) {
            ++c.gridy;
            panel.add((Component)this.labelFilial, c);
            ++c.gridy;
            panel.add((Component)this.comboFiliais, c);
            altura = 170;
        } else {
            this.labelFilial.setVisible(false);
            this.comboFiliais.setVisible(false);
        }
        this.preencheFiliais();
        this.setSize(315, altura);
        ScreenUtil.requisitarFoco(this.textDescricao);
        ManualFocusPolicy policy = new ManualFocusPolicy();
        policy.setFirstComponent(this, this.textDescricao);
        policy.setNextFocusableComponent(this.textDescricao, this.buttonOK);
        this.setFocusTraversalPolicy(policy);
        this.buttonRestaurar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestaurarEstacao restaurarEstacao = new RestaurarEstacao((Dialog)NovaEstacao.this, "Restaurando Esta\u00e7\u00e3o");
                restaurarEstacao.setLocationRelativeTo(NovaEstacao.this);
                restaurarEstacao.setVisible(true);
            }
        });
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o da filial deve ser informada", 1);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        return true;
    }

    public String getDescricao() {
        return this.textDescricao.getText();
    }

    public String getFilial() {
        return this.comboFiliais.isVisible() ? ((ObjetoFilial)this.comboFiliais.getSelectedItem()).getCodigo() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preencheFiliais() {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder("select fil_codigo, fil_descricao from filiais_postocoleta order by fil_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            this.comboFiliais.removeAllItems();
            while (rs.next()) {
                this.comboFiliais.addItem(new ObjetoFilial(rs.getString("fil_codigo"), rs.getString("fil_descricao")));
            }
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ValidaEstacao (268)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.textDescricao.grabFocus();
    }

    @Override
    @Deprecated
    public void windowLostFocus(WindowEvent e) {
    }
}

