/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.componentes;

import jalis.comum.Variaveis;
import jalis.util.Funcoes;
import jalis.util.SteppedComboBox;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.AcaoComboBox;
import jalis.util.componentes.ComponenteTextPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.StyledDocument;

public class ComponenteFactory {
    public static JTextPane novoJTextPane() {
        return ComponenteFactory.novoJTextPane(null, null);
    }

    public static JTextPane novoJTextPane(StyledDocument doc) {
        return ComponenteFactory.novoJTextPane(doc, null);
    }

    public static JTextPane novoJTextPane(StyledDocument doc, Font fonte) {
        ComponenteTextPane text;
        ComponenteTextPane componenteTextPane = text = doc == null ? new ComponenteTextPane() : new ComponenteTextPane(doc);
        if (fonte != null) {
            text.setFont(fonte);
        }
        return text;
    }

    public static JTable novoJTable(TableModel modelo, ListSelectionListener listener, TableCellRenderer renderer, int ... colunas) {
        JTable tab = new JTable();
        if (modelo != null) {
            tab.setModel(modelo);
        }
        if (tab.getColumnCount() == colunas.length) {
            TableColumnModel colModel = tab.getColumnModel();
            for (int i = 0; i < colunas.length; ++i) {
                if (colunas[i] <= 0) continue;
                colModel.getColumn(i).setMinWidth(colunas[i]);
                colModel.getColumn(i).setMaxWidth(colunas[i]);
            }
        }
        if (listener != null) {
            tab.getSelectionModel().addListSelectionListener(listener);
        }
        if (renderer != null) {
            tab.setDefaultRenderer(Object.class, renderer);
        }
        tab.getTableHeader().setReorderingAllowed(false);
        tab.setAutoResizeMode(3);
        return tab;
    }

    public static JTable novoJTable(TableModel modelo, ListSelectionListener listener, int ... colunas) {
        return ComponenteFactory.novoJTable(modelo, listener, null, colunas);
    }

    public static JTable novoJTable(TableModel modelo, int ... colunas) {
        return ComponenteFactory.novoJTable(modelo, null, null, colunas);
    }

    public static JTable novoJTable(TableModel modelo) {
        return ComponenteFactory.novoJTable(modelo, null, null, new int[0]);
    }

    public static JRadioButton novoJRadioButton(String text, char mnemonic, ActionListener listener, Dimension size, Dimension preferredSize) {
        JRadioButton button = new JRadioButton();
        if (text != null) {
            button.setText(text);
        }
        button.setMnemonic(mnemonic);
        if (listener != null) {
            button.addActionListener(listener);
        }
        if (size != null) {
            button.setSize(size);
        }
        if (preferredSize != null) {
            button.setPreferredSize(preferredSize);
        }
        return button;
    }

    public static JRadioButton novoJRadioButton(String text, ActionListener listener) {
        return ComponenteFactory.novoJRadioButton(text, '\u0000', listener, null, null);
    }

    public static JButton novoJButton(String text, char mnemonic, ActionListener listener, Dimension size, Dimension preferredSize, boolean enabled, int horizAlin) {
        return ComponenteFactory.novoJButton(text, mnemonic, listener, size, preferredSize, enabled, horizAlin, "");
    }

    public static JButton novoJButton(String text, char mnemonic, ActionListener listener, Dimension size, Dimension preferredSize, boolean enabled, int horizAlin, String toolTip) {
        JButton button = new JButton();
        if (text != null) {
            button.setText(text);
        }
        button.setMnemonic(mnemonic);
        if (listener != null) {
            button.addActionListener(listener);
        }
        if (size != null) {
            button.setSize(size);
        }
        if (preferredSize != null) {
            button.setPreferredSize(preferredSize);
        }
        button.setHorizontalAlignment(horizAlin);
        button.setEnabled(enabled);
        if (toolTip != null && !Funcoes.textoVazio(toolTip)) {
            button.setToolTipText(toolTip);
        }
        Insets margin = button.getMargin();
        margin.left = 7;
        margin.right = 7;
        button.setMargin(margin);
        return button;
    }

    public static JButton novoJButton(String text, char mnemonic, ActionListener listener, Dimension size, Dimension preferredSize, boolean enabled) {
        return ComponenteFactory.novoJButton(text, mnemonic, listener, size, preferredSize, enabled, 0, null);
    }

    public static JButton novoJButton(String text, char mnemonic, ActionListener listener, Dimension size, Dimension preferredSize) {
        return ComponenteFactory.novoJButton(text, mnemonic, listener, size, preferredSize, true);
    }

    public static JButton novoJButton(String text, char mnemonico, ActionListener listener) {
        return ComponenteFactory.novoJButton(text, mnemonico, listener, null, null, true);
    }

    public static JButton novoJButton(String text, ActionListener listener, String toolTip) {
        return ComponenteFactory.novoJButton(text, '\u0000', listener, null, null, true, 0, toolTip);
    }

    public static JButton novoJButton(String text, ActionListener listener) {
        return ComponenteFactory.novoJButton(text, '\u0000', listener, null, null, true);
    }

    public static JButton novoJButton(String text, ActionListener listener, Icon icone) {
        JButton novoJButton = ComponenteFactory.novoJButton(text, '\u0000', listener, null, null, true);
        novoJButton.setIcon(icone);
        return novoJButton;
    }

    public static JButton novoJButton(String text, ActionListener listener, Dimension size, Dimension preferredSize) {
        return ComponenteFactory.novoJButton(text, '\u0000', listener, size, preferredSize, true);
    }

    public static JButton novoJButton(ActionListener listener, Dimension size, Dimension preferredSize, boolean imagemPesquisa) {
        return ComponenteFactory.novoJButton(listener, size, preferredSize, imagemPesquisa, true);
    }

    public static JButton novoJButton(ActionListener listener, boolean imagemPesquisa) {
        return ComponenteFactory.novoJButton(listener, null, null, imagemPesquisa, true);
    }

    public static JButton novoJButton(ActionListener listener, Dimension size, Dimension preferredSize, boolean imagemPesquisa, boolean enabled) {
        JButton button = ComponenteFactory.novoJButton(null, '\u0000', listener, size, preferredSize, enabled);
        if (imagemPesquisa) {
            Funcoes.imagemPesquisa(button);
            button.setFocusable(false);
        }
        return button;
    }

    public static JButton novoJButton(ActionListener listener, Dimension size, Dimension preferredSize, Icon icone, boolean enabled) {
        JButton button = ComponenteFactory.novoJButton(null, '\u0000', listener, size, preferredSize, enabled);
        if (icone != null) {
            button.setIcon(icone);
        }
        return button;
    }

    public static JButton novoJButton(ActionListener listener, Dimension size, Dimension preferredSize, Icon icone, Icon rolloverIcon, Icon disabledIcon, boolean enabled) {
        JButton button = ComponenteFactory.novoJButton(listener, size, preferredSize, icone, enabled);
        if (rolloverIcon != null) {
            button.setRolloverIcon(rolloverIcon);
        }
        if (disabledIcon != null) {
            button.setDisabledIcon(disabledIcon);
        }
        return button;
    }

    public static JLabel novoJLabel(String text, Dimension preferredSize) {
        return ComponenteFactory.novoJLabel(text, '\u0000', preferredSize, null, 2, null, null);
    }

    public static JLabel novoJLabel(String text, char mnemonico, Dimension preferredSize, Component labelFor) {
        return ComponenteFactory.novoJLabel(text, mnemonico, preferredSize, null, 2, null, labelFor);
    }

    public static JLabel novoJLabel(String text, Dimension preferredSize, int horizontalAlignment) {
        return ComponenteFactory.novoJLabel(text, '\u0000', preferredSize, null, horizontalAlignment, null, null);
    }

    public static JLabel novoJLabel(String text, Dimension preferredSize, Border border) {
        return ComponenteFactory.novoJLabel(text, '\u0000', preferredSize, null, 2, border, null);
    }

    public static JLabel novoJLabel(String text, char mnemonico, Component labelFor) {
        return ComponenteFactory.novoJLabel(text, mnemonico, null, null, 2, null, labelFor);
    }

    public static JLabel novoJLabel(String text, char mnemonico, Dimension preferredSize, Border border, Component labelFor) {
        return ComponenteFactory.novoJLabel(text, mnemonico, preferredSize, null, 2, border, labelFor);
    }

    public static JLabel novoJLabel(String text, char mnemonico, Dimension preferredSize, int horizontalAlignment, Border border, Component labelFor) {
        return ComponenteFactory.novoJLabel(text, mnemonico, preferredSize, null, horizontalAlignment, border, labelFor);
    }

    public static JLabel novoJLabel(String text, char mnemonico, Dimension preferredSize, Dimension minimumSize, int horizontalAlignment, Border border, Component labelFor) {
        JLabel label = new JLabel(text, horizontalAlignment);
        label.setDisplayedMnemonic(mnemonico);
        if (preferredSize != null) {
            label.setPreferredSize(preferredSize);
        }
        if (minimumSize != null) {
            label.setMinimumSize(preferredSize);
        }
        if (border != null) {
            label.setBorder(border);
        }
        if (labelFor != null) {
            label.setLabelFor(labelFor);
        }
        return label;
    }

    public static JPanel novoJPanel(LayoutManager layout, Dimension preferredSize, Border border) {
        JPanel panel = layout != null ? new JPanel(layout) : new JPanel();
        if (preferredSize != null) {
            panel.setPreferredSize(preferredSize);
        }
        if (border != null) {
            panel.setBorder(border);
        }
        return panel;
    }

    public static JPanel novoJPanel(LayoutManager layout, Border border) {
        return ComponenteFactory.novoJPanel(layout, null, border);
    }

    public static JPanel novoJPanel(Dimension preferredSize) {
        return ComponenteFactory.novoJPanel(null, preferredSize, null);
    }

    public static JPanel novoJPanelFlowLayout(int alin, Component ... comps) {
        return ComponenteFactory.novoJPanelFlowLayout(alin, 3, 3, comps);
    }

    public static JPanel novoJPanelFlowLayout(int alin, int hgap, int vgap, Component ... comps) {
        JPanel panel = new JPanel(new FlowLayout(alin, hgap, vgap));
        for (Component c : comps) {
            panel.add(c);
        }
        return panel;
    }

    public static JPanel novoJPanelBorderLayout(String titulo, Component center) {
        return ComponenteFactory.novoJPanelBorderLayout(titulo, center, null, null, null, null);
    }

    public static JPanel novoJPanelBorderLayout(Component center, Component north, Component south, Component east, Component west) {
        return ComponenteFactory.novoJPanelBorderLayout((Border)null, center, north, south, east, west);
    }

    public static JPanel novoJPanelBorderLayout(String titulo, Component center, Component north, Component south, Component east, Component west) {
        return ComponenteFactory.novoJPanelBorderLayout(titulo == null ? null : BorderFactory.createTitledBorder(titulo), center, north, south, east, west);
    }

    public static JPanel novoJPanelBorderLayout(Border border, Component center, Component north, Component south, Component east, Component west) {
        JPanel panel = new JPanel(new BorderLayout());
        if (border != null) {
            panel.setBorder(border);
        }
        if (center != null) {
            panel.add(center, "Center");
        }
        if (north != null) {
            panel.add(north, "North");
        }
        if (south != null) {
            panel.add(south, "South");
        }
        if (east != null) {
            panel.add(east, "East");
        }
        if (west != null) {
            panel.add(west, "West");
        }
        return panel;
    }

    public static JCheckBox novoJCheckBox(String texto, char mnemonic) {
        return ComponenteFactory.novoJCheckBox(texto, mnemonic, null, null, true);
    }

    public static JCheckBox novoJCheckBox(String texto, char mnemonic, ActionListener action) {
        return ComponenteFactory.novoJCheckBox(texto, mnemonic, action, null, true);
    }

    public static JCheckBox novoJCheckBox(String texto, char mnemonic, ActionListener action, Dimension preferredSize, boolean enabled) {
        return ComponenteFactory.novoJCheckBox(texto, mnemonic, action, preferredSize, enabled, null);
    }

    public static JCheckBox novoJCheckBox(String texto, char mnemonic, ActionListener action, String toolTip) {
        return ComponenteFactory.novoJCheckBox(texto, mnemonic, action, null, true, toolTip);
    }

    public static JCheckBox novoJCheckBox(String texto, char mnemonic, ActionListener action, Dimension preferredSize, boolean enabled, String toolTip) {
        JCheckBox check = new JCheckBox(texto);
        check.setMnemonic(mnemonic);
        if (action != null) {
            check.addActionListener(action);
        }
        if (preferredSize != null) {
            check.setPreferredSize(preferredSize);
        }
        check.setEnabled(enabled);
        if (toolTip != null) {
            check.setToolTipText(toolTip);
        }
        return check;
    }

    public static JCheckBox novoJCheckBox(String texto, ActionListener action) {
        JCheckBox check = new JCheckBox(texto);
        if (action != null) {
            check.addActionListener(action);
        }
        return check;
    }

    public static JMenu novoJMenu(JComponent pai, String texto, char mnemonic) {
        JMenu menu = new JMenu(texto);
        menu.setMnemonic(mnemonic);
        if (pai != null) {
            pai.add(menu);
        }
        return menu;
    }

    public static JMenuItem novoJMenuItem(JComponent pai, String texto, char mnemonic, ActionListener action) {
        JMenuItem item = new JMenuItem(texto, mnemonic);
        if (action != null) {
            item.addActionListener(action);
        }
        if (pai != null) {
            pai.add(item);
        }
        return item;
    }

    public static JMenuItem novoJMenuItem(JComponent pai, String texto, ActionListener action) {
        return ComponenteFactory.novoJMenuItem(pai, texto, '\u0000', action);
    }

    public static JMenuItem novoJMenuItem(String texto, char mnemonic, ActionListener action) {
        return ComponenteFactory.novoJMenuItem(null, texto, mnemonic, action);
    }

    public static JMenuItem novoJMenuItem(String texto, ActionListener action) {
        return ComponenteFactory.novoJMenuItem(null, texto, '\u0000', action);
    }

    public static JProgressBar novoJProgressBar(String texto) {
        return ComponenteFactory.novoJProgressBar(texto, true);
    }

    public static JProgressBar novoJProgressBar(final String texto, boolean visible) {
        JProgressBar progress = new JProgressBar(){

            @Override
            public void setValue(int value) {
                super.setValue(value);
                this.setString(StringUtil.getStringProgresso(texto, this));
            }
        };
        progress.setVisible(visible);
        progress.setValue(0);
        progress.setMaximum(0);
        progress.setString("");
        progress.setStringPainted(true);
        return progress;
    }

    public static JComboBox novoJComboBox(Dimension preferredSize) {
        return ComponenteFactory.novoJComboBox(null, null, false, preferredSize);
    }

    public static JComboBox novoJComboBox(Object[] itens, ActionListener action, Dimension preferredSize) {
        return ComponenteFactory.novoJComboBox(itens, action, false, preferredSize);
    }

    public static JComboBox novoJComboBox(Object[] itens, ActionListener action, boolean tratarActionListener, Dimension preferredSize) {
        JComboBox<Object> combo = new JComboBox<Object>();
        if (itens != null) {
            combo.setModel(new DefaultComboBoxModel<Object>(itens));
        }
        if (action != null) {
            if (tratarActionListener) {
                AcaoComboBox.configurar(combo, action);
            } else {
                combo.addActionListener(action);
            }
        }
        if (preferredSize != null) {
            combo.setPreferredSize(preferredSize);
        }
        return combo;
    }

    public static JComboBox novoJcomboBoxPopup(Object[] itens, int tamanhoPopup, int selecaoInicial) {
        SteppedComboBox combo = new SteppedComboBox(itens);
        combo.setPreferredSize(new Dimension(50, 20));
        combo.setMinimumSize(new Dimension(50, 20));
        combo.setPopupWidth(tamanhoPopup);
        if (itens.length > 0) {
            combo.setSelectedIndex(selecaoInicial);
        }
        return combo;
    }

    public static JComboBox novoJComboBox(Object[] itens, Dimension preferredSize) {
        return ComponenteFactory.novoJComboBox(itens, null, false, preferredSize);
    }

    public static JComboBox novoJComboBox(Object[] itens) {
        return ComponenteFactory.novoJComboBox(itens, null, false, null);
    }

    public static JComboBox novoJComboBox(ActionListener action) {
        return ComponenteFactory.novoJComboBox(null, action, false, null);
    }

    public static JComboBox novoJComboBox(ActionListener action, boolean tratarActionListener) {
        return ComponenteFactory.novoJComboBox(null, action, tratarActionListener, null);
    }

    public static JList novoJList(DefaultListModel model, ListSelectionListener selection, Object[] itens, Dimension preferredSize) {
        JList list = new JList();
        if (model != null) {
            list.setModel(model);
        }
        if (selection != null) {
            list.addListSelectionListener(selection);
        }
        if (preferredSize != null) {
            list.setPreferredSize(preferredSize);
        }
        return list;
    }

    public static JList novoJList(Object[] itens) {
        return ComponenteFactory.novoJList(null, null, itens, null);
    }

    public static JList novoJList() {
        return ComponenteFactory.novoJList(null, null, null, null);
    }

    public static JToolBar novoJToolBar(Color background, Dimension preferredSize, boolean borderPainted, boolean floatable, boolean rollover) {
        JToolBar toolBar = new JToolBar();
        toolBar.setBackground(background);
        if (preferredSize != null) {
            toolBar.setPreferredSize(preferredSize);
        }
        toolBar.setBorderPainted(borderPainted);
        toolBar.setFloatable(floatable);
        toolBar.setRollover(rollover);
        return toolBar;
    }

    public static TitledBorder novoTitledEtchedBorder(String texto) {
        return new TitledBorder(BorderFactory.createEtchedBorder(1), texto);
    }

    public static JFileChooser novoJFileChooser() {
        return ComponenteFactory.novoJFileChooser(null);
    }

    public static JFileChooser novoJFileChooser(String titulo) {
        return ComponenteFactory.novoJFileChooser(titulo, Variaveis.ultimoDiretorioDialogo != null ? Variaveis.ultimoDiretorioDialogo.getAbsolutePath() : null);
    }

    public static JFileChooser novoJFileChooser(String titulo, String ultimoDiretorio) {
        return ComponenteFactory.novoJFileChooser(titulo, ultimoDiretorio, null);
    }

    public static JFileChooser novoJFileChooser(String titulo, String ultimoDiretorio, final String msgCancelamento) {
        final JFileChooser chooser = new JFileChooser(ultimoDiretorio);
        if (titulo != null) {
            chooser.setDialogTitle(titulo);
        }
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "ApproveSelection") {
                    Variaveis.ultimoDiretorioDialogo = chooser.getCurrentDirectory();
                } else if (e.getActionCommand() == "CancelSelection" && !Funcoes.textoVazio(msgCancelamento)) {
                    Funcoes.mensagem(null, msgCancelamento, 2);
                }
            }
        });
        return chooser;
    }

    public static FileFilter novoFileFilter(final String descricao, String ... extensoes) {
        final ArrayList<String> ext = new ArrayList<String>();
        for (String s : extensoes) {
            ext.add(s.toLowerCase());
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String tmp = f.getName();
                int pos = tmp.lastIndexOf(46);
                if (pos > -1) {
                    return ext.contains(tmp.substring(pos + 1, tmp.length()).toLowerCase());
                }
                return false;
            }

            @Override
            public String getDescription() {
                return descricao;
            }
        };
        return filter;
    }

    public static TTextField novoTTextField(int qtdeCaracteres, int tipo, Dimension preferredSize, Dimension minimumSize, String toolTipText, String maskDecimal, ActionListener action) {
        TTextField txt = new TTextField(qtdeCaracteres, tipo);
        if (preferredSize != null) {
            txt.setPreferredSize(preferredSize);
        }
        if (minimumSize != null) {
            txt.setMinimumSize(minimumSize);
        }
        if (toolTipText != null) {
            txt.setToolTipText(toolTipText);
        }
        if (maskDecimal != null) {
            txt.setMaskDecimal(maskDecimal);
        }
        if (action != null) {
            txt.addActionListener(action);
        }
        return txt;
    }

    public static TTextField novoTTextField(int qtdeCaracteres, int tipo) {
        return ComponenteFactory.novoTTextField(qtdeCaracteres, tipo, null, null, null, null, null);
    }

    public static TTextField novoTTextField(int qtdeCaracteres, int tipo, String toolTipText, String maskDecimal) {
        return ComponenteFactory.novoTTextField(qtdeCaracteres, tipo, null, null, toolTipText, maskDecimal, null);
    }

    public static TTextField novoTTextField(int qtdeCaracteres, int tipo, String toolTipText) {
        return ComponenteFactory.novoTTextField(qtdeCaracteres, tipo, null, null, toolTipText, null, null);
    }

    public static TTextField novoTTextField(int qtdeCaracteres, int tipo, ActionListener action) {
        return ComponenteFactory.novoTTextField(qtdeCaracteres, tipo, null, null, null, null, action);
    }
}

