/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.barras;

import java.awt.Rectangle;
import java.util.ArrayList;

public class CodigoBarras25 {
    private static String INICIO = "0000";
    private static String FIM = "100";
    private static String[] codigos = new String[]{"00110", "10001", "01001", "11000", "00101", "10100", "01100", "00011", "10010", "01010"};

    public static String getCodigo(String valor) {
        StringBuilder bui = new StringBuilder();
        if (valor.matches("\\-?\\d+")) {
            bui.append(INICIO);
            String tmp = valor.length() % 2 == 0 ? valor : "0" + valor;
            char[] ch = tmp.toCharArray();
            for (int i = 0; i < ch.length - 1; i += 2) {
                bui.append(CodigoBarras25.intercalar(ch[i], ch[i + 1]));
            }
            bui.append(FIM);
        }
        return bui.toString();
    }

    public static Rectangle[] getBarras(String valor, int altura) {
        ArrayList<Rectangle> barras = new ArrayList<Rectangle>();
        int x = 0;
        char[] ch = CodigoBarras25.getCodigo(valor).toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            int w;
            int n = w = ch[i] == '1' ? 2 : 1;
            if (i % 2 == 0) {
                barras.add(new Rectangle(x, 0, w, altura));
            }
            x += w;
        }
        return barras.toArray(new Rectangle[barras.size()]);
    }

    private static String intercalar(char a, char b) {
        int nA = Integer.parseInt(Character.toString(a));
        int nB = Integer.parseInt(Character.toString(b));
        char[] cA = codigos[nA].toCharArray();
        char[] cB = codigos[nB].toCharArray();
        return new String(new char[]{cA[0], cB[0], cA[1], cB[1], cA[2], cB[2], cA[3], cB[3], cA[4], cB[4]});
    }
}

