/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.barras;

import jalis.util.Funcoes;
import jalis.util.barras.CodigoBarras25;
import jalis.util.barras.CodigoBarras39;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class CodigoBarras
extends JComponent {
    public static final int BARCODE_2x5 = 0;
    public static final int BARCODE_3x9 = 1;
    private int formato = 0;
    private String valor = "";
    private int alin = 2;
    private int colZeros = 0;

    public CodigoBarras() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
    }

    public void setFormato(int formato) {
        this.formato = formato;
        this.revalidate();
        this.repaint();
    }

    public int getFormato() {
        return this.formato;
    }

    public void setValorCodigo(String valor) {
        this.valor = Funcoes.preencheZero(valor, this.colZeros);
        this.revalidate();
        this.repaint();
    }

    public String getValorCodigo() {
        return this.valor;
    }

    public int getPreencherZero() {
        return this.colZeros;
    }

    public void setPreencherZero(int coluna) {
        this.colZeros = coluna;
    }

    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alin = alinhamento;
        this.revalidate();
        this.repaint();
    }

    public int getAlinhamentoHorizontal() {
        return this.alin;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.getBackground().getRGB() == Color.black.getRGB() ? new Color(1, 1, 1) : this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.getForeground().getRGB() == Color.black.getRGB() ? new Color(1, 1, 1) : this.getForeground());
        Rectangle[] barras = new Rectangle[]{};
        switch (this.formato) {
            case 0: {
                barras = CodigoBarras25.getBarras(this.valor, this.getHeight());
                break;
            }
            case 1: {
                barras = CodigoBarras39.getBarras(this.valor, this.getHeight());
            }
        }
        if (barras.length > 0) {
            int larg = barras[barras.length - 1].x + barras[barras.length - 1].width;
            int off = 0;
            switch (this.alin) {
                case 0: {
                    off = (this.getWidth() - larg) / 2;
                    break;
                }
                case 4: {
                    off = this.getWidth() - larg;
                }
            }
            for (int i = 0; i < barras.length; ++i) {
                g.fillRect(barras[i].x + off, 0, barras[i].width, barras[i].height);
            }
        }
    }
}

