/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.Funcoes;

public class ValidaDoc {
    public static final int TIPO_CPF = 8;
    public static final int TIPO_CNPJ = 7;
    public static final int TIPO_CARTAO_SUS = 3;

    public static int modulo11(String valor) {
        int retorno = 0;
        int soma = 0;
        int multiplo = 2;
        String modulo = ValidaDoc.limpa(valor);
        for (int i = modulo.length() - 1; i >= 0; --i) {
            if (multiplo == 10) {
                multiplo = 2;
            }
            soma += Integer.parseInt(modulo.substring(i, i + 1)) * multiplo;
            ++multiplo;
        }
        retorno = (soma = 11 - soma % 11) >= 10 ? 0 : soma;
        return retorno;
    }

    private static int modulo11Doc(String valor) {
        int soma = 0;
        int multiplo = 2;
        String modulo = ValidaDoc.limpa(valor);
        for (int i = modulo.length() - 1; i >= 0; --i) {
            soma += Integer.parseInt(modulo.substring(i, i + 1)) * multiplo;
            ++multiplo;
        }
        if ((soma = 11 - soma % 11) >= 10) {
            return 0;
        }
        return soma;
    }

    public static boolean verificaTodosDigitosIguais(String valor) {
        valor = ValidaDoc.limpa(valor);
        String carac = null;
        for (int i = 0; i < valor.length(); ++i) {
            if (carac == null) {
                carac = valor.substring(i, i + 1);
                continue;
            }
            if (carac.equals(valor.substring(i, i + 1))) continue;
            return false;
        }
        return true;
    }

    public static int modulo10(String valor) {
        int retorno = 0;
        int soma = 0;
        int multiplo = 2;
        String modulo = ValidaDoc.limpa(valor);
        for (int i = modulo.length() - 1; i >= 0; --i) {
            if (multiplo == 0) {
                multiplo = 2;
            }
            soma += Integer.parseInt(modulo.substring(i, i + 1)) * multiplo;
            --multiplo;
        }
        retorno = (soma = 10 - soma / 11) >= 10 ? 0 : soma;
        return retorno;
    }

    private static String limpa(String valor) {
        String retorno = "";
        if (valor.matches("[0-9]+")) {
            retorno = valor;
        } else {
            for (int i = 0; i < valor.length(); ++i) {
                if (!valor.substring(i, i + 1).matches("[0-9]+")) continue;
                retorno = retorno + valor.substring(i, i + 1);
            }
        }
        return retorno;
    }

    public static boolean checkDoc(String documento, int tipo) {
        boolean retorno = false;
        if (documento == null) {
            return false;
        }
        documento = documento.trim();
        String testar = ValidaDoc.limpa(documento);
        if (tipo == 7 && testar.length() < 14) {
            return false;
        }
        if (tipo == 8 && testar.length() < 11) {
            return false;
        }
        if (tipo == 3 && testar.length() != 15) {
            return false;
        }
        if (tipo == 7) {
            int primDigito = ValidaDoc.modulo11(testar.substring(0, 12));
            int segDigito = ValidaDoc.modulo11(testar.substring(0, 12) + String.valueOf(primDigito));
            return Integer.parseInt(testar.substring(12, 14)) == Integer.parseInt(String.valueOf(primDigito) + String.valueOf(segDigito));
        }
        if (tipo == 8) {
            if (ValidaDoc.verificaTodosDigitosIguais(testar)) {
                return false;
            }
            int primDigito = ValidaDoc.modulo11Doc(testar.substring(0, 9));
            int segDigito = ValidaDoc.modulo11Doc(testar.substring(0, 9) + String.valueOf(primDigito));
            return Integer.parseInt(testar.substring(9, 11)) == Integer.parseInt(String.valueOf(primDigito) + String.valueOf(segDigito));
        }
        if (tipo == 3) {
            if (!Funcoes.isNumeric(documento)) {
                return false;
            }
            Integer primeiroDigito = Integer.parseInt(documento.substring(0, 1));
            if (primeiroDigito == 1 || primeiroDigito == 2) {
                return ValidaDoc.validaCns(documento);
            }
            if (primeiroDigito == 7 || primeiroDigito == 8 || primeiroDigito == 9) {
                return ValidaDoc.validaCnsProv(documento);
            }
            return false;
        }
        return false;
    }

    public static boolean validaCns(String cns) {
        String pis = new String("");
        String resultado = new String("");
        pis = cns.substring(0, 11);
        float soma = Integer.valueOf(pis.substring(0, 1)) * 15 + Integer.valueOf(pis.substring(1, 2)) * 14 + Integer.valueOf(pis.substring(2, 3)) * 13 + Integer.valueOf(pis.substring(3, 4)) * 12 + Integer.valueOf(pis.substring(4, 5)) * 11 + Integer.valueOf(pis.substring(5, 6)) * 10 + Integer.valueOf(pis.substring(6, 7)) * 9 + Integer.valueOf(pis.substring(7, 8)) * 8 + Integer.valueOf(pis.substring(8, 9)) * 7 + Integer.valueOf(pis.substring(9, 10)) * 6 + Integer.valueOf(pis.substring(10, 11)) * 5;
        float resto = soma % 11.0f;
        float dv = 11.0f - resto;
        if (dv == 11.0f) {
            dv = 0.0f;
        }
        if (dv == 10.0f) {
            soma = Integer.valueOf(pis.substring(0, 1)) * 15 + Integer.valueOf(pis.substring(1, 2)) * 14 + Integer.valueOf(pis.substring(2, 3)) * 13 + Integer.valueOf(pis.substring(3, 4)) * 12 + Integer.valueOf(pis.substring(4, 5)) * 11 + Integer.valueOf(pis.substring(5, 6)) * 10 + Integer.valueOf(pis.substring(6, 7)) * 9 + Integer.valueOf(pis.substring(7, 8)) * 8 + Integer.valueOf(pis.substring(8, 9)) * 7 + Integer.valueOf(pis.substring(9, 10)) * 6 + Integer.valueOf(pis.substring(10, 11)) * 5 + 2;
            resto = soma % 11.0f;
            dv = 11.0f - resto;
            resultado = pis + "001" + String.valueOf((int)dv);
        } else {
            resultado = pis + "000" + String.valueOf((int)dv);
        }
        return cns.equals(resultado);
    }

    public static boolean validaCnsProv(String cns) {
        float aux = Integer.valueOf(cns.substring(0, 1)) * 15 + Integer.valueOf(cns.substring(1, 2)) * 14 + Integer.valueOf(cns.substring(2, 3)) * 13 + Integer.valueOf(cns.substring(3, 4)) * 12 + Integer.valueOf(cns.substring(4, 5)) * 11 + Integer.valueOf(cns.substring(5, 6)) * 10 + Integer.valueOf(cns.substring(6, 7)) * 9 + Integer.valueOf(cns.substring(7, 8)) * 8 + Integer.valueOf(cns.substring(8, 9)) * 7 + Integer.valueOf(cns.substring(9, 10)) * 6 + Integer.valueOf(cns.substring(10, 11)) * 5 + Integer.valueOf(cns.substring(11, 12)) * 4 + Integer.valueOf(cns.substring(12, 13)) * 3 + Integer.valueOf(cns.substring(13, 14)) * 2 + Integer.valueOf(cns.substring(14, 15)) * 1;
        return (aux %= 11.0f) == 0.0f;
    }
}

