/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import java.util.ArrayList;

public class Temporizador {
    int time;
    ArrayList<Runnable> ouvintes = new ArrayList();
    ContaTempo contador;

    public Temporizador(Runnable ouvinte) {
        this.ouvintes.add(ouvinte);
    }

    public void iniciar(int tempo_milissegundos) {
        this.encerrar();
        this.time = tempo_milissegundos;
        if (this.contador == null) {
            this.contador = new ContaTempo();
        }
        this.contador.start();
    }

    public void encerrar() {
        if (this.contador != null && this.contador.isAlive()) {
            this.contador.interrupt();
        }
        this.contador = new ContaTempo();
    }

    public void addEsperaTempo(Runnable ouvinte) {
        if (!this.ouvintes.contains(ouvinte)) {
            this.ouvintes.add(ouvinte);
        }
    }

    private void fireTempoEsgotado() {
        for (Runnable ouvinte : this.ouvintes) {
            ouvinte.run();
        }
    }

    private class ContaTempo
    extends Thread {
        public ContaTempo() {
            super("Contador de tempo");
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                ContaTempo.sleep(Temporizador.this.time);
                Temporizador.this.fireTempoEsgotado();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

