/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import sun.swing.SwingUtilities2;

public class TTitledBorder
extends TitledBorder {
    private char mnemonic = '\u0000';
    private Point textLoc = new Point();
    private JComponent componenteFoco = null;
    private JComponent componentePai = null;

    public TTitledBorder(String title, char mnemonic, JComponent componentePai, JComponent enviarFocoPara) {
        super(title);
        this.setMnemonic(mnemonic);
        this.setComponenteParaFoco(enviarFocoPara);
        this.setComponentePai(componentePai);
        this.configurarInputMap();
    }

    public void setMnemonic(char c) {
        this.mnemonic = c;
        this.configurarInputMap();
    }

    public void setComponentePai(JComponent c) {
        this.componentePai = c;
    }

    public void setComponenteParaFoco(JComponent c) {
        this.componenteFoco = c;
    }

    private void configurarInputMap() {
        if (this.mnemonic == '\u0000' || this.componenteFoco == null || this.componentePai == null) {
            return;
        }
        String inputMapName = "mnemonic_" + String.valueOf(this.mnemonic).toUpperCase();
        char charMaiusculo = String.valueOf(this.mnemonic).toUpperCase().charAt(0);
        this.componentePai.getInputMap(0).put(KeyStroke.getKeyStroke((int)charMaiusculo, 8), inputMapName);
        this.componentePai.getInputMap(2).put(KeyStroke.getKeyStroke((int)charMaiusculo, 8), inputMapName);
        this.componentePai.getInputMap(1).put(KeyStroke.getKeyStroke((int)charMaiusculo, 8), inputMapName);
        this.componentePai.getActionMap().put(inputMapName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(TTitledBorder.this.componenteFoco instanceof JTable) || TTitledBorder.this.componenteFoco instanceof JTable && ((JTable)TTitledBorder.this.componenteFoco).getRowCount() > 0) {
                    JTable t;
                    if (TTitledBorder.this.componenteFoco instanceof JTable && (t = (JTable)TTitledBorder.this.componenteFoco).getSelectedRow() < 0) {
                        t.setRowSelectionInterval(0, 0);
                    }
                    ScreenUtil.requisitarFoco(TTitledBorder.this.componenteFoco);
                }
            }
        });
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder();
        if (this.getTitle() == null || this.getTitle().equals("")) {
            if (border != null) {
                border.paintBorder(c, g, x, y, width, height);
            }
            return;
        }
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        g.setFont(this.getFont(c));
        JComponent jc = c instanceof JComponent ? (JComponent)c : null;
        FontMetrics fm = SwingUtilities2.getFontMetrics(jc, g);
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int stringWidth = SwingUtilities2.stringWidth(jc, fm, this.getTitle());
        Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        int titlePos = this.getTitlePosition();
        switch (titlePos) {
            case 1: {
                int diff = ascent + descent + (Math.max(2, 4) - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - (descent + 2);
                break;
            }
            case 0: 
            case 2: {
                int diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
                break;
            }
            case 3: {
                this.textLoc.y = grooveRect.y + insets.top + ascent + 2;
                break;
            }
            case 4: {
                this.textLoc.y = grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
                break;
            }
            case 5: {
                grooveRect.height -= fontHeight / 2;
                this.textLoc.y = grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
                break;
            }
            case 6: {
                grooveRect.height -= fontHeight;
                this.textLoc.y = grooveRect.y + grooveRect.height + ascent + 2;
            }
        }
        int justification = this.getTitleJustification();
        if (justification == 4 || justification == 0) {
            justification = 1;
        } else if (justification == 5) {
            justification = 3;
        }
        switch (justification) {
            case 1: {
                this.textLoc.x = grooveRect.x + 5 + insets.left;
                break;
            }
            case 3: {
                this.textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 5 + insets.right);
                break;
            }
            case 2: {
                this.textLoc.x = grooveRect.x + (grooveRect.width - stringWidth) / 2;
            }
        }
        if (border != null) {
            if ((titlePos == 2 || titlePos == 0) && grooveRect.y > this.textLoc.y - ascent || titlePos == 5 && grooveRect.y + grooveRect.height < this.textLoc.y + descent) {
                Rectangle clipRect = new Rectangle();
                Rectangle saveClip = g.getClipBounds();
                clipRect.setBounds(saveClip);
                if (TTitledBorder.computeIntersection(clipRect, x, y, this.textLoc.x - 1 - x, height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                clipRect.setBounds(saveClip);
                if (TTitledBorder.computeIntersection(clipRect, this.textLoc.x + stringWidth + 1, y, x + width - (this.textLoc.x + stringWidth + 1), height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                if (titlePos == 2 || titlePos == 0) {
                    clipRect.setBounds(saveClip);
                    if (TTitledBorder.computeIntersection(clipRect, this.textLoc.x - 1, this.textLoc.y + descent, stringWidth + 2, y + height - this.textLoc.y - descent)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                } else {
                    clipRect.setBounds(saveClip);
                    if (TTitledBorder.computeIntersection(clipRect, this.textLoc.x - 1, y, stringWidth + 2, this.textLoc.y - ascent - y)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                }
                g.setClip(saveClip);
            } else {
                border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
        }
        g.setColor(this.getTitleColor());
        if (this.mnemonic != '\u0000') {
            SwingUtilities2.drawStringUnderlineCharAt(jc, g, this.getTitle(), this.getTitle().indexOf(this.mnemonic), this.textLoc.x, this.textLoc.y);
        } else {
            SwingUtilities2.drawString(jc, g, this.getTitle(), this.textLoc.x, this.textLoc.y);
        }
        g.setFont(font);
        g.setColor(color);
    }

    private static boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }
}

