/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.ConstantesGerais;
import jalis.util.ComponenteUtils;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.text.DefaultFormatterFactory;

public class TTextFieldTelefone
extends TTextField {
    private static final int TELEFONE_OITO_DIGITOS = 8;
    private String mascaraTelefone = "";

    public TTextFieldTelefone(int qtdeCaracteres, String mascaraTelefone) {
        this.mascaraTelefone = mascaraTelefone;
        this.enableEvents(4L);
        this.setFocusLostBehavior(1);
        this.adicionaCorFoco(this);
        this.setDocument((TTextField)this.new TTextField.TDocument(qtdeCaracteres, 16));
    }

    @Override
    public void setText(String t) {
        char[] telefoneMascarado;
        StringBuilder telefoneSemFormato = new StringBuilder();
        if (t == null) {
            t = "";
        }
        for (char c : telefoneMascarado = t.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            telefoneSemFormato.append(c);
        }
        if (!Funcoes.textoVazio(telefoneSemFormato.toString())) {
            t = telefoneSemFormato.toString();
        }
        TTextField textField = new TTextField(20);
        TTextFieldTelefone.mascaraTelefone(this.mascaraTelefone, textField);
        textField.setText(t);
        String telefoneFormatado = textField.getText();
        String espacoFinal = telefoneFormatado.substring(telefoneFormatado.length() - 1, telefoneFormatado.length());
        if (espacoFinal.matches("\\s") && Funcoes.isNumeric(telefoneSemFormato.toString())) {
            int tamanho = telefoneSemFormato.toString().length();
            if (tamanho - 8 >= 0) {
                telefoneSemFormato = telefoneSemFormato.insert(tamanho - 8, this.getEspacoMascara());
            }
            textField.setText(telefoneSemFormato.toString());
            telefoneFormatado = textField.getText();
        }
        super.setText(telefoneFormatado);
    }

    private String getEspacoMascara() {
        char[] mascara;
        String espacos = " ";
        for (char c : mascara = this.mascaraTelefone.trim().toCharArray()) {
            if (!Character.isSpaceChar(c)) continue;
            espacos = espacos + c;
        }
        return espacos;
    }

    private void adicionaCorFoco(TTextFieldTelefone t) {
        if (t == null) {
            return;
        }
        t.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((TTextFieldTelefone)e.getSource()).setBackground(ConstantesGerais.COR_FUNDO);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((TTextFieldTelefone)e.getSource()).setBackground(Color.white);
            }
        });
    }

    @Override
    public void clear() {
        if (this.getFormatterFactory() != null) {
            this.setValue(null);
        }
        this.setText("");
    }

    private static void mascaraTelefone(String mascara, TTextField ... txt) {
        if (!Funcoes.textoVazio(mascara)) {
            for (TTextField t : txt) {
                try {
                    DefaultFormatterFactory defaultFormatterFactory = ComponenteUtils.criaFormatacao(mascara);
                    t.setFormatterFactory(defaultFormatterFactory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

