/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.ConstantesGerais;
import jalis.util.ComponenteUtils;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.text.DefaultFormatterFactory;

public class TTextFieldCPF
extends TTextField {
    private static final String MASCARA_CNPJ = "##.###.###/####-##";
    private static final int QTDE_CARACTERES_CPF = 11;
    private static final String MASCARA_CPF = "###.###.###-##";
    private static final int QTDE_CARACTERES_CNPJ = 14;
    private String mascaraCPF = "";
    private int tipo;

    public TTextFieldCPF(int qtdeCaracteres) {
        this.mascaraCPF = MASCARA_CPF;
        this.enableEvents(4L);
        this.setFocusLostBehavior(0);
        this.adicionaCorFoco(this);
        this.setDocument((TTextField)this.new TTextField.TDocument(qtdeCaracteres, 8));
    }

    public TTextFieldCPF(int qtdeCaracteres, int tipo) {
        if (tipo == 8) {
            this.configParaCPF(qtdeCaracteres, tipo);
        } else if (tipo == 7) {
            this.configParaCNPJ(qtdeCaracteres, tipo);
        }
    }

    public void configParaCPF(int qtdeCaracteres, int tipo) {
        this.mascaraCPF = MASCARA_CPF;
        this.config(qtdeCaracteres, tipo);
    }

    private void config(int qtdeCaracteres, int tipo) {
        this.enableEvents(4L);
        this.setFocusLostBehavior(0);
        this.adicionaCorFoco(this);
        this.tipo = tipo;
    }

    public void configParaCNPJ(int qtdeCaracteres, int tipo) {
        this.mascaraCPF = MASCARA_CNPJ;
        this.config(qtdeCaracteres, tipo);
    }

    @Override
    public void setText(String t) {
        char[] cpf;
        StringBuilder cpfSemFormato = new StringBuilder();
        if (t == null) {
            t = "";
        }
        for (char c : cpf = t.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            cpfSemFormato.append(c);
        }
        if (!Funcoes.textoVazio(cpfSemFormato.toString())) {
            t = cpfSemFormato.toString();
        }
        TTextField textField = new TTextField(20);
        TTextFieldCPF.mascaraCPF(this.mascaraCPF, textField);
        textField.setText(t);
        String cpfFormatado = textField.getText();
        String espacoFinal = cpfFormatado.substring(cpfFormatado.length() - 1, cpfFormatado.length());
        if (espacoFinal.matches("\\s") && Funcoes.isNumeric(cpfSemFormato.toString())) {
            int tamanho = cpfSemFormato.toString().length();
            if (this.tipo == 8 && tamanho - 11 >= 0) {
                cpfSemFormato = cpfSemFormato.insert(tamanho - 11, this.getEspacoMascara());
            }
            if (this.tipo == 7 && tamanho - 14 >= 0) {
                cpfSemFormato = cpfSemFormato.insert(tamanho - 14, this.getEspacoMascara());
            }
            textField.setText(cpfSemFormato.toString());
            cpfFormatado = textField.getText();
        }
        super.setText(cpfFormatado);
    }

    private String getEspacoMascara() {
        char[] mascara;
        String espacos = " ";
        for (char c : mascara = this.mascaraCPF.trim().toCharArray()) {
            if (!Character.isSpaceChar(c)) continue;
            espacos = espacos + c;
        }
        return espacos;
    }

    private void adicionaCorFoco(TTextFieldCPF t) {
        if (t == null) {
            return;
        }
        t.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((TTextFieldCPF)e.getSource()).setBackground(ConstantesGerais.COR_FUNDO);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((TTextFieldCPF)e.getSource()).setBackground(Color.white);
            }
        });
    }

    @Override
    public void clear() {
        if (this.getFormatterFactory() != null) {
            this.setValue(null);
        }
        this.setText("");
    }

    private static void mascaraCPF(String mascara, TTextField ... txt) {
        if (!Funcoes.textoVazio(mascara)) {
            for (TTextField t : txt) {
                try {
                    DefaultFormatterFactory defaultFormatterFactory = ComponenteUtils.criaFormatacao(mascara);
                    t.setFormatterFactory(defaultFormatterFactory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setText(this.getText());
    }
}

