/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.util.DocumentoMascara;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TTextField
extends JFormattedTextField
implements KeyListener,
FocusListener {
    private String maskDecimal = "#,##0.00";
    private boolean isValidarConteudo = true;
    private boolean isUpperCase = false;
    private final int QTDE_MAXIMA_PARTE_INTEIRA_CARACTERES_FLUTUANTE = 9;

    public void setMaskDecimal(String mask) {
        if (mask != null) {
            this.maskDecimal = mask;
        }
    }

    public void setUpperCase(boolean upper) {
        this.isUpperCase = upper;
        if (this.getDocument() instanceof TDocument) {
            ((TDocument)this.getDocument()).setUpperCase(this.isUpperCase);
        }
    }

    public String getMaskDecimal() {
        return this.maskDecimal;
    }

    public void setDocument(int qtdeCaracteres, int tipoDoc) {
        this.setDocument(new TDocument(qtdeCaracteres, tipoDoc));
    }

    public TDocument criaDocument(int qtdeCaracteres, int tipoDoc) {
        return new TDocument(qtdeCaracteres, tipoDoc);
    }

    public void setDocument(int tipoDoc) {
        this.setDocument(new TDocument(tipoDoc));
    }

    public String getTextDB() {
        return StringUtil.textoDB(this.getText());
    }

    public String getTextDBEscape() {
        return StringUtil.textoDBEscape(this.getText());
    }

    public String getTextDecimal() {
        if (Funcoes.isNumeric(this.getText().replace(',', '.'))) {
            return Funcoes.formataDecimal(this.maskDecimal, Double.parseDouble(this.getText().replace(',', '.')));
        }
        return this.getText();
    }

    public void clear() {
        if (this.getFormatterFactory() != null) {
            this.setValue(null);
        }
        this.setText("");
    }

    private void adicionaCorFoco(TTextField t) {
        if (t == null) {
            return;
        }
        t.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((TTextField)e.getSource()).setBackground(ConstantesGerais.COR_FUNDO);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((TTextField)e.getSource()).setBackground(Color.white);
            }
        });
    }

    public TTextField() {
        this.adicionaCorFoco(this);
        this.addFocusListener(this);
    }

    public TTextField(String formato) {
        super((Object)formato);
        this.adicionaCorFoco(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TTextField o = (TTextField)e.getSource();
                o.setCaretPosition(o.getText().trim().length());
            }
        });
        this.addFocusListener(this);
    }

    public TTextField(int qtdeCaracteres, String regex) {
        this.adicionaCorFoco(this);
        TDocument documento = new TDocument(qtdeCaracteres, 3);
        documento.setRegex(regex);
        this.setDocument(documento);
    }

    public TTextField(int qtdeCaracteres) {
        this.adicionaCorFoco(this);
        this.setDocument(new TDocument(qtdeCaracteres, 3));
    }

    public TTextField(int qtdeCaracteres, int tipoDoc, int casaDecimais) {
        this.adicionaCorFoco(this);
        this.montaMascaraCampos(qtdeCaracteres, tipoDoc, casaDecimais, false);
    }

    public TTextField(int qtdeCaracteres, int tipoDoc, int casaDecimais, boolean isAdicionarEspacoPercentual) {
        this.adicionaCorFoco(this);
        this.montaMascaraCampos(qtdeCaracteres, tipoDoc, casaDecimais, isAdicionarEspacoPercentual);
    }

    private void montaMascaraCampos(int qtdeCaracteres, int tipoDoc, int casaDecimais, boolean isAdicionarEspacoPercentual) {
        if (tipoDoc == 4) {
            qtdeCaracteres = 10;
            this.addKeyListener(this);
        } else if (tipoDoc == 12) {
            qtdeCaracteres = 5;
            this.addKeyListener(this);
        } else if (tipoDoc == 7) {
            qtdeCaracteres = 18;
        } else if (tipoDoc == 9) {
            qtdeCaracteres = 9;
        }
        this.setDocument(new TDocument(qtdeCaracteres, tipoDoc));
        if (tipoDoc == 2) {
            this.setMaskDecimal("0." + Funcoes.preencheZero(0, isAdicionarEspacoPercentual ? casaDecimais : casaDecimais));
            this.setDocument(new DocumentoMascara(this, this.gerarMascaraFlutuante(qtdeCaracteres, isAdicionarEspacoPercentual ? casaDecimais + 1 : casaDecimais), 2));
            this.setHorizontalAlignment(4);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    boolean isPercent = TTextField.super.getText().indexOf("%") > 0;
                    String temp = TTextField.super.getText();
                    if (!isPercent) {
                        TTextField.this.setText(temp.trim());
                        return;
                    }
                    if (isPercent && TTextField.super.getText().indexOf("%") >= TTextField.super.getText().length() - 1) {
                        return;
                    }
                    if (isPercent) {
                        temp = TTextField.this.getText().substring(0, TTextField.super.getText().indexOf("%"));
                    }
                    if (temp.contains("%")) {
                        temp = StringUtil.limpaString(temp, new String[]{"%"});
                    }
                    if (Funcoes.isNumeric(temp)) {
                        temp = Funcoes.formataDecimal(TTextField.this.maskDecimal, Double.parseDouble(temp));
                        if (isPercent) {
                            TTextField.this.setText(temp + "%");
                        } else {
                            TTextField.this.setText(temp);
                        }
                    }
                }
            });
        } else if (tipoDoc == 10) {
            this.setMaskDecimal("0." + Funcoes.preencheZero(0, casaDecimais));
            this.setDocument(new DocumentoMascara(this, this.gerarMascaraPercentual(qtdeCaracteres, casaDecimais), tipoDoc));
        } else if (tipoDoc == 4) {
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (Funcoes.verificaData(TTextField.this.getText())) {
                        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                        sdf.setLenient(false);
                        try {
                            TTextField.this.setText(Funcoes.formataData(sdf.parse(TTextField.this.getText())));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        } else if (tipoDoc == 12) {
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (Funcoes.verificaDataReduzida(TTextField.this.getText())) {
                        SimpleDateFormat sdf = new SimpleDateFormat("MM/yy");
                        sdf.setLenient(false);
                        try {
                            TTextField.this.setText(Funcoes.formataDataReduzida(sdf.parse(TTextField.this.getText())));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        if (tipoDoc == 2 || tipoDoc == 1 || tipoDoc == 10) {
            this.setHorizontalAlignment(4);
        }
        this.addFocusListener(this);
    }

    public TTextField(int qtdeCaracteres, int tipoDoc) {
        this.adicionaCorFoco(this);
        if (tipoDoc == 4) {
            qtdeCaracteres = 10;
            this.addKeyListener(this);
        } else if (tipoDoc == 12) {
            qtdeCaracteres = 5;
            this.addKeyListener(this);
        } else if (tipoDoc == 7) {
            qtdeCaracteres = 18;
        } else if (tipoDoc == 9) {
            qtdeCaracteres = 9;
        }
        this.setDocument(new TDocument(qtdeCaracteres, tipoDoc));
        if (tipoDoc == 2) {
            String mask = this.gerarMascaraFlutuante(qtdeCaracteres, tipoDoc);
            this.setMaskDecimal("0." + Funcoes.preencheZero(0, tipoDoc));
            this.setDocument(new DocumentoMascara(this, mask, 2));
        } else if (tipoDoc == 10) {
            this.setHorizontalAlignment(4);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    boolean isPercent = TTextField.super.getText().indexOf("%") > 0;
                    String temp = TTextField.super.getText();
                    if (isPercent) {
                        temp = TTextField.this.getText().substring(0, TTextField.super.getText().indexOf("%"));
                    }
                    if (Funcoes.isNumeric(temp.replaceAll("[.]", "").replace(',', '.'))) {
                        temp = Funcoes.formataDecimal(TTextField.this.maskDecimal, Double.parseDouble(temp.replaceAll("[.]", "").replace(',', '.')));
                        if (isPercent) {
                            TTextField.this.setText(temp + "%");
                        } else {
                            TTextField.this.setText(temp);
                        }
                    }
                }
            });
        } else if (tipoDoc == 4) {
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (Funcoes.verificaData(TTextField.this.getText())) {
                        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                        sdf.setLenient(false);
                        try {
                            TTextField.this.setText(Funcoes.formataData(sdf.parse(TTextField.this.getText())));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        } else if (tipoDoc == 12) {
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (Funcoes.verificaDataReduzida(TTextField.this.getText())) {
                        SimpleDateFormat sdf = new SimpleDateFormat("MM/yy");
                        sdf.setLenient(false);
                        try {
                            TTextField.this.setText(Funcoes.formataDataReduzida(sdf.parse(TTextField.this.getText())));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        if (tipoDoc == 2 || tipoDoc == 1 || tipoDoc == 10) {
            this.setHorizontalAlignment(4);
        }
        this.addFocusListener(this);
    }

    public String gerarMascaraFlutuante(int qtdeCaracteres, int casasDecimais) {
        int i;
        if (qtdeCaracteres <= 0) {
            qtdeCaracteres = 10;
        }
        if (casasDecimais < 0) {
            throw new IllegalArgumentException("Quantidade de casas decimais \u00e9 inv\u00e1lida.");
        }
        if (qtdeCaracteres - casasDecimais > 9) {
            qtdeCaracteres = 9 + casasDecimais;
        }
        StringBuilder mask = new StringBuilder();
        StringBuilder maskNumber = new StringBuilder();
        int cont = 0;
        for (i = 0; i < qtdeCaracteres - casasDecimais; ++i) {
            if (cont == 3) {
                cont = 0;
                maskNumber.append(".");
            }
            maskNumber.append("#");
            ++cont;
        }
        mask.append((CharSequence)maskNumber.reverse());
        if (casasDecimais > 0) {
            mask.append(",");
        }
        for (i = 0; i < casasDecimais; ++i) {
            mask.append("#");
        }
        return mask.toString();
    }

    public String gerarMascaraPercentual(int qtdeCaracteres, int casasDecimais) {
        int i;
        if (qtdeCaracteres <= 0) {
            qtdeCaracteres = 5;
        }
        if (casasDecimais < 0) {
            throw new IllegalArgumentException("Quantidade de casas decimais \u00e9 inv\u00e1lida.");
        }
        StringBuilder mask = new StringBuilder();
        StringBuilder maskNumber = new StringBuilder();
        int cont = 0;
        for (i = 0; i < qtdeCaracteres - casasDecimais; ++i) {
            if (cont == 3) {
                cont = 0;
                maskNumber.append(".");
            }
            maskNumber.append("#");
            ++cont;
        }
        mask.append((CharSequence)maskNumber.reverse());
        if (casasDecimais > 0) {
            mask.append(",");
        }
        for (i = 0; i < casasDecimais; ++i) {
            mask.append("#");
        }
        return mask.toString();
    }

    private String retiraDecimal(String texto) throws ParseException {
        DecimalFormat meuFormato = new DecimalFormat(this.maskDecimal.trim().length() == 0 ? "#,###0.00" : this.maskDecimal);
        return String.valueOf(meuFormato.parse(texto));
    }

    @Override
    public String getText() {
        String texto = super.getText();
        if (this.getDocument() instanceof TDocument && ((TDocument)this.getDocument()).getTipoDocumento() == 2 || this.getDocument() instanceof DocumentoMascara && ((DocumentoMascara)this.getDocument()).getTipoDocumento() == 2) {
            texto = texto.replaceAll("\\.", "").replaceAll("\\,", ".");
            texto = texto.replaceAll("\\s+", "");
            String valor = null;
            if (texto.contains("%")) {
                valor = StringUtil.limpaString(texto, new String[]{"%"});
            }
            if (Funcoes.isNumeric(texto) || Funcoes.isNumeric(valor)) {
                return texto;
            }
            return "";
        }
        return texto;
    }

    public Date getData() {
        if (this.getDocument() instanceof TDocument && ((TDocument)this.getDocument()).getTipoDocumento() == 4) {
            if (super.getText().matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])/\\d{4}")) {
                return Funcoes.stringToDate("dd/MM/yyyy", super.getText());
            }
        } else if (this.getDocument() instanceof TDocument && ((TDocument)this.getDocument()).getTipoDocumento() == 12 && super.getText().matches("(0[1-9]|1[012])/\\d{2}")) {
            return Funcoes.stringToDate("MM/yy", super.getText());
        }
        return null;
    }

    @Override
    @Deprecated
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.getDocument() != null && ((TDocument)this.getDocument()).getTipoDocumento() == 4) {
            if (e.getKeyCode() == 38) {
                if (Funcoes.textoVazio(this)) {
                    this.setText(Funcoes.formataData(new Date()));
                } else {
                    try {
                        Date data = Funcoes.getDataComException("dd/MM/yyyy", this.getText());
                        data = Funcoes.somaDias(data, 1);
                        this.setText(Funcoes.formataData(data));
                    }
                    catch (Exception data) {}
                }
            } else if (e.getKeyCode() == 40) {
                if (Funcoes.textoVazio(this)) {
                    this.setText(Funcoes.formataData(new Date()));
                } else {
                    try {
                        Date data = Funcoes.getDataComException("dd/MM/yyyy", this.getText());
                        data = Funcoes.subtraiDias(data, 1);
                        this.setText(Funcoes.formataData(data));
                    }
                    catch (Exception data) {}
                }
            } else if (e.getKeyCode() == 34) {
                if (Funcoes.textoVazio(this)) {
                    this.setText(Funcoes.formataData(new Date()));
                } else {
                    try {
                        Date data = Funcoes.getDataComException("dd/MM/yyyy", this.getText());
                        data = Funcoes.subtraiMeses(data, 1);
                        this.setText(Funcoes.formataData(data));
                    }
                    catch (Exception data) {}
                }
            } else if (e.getKeyCode() == 33) {
                if (Funcoes.textoVazio(this)) {
                    this.setText(Funcoes.formataData(new Date()));
                } else {
                    try {
                        Date data = Funcoes.getDataComException("dd/MM/yyyy", this.getText());
                        data = Funcoes.somaMeses(data, 1);
                        this.setText(Funcoes.formataData(data));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    public void keyReleased(KeyEvent e) {
    }

    @Override
    @Deprecated
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!this.isValidarConteudo) {
            return;
        }
        if (e.getComponent() == this && !e.isTemporary() && this.getDocument() instanceof TDocument) {
            if (((TDocument)this.getDocument()).getTipoDocumento() == 4) {
                if (!Funcoes.textoVazio(this.getText()) && !Funcoes.verificaData(this.getText())) {
                    Funcoes.mensagem(this, "Data inv\u00e1lida.", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 12) {
                if (!Funcoes.textoVazio(this.getText()) && !Funcoes.verificaDataReduzida(this.getText())) {
                    Funcoes.mensagem(this, "Data inv\u00e1lida.", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 6 || ((TDocument)this.getDocument()).getTipoDocumento() == 13) {
                if (!Funcoes.textoVazio(this.getText()) && (((TDocument)this.getDocument()).getTipoDocumento() == 6 && !Funcoes.verificaHora(this.getText()) || ((TDocument)this.getDocument()).getTipoDocumento() == 13 && !this.getText().matches("([0-9]\\d|2[0-9]):[0-5]\\d"))) {
                    int horaParaTeste;
                    String auxMinutos;
                    String auxHora = this.getText().substring(0, this.getText().indexOf(":") == -1 ? (2 > this.getText().length() ? this.getText().length() : 2) : this.getText().indexOf(":"));
                    String string = auxMinutos = this.getText().indexOf(":") == -1 ? null : this.getText().substring(this.getText().indexOf(":") + 1);
                    if (auxMinutos != null) {
                        auxMinutos = auxMinutos.length() == 0 ? null : auxMinutos;
                    }
                    int n = horaParaTeste = ((TDocument)this.getDocument()).getTipoDocumento() == 6 ? 23 : 99;
                    if (!Funcoes.textoVazio(auxHora) && Integer.parseInt(auxHora) <= horaParaTeste) {
                        if (auxHora.length() == 1 && auxMinutos == null) {
                            this.setText("0" + auxHora + ":00");
                        } else if (auxHora.length() == 2 && auxMinutos == null) {
                            this.setText(auxHora + ":00");
                        } else if (auxHora.length() == 2 && auxMinutos.length() == 1) {
                            this.setText(auxHora + ":" + auxMinutos + "0");
                        }
                        if (((TDocument)this.getDocument()).getTipoDocumento() == 6 && !Funcoes.verificaHora(this.getText())) {
                            Funcoes.mensagem(this, "Hora inv\u00e1lida.", 2);
                            ScreenUtil.requisitarFoco(this);
                        } else if (((TDocument)this.getDocument()).getTipoDocumento() == 13 && !this.getText().matches("([0-9]\\d|2[0-9]):[0-5]\\d")) {
                            Funcoes.mensagem(this, "Intervalo inv\u00e1lido.", 2);
                            ScreenUtil.requisitarFoco(this);
                        }
                    } else {
                        Funcoes.mensagem(this, "Hora inv\u00e1lida.", 2);
                        ScreenUtil.requisitarFoco(this);
                    }
                } else if (this.getText().length() == 4) {
                    this.setText(this.getText() + "0");
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 14) {
                if (!Funcoes.textoVazio(this.getText()) && !Funcoes.verificaDataHora(this.getText())) {
                    Funcoes.mensagem(this, "Data/Hora inv\u00e1lida.", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 15) {
                if (!Funcoes.textoVazio(this.getText()) && !this.getText().matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$")) {
                    Funcoes.mensagem(this, "Email inv\u00e1lido.", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 17) {
                this.setText(this.getText().trim());
                if (!Funcoes.textoVazio(this.getText()) && !this.getText().matches("([_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})(([\\s,;]+)|[\\s]*))+")) {
                    Funcoes.mensagem(this, "Campo e-mail possui valor(es) inv\u00e1lido(s).", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 16 && (!Funcoes.textoVazio(this.getText()) && this.getText().trim().length() < ParametrosGerais.getMascaraFone().length() - 1 || this.getQtdeEspacoTelefone() > this.getQtdeEspacoMascaraTelefone())) {
                String fone = this.getText();
                for (char c : ParametrosGerais.getMascaraFone().toCharArray()) {
                    fone = fone.replaceAll("\\" + c, "");
                }
                if (!Funcoes.textoVazio(fone)) {
                    if (this.getFormatterFactory() != null) {
                        this.setValue(null);
                    }
                    this.setText("");
                    ScreenUtil.requisitarFoco(this);
                }
            }
        }
    }

    public void validar(FocusEvent e) {
        if (e.getComponent() == this && !e.isTemporary() && this.getDocument() instanceof TDocument) {
            if (((TDocument)this.getDocument()).getTipoDocumento() == 4) {
                if (!Funcoes.textoVazio(this.getText()) && !Funcoes.verificaData(this.getText())) {
                    Funcoes.mensagem(this, "Data inv\u00e1lida.", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 12) {
                if (!Funcoes.textoVazio(this.getText()) && !Funcoes.verificaDataReduzida(this.getText())) {
                    Funcoes.mensagem(this, "Data inv\u00e1lida.", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 6 || ((TDocument)this.getDocument()).getTipoDocumento() == 13) {
                if (!Funcoes.textoVazio(this.getText()) && (((TDocument)this.getDocument()).getTipoDocumento() == 6 && !Funcoes.verificaHora(this.getText()) || ((TDocument)this.getDocument()).getTipoDocumento() == 13 && !this.getText().matches("([0-9]\\d|2[0-9]):[0-5]\\d"))) {
                    int horaParaTeste;
                    String auxMinutos;
                    String auxHora = this.getText().substring(0, this.getText().indexOf(":") == -1 ? (2 > this.getText().length() ? this.getText().length() : 2) : this.getText().indexOf(":"));
                    String string = auxMinutos = this.getText().indexOf(":") == -1 ? null : this.getText().substring(this.getText().indexOf(":") + 1);
                    if (auxMinutos != null) {
                        auxMinutos = auxMinutos.length() == 0 ? null : auxMinutos;
                    }
                    int n = horaParaTeste = ((TDocument)this.getDocument()).getTipoDocumento() == 6 ? 23 : 99;
                    if (!Funcoes.textoVazio(auxHora) && Integer.parseInt(auxHora) <= horaParaTeste) {
                        if (auxHora.length() == 1 && auxMinutos == null) {
                            this.setText("0" + auxHora + ":00");
                        } else if (auxHora.length() == 2 && auxMinutos == null) {
                            this.setText(auxHora + ":00");
                        } else if (auxHora.length() == 2 && auxMinutos.length() == 1) {
                            this.setText(auxHora + ":" + auxMinutos + "0");
                        }
                        if (((TDocument)this.getDocument()).getTipoDocumento() == 6 && !Funcoes.verificaHora(this.getText())) {
                            Funcoes.mensagem(this, "Hora inv\u00e1lida.", 2);
                            ScreenUtil.requisitarFoco(this);
                        } else if (((TDocument)this.getDocument()).getTipoDocumento() == 13 && !this.getText().matches("([0-9]\\d|2[0-9]):[0-5]\\d")) {
                            Funcoes.mensagem(this, "Intervalo inv\u00e1lido.", 2);
                            ScreenUtil.requisitarFoco(this);
                        }
                    } else {
                        Funcoes.mensagem(this, "Hora inv\u00e1lida.", 2);
                        ScreenUtil.requisitarFoco(this);
                    }
                } else if (this.getText().length() == 4) {
                    this.setText(this.getText() + "0");
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 14) {
                if (!Funcoes.textoVazio(this.getText()) && !Funcoes.verificaDataHora(this.getText())) {
                    Funcoes.mensagem(this, "Data/Hora inv\u00e1lida.", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 15) {
                if (!Funcoes.textoVazio(this.getText()) && !this.getText().matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$")) {
                    Funcoes.mensagem(this, "Email inv\u00e1lido.", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 17) {
                this.setText(this.getText().trim());
                if (!Funcoes.textoVazio(this.getText()) && !this.getText().matches("([_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})(([\\s,;]+)|[\\s]*))+")) {
                    Funcoes.mensagem(this, "Campo e-mail possui valor(es) inv\u00e1lido(s).", 2);
                    ScreenUtil.requisitarFoco(this);
                }
            } else if (((TDocument)this.getDocument()).getTipoDocumento() == 16 && (!Funcoes.textoVazio(this.getText()) && this.getText().trim().length() < ParametrosGerais.getMascaraFone().length() - 1 || this.getQtdeEspacoTelefone() > this.getQtdeEspacoMascaraTelefone())) {
                String fone = this.getText();
                for (char c : ParametrosGerais.getMascaraFone().toCharArray()) {
                    fone = fone.replaceAll("\\" + c, "");
                }
                if (!Funcoes.textoVazio(fone)) {
                    if (this.getFormatterFactory() != null) {
                        this.setValue(null);
                    }
                    this.setText("");
                    ScreenUtil.requisitarFoco(this);
                }
            }
        }
    }

    private int getQtdeEspacoTelefone() {
        int qtd = 0;
        for (char c : this.getText().toCharArray()) {
            if (!Character.isSpaceChar(c)) continue;
            ++qtd;
        }
        return qtd;
    }

    private int getQtdeEspacoMascaraTelefone() {
        int qtd = 1;
        for (char c : ParametrosGerais.getMascaraFone().trim().toCharArray()) {
            if (!Character.isSpaceChar(c)) continue;
            ++qtd;
        }
        if (qtd == 1) {
            return qtd++;
        }
        return qtd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConteudoValido() {
        if (!(this.getDocument() instanceof TDocument)) return true;
        if (((TDocument)this.getDocument()).getTipoDocumento() == 4) {
            if (Funcoes.textoVazio(this.getText()) || Funcoes.verificaData(this.getText())) return true;
            return false;
        }
        if (((TDocument)this.getDocument()).getTipoDocumento() == 12) {
            if (Funcoes.textoVazio(this.getText()) || Funcoes.verificaDataReduzida(this.getText())) return true;
            return false;
        }
        if (((TDocument)this.getDocument()).getTipoDocumento() == 6 || ((TDocument)this.getDocument()).getTipoDocumento() == 13) {
            if (!Funcoes.textoVazio(this.getText()) && (((TDocument)this.getDocument()).getTipoDocumento() == 6 && !Funcoes.verificaHora(this.getText()) || ((TDocument)this.getDocument()).getTipoDocumento() == 13 && !this.getText().matches("([0-9]\\d|2[0-9]):[0-5]\\d"))) {
                int horaParaTeste;
                String auxMinutos;
                String auxHora = this.getText().substring(0, this.getText().indexOf(":") == -1 ? (2 > this.getText().length() ? this.getText().length() : 2) : this.getText().indexOf(":"));
                String string = auxMinutos = this.getText().indexOf(":") == -1 ? null : this.getText().substring(this.getText().indexOf(":") + 1);
                if (auxMinutos != null) {
                    auxMinutos = auxMinutos.length() == 0 ? null : auxMinutos;
                }
                int n = horaParaTeste = ((TDocument)this.getDocument()).getTipoDocumento() == 6 ? 23 : 99;
                if (Funcoes.textoVazio(auxHora) || Integer.parseInt(auxHora) > horaParaTeste) return false;
                if (auxHora.length() == 1 && auxMinutos == null) {
                    this.setText("0" + auxHora + ":00");
                } else if (auxHora.length() == 2 && auxMinutos == null) {
                    this.setText(auxHora + ":00");
                } else if (auxHora.length() == 2 && auxMinutos.length() == 1) {
                    this.setText(auxHora + ":" + auxMinutos + "0");
                }
                if (((TDocument)this.getDocument()).getTipoDocumento() == 6 && !Funcoes.verificaHora(this.getText())) {
                    return false;
                }
                if (((TDocument)this.getDocument()).getTipoDocumento() != 13 || this.getText().matches("([0-9]\\d|2[0-9]):[0-5]\\d")) return true;
                return false;
            }
            if (this.getText().length() != 4) return true;
            this.setText(this.getText() + "0");
            return true;
        } else {
            if (((TDocument)this.getDocument()).getTipoDocumento() == 14) {
                if (Funcoes.textoVazio(this.getText()) || Funcoes.verificaDataHora(this.getText())) return true;
                return false;
            }
            if (((TDocument)this.getDocument()).getTipoDocumento() == 15) {
                if (Funcoes.textoVazio(this.getText()) || this.getText().trim().matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$")) return true;
                return false;
            }
            if (((TDocument)this.getDocument()).getTipoDocumento() != 17) return true;
            this.setText(this.getText().trim());
            if (Funcoes.textoVazio(this.getText()) || this.getText().matches("([_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})(([\\s,;]+)|[\\s]*))+")) return true;
            return false;
        }
    }

    public void setValidarConteudo(boolean isValidar) {
        this.isValidarConteudo = isValidar;
    }

    public boolean isValidarConteudo() {
        return this.isValidarConteudo;
    }

    public class TDocument
    extends PlainDocument {
        private int maxLength = 0;
        private boolean isUpperCase = false;
        private String regex = "";
        public static final int TIPO_NUMERO = 1;
        public static final int TIPO_FLUTUANTE = 2;
        public static final int TIPO_TEXTO = 3;
        public static final int TIPO_DATA = 4;
        public static final int TIPO_DOCUMENTO = 5;
        public static final int TIPO_HORA = 6;
        public static final int TIPO_CNPJ = 7;
        public static final int TIPO_CPF = 8;
        public static final int TIPO_CEP = 9;
        public static final int TIPO_PERCENTUAL = 10;
        public static final int TIPO_INTERVALO = 11;
        public static final int TIPO_DATA_REDUZIDA = 12;
        public static final int TIPO_INTERVALO_HORA = 13;
        public static final int TIPO_DATA_HORA = 14;
        public static final int TIPO_EMAIL = 15;
        public static final int TIPO_TELEFONE = 16;
        public static final int TIPO_LISTA_EMAIL = 17;
        public static final int TIPO_CODIGO = 18;
        public static final int TIPO_TABELA_PRECO = 19;
        private int tipoDocumento = 1;

        public void setUpperCase(boolean upper) {
            this.isUpperCase = upper;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }

        public TDocument(int maxChars, int tipoDoc) {
            if (maxChars != this.maxLength) {
                this.maxLength = maxChars;
            }
            this.tipoDocumento = tipoDoc;
        }

        public TDocument(int tipoDoc) {
            this.tipoDocumento = tipoDoc;
        }

        public TDocument(int maxChars, String regex) {
            if (maxChars != this.maxLength) {
                this.maxLength = maxChars;
            }
            this.regex = regex;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public int getTipoDocumento() {
            return this.tipoDocumento;
        }

        public void setTipoDocumento(int tipoDoc) {
            this.tipoDocumento = tipoDoc;
        }

        public void setMaxChars(int maxChars) {
            this.maxLength = maxChars;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str != null) {
                int qtdeFinal = this.getLength() + str.length();
                boolean aceitaDigito = true;
                switch (this.tipoDocumento) {
                    case 4: {
                        aceitaDigito = str.matches("[0-9/]+");
                        break;
                    }
                    case 6: {
                        aceitaDigito = str.matches("[0-9:]+");
                        break;
                    }
                    case 13: {
                        aceitaDigito = str.matches("[0-9:]+");
                        break;
                    }
                    case 1: {
                        aceitaDigito = str.matches("[0-9]+");
                        break;
                    }
                    case 2: {
                        aceitaDigito = str.matches("-?[0-9,.]*");
                        break;
                    }
                    case 10: {
                        aceitaDigito = str.matches("-?[0-9,.]*%?");
                        break;
                    }
                    case 11: {
                        aceitaDigito = str.matches("[0-9,-]+");
                        break;
                    }
                    case 5: {
                        aceitaDigito = str.matches("[a-zA-Z0-9./-]+");
                        break;
                    }
                    case 7: {
                        aceitaDigito = str.matches("([0-9]{0,2}[\\.][0-9]{0,3}[\\.][0-9]{0,3}[/][0-9]{0,4}[-][0-9]{2})|([0-9]{0,14})");
                        break;
                    }
                    case 9: {
                        aceitaDigito = str.matches("[0-9/-]+");
                        break;
                    }
                    case 12: {
                        aceitaDigito = str.matches("[0-9/]+");
                        break;
                    }
                    case 14: {
                        aceitaDigito = str.matches("[0-9/:\\s]+");
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 17: {
                        break;
                    }
                    case 18: {
                        aceitaDigito = str.matches("[A-Za-z0-9]+");
                        break;
                    }
                    case 19: {
                        aceitaDigito = str.matches("[0-9.-]+");
                        break;
                    }
                    default: {
                        aceitaDigito = Funcoes.textoVazio(this.regex) ? true : str.matches(this.regex);
                    }
                }
                if (aceitaDigito) {
                    if (this.tipoDocumento == 2 || this.tipoDocumento == 10) {
                        if (str.equals(".")) {
                            str = ",";
                        } else if (str.equals(",")) {
                            str = "";
                        }
                    }
                    if (this.maxLength == 0 || qtdeFinal <= this.maxLength) {
                        super.insertString(offs, this.isUpperCase ? str.toUpperCase() : str, a);
                    } else if (qtdeFinal > this.maxLength) {
                        String nova = str.substring(0, this.maxLength - this.getLength());
                        super.insertString(offs, this.isUpperCase ? nova.toUpperCase() : nova, a);
                    }
                    if (this.tipoDocumento == 4 && (this.getLength() == 3 || this.getLength() == 6)) {
                        super.insertString(offs, "/", a);
                    }
                    if (this.tipoDocumento == 12) {
                        if (this.getLength() == 3) {
                            super.insertString(offs, "/", a);
                        }
                    } else if (this.tipoDocumento == 6) {
                        if (this.getLength() == 3) {
                            super.insertString(offs, ":", a);
                        }
                    } else if (this.tipoDocumento == 13 && this.getLength() == 3) {
                        super.insertString(offs, ":", a);
                    }
                    if (this.tipoDocumento == 7) {
                        if (this.getLength() > 2 && !this.getText(2, 1).equalsIgnoreCase(".")) {
                            super.insertString(2, ".", a);
                        }
                        if (this.getLength() > 6 && !this.getText(6, 1).equalsIgnoreCase(".")) {
                            super.insertString(6, ".", a);
                        }
                        if (this.getLength() > 10 && !this.getText(10, 1).equalsIgnoreCase("/")) {
                            super.insertString(10, "/", a);
                        }
                        if (this.getLength() > 15 && !this.getText(15, 1).equalsIgnoreCase("-")) {
                            super.insertString(15, "-", a);
                        }
                    } else if (this.tipoDocumento == 9) {
                        if (this.getLength() == 6) {
                            super.insertString(offs, "-", a);
                        }
                    } else if (this.tipoDocumento == 14) {
                        if (this.getLength() == 3 || this.getLength() == 6) {
                            super.insertString(offs, "/", a);
                        }
                        if (this.getLength() == 11) {
                            super.insertString(offs, " ", a);
                        }
                        if (this.getLength() == 14) {
                            super.insertString(offs, ":", a);
                        }
                    }
                }
            }
        }
    }
}

