/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.ConstantesGerais;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class TDialog {
    private static final int SANGRIA_TEXTO = 80;
    private static final int SANGRIA_BOTOES = 10;
    private static final int MAX_TAMANHO = 700;
    private final String TITULO_ERRO = "Erro";
    private final String TITULO_ALERTA = "Alerta";
    private final String TITULO_PERGUNTA = "Pergunta";
    private final String TITULO_INFO = "Informa\u00e7\u00e3o";
    public static final int OPCAO_SIM = 0;
    public static final int OPCAO_OK = 0;
    public static final int OPCAO_NAO = 1;
    public static final int OPCAO_CANCEL = 2;
    public static final int OPCAO_FECHOU = -1;
    public static final int OPCAO_SUBSTITUIR = 3;
    public static final int OPCAO_ATUALIZAR = 4;
    public static final int PADRAO_SIM = 0;
    public static final int PADRAO_NAO = 1;
    public final int PADRAO_CANCELAR = 2;
    public static final int PADRAO_SUBSTITUIR = 3;
    private static final int PADRAO_ATUALIZAR = 4;
    static ImageIcon ICON_QUESTION = ImagemUtils.carregaImagemJalis("dialog_question.gif");
    static ImageIcon ICON_ERROR = ImagemUtils.carregaImagemJalis("dialog_error.gif");
    static ImageIcon ICON_WARNING = ImagemUtils.carregaImagemJalis("dialog_warning.gif");
    static ImageIcon ICON_INFO = ImagemUtils.carregaImagemJalis("dialog_info.gif");
    JDialog dlg;
    JButton button_ok = new TDButton("OK");
    JButton button_sim = new TDButton("Sim");
    JButton button_nao = new TDButton("N\u00e3o");
    JButton button_cancel = new TDButton("Cancelar");
    JButton buttonSubstituir = new JButton("Substituir");
    JButton buttonAtualizar = new JButton("Atualizar");
    JLabel label_msg = new JLabel();
    JLabel label_icon = new JLabel();
    JPanel panel_main = new JPanel(new BorderLayout());
    JPanel panel_bottom = new JPanel(new FlowLayout(1));
    JPanel panel_left = new JPanel(new BorderLayout());
    JPanel panel_right = new JPanel(new BorderLayout());
    JPanel panel_msg = new JPanel(new BorderLayout());
    JPanel panel_input = new JPanel(null);
    TTextField text_field = ComponenteFactory.novoTTextField(100, 3);
    ArrayList<JButton> lista;
    int option = -1;
    JComponent toFocus;
    Component parent;
    private final Action acaoPadrao = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TDialog.this.button_cancel) {
                TDialog.this.option = 2;
            } else if (e.getSource() == TDialog.this.button_nao) {
                TDialog.this.option = 1;
            } else if (e.getSource() == TDialog.this.button_ok) {
                TDialog.this.option = 0;
            } else if (e.getSource() == TDialog.this.button_sim) {
                TDialog.this.option = 0;
            }
            TDialog.this.dlg.dispose();
        }
    };

    protected <T extends Window> void novoDialog(T parent) {
        if (parent != null) {
            if (parent instanceof Frame) {
                this.dlg = new JDialog((Frame)parent);
            } else if (parent instanceof Dialog) {
                this.dlg = new JDialog((Dialog)parent);
            }
        } else {
            this.dlg = new JDialog(new JDialog(parent));
        }
        this.init();
    }

    protected void init() {
        try {
            Funcoes.montaEnter((JComponent)this.panel_bottom);
            Funcoes.montaEnter((JComponent)this.panel_main);
            Funcoes.montaEnter((JComponent)this.panel_msg);
            Funcoes.montaEnter((JComponent)this.panel_input);
            this.dlg.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
            this.button_cancel.setDisplayedMnemonicIndex(0);
            this.button_cancel.setName("button_cancel");
            this.button_nao.setDisplayedMnemonicIndex(0);
            this.button_nao.setName("button_nao");
            this.button_sim.setDisplayedMnemonicIndex(0);
            this.button_sim.setName("button_sim");
            this.button_ok.setDisplayedMnemonicIndex(0);
            this.button_ok.setName("button_ok");
            this.buttonSubstituir.setName("button_substituir");
            this.buttonAtualizar.setName("button_atualizar");
            this.dlg.setPreferredSize(new Dimension(170, 100));
            this.dlg.setSize(new Dimension(170, 100));
            this.dlg.setModal(true);
            this.dlg.getContentPane().setLayout(new BorderLayout());
            this.dlg.add((Component)this.panel_main, "Center");
            this.dlg.add((Component)this.panel_bottom, "South");
            this.dlg.requestFocus();
            this.dlg.setDefaultCloseOperation(0);
            this.panel_main.add((Component)this.panel_left, "West");
            this.panel_main.add((Component)this.panel_right, "Center");
            this.panel_left.add((Component)this.label_icon, "Center");
            this.panel_right.add((Component)this.panel_msg, "Center");
            this.panel_right.add((Component)this.panel_input, "South");
            this.panel_msg.add((Component)this.label_msg, "Center");
            this.panel_input.add((Component)this.text_field, null);
            this.panel_input.setPreferredSize(new Dimension(10, 25));
            this.panel_input.setVisible(false);
            this.panel_bottom.setPreferredSize(new Dimension(10, 35));
            this.panel_bottom.add(this.button_ok);
            this.panel_bottom.add(this.button_sim);
            this.panel_bottom.add(this.button_nao);
            this.panel_bottom.add(this.button_cancel);
            this.panel_bottom.add(this.buttonSubstituir);
            this.panel_bottom.add(this.buttonAtualizar);
            this.button_ok.setVisible(false);
            this.button_sim.setVisible(false);
            this.button_nao.setVisible(false);
            this.button_cancel.setVisible(false);
            this.buttonSubstituir.setVisible(false);
            this.buttonAtualizar.setVisible(false);
            this.panel_left.setPreferredSize(new Dimension(60, 40));
            this.label_msg.setVerticalAlignment(0);
            this.label_icon.setHorizontalAlignment(0);
            this.label_icon.setVerticalAlignment(0);
            this.button_ok.addKeyListener(new AcaoBotao(0));
            this.button_ok.addMouseListener(new AcaoBotao(0));
            this.button_cancel.addKeyListener(new AcaoBotao(2));
            this.button_cancel.addMouseListener(new AcaoBotao(2));
            this.button_sim.addMouseListener(new AcaoBotao(0));
            this.button_sim.addKeyListener(new AcaoBotao(0));
            this.button_nao.addMouseListener(new AcaoBotao(1));
            this.button_nao.addKeyListener(new AcaoBotao(1));
            this.buttonSubstituir.addMouseListener(new AcaoBotao(3));
            this.buttonSubstituir.addKeyListener(new AcaoBotao(3));
            this.buttonAtualizar.addMouseListener(new AcaoBotao(4));
            this.buttonAtualizar.addKeyListener(new AcaoBotao(4));
            this.button_cancel.getInputMap(2).put(KeyStroke.getKeyStroke(67, 512, false), "ACAO");
            this.button_cancel.getActionMap().put("ACAO", this.acaoPadrao);
            this.button_nao.getInputMap(2).put(KeyStroke.getKeyStroke(78, 512, false), "ACAO");
            this.button_nao.getActionMap().put("ACAO", this.acaoPadrao);
            this.button_sim.getInputMap(2).put(KeyStroke.getKeyStroke(83, 512, false), "ACAO");
            this.button_sim.getActionMap().put("ACAO", this.acaoPadrao);
            this.button_ok.getInputMap(2).put(KeyStroke.getKeyStroke(79, 512, false), "ACAO");
            this.button_ok.getActionMap().put("ACAO", this.acaoPadrao);
            this.dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    TDialog.this.dlg.getRootPane().revalidate();
                    TDialog.this.dlg.getRootPane().repaint();
                    TDialog.this.toFocus.requestFocus();
                }
            });
            this.panel_input.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = TDialog.this.panel_input.getSize().width;
                    TDialog.this.text_field.setBounds(3, 3, w - 6, 20);
                    TDialog.this.text_field.revalidate();
                    TDialog.this.text_field.repaint();
                }
            });
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this.dlg, ex.getMessage(), ex.getStackTrace(), "TDialog");
        }
    }

    int showMessage(Component c, String mensagem, int tipoMensagem) {
        return this.showMessage(c, mensagem, tipoMensagem, 0);
    }

    int showMessage(Component c, String mensagem, int tipoMensagem, int botaoPadrao) {
        if (this.dlg != null && this.dlg.isShowing()) {
            this.dlg.setVisible(false);
            this.dlg.dispose();
        }
        int retorno = 0;
        this.parent = c;
        Window w = c instanceof Frame ? (Frame)c : (c instanceof Dialog ? (Dialog)c : (c instanceof JPanel && ((JPanel)c).getTopLevelAncestor() != null ? (((JPanel)c).getTopLevelAncestor() instanceof Frame ? (Frame)((JPanel)c).getTopLevelAncestor() : (((JPanel)c).getTopLevelAncestor() instanceof Dialog ? (Dialog)((JPanel)c).getTopLevelAncestor() : null)) : null));
        switch (tipoMensagem) {
            case 2: {
                if (botaoPadrao == 3 || botaoPadrao == 4) {
                    retorno = this.showPerguntaSubstituirAtualizar(w, "Alerta", mensagem, botaoPadrao);
                    break;
                }
                retorno = this.showAlertaOK(w, mensagem);
                break;
            }
            case 0: {
                retorno = this.showErro(w, mensagem);
                break;
            }
            case 1: {
                retorno = this.showInfo(w, mensagem);
                break;
            }
            case 3: {
                retorno = this.showPerguntaSimNao(w, "Pergunta", mensagem, botaoPadrao);
                break;
            }
            default: {
                retorno = this.showInfo(w, mensagem);
            }
        }
        return retorno;
    }

    public <T extends Window> int showErro(T parent, String mensagem) {
        this.preparaDados(parent, "Erro", ICON_ERROR, mensagem, this.button_ok);
        this.addBotoes(this.button_ok);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showErro(T parent, String titulo, String mensagem) {
        this.preparaDados(parent, titulo, ICON_ERROR, mensagem, this.button_ok);
        this.addBotoes(this.button_ok);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showInfo(T parent, String mensagem) {
        this.preparaDados(parent, "Informa\u00e7\u00e3o", ICON_INFO, mensagem, this.button_ok);
        this.addBotoes(this.button_ok);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showInfo(T parent, String titulo, String mensagem) {
        this.preparaDados(parent, titulo, ICON_INFO, mensagem, this.button_ok);
        this.addBotoes(this.button_ok);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showAlertaOK(T parent, String mensagem) {
        this.preparaDados(parent, "Alerta", ICON_WARNING, mensagem, this.button_ok);
        this.addBotoes(this.button_ok);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showAlertaOK(T parent, String titulo, String mensagem) {
        this.preparaDados(parent, titulo, ICON_WARNING, mensagem, this.button_ok);
        this.addBotoes(this.button_ok);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showAlertaOKCancel(T parent, String mensagem) {
        this.preparaDados(parent, "Alerta", ICON_WARNING, mensagem, this.button_ok);
        this.addBotoes(this.button_ok, this.button_cancel);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showAlertaOKCancel(T parent, String titulo, String mensagem) {
        this.preparaDados(parent, titulo, ICON_WARNING, mensagem, this.button_ok);
        this.addBotoes(this.button_ok, this.button_cancel);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showAlertaSimNao(T parent, String mensagem) {
        this.preparaDados(parent, "Alerta", ICON_WARNING, mensagem, this.button_sim);
        this.addBotoes(this.button_sim, this.button_nao);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showAlertaSimNao(T parent, String titulo, String mensagem) {
        this.preparaDados(parent, titulo, ICON_WARNING, mensagem, this.button_sim);
        this.addBotoes(this.button_sim, this.button_nao);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showAlertaSimNaoCancel(T parent, String mensagem) {
        this.preparaDados(parent, "Alerta", ICON_WARNING, mensagem, this.button_sim);
        this.addBotoes(this.button_sim, this.button_nao, this.button_cancel);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showAlertaSimNaoCancel(T parent, String titulo, String mensagem) {
        this.preparaDados(parent, titulo, ICON_WARNING, mensagem, this.button_sim);
        this.addBotoes(this.button_sim, this.button_nao, this.button_cancel);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showPerguntaOKCancel(T parent, String mensagem) {
        this.preparaDados(parent, "Pergunta", ICON_QUESTION, mensagem, this.button_ok);
        this.addBotoes(this.button_ok, this.button_cancel);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showPerguntaOKCancel(T parent, String titulo, String mensagem) {
        this.preparaDados(parent, titulo, ICON_QUESTION, mensagem, this.button_ok);
        this.addBotoes(this.button_ok, this.button_cancel);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showPerguntaSimNao(T parent, String mensagem) {
        return this.showPerguntaSimNao(parent, "Pergunta", mensagem, 0);
    }

    public <T extends Window> int showPerguntaSimNao(T parent, String titulo, String mensagem) {
        return this.showPerguntaSimNao(parent, titulo, mensagem, 0);
    }

    public <T extends Window> int showPerguntaSimNao(T parent, String titulo, String mensagem, int botaoPadrao) {
        this.preparaDados(parent, titulo, ICON_QUESTION, mensagem, botaoPadrao == 0 ? this.button_sim : this.button_nao);
        this.addBotoes(this.button_sim, this.button_nao);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showPerguntaSimNaoCancel(T parent, String mensagem) {
        this.preparaDados(parent, "Pergunta", ICON_QUESTION, mensagem, this.button_sim);
        this.addBotoes(this.button_sim, this.button_nao, this.button_cancel);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showPerguntaSimNaoCancel(T parent, String titulo, String mensagem) {
        this.preparaDados(parent, titulo, ICON_QUESTION, mensagem, this.button_sim);
        this.addBotoes(this.button_sim, this.button_nao, this.button_cancel);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showPerguntaSubstituirAtualizar(T parent, String titulo, String mensagem, int botaoPadrao) {
        this.preparaDados(parent, titulo, ICON_WARNING, mensagem, botaoPadrao == 3 ? this.buttonSubstituir : this.buttonAtualizar);
        this.addBotoes(this.buttonSubstituir, this.buttonAtualizar);
        this.dlg.setDefaultCloseOperation(2);
        this.resizeCenterAndShow();
        return this.option;
    }

    public <T extends Window> int showPerguntaOpcoes(T parent, String mensagem, String[] opcoes) {
        this.lista = new ArrayList();
        for (int i = 0; i < opcoes.length; ++i) {
            TDButton novo = new TDButton(opcoes[i]);
            novo.addMouseListener(new AcaoBotao(i));
            novo.addKeyListener(new AcaoBotao(i));
            this.panel_bottom.add(novo);
            this.lista.add(novo);
        }
        this.parent = parent;
        this.preparaDados(parent, "Pergunta", ICON_QUESTION, mensagem, this.lista.get(0));
        this.resizeCenterAndShow();
        while (!this.lista.isEmpty()) {
            this.panel_bottom.remove(this.lista.remove(0));
        }
        return this.option;
    }

    public <T extends Window> int showPerguntaOpcoes(T parent, String titulo, String mensagem, String[] opcoes) {
        this.lista = new ArrayList();
        for (int i = 0; i < opcoes.length; ++i) {
            TDButton novo = new TDButton(opcoes[i]);
            novo.addMouseListener(new AcaoBotao(i));
            novo.addKeyListener(new AcaoBotao(i));
            this.panel_bottom.add(novo);
            this.lista.add(novo);
        }
        this.preparaDados(parent, titulo, ICON_QUESTION, mensagem, this.lista.get(0));
        this.resizeCenterAndShow();
        while (!this.lista.isEmpty()) {
            this.panel_bottom.remove(this.lista.remove(0));
        }
        return this.option;
    }

    public <T extends Window> int showPerguntaOpcoes(T parent, String mensagem, String[] opcoes, char[] mnemonicos) {
        this.lista = new ArrayList();
        for (int i = 0; i < opcoes.length; ++i) {
            TDButton novo = new TDButton(opcoes[i]);
            if (i < mnemonicos.length) {
                novo.setMnemonic(mnemonicos[i]);
            }
            novo.addKeyListener(new AcaoBotao(i));
            novo.addMouseListener(new AcaoBotao(i));
            this.panel_bottom.add(novo);
            this.lista.add(novo);
        }
        this.preparaDados(parent, "Pergunta", ICON_QUESTION, mensagem, this.lista.get(0));
        this.resizeCenterAndShow();
        while (!this.lista.isEmpty()) {
            this.panel_bottom.remove(this.lista.remove(0));
        }
        return this.option;
    }

    public <T extends Window> int showPerguntaOpcoes(T parent, String titulo, String mensagem, String[] opcoes, char[] mnemonicos) {
        this.lista = new ArrayList();
        for (int i = 0; i < opcoes.length; ++i) {
            TDButton novo = new TDButton(opcoes[i]);
            if (i < mnemonicos.length) {
                novo.setMnemonic(mnemonicos[i]);
            }
            novo.addKeyListener(new AcaoBotao(i));
            novo.addMouseListener(new AcaoBotao(i));
            this.panel_bottom.add(novo);
            this.lista.add(novo);
        }
        this.preparaDados(parent, titulo, ICON_QUESTION, mensagem, this.lista.get(0));
        this.resizeCenterAndShow();
        while (!this.lista.isEmpty()) {
            this.panel_bottom.remove(this.lista.remove(0));
        }
        return this.option;
    }

    public <T extends Window> int showPerguntaOpcoes(T parent, String titulo, String mensagem, String[] opcoes, char[] mnemonicos, int icone) {
        this.lista = new ArrayList();
        int i = 0;
        while (i < opcoes.length) {
            TDButton novo = new TDButton(opcoes[i]);
            if (i < mnemonicos.length) {
                novo.setMnemonic(mnemonicos[i]);
            }
            novo.addKeyListener(new AcaoBotao(i));
            novo.addMouseListener(new AcaoBotao(i));
            final String[] opcoesAction = opcoes;
            final int posicao = i++;
            novo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == TDialog.this.button_cancel) {
                        TDialog.this.option = 2;
                    } else if (e.getSource() == TDialog.this.button_nao) {
                        TDialog.this.option = 1;
                    } else if (e.getSource() == TDialog.this.button_ok) {
                        TDialog.this.option = 0;
                    } else if (e.getSource() == TDialog.this.button_sim) {
                        TDialog.this.option = 0;
                    } else if (((TDButton)e.getSource()).getText().equals(opcoesAction[posicao])) {
                        TDialog.this.option = posicao;
                    }
                    TDialog.this.dlg.dispose();
                }
            });
            this.panel_bottom.add(novo);
            this.lista.add(novo);
        }
        ImageIcon imageIcon = null;
        switch (icone) {
            case 0: {
                imageIcon = ICON_QUESTION;
                break;
            }
            case 1: {
                imageIcon = ICON_ERROR;
                break;
            }
            case 2: {
                imageIcon = ICON_WARNING;
                break;
            }
            case 3: {
                imageIcon = ICON_INFO;
                break;
            }
            default: {
                imageIcon = ICON_QUESTION;
            }
        }
        this.parent = parent;
        this.preparaDados(parent, titulo, imageIcon, mensagem, this.lista.get(0));
        this.resizeCenterAndShow();
        while (!this.lista.isEmpty()) {
            this.panel_bottom.remove(this.lista.remove(0));
        }
        return this.option;
    }

    public <T extends Window> String showDigitacao(T parent, String titulo, String mensagem) {
        return this.showDigitacao(parent, titulo, mensagem, "");
    }

    public <T extends Window> String showDigitacao(T parent, String titulo, String mensagem, String valor_predefinido) {
        this.text_field.setText(valor_predefinido);
        this.preparaDados(parent, titulo, ICON_INFO, mensagem, this.text_field);
        this.addBotoes(this.button_ok);
        this.panel_input.setVisible(true);
        this.resizeCenterAndShow();
        this.panel_input.setVisible(false);
        return this.text_field.getText().trim();
    }

    <T extends Window> void preparaDados(T parent, String titulo, Icon icon, String mensagem, JComponent selecionado) {
        this.novoDialog(parent);
        this.init();
        this.dlg.setTitle(titulo);
        this.setIcon(icon);
        this.setMessage(mensagem == null ? titulo : mensagem);
        this.toFocus = selecionado;
    }

    private void resizeCenterAndShow() {
        FontMetrics metrics = this.label_msg.getFontMetrics(this.label_msg.getFont());
        String text = this.label_msg.getText();
        int linhas = this.getNumLinhas(text);
        int largura = this.getMaxLargura(text, metrics) + 80;
        int botoes = this.getEspacoBotoes();
        int altura = linhas * metrics.getHeight();
        if ((largura = Math.max(botoes, largura)) > 700) {
            largura = 700;
            altura += this.contaLinhasGigantes(text, metrics) * metrics.getHeight();
        }
        Dimension dlgSize = this.dlg.getSize();
        Dimension frmSize = null;
        if (this.parent == null || !this.verificarPaiVisivel()) {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            frmSize = new Dimension(gd.getDisplayMode().getWidth(), gd.getDisplayMode().getHeight());
        } else {
            frmSize = new Dimension((int)((double)this.parent.getWidth() + 2.0 * this.parent.getLocationOnScreen().getX()), (int)((double)this.parent.getHeight() + this.parent.getLocationOnScreen().getY()));
        }
        int posX = (int)((frmSize.getWidth() - (double)largura) / 2.0);
        int posY = (int)((frmSize.getHeight() - (double)altura) / 2.0);
        this.dlg.setBounds(posX, posY, largura, this.dlg.getSize().height + altura);
        this.dlg.setAlwaysOnTop(true);
        this.dlg.paint(this.dlg.getGraphics());
        this.dlg.requestFocus();
        this.dlg.setVisible(true);
        this.button_ok.setVisible(false);
        this.button_sim.setVisible(false);
        this.button_nao.setVisible(false);
        this.button_cancel.setVisible(false);
        this.dlg.setPreferredSize(new Dimension(170, 100));
        this.dlg.setSize(new Dimension(170, 100));
    }

    private boolean verificarPaiVisivel() {
        try {
            Point p = this.parent.getLocationOnScreen();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int contaLinhasGigantes(String html_text, FontMetrics metrics) {
        String[] linhas = html_text.replaceAll("\\<.*?\\>", "").split("<br>");
        int linhas_gigantes = 0;
        for (int i = 0; i < linhas.length; ++i) {
            if (metrics.stringWidth(linhas[i]) < 700) continue;
            ++linhas_gigantes;
        }
        return linhas_gigantes;
    }

    private int getEspacoBotoes() {
        Component[] botoes = this.panel_bottom.getComponents();
        int espaco = 0;
        for (int i = 0; i < botoes.length; ++i) {
            if (!((JButton)botoes[i]).isVisible()) continue;
            espaco += ((JButton)botoes[i]).getPreferredSize().width;
        }
        espaco += ((FlowLayout)this.panel_bottom.getLayout()).getHgap() * (botoes.length + 1);
        return espaco += 10;
    }

    private int getMaxLargura(String html_text, FontMetrics metrics) {
        String[] linhas = html_text.split("<br>");
        int max = 0;
        for (int i = 0; i < linhas.length; ++i) {
            String linha = linhas[i];
            int tamanho = metrics.stringWidth(linha = linha.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", ""));
            if (tamanho <= max) continue;
            max = tamanho;
        }
        return max;
    }

    private int getNumLinhas(String html_text) {
        String[] linhas = html_text.split("<br>");
        return linhas.length;
    }

    private void setMessage(String msg) {
        msg = "<html>" + msg.replaceAll("\n", "<br>") + "</html>";
        this.label_msg.setText(msg);
        this.label_msg.getFontMetrics(this.label_msg.getFont()).getLineMetrics(msg, this.label_msg.getGraphics());
    }

    private void setIcon(Icon icon) {
        this.label_icon.setIcon(icon);
    }

    private void addBotoes(JButton ... buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setVisible(true);
        }
    }

    class TDTextField
    extends JTextField {
        TDTextField() {
            this.addKeyListener(new TDKeyListener());
            this.addFocusListener(new TDFocusListener());
        }
    }

    class TDButton
    extends JButton {
        TDButton(String text, char mnemonic) {
            this.addKeyListener(new TDKeyListener());
            this.setText(text);
            this.setMnemonic(mnemonic);
        }

        TDButton(String text) {
            this.addKeyListener(new TDKeyListener());
            this.setText(text);
        }
    }

    class TDFocusListener
    implements FocusListener {
        TDFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTextField f = (JTextField)e.getSource();
            f.setBackground(ConstantesGerais.COR_FUNDO);
            f.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextField f = (JTextField)e.getSource();
            f.setBackground(UIManager.getColor("TextField.background"));
        }
    }

    class TDKeyListener
    implements KeyListener {
        TDKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            block7: {
                Component c;
                block6: {
                    block5: {
                        block4: {
                            c = (Component)e.getSource();
                            if (e.getKeyCode() == 38) break block4;
                            if (!(c instanceof JButton)) break block5;
                            if (e.getKeyCode() != 37) break block5;
                        }
                        this.focoAnterior(c);
                    }
                    if (e.getKeyCode() == 40) break block6;
                    if (!(c instanceof JButton)) break block7;
                    if (e.getKeyCode() != 39) break block7;
                }
                this.focoPosterior(c);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        public void focoPosterior(Component c) {
            c.getFocusCycleRootAncestor().getFocusTraversalPolicy().getComponentAfter(c.getFocusCycleRootAncestor(), c).requestFocus();
        }

        public void focoAnterior(Component c) {
            c.getFocusCycleRootAncestor().getFocusTraversalPolicy().getComponentBefore(c.getFocusCycleRootAncestor(), c).requestFocus();
        }
    }

    class AcaoBotao
    implements MouseListener,
    KeyListener {
        int opcao = 0;

        AcaoBotao(int option) {
            this.opcao = option;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                TDialog.this.option = this.opcao;
                TDialog.this.dlg.dispose();
                e.setKeyCode(0);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TDialog.this.option = this.opcao;
            TDialog.this.dlg.dispose();
        }

        @Override
        @Deprecated
        public void keyTyped(KeyEvent e) {
        }

        @Override
        @Deprecated
        public void keyReleased(KeyEvent e) {
        }

        @Override
        @Deprecated
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        @Deprecated
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        @Deprecated
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        @Deprecated
        public void mouseExited(MouseEvent e) {
        }
    }
}

