/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.Conexao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.resultados.EditarResultado;
import jalis.laboratorio.recepcao.preagendamento.RequisicaoPreAgendamento;
import jalis.laboratorio.resultados.DigitacaoConferencia;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class TAvisoLabel
extends JLabel {
    public static final int INSET_IMAGEM = 5;
    public static final int WIDTH_IMAGEM = 15;
    public static final int HEIGHT_IMAGEM = 15;
    private Rectangle areaAviso = null;
    private Rectangle areaAviso2 = null;
    private Rectangle areaAviso3 = null;
    private String aviso = null;
    private String avisoNomeSocial = null;
    private String avisoGenero = null;
    private Image imagemAviso = ImagemUtils.carregaImagemJalis("error.png").getImage();
    private Image imagemLgbt = ImagemUtils.carregaImagemJalis("lgbt.png").getImage();
    private Image imagemGenero = ImagemUtils.carregaImagemJalis("genero.png").getImage();
    private static final LineBorder BORDER_AVISO = new LineBorder(Color.RED);
    private Border borderAntiga = null;
    private int posicao = 0;
    private boolean quebrarLinha = false;

    public TAvisoLabel() {
        this.inicializaComponente(null);
    }

    public TAvisoLabel(String text) {
        super(text);
        this.inicializaComponente(null);
    }

    public TAvisoLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.inicializaComponente(null);
    }

    public TAvisoLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.inicializaComponente(null);
    }

    public TAvisoLabel(Icon image) {
        super(image);
        this.inicializaComponente(null);
    }

    public TAvisoLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.inicializaComponente(null);
    }

    public TAvisoLabel(Border border) {
        this.inicializaComponente(null);
        this.borderAntiga = border;
    }

    private void inicializaComponente(String aviso) {
        this.aviso = aviso;
        this.addMouseListener(new ListenerMouse());
        this.addMouseMotionListener(new ListenerMouseMotion());
        this.addComponentListener(new ListenerComponente());
        this.recalcularPosicoes();
    }

    public void setImagem(ImageIcon imagem) {
        if (imagem != null) {
            this.imagemAviso = imagem.getImage();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.areaAviso != null && this.imagemAviso != null) {
            g.drawImage(this.imagemAviso, new Double(this.areaAviso.getX()).intValue(), new Double(this.areaAviso.getY()).intValue(), null);
        }
        if (this.areaAviso2 != null && this.imagemLgbt != null) {
            g.drawImage(this.imagemLgbt, new Double(this.areaAviso2.getX()).intValue(), new Double(this.areaAviso2.getY()).intValue(), null);
        }
        if (this.areaAviso3 != null && this.imagemGenero != null) {
            g.drawImage(this.imagemGenero, new Double(this.areaAviso3.getX()).intValue(), new Double(this.areaAviso3.getY()).intValue(), null);
        }
    }

    @Override
    public void paintBorder(Graphics g) {
        if (this.areaAviso != null && this.imagemAviso != null || this.areaAviso2 != null && this.imagemLgbt != null) {
            if (this.getBorder() != BORDER_AVISO) {
                this.borderAntiga = this.getBorder();
                this.setBorder(BORDER_AVISO);
            }
        } else if (this.borderAntiga != null && this.getBorder() != this.borderAntiga) {
            this.setBorder(this.borderAntiga);
        }
        super.paintBorder(g);
    }

    public String getAvisoNomeSocial() {
        return this.avisoNomeSocial;
    }

    public String getAviso() {
        return this.aviso;
    }

    public void setAviso(String aviso) {
        this.aviso = aviso;
        if (!(aviso == null || this.getRootPane() != null && this.getRootPane().getGlassPane() instanceof GlassPaneMensagem)) {
            aviso = "<html>" + aviso.replace("\n", "<br>") + "</html>";
            this.setToolTipText(aviso);
        }
        this.recalcularPosicoes();
        this.repaint();
    }

    public void setNomeSocial(String nomeSocial) {
        if (Funcoes.textoVazio(nomeSocial)) {
            this.areaAviso2 = null;
            this.avisoNomeSocial = null;
            return;
        }
        this.avisoNomeSocial = nomeSocial;
        this.avisoNomeSocial = String.format("Nome: %1$s", this.getText());
        this.setText(nomeSocial);
        this.recalcularPosicoes();
        this.repaint();
    }

    public void setGenero(String genero) {
        if (Funcoes.textoVazio(genero) || genero.equalsIgnoreCase("1")) {
            this.areaAviso3 = null;
            this.avisoGenero = null;
            return;
        }
        this.avisoGenero = genero;
        this.avisoGenero = String.format("G\u00eanero: %1$s", this.getDescricaoGenero(genero));
        this.recalcularPosicoes();
        this.repaint();
    }

    private String getDescricaoGenero(String codigoGenero) {
        String retorno = "";
        Statement st = Conexao.getStatement();
        String sql = "select ige_descricao from identidadegenero where ige_codigo = " + codigoGenero;
        try {
            ResultSet rs = st.executeQuery(sql);
            if (rs.next()) {
                retorno = rs.getString("ige_descricao");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public void setQuebrarLinha(boolean quebrarLinha) {
        this.quebrarLinha = quebrarLinha;
    }

    public void setAviso(String aviso, int posicao) {
        this.aviso = aviso;
        this.posicao = posicao;
        if (!(aviso == null || this.getRootPane() != null && this.getRootPane().getGlassPane() instanceof GlassPaneMensagem)) {
            aviso = "<html>" + aviso.replace("\n", "<br>") + "</html>";
            this.setToolTipText(aviso);
        }
        this.recalcularPosicoes();
        this.repaint();
    }

    private void recalcularPosicoes() {
        if (this.aviso != null) {
            int posicao_x = -1;
            int posicao_y = -1;
            int posicao_x2 = -1;
            int posicao_y2 = -1;
            int posicao_x3 = -1;
            int posicao_y3 = -1;
            if (this.getHorizontalAlignment() == 4) {
                posicao_x = 5;
            } else {
                int aux = this.getWidth() - 5 - 15;
                posicao_x = aux > 0 ? aux : -1;
                aux = (this.getHeight() - 15) / 2;
                posicao_y = aux > 0 ? aux : -1;
                Rectangle rectangle = this.areaAviso = posicao_x >= 0 && posicao_y >= 0 ? new Rectangle(posicao_x, posicao_y, 15, 15) : null;
                if (this.avisoNomeSocial != null) {
                    posicao_x2 = posicao_x - 19;
                    posicao_y2 = posicao_y;
                    this.areaAviso2 = posicao_x2 >= 0 && posicao_y >= 0 ? new Rectangle(posicao_x2, posicao_y2, 15, 15) : null;
                }
            }
        } else if (this.avisoNomeSocial != null) {
            int aux;
            int posicao_x2 = -1;
            int posicao_y2 = -1;
            posicao_x2 = this.getHorizontalAlignment() == 4 ? 5 : ((aux = this.getWidth() - 5 - 15) > 0 ? aux : -1);
            aux = (this.getHeight() - 15) / 2;
            posicao_y2 = aux > 0 ? aux : -1;
            this.areaAviso2 = posicao_x2 >= 0 && posicao_y2 >= 0 ? new Rectangle(posicao_x2, posicao_y2, 15, 15) : null;
        } else if (this.avisoGenero != null) {
            int aux;
            int posicao_x3 = -1;
            int posicao_y3 = -1;
            posicao_x3 = this.getHorizontalAlignment() == 4 ? 5 : ((aux = this.getWidth() - 5 - 15) > 0 ? aux : -1);
            aux = (this.getHeight() - 15) / 2;
            posicao_y3 = aux > 0 ? aux : -1;
            this.areaAviso3 = posicao_x3 >= 0 && posicao_y3 >= 0 ? new Rectangle(posicao_x3, posicao_y3, 15, 15) : null;
        }
        this.repaint();
    }

    class ListenerComponente
    implements ComponentListener {
        ListenerComponente() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (e.getSource() instanceof TAvisoLabel) {
                ((TAvisoLabel)e.getSource()).recalcularPosicoes();
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (e.getSource() instanceof TAvisoLabel) {
                ((TAvisoLabel)e.getSource()).recalcularPosicoes();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (e.getSource() instanceof TAvisoLabel) {
                ((TAvisoLabel)e.getSource()).recalcularPosicoes();
            }
        }

        @Override
        @Deprecated
        public void componentMoved(ComponentEvent e) {
        }
    }

    class ListenerMouseMotion
    extends MouseMotionAdapter {
        ListenerMouseMotion() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (TAvisoLabel.this.getRootPane() != null && (TAvisoLabel.this.getRootPane().getGlassPane() instanceof GlassPaneMensagem || TAvisoLabel.this.getRootPane().getGlassPane() instanceof JPanel)) {
                if (TAvisoLabel.this.avisoNomeSocial != null && TAvisoLabel.this.areaAviso2 != null && TAvisoLabel.this.areaAviso2.contains(e.getPoint())) {
                    if (TAvisoLabel.this.areaAviso2.contains(e.getPoint())) {
                        if (!Laboratorio.getInstancia().getComponenteMensagemVisivel()) {
                            Laboratorio.getInstancia().setComponenteMensagemVisivel(true);
                            Laboratorio.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoNomeSocial, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                        }
                    } else {
                        Laboratorio.getInstancia().setComponenteMensagemVisivel(false);
                    }
                } else if (TAvisoLabel.this.avisoGenero != null && TAvisoLabel.this.areaAviso3 != null) {
                    if (TAvisoLabel.this.areaAviso3.contains(e.getPoint())) {
                        if (!Laboratorio.getInstancia().getComponenteMensagemVisivel() && (TAvisoLabel.this.getRootPane().getGlassPane() instanceof GlassPaneMensagem || TAvisoLabel.this.getRootPane().getGlassPane() instanceof JPanel)) {
                            if (TAvisoLabel.this.getRootPane().getParent() instanceof Laboratorio) {
                                Laboratorio.getInstancia().setComponenteMensagemVisivel(true);
                                Laboratorio.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoGenero, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                            } else if (TAvisoLabel.this.getRootPane().getContentPane() instanceof DigitacaoConferencia) {
                                DigitacaoConferencia.getInstancia().setComponenteMensagemVisivel(true);
                                DigitacaoConferencia.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoGenero, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                            } else if (TAvisoLabel.this.getRootPane().getParent() instanceof EditarResultado) {
                                EditarResultado.getInstancia().setComponenteMensagemVisivel(true);
                                EditarResultado.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoGenero, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                            } else if (TAvisoLabel.this.getRootPane().getParent() instanceof RequisicaoPreAgendamento) {
                                RequisicaoPreAgendamento.getInstancia().setComponenteMensagemVisivel(true);
                                RequisicaoPreAgendamento.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoGenero, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                            }
                        }
                    } else if (TAvisoLabel.this.getRootPane().getParent() instanceof Laboratorio) {
                        Laboratorio.getInstancia().setComponenteMensagemVisivel(false);
                    } else if (TAvisoLabel.this.getRootPane().getContentPane() instanceof DigitacaoConferencia) {
                        DigitacaoConferencia.getInstancia().setComponenteMensagemVisivel(false);
                    } else if (TAvisoLabel.this.getRootPane().getParent() instanceof EditarResultado) {
                        EditarResultado.getInstancia().setComponenteMensagemVisivel(false);
                    } else if (TAvisoLabel.this.getRootPane().getParent() instanceof RequisicaoPreAgendamento) {
                        RequisicaoPreAgendamento.getInstancia().setComponenteMensagemVisivel(false);
                    }
                } else if (TAvisoLabel.this.aviso != null && TAvisoLabel.this.areaAviso != null && TAvisoLabel.this.areaAviso.contains(e.getPoint())) {
                    if (TAvisoLabel.this.areaAviso.contains(e.getPoint())) {
                        if (!Laboratorio.getInstancia().getComponenteMensagemVisivel()) {
                            Laboratorio.getInstancia().setComponenteMensagemVisivel(true);
                            Laboratorio.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.aviso, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                        }
                    } else {
                        Laboratorio.getInstancia().setComponenteMensagemVisivel(false);
                    }
                } else {
                    Laboratorio.getInstancia().setComponenteMensagemVisivel(false);
                }
            }
        }
    }

    class ListenerMouse
    extends MouseAdapter {
        ListenerMouse() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (TAvisoLabel.this.getRootPane() != null && (TAvisoLabel.this.getRootPane().getGlassPane() instanceof GlassPaneMensagem || TAvisoLabel.this.getRootPane().getGlassPane() instanceof JPanel)) {
                if (TAvisoLabel.this.aviso != null && TAvisoLabel.this.areaAviso != null && TAvisoLabel.this.areaAviso.contains(e.getPoint())) {
                    Laboratorio.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.aviso, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                    Laboratorio.getInstancia().setComponenteMensagemVisivel(true);
                } else if (TAvisoLabel.this.avisoNomeSocial != null && TAvisoLabel.this.areaAviso2 != null && TAvisoLabel.this.areaAviso2.contains(e.getPoint())) {
                    Laboratorio.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoNomeSocial, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                    Laboratorio.getInstancia().setComponenteMensagemVisivel(true);
                } else if (TAvisoLabel.this.avisoGenero != null && TAvisoLabel.this.areaAviso3 != null) {
                    if (TAvisoLabel.this.areaAviso3.contains(e.getPoint()) && TAvisoLabel.this.getRootPane().getContentPane() instanceof JPanel) {
                        Laboratorio.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoGenero, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                        Laboratorio.getInstancia().setComponenteMensagemVisivel(true);
                    } else if (TAvisoLabel.this.getRootPane().getContentPane() instanceof DigitacaoConferencia) {
                        DigitacaoConferencia.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoGenero, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                        DigitacaoConferencia.getInstancia().setComponenteMensagemVisivel(true);
                    } else if (TAvisoLabel.this.getRootPane().getParent() instanceof EditarResultado) {
                        EditarResultado.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoGenero, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                        EditarResultado.getInstancia().setComponenteMensagemVisivel(true);
                    } else if (TAvisoLabel.this.getRootPane().getParent() instanceof RequisicaoPreAgendamento) {
                        RequisicaoPreAgendamento.getInstancia().adicionarComponenteMensagem(TAvisoLabel.this, TAvisoLabel.this.avisoGenero, TAvisoLabel.this.posicao, TAvisoLabel.this.quebrarLinha);
                        RequisicaoPreAgendamento.getInstancia().setComponenteMensagemVisivel(true);
                    }
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (TAvisoLabel.this.getRootPane().getContentPane() instanceof JPanel) {
                Laboratorio.getInstancia().removerComponenteMensagem(TAvisoLabel.this);
            } else if (TAvisoLabel.this.getRootPane().getContentPane() instanceof DigitacaoConferencia) {
                DigitacaoConferencia.getInstancia().removerComponenteMensagem(TAvisoLabel.this);
            } else if (TAvisoLabel.this.getRootPane().getParent() instanceof EditarResultado) {
                EditarResultado.getInstancia().removerComponenteMensagem(TAvisoLabel.this);
            } else if (TAvisoLabel.this.getRootPane().getParent() instanceof RequisicaoPreAgendamento) {
                RequisicaoPreAgendamento.getInstancia().removerComponenteMensagem(TAvisoLabel.this);
            }
        }
    }
}

