/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.Tipos;
import jalis.integracao.servidor.GZipException;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.PilhaInt;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JProgressBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;

public class StringUtil {
    private static final char[] NUM = new char[]{'Z', 'F', 'I', 'O', 'W', 'B', 'R', 'M', 'L', 'Q'};
    public static final String[] MASCARAS_NUMERO = new String[]{"###,##", "#.###,##", "000,00", "0.000,00", "#.##0,00"};
    public static final String[] MASCARAS_DATA = new String[]{"dd/MM/aa", "dd/MM/aaaa", "dd/MM", "hh:mm", "hh:mm:ss", "dd/MM/aa hh:mm"};
    public static final String[] MASCARAS_NUMERO_DATA = ArraysUtil.concatenar(MASCARAS_NUMERO, MASCARAS_DATA);
    public static final char NUL = '\u0000';
    public static final char SOH = '\u0001';
    public static final char STX = '\u0002';
    public static final char ETX = '\u0003';
    public static final char EOT = '\u0004';
    public static final char ENQ = '\u0005';
    public static final char ACK = '\u0006';
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char DLE = '\u0010';
    public static final char NAK = '\u0015';
    public static final char SYN = '\u0016';
    public static final char ETB = '\u0017';
    public static final char CAN = '\u0018';
    public static final char SP = ' ';
    public static final char DEL = '\u007f';
    public static final String sNUL = "[NUL]";
    public static final String sSOH = "[SOH]";
    public static final String sSTX = "[STX]";
    public static final String sETX = "[ETX]";
    public static final String sEOT = "[EOT]";
    public static final String sENQ = "[ENQ]";
    public static final String sACK = "[ACK]";
    public static final String sSB = "[SB]";
    public static final String sDLE = "[DLE]";
    public static final String sDC1 = "[D1C]";
    public static final String sNAK = "[NAK]";
    public static final String sSYN = "[SYN]";
    public static final String sETB = "[ETB]";
    public static final String sCAN = "[CAN]";
    public static final String sEB = "[EB]";
    public static final String sSP = "[SP]";
    public static final String sDEL = "[DEL]";
    public static final String sFD = "[FD]";
    public static final String LINE = String.valueOf('\r') + String.valueOf('\n');
    public static final char SB = '\u000b';
    public static final char DC1 = '\u0011';
    public static final char EB = '\u001c';
    public static final char FD = '\u00fd';
    static final int TAMANHO_BUFFER = 4096;
    public static final int ORI_DIREITA = 0;
    public static final int ORI_ESQUERDA = 1;
    public static final int ORI_AMBOS = 2;
    public static final Map<Integer, String> entidadesHTML = new HashMap<Integer, String>();
    private static final int PRIMEIRO_CARACTERE_NUMERICO_ASCII = 48;
    private static final int ULTIMO_CARACTERE_NUMERICO_ASCII = 57;
    private static final CharSequence TAG_RELACIONAMENTO;
    private static final String TAG_FECHAMENTO_ALTERAR = "/>";

    public static String getValor(String xml, String tag) {
        return StringUtil.getValor(xml, tag, false);
    }

    public static String getValor(String xml, String tag, boolean tagInsensitive) {
        return StringUtil.getValor(xml, tag, tagInsensitive, null, true);
    }

    public static String getValor(String xml, String tag, boolean tagInsensitive, String tagRelacionada, boolean limparCData) {
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(tag)) {
            StringBuilder aux = new StringBuilder();
            aux.append('<');
            aux.append(tag);
            if (xml.contains(TAG_FECHAMENTO_ALTERAR)) {
                int posicao;
                String tagSelfClosing = aux.toString() + TAG_FECHAMENTO_ALTERAR;
                int n = posicao = tagInsensitive ? xml.toUpperCase().indexOf(tagSelfClosing.toUpperCase()) : xml.indexOf(tagSelfClosing);
                if (posicao > 0) {
                    return "";
                }
            }
            if (!Funcoes.textoVazio(tagRelacionada)) {
                aux.append(StringUtil.adicionaAtributoTag(xml, tag, tagRelacionada));
            }
            aux.append('>');
            int start = tagInsensitive ? xml.toUpperCase().indexOf(aux.toString().toUpperCase()) : xml.indexOf(aux.toString());
            int tamTagInicio = aux.length();
            if (start == -1) {
                aux.setLength(0);
                aux.append("<").append(tag).append(" ");
                int n = start = tagInsensitive ? xml.toUpperCase().indexOf(aux.toString().toUpperCase()) : xml.indexOf(aux.toString());
                if (start > -1) {
                    tamTagInicio = xml.indexOf(">", start) + 1;
                    tamTagInicio -= start;
                }
            }
            aux.delete(0, aux.length());
            aux.append("</");
            aux.append(tag);
            aux.append('>');
            int end = tagInsensitive ? xml.toUpperCase().indexOf(aux.toString().toUpperCase()) : xml.indexOf(aux.toString());
            String retorno = start > -1 && end > -1 ? xml.substring(start + tamTagInicio, end) : "";
            return limparCData ? StringUtil.limpaCdata(retorno) : retorno;
        }
        return "";
    }

    public static String adicionaAtributoTag(String xml, String tag, String tagRelacionada) {
        if (Funcoes.textoVazio(tagRelacionada)) {
            tagRelacionada = "tagResultado";
        }
        StringBuilder aux = new StringBuilder();
        aux.append(" ").append(tagRelacionada).append("=\"");
        String tagAux = StringUtil.getValorAtributoTag(xml, tag, tagRelacionada);
        aux.append(tagAux).append("\"");
        return aux.toString();
    }

    public static String getValorAtributoTag(String xml, String tag, String tagRelacionada) {
        int start = xml.indexOf("<" + tag);
        int end = xml.indexOf("</" + tag);
        String tagAux = xml.substring(start, end);
        tagAux = tagAux.substring(tagAux.indexOf(tagRelacionada) + tagRelacionada.length() + 2, tagAux.indexOf(">") - 1);
        return tagAux;
    }

    public static String getValorAtributoTagCampo(String tag, String valorTag, String xml) {
        String concat = tag + "=\"" + valorTag + "\"".toLowerCase();
        xml = xml.toLowerCase();
        String subtituir = "";
        String retorno = "";
        if (xml.indexOf(concat) >= 0) {
            int inicio = xml.indexOf(concat);
            while (!String.valueOf(xml.charAt(inicio)).equals("<")) {
                --inicio;
            }
            String campo = xml.substring(inicio + 1, xml.indexOf(concat)).trim();
            int fim = xml.indexOf(campo);
            while (!String.valueOf(xml.charAt(fim)).equals(">")) {
                subtituir = subtituir + String.valueOf(xml.charAt(fim));
                ++fim;
            }
            String xmlCopy = xml.replaceAll(subtituir, campo);
            retorno = StringUtil.getValor(xmlCopy, campo);
        }
        return retorno;
    }

    public static void setValor(StringBuilder xml, String tag, String valor) {
        StringUtil.setValor(xml, tag, valor, null);
    }

    public static void setValor(StringBuilder xml, String tag, String valor, String tagRelacionada) {
        if (xml != null && tag != null && valor != null) {
            int posFecha;
            int posAbre;
            String tagAbre = "<" + tag + ">";
            String tagFecha = "</" + tag + ">";
            if (!Funcoes.textoVazio(tagRelacionada)) {
                tagAbre = "<" + tag + " tag=\"" + tagRelacionada + "\">";
            }
            if ((posAbre = xml.indexOf(tagAbre)) < (posFecha = xml.indexOf(tagFecha))) {
                xml.replace(posAbre + tagAbre.length(), posFecha, valor);
            }
        }
    }

    public static int getInt(String xml, String tag) {
        String tmp = StringUtil.getValor(xml, tag);
        return StringUtil.validaInteiro(tmp) ? Integer.parseInt(tmp) : 0;
    }

    public static BigInteger getBigInteger(String xml, String tag) {
        String tmp = StringUtil.getValor(xml, tag);
        return StringUtil.validaInteiro(tmp) ? new BigInteger(tmp) : BigInteger.ZERO;
    }

    public static float getFloat(String xml, String tag) {
        String tmp = StringUtil.getValor(xml, tag);
        if (tmp.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            return Float.parseFloat(StringUtil.strDecimal(tmp));
        }
        return 0.0f;
    }

    public static boolean getBoolean(String xml, String tag) {
        return StringUtil.getBoolean(StringUtil.getValor(xml, tag));
    }

    public static Date getHora(String xml, String tag) {
        String tmp = StringUtil.getValor(xml, tag);
        try {
            if (tmp.matches("(([01]\\d|2[0-3]):)?[0-5]\\d(:[0-5]\\d)?")) {
                return new SimpleDateFormat("HH:mm:ss").parse(tmp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Date getHoraMinuto(String xml, String tag) {
        String tmp = StringUtil.getValor(xml, tag);
        try {
            if (tmp.matches("(([01]\\d|2[0-3]):)?[0-5]\\d(:[0-5]\\d)?")) {
                return new SimpleDateFormat("HH:mm").parse(tmp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Color getColor(String xml, String tag) {
        Color cor = Color.white;
        try {
            cor = Color.decode(StringUtil.getValor(xml, tag));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cor;
    }

    public static String[] getValores(String xml, String tag) {
        return StringUtil.getValores(xml, tag, false);
    }

    public static String[] getValores(String xml, String tag, boolean keepTag) {
        List<String> list = StringUtil.getListValores(xml, tag, keepTag);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> getListValores(String xml, String tag) {
        return StringUtil.getListValores(xml, tag, false);
    }

    public static List<String> getListValores(String xml, String tag, boolean keepTag) {
        int end;
        int start;
        ArrayList<String> vlr = new ArrayList<String>();
        String abre = "<" + tag + ">";
        String fecha = "</" + tag + ">";
        int pos = 0;
        do {
            start = xml.indexOf(abre, pos);
            end = xml.indexOf(fecha, pos);
            pos = end + tag.length() + 3;
            if (start <= -1 || end <= -1 || start >= end) continue;
            if (keepTag) {
                vlr.add(xml.substring(start, end + tag.length() + 3));
                continue;
            }
            vlr.add(xml.substring(start + tag.length() + 2, end));
        } while (start > -1 && end > -1 && start < end);
        return vlr;
    }

    public static List<String> getListValoresTagUnica(String xml, String tag, boolean keepTag) {
        int end;
        int start;
        ArrayList<String> vlr = new ArrayList<String>();
        String abre = "<" + tag;
        String fecha = TAG_FECHAMENTO_ALTERAR;
        int pos = 0;
        do {
            start = xml.indexOf(abre, pos);
            end = xml.indexOf(fecha, pos);
            pos = end + tag.length() + 3;
            if (start <= -1 || end <= -1 || start >= end) continue;
            if (keepTag) {
                vlr.add(xml.substring(start, end + tag.length() + 3));
                continue;
            }
            vlr.add(xml.substring(start + tag.length() + 2, end));
        } while (start > -1 && end > -1 && start < end);
        return vlr;
    }

    public static Set<String> getSetValoresTagAberta(String xml, String tag, boolean keepTag) throws Exception {
        int end;
        int start;
        xml = StringUtil.padronizarFechamentoTags(xml);
        LinkedHashSet<String> vlr = new LinkedHashSet<String>();
        String abre = "<" + tag;
        String fecha = "</" + tag + ">";
        int pos = 0;
        do {
            start = xml.indexOf(abre, pos);
            end = xml.indexOf(fecha, pos);
            pos = end + tag.length() + 3;
            if (start <= -1 || end <= -1 || start >= end) continue;
            if (keepTag) {
                vlr.add(xml.substring(start, end + tag.length() + 3));
                continue;
            }
            vlr.add(abre + " " + xml.substring(start + tag.length() + 2, end) + fecha);
        } while (start > -1 && end > -1 && start < end);
        if (vlr.isEmpty()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(StringUtil.trocaCaracterUTF(xml.toString()).getBytes());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource io = new InputSource(reader);
            io.setEncoding("UTF-8");
            DocumentBuilder dbf = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dbf.parse(io);
            Element raiz = doc.getDocumentElement();
            if (!XMLUtil.getElementosFilhos(raiz).isEmpty()) {
                Element solicitacoesPai = XMLUtil.getElementosFilhos(raiz).get(1);
                List<Element> solicitacoes = XMLUtil.getElementosFilhos(solicitacoesPai);
                for (Element solicitacao : solicitacoes) {
                    NamedNodeMap map = solicitacao.getAttributes();
                    String conteudo = "";
                    for (int pos1 = 0; pos1 < map.getLength(); ++pos1) {
                        conteudo = conteudo + map.item(pos1).getNodeName();
                        conteudo = conteudo + "=";
                        conteudo = conteudo + "\"" + map.item(pos1).getNodeValue() + "\"";
                        conteudo = conteudo + " ";
                    }
                    vlr.add("<" + tag + " " + conteudo + TAG_FECHAMENTO_ALTERAR);
                }
            }
        }
        return vlr;
    }

    public static List<String> getListValoresTagAberta(String xml, String tag, boolean keepTag) throws Exception {
        int end;
        int start;
        xml = StringUtil.padronizarFechamentoTags(xml);
        ArrayList<String> vlr = new ArrayList<String>();
        String abre = "<" + tag;
        String fecha = "</" + tag + ">";
        int pos = 0;
        do {
            start = xml.indexOf(abre, pos);
            end = xml.indexOf(fecha, pos);
            pos = end + tag.length() + 3;
            if (start <= -1 || end <= -1 || start >= end) continue;
            if (keepTag) {
                vlr.add(xml.substring(start, end + tag.length() + 3));
                continue;
            }
            vlr.add(abre + " " + xml.substring(start + tag.length() + 2, end) + fecha);
        } while (start > -1 && end > -1 && start < end);
        if (vlr.isEmpty()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(StringUtil.trocaCaracterUTF(xml.toString()).getBytes());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource io = new InputSource(reader);
            io.setEncoding("UTF-8");
            DocumentBuilder dbf = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dbf.parse(io);
            Element raiz = doc.getDocumentElement();
            if (!XMLUtil.getElementosFilhos(raiz).isEmpty()) {
                Element solicitacoesPai = XMLUtil.getElementosFilhos(raiz).get(1);
                List<Element> solicitacoes = XMLUtil.getElementosFilhos(solicitacoesPai);
                for (Element solicitacao : solicitacoes) {
                    NamedNodeMap map = solicitacao.getAttributes();
                    String conteudo = "";
                    for (int pos1 = 0; pos1 < map.getLength(); ++pos1) {
                        conteudo = conteudo + map.item(pos1).getNodeName();
                        conteudo = conteudo + "=";
                        conteudo = conteudo + "\"" + map.item(pos1).getNodeValue() + "\"";
                        conteudo = conteudo + " ";
                    }
                    vlr.add("<" + tag + " " + conteudo + TAG_FECHAMENTO_ALTERAR);
                }
            }
        }
        return vlr;
    }

    public static String padronizarFechamentoTags(String xml) {
        int posicaoIni = 0;
        StringBuilder xmlPadronizado = new StringBuilder();
        while (true) {
            int posicaoFim = xml.indexOf(TAG_FECHAMENTO_ALTERAR);
            int posicaoRecorteTag = 0;
            String conteudoTagAlterar = "";
            if (posicaoFim > 0) {
                posicaoRecorteTag = StringUtil.getPosicaoInicial(xml.substring(posicaoIni, posicaoFim), posicaoFim);
                conteudoTagAlterar = xml.substring(posicaoFim - posicaoRecorteTag, posicaoFim);
            }
            if (posicaoFim > 0) {
                xmlPadronizado.append(xml.substring(0, posicaoFim - posicaoRecorteTag));
                xmlPadronizado.append(conteudoTagAlterar).append(">");
                String nomeTag = conteudoTagAlterar.split(" ")[0];
                xmlPadronizado.append("</").append(nomeTag).append(">");
            } else {
                xmlPadronizado.append(xml);
            }
            if (posicaoFim < 0) break;
            xml = xml.substring(posicaoFim + 2, xml.length());
        }
        return xmlPadronizado.toString();
    }

    private static int getPosicaoInicial(String recorte, int posicaoFinal) {
        String reversa = new StringBuilder(recorte).reverse().toString();
        return reversa.indexOf("<");
    }

    public static String getTag(String tag, String valor) {
        return StringUtil.getTag(tag, valor, null, null);
    }

    public static String getTag(String tag, String valor, String tagRelacionada, String valorTagRelacionada) {
        StringBuilder bui = new StringBuilder("<");
        bui.append(tag);
        if (!Funcoes.textoVazio(tagRelacionada) && !Funcoes.textoVazio(valorTagRelacionada)) {
            bui.append(" " + tagRelacionada + "=\"").append(valorTagRelacionada).append("\"");
        }
        bui.append(">");
        bui.append(valor);
        bui.append("</");
        bui.append(tag);
        bui.append(">");
        return bui.toString();
    }

    public static String getTag(String tag, String[] valores) {
        StringBuilder bui = new StringBuilder();
        if (tag != null && valores != null) {
            for (String valor : valores) {
                bui.append("<");
                bui.append(tag);
                bui.append(">");
                bui.append(StringUtil.preencheCData(valor));
                bui.append("</");
                bui.append(tag);
                bui.append(">");
            }
        }
        return bui.toString();
    }

    public static String getTag(String tag, List<String> valores) {
        StringBuilder bui = new StringBuilder();
        if (tag != null && valores != null) {
            for (String valor : valores) {
                bui.append("<");
                bui.append(tag);
                bui.append(">");
                bui.append(valor);
                bui.append("</");
                bui.append(tag);
                bui.append(">");
            }
        }
        return bui.toString();
    }

    public static String getTagComCdata(String tag, String[] valores) {
        StringBuilder bui = new StringBuilder();
        if (tag != null && valores != null) {
            for (String valor : valores) {
                bui.append("<");
                bui.append(tag);
                bui.append(">");
                bui.append(StringUtil.preencheCData(valor));
                bui.append("</");
                bui.append(tag);
                bui.append(">");
            }
        }
        return bui.toString();
    }

    public static String getTag(String tag, Set<String> valores) {
        StringBuilder bui = new StringBuilder();
        if (tag != null && valores != null) {
            for (String valor : valores) {
                bui.append("<");
                bui.append(tag);
                bui.append(">");
                bui.append(valor);
                bui.append("</");
                bui.append(tag);
                bui.append(">");
            }
        }
        return bui.toString();
    }

    public static String getTagEmMinusculas(String xml) {
        StringBuilder bui = new StringBuilder(xml == null ? "" : xml);
        int abre = bui.indexOf("<");
        while (abre > -1) {
            int fecha = bui.indexOf(">", abre + 1);
            int abreTmp = bui.indexOf("<", abre + 1);
            while (abreTmp > -1 && abreTmp < fecha) {
                abre = abreTmp;
                abreTmp = bui.indexOf("<", abre + 1);
            }
            if (abre < fecha) {
                bui.replace(abre + 1, fecha, bui.substring(abre + 1, fecha).toLowerCase());
                abre = bui.indexOf("<", fecha + 1);
                continue;
            }
            abre = -1;
        }
        return bui.toString();
    }

    public static String getRetanguloAtributos(Rectangle rec) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("x", String.valueOf(rec.x)));
        bui.append(StringUtil.getTag("y", String.valueOf(rec.y)));
        bui.append(StringUtil.getTag("largura", String.valueOf(rec.width)));
        bui.append(StringUtil.getTag("altura", String.valueOf(rec.height)));
        return bui.toString();
    }

    public static Rectangle getRetangulo(String atr) {
        int x = StringUtil.getInt(atr, "x");
        int y = StringUtil.getInt(atr, "y");
        int w = StringUtil.getInt(atr, "largura");
        int h = StringUtil.getInt(atr, "altura");
        return new Rectangle(x, y, w, h);
    }

    public static Rectangle2D.Float getRetangulo2DFloat(String atr) {
        float x = StringUtil.getFloat(atr, "x");
        float y = StringUtil.getFloat(atr, "y");
        float w = StringUtil.getFloat(atr, "largura");
        float h = StringUtil.getFloat(atr, "altura");
        return new Rectangle2D.Float(x, y, w, h);
    }

    public static String getMargemAtributos(Insets margens) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("esquerda", String.valueOf(margens.left)));
        bui.append(StringUtil.getTag("direita", String.valueOf(margens.right)));
        bui.append(StringUtil.getTag("superior", String.valueOf(margens.top)));
        bui.append(StringUtil.getTag("inferior", String.valueOf(margens.bottom)));
        return bui.toString();
    }

    public static Insets getMargem(String atr) {
        int esquerda = StringUtil.getInt(atr, "esquerda");
        int direita = StringUtil.getInt(atr, "direita");
        int superior = StringUtil.getInt(atr, "superior");
        int inferior = StringUtil.getInt(atr, "inferior");
        return new Insets(esquerda, direita, superior, inferior);
    }

    public static String getFonteAtributos(Font fonte) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("nome", fonte.getName()));
        bui.append(StringUtil.getTag("estilo", String.valueOf(fonte.getStyle())));
        bui.append(StringUtil.getTag("tamanho", String.valueOf(fonte.getSize())));
        return bui.toString();
    }

    public static Font getFonte(String atr) {
        return new Font(StringUtil.getValor(atr, "nome"), StringUtil.getInt(atr, "estilo"), StringUtil.getInt(atr, "tamanho"));
    }

    public static boolean getBoolean(String valor) {
        return valor.equalsIgnoreCase("true") || valor.equalsIgnoreCase("sim") || valor.equalsIgnoreCase("t") || valor.equalsIgnoreCase("s");
    }

    public static String extenso(float valor) {
        StringBuilder bui = new StringBuilder();
        if ((double)valor > 0.0) {
            String[] sing = new String[]{"", "mil", "milh\u00e3o", "bilh\u00e3o", "trilh\u00e3o", "quatrilh\u00e3o", "quintilh\u00e3o", "sextilh\u00e3o", "setilh\u00e3o"};
            String[] plur = new String[]{"", "mil", "milh\u00f5es", "bilh\u00f5es", "trilh\u00f5es", "quatrilh\u00f5es", "quintilh\u00f5es", "sextilh\u00f5es", "setilh\u00f5es"};
            boolean plural = Double.parseDouble(new DecimalFormat(".").format(valor).split("\\D")[0]) > 1.0;
            String[] tmp = new DecimalFormat("0,000.00").format(valor).split("\\D");
            int i = 0;
            int pos = tmp.length - i - 2;
            while (i < tmp.length) {
                int vlr = Integer.parseInt(tmp[i]);
                if (vlr > 0) {
                    bui.append(bui.length() > 0 ? (i >= tmp.length - 2 && vlr < 101 ? " e " : ", ") : "");
                    bui.append(StringUtil.centenaExtenso(tmp[i]));
                    bui.append(" ");
                    if (i == tmp.length - 2) {
                        bui.append(plural ? "reais" : "real");
                    } else if (i == tmp.length - 1) {
                        bui.append(vlr > 1 ? "centavos" : "centavo");
                    } else {
                        bui.append(vlr > 1 ? plur[pos] : sing[pos]);
                    }
                }
                pos = tmp.length - ++i - 2;
            }
        }
        return bui.toString();
    }

    private static String centenaExtenso(String str) {
        StringBuilder bui = new StringBuilder();
        if (str.length() <= 3) {
            int centena;
            String[] uni = new String[]{"", "um", "dois", "tr\u00eas", "quatro", "cinco", "seis", "sete", "oito", "nove"};
            String[] esp = new String[]{"dez", "onze", "doze", "treze", "quatorze", "quinze", "dezesseis", "dezessete", "dezoito", "dezenove"};
            String[] dez = new String[]{"", "", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa"};
            String[] cen = new String[]{"", "cento", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos"};
            int unidade = str.length() > 0 ? Character.getNumericValue(str.charAt(str.length() - 1)) : 0;
            int dezena = str.length() > 1 ? Character.getNumericValue(str.charAt(str.length() - 2)) : 0;
            int n = centena = str.length() > 2 ? Character.getNumericValue(str.charAt(str.length() - 3)) : 0;
            if (centena > 0) {
                bui.append(centena == 1 && dezena == 0 && unidade == 0 ? "cem" : cen[centena]);
            }
            if (dezena == 1) {
                bui.append(bui.length() > 0 ? " e " : "");
                bui.append(esp[unidade]);
            } else {
                if (dezena > 1) {
                    bui.append(bui.length() > 0 ? " e " : "");
                    bui.append(dez[dezena]);
                }
                if (unidade > 0) {
                    bui.append(bui.length() > 0 ? " e " : "");
                    bui.append(uni[unidade]);
                }
            }
        }
        return bui.toString();
    }

    public static boolean validaMascaraNumero(String mascara) {
        boolean valido = true;
        try {
            new DecimalFormat(mascara);
        }
        catch (Exception e) {
            valido = false;
        }
        return valido;
    }

    public static boolean validaNumero(String str) {
        return str != null && str.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?");
    }

    public static Object getValorString(String str) {
        if (str != null) {
            try {
                String tmp = StringUtil.trataPontuacao(str);
                if (tmp.matches("\\-?\\d+")) {
                    return new BigInteger(tmp);
                }
                if (tmp.matches("\\-?\\d+(\\.\\d+)?")) {
                    return new BigDecimal(tmp);
                }
                if (tmp.matches("(\\-?\\d+(\\.\\d+)?)*(E+\\-?\\d+)?")) {
                    return new BigDecimal(tmp);
                }
                if (tmp.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])(/(\\d{2}|\\d{4}))?")) {
                    return new SimpleDateFormat("dd/MM/yyyy").parse(tmp);
                }
                if (tmp.matches("(([01]\\d|2[0-3]):)?[0-5]\\d(:[0-5]\\d)?") && Funcoes.verificaHora(tmp)) {
                    return new SimpleDateFormat(tmp.matches("([01]\\d|2[0-3]):[0-5]\\d") ? "HH:mm" : "HH:mm:ss").parse(tmp);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("N\u00e3o foi poss\u00edvel formatar a String:" + str, e);
            }
        }
        return str;
    }

    public static String trataPontuacao(String str) {
        return StringUtil.removeCaractere(str, '.').replace(',', '.');
    }

    public static String trataPontuacaoRaiz(String str) {
        if (StringUtil.validaCaracteres(str)) {
            return str;
        }
        return StringUtil.removeCaractere(str, '.').replace(',', '.');
    }

    private static boolean validaCaracteres(String str) {
        return str.contains("E") || str.contains(".") && str.length() - str.indexOf(".") > 5 && !str.contains(",");
    }

    public static boolean verificaDataValida(String str) {
        return str != null && str.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])(/(\\d{2}|\\d{4}))?");
    }

    public static Date getDataDeString(String str) {
        if (str != null) {
            try {
                if (str.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])(/(\\d{2}|\\d{4}))?")) {
                    return new SimpleDateFormat("dd/MM/yyyy").parse(str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int valorInt(String valor) {
        Object obj = StringUtil.getValorString(valor);
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        return 0;
    }

    public static float valorFloat(String valor) {
        Object obj = StringUtil.getValorString(valor);
        if (obj instanceof Long) {
            return ((Long)obj).floatValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        return 0.0f;
    }

    public static boolean validaDouble(String str) {
        boolean res = true;
        try {
            Double.parseDouble(StringUtil.strDecimal(str));
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    public static boolean validaInteiro(String str) {
        return str != null && str.matches("[0-9]+");
    }

    public static String strDecimal(String str) {
        if (str.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            StringBuilder bui = new StringBuilder();
            char[] c = str.toCharArray();
            boolean ponto = false;
            for (int i = c.length - 1; i >= 0; --i) {
                if (c[i] == '.' || c[i] == ',') {
                    if (ponto) continue;
                    bui.insert(0, '.');
                    ponto = true;
                    continue;
                }
                bui.insert(0, c[i]);
            }
            return bui.toString();
        }
        return str;
    }

    public static String adicionarBarrasEscape(String str, String chars) {
        if (str != null) {
            StringBuilder bui = new StringBuilder(str);
            if (chars != null) {
                for (int pos = 0; pos < bui.length(); ++pos) {
                    if (chars.indexOf(bui.charAt(pos)) <= -1) continue;
                    bui.insert(pos++, '\\');
                }
            }
            return bui.toString();
        }
        return str;
    }

    public static String textoDB(String texto) {
        StringBuilder bui = new StringBuilder();
        if (texto != null) {
            for (int i = 0; i < texto.length(); ++i) {
                if (texto.charAt(i) == '\'' || texto.charAt(i) == '\u0092' || texto.charAt(i) == '\u2019' || texto.charAt(i) == '`' || texto.charAt(i) == '\u00b4') {
                    bui.append("''");
                    continue;
                }
                if (texto.charAt(i) == '\u201c' || texto.charAt(i) == '\u201d' || texto.charAt(i) == '\ue2809d' || texto.charAt(i) == '\ue2809c') {
                    bui.append("\"");
                    continue;
                }
                if (texto.charAt(i) == '\u221e' || texto.charAt(i) == '\u2013' || texto.charAt(i) == '\u25ba') {
                    bui.append(" ");
                    continue;
                }
                if (texto.charAt(i) == '\\') {
                    bui.append("\\").append(texto.charAt(i));
                    continue;
                }
                if (texto.charAt(i) == '\u00e2') {
                    bui.append("\u00e2");
                    continue;
                }
                if (texto.charAt(i) == '\u0161') {
                    bui.append("s");
                    continue;
                }
                if (texto.charAt(i) == '\u00ef') {
                    bui.append("i");
                    continue;
                }
                if (texto.charAt(i) == '\u00e1') {
                    bui.append("\u00e1");
                    continue;
                }
                if (texto.charAt(i) == '\uff7d') {
                    bui.append("\u00c7");
                    continue;
                }
                if (texto.charAt(i) == '\ue280a2' || texto.charAt(i) == '\u2022') {
                    bui.append(".");
                    continue;
                }
                if (texto.charAt(i) == '\ufffd' || texto.charAt(i) == '\ue282ac' || texto.charAt(i) == '\uc595' || texto.charAt(i) == '\uc594' || texto.charAt(i) == '\uc4b9' || texto.charAt(i) == '\uc692' || texto.charAt(i) == '\uefbfbd' || texto.charAt(i) == '\uc59b' || texto.charAt(i) == '\ue1b994' || texto.charAt(i) == '\ue2889e' || texto.charAt(i) == '\ue1b995' || texto.charAt(i) == '\ue1b98d' || texto.charAt(i) == '\ue28093' || texto.charAt(i) == '\uc4ba' || texto.charAt(i) == '\uc59a' || texto.charAt(i) == '\uefbdbd' || texto.charAt(i) == '\uefbfbd' || texto.charAt(i) == '\ue296ba' || texto.charAt(i) == '\ucebc' || texto.charAt(i) == '\ud8b2' || texto.charAt(i) == '\ud8b5' || texto.charAt(i) == '\ue2808e' || texto.charAt(i) == '\u20ac' || texto.charAt(i) == '\u200e' || texto.charAt(i) == '\uc4b9' || texto.charAt(i) == '\uc4ba' || texto.charAt(i) == '\uc594' || texto.charAt(i) == '\uc595' || texto.charAt(i) == '\uc59a' || texto.charAt(i) == '\uc59b' || texto.charAt(i) == '\uc692' || texto.charAt(i) == '\ucebc' || texto.charAt(i) == '\ud8b2' || texto.charAt(i) == '\ud8b5' || texto.charAt(i) == '\ue1b9' || texto.charAt(i) == '\ue280' || texto.charAt(i) == '\ue288' || texto.charAt(i) == '\ue296' || texto.charAt(i) == '\uefbd' || texto.charAt(i) == '\uefbf') {
                    bui.append(" ");
                    continue;
                }
                bui.append(texto.charAt(i));
            }
        }
        return bui.toString();
    }

    public static String trocaCaracterUTF(String texto) {
        StringBuilder retorno = new StringBuilder("");
        try {
            retorno.append(new String(texto.getBytes(), "latin1"));
        }
        catch (Exception e) {
            for (char c : texto.toCharArray()) {
                retorno.append(StringUtil.trocaCaracterUTF(c));
            }
        }
        return retorno.toString();
    }

    public static String trocaCaracterUTF(char c) {
        if (c == '\uc595' || c == '\uc594' || c == '\uc4b9' || c == '\uc692' || c == '\uefbfbd') {
            return " ";
        }
        return String.valueOf(c);
    }

    public static String textoHSQLDB(String texto) {
        StringBuilder bui = new StringBuilder();
        if (texto != null) {
            for (int i = 0; i < texto.length(); ++i) {
                if (texto.charAt(i) == '\u0092' || texto.charAt(i) == '\u2019') {
                    bui.append("\\'");
                } else if (texto.charAt(i) == '\\') {
                    bui.append("\\");
                    bui.append(texto.charAt(i));
                }
                if (texto.charAt(i) == '\'') {
                    bui.append("'");
                    bui.append(texto.charAt(i));
                    continue;
                }
                bui.append(texto.charAt(i));
            }
        }
        return bui.toString();
    }

    public static String removerAcentos(String str) {
        StringBuilder bui = new StringBuilder("");
        if (!Funcoes.textoVazio(str)) {
            char[] ch = str.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                bui.append(StringUtil.removerAcento(ch[i]));
            }
        }
        return bui.toString();
    }

    public static char removerAcento(char ch) {
        switch (Character.toLowerCase(ch)) {
            case '\u00e0': 
            case '\u00e1': 
            case '\u00e2': 
            case '\u00e3': 
            case '\u00e4': {
                return Character.isLowerCase(ch) ? (char)'a' : 'A';
            }
            case '\u00e8': 
            case '\u00e9': 
            case '\u00ea': 
            case '\u00eb': {
                return Character.isLowerCase(ch) ? (char)'e' : 'E';
            }
            case '\u00ec': 
            case '\u00ed': 
            case '\u00ee': 
            case '\u00ef': {
                return Character.isLowerCase(ch) ? (char)'i' : 'I';
            }
            case '\u00f2': 
            case '\u00f3': 
            case '\u00f4': 
            case '\u00f5': 
            case '\u00f6': {
                return Character.isLowerCase(ch) ? (char)'o' : 'O';
            }
            case '\u00f9': 
            case '\u00fa': 
            case '\u00fb': 
            case '\u00fc': {
                return Character.isLowerCase(ch) ? (char)'u' : 'U';
            }
            case '\u00e7': {
                return Character.isLowerCase(ch) ? (char)'c' : 'C';
            }
            case '\u00f1': {
                return Character.isLowerCase(ch) ? (char)'n' : 'N';
            }
        }
        return ch;
    }

    public static String getStringImpressaoMatricial(String str) {
        StringBuilder bui = new StringBuilder();
        char[] c = str.toCharArray();
        block8: for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                case '\u00c3': 
                case '\u00d1': 
                case '\u00d5': 
                case '\u00e3': 
                case '\u00f1': 
                case '\u00f5': {
                    bui.append(StringUtil.removerAcento(c[i]));
                    bui.append("\b~");
                    continue block8;
                }
                case '\u00c1': 
                case '\u00c9': 
                case '\u00cd': 
                case '\u00d3': 
                case '\u00da': 
                case '\u00e1': 
                case '\u00e9': 
                case '\u00ed': 
                case '\u00f3': 
                case '\u00fa': {
                    bui.append(StringUtil.removerAcento(c[i]));
                    bui.append("\b'");
                    continue block8;
                }
                case '\u00c0': 
                case '\u00c8': 
                case '\u00cc': 
                case '\u00d2': 
                case '\u00d9': 
                case '\u00e0': 
                case '\u00e8': 
                case '\u00ec': 
                case '\u00f2': 
                case '\u00f9': {
                    bui.append(StringUtil.removerAcento(c[i]));
                    bui.append("\b`");
                    continue block8;
                }
                case '\u00c2': 
                case '\u00ca': 
                case '\u00ce': 
                case '\u00d4': 
                case '\u00db': 
                case '\u00e2': 
                case '\u00ea': 
                case '\u00ee': 
                case '\u00f4': 
                case '\u00fb': {
                    bui.append(StringUtil.removerAcento(c[i]));
                    bui.append("\b^");
                    continue block8;
                }
                case '\u00c4': 
                case '\u00cb': 
                case '\u00cf': 
                case '\u00d6': 
                case '\u00dc': 
                case '\u00e4': 
                case '\u00eb': 
                case '\u00ef': 
                case '\u00f6': 
                case '\u00fc': {
                    bui.append(StringUtil.removerAcento(c[i]));
                    bui.append("\b\"");
                    continue block8;
                }
                case '\u00c7': 
                case '\u00e7': {
                    bui.append(StringUtil.removerAcento(c[i]));
                    bui.append("\b,");
                    continue block8;
                }
                default: {
                    bui.append(c[i]);
                }
            }
        }
        return bui.toString();
    }

    public static String lerArquivoTexto(String arquivo) throws Exception {
        return StringUtil.lerArquivoTexto(arquivo, "ISO-8859-1");
    }

    public static String lerArquivoTexto(File arquivo) throws Exception {
        return StringUtil.lerArquivoTexto(arquivo, "ISO-8859-1");
    }

    public static String lerArquivoTexto(InputStream input) throws Exception {
        return StringUtil.lerArquivoTexto(input, "ISO-8859-1");
    }

    public static String lerArquivoTexto(String arquivo, String charset) throws Exception {
        return StringUtil.lerArquivoTexto(new FileInputStream(new File(arquivo)), charset);
    }

    public static String lerArquivoTexto(File arquivo, String charset) throws Exception {
        return StringUtil.lerArquivoTexto(new FileInputStream(arquivo), charset);
    }

    public static String lerArquivoTexto(InputStream input, String charset) throws Exception {
        Funcoes.validarNaoNull(input, "input");
        Funcoes.validarNaoNull(charset, "charset");
        String retorno = "";
        try {
            StringBuilder str = new StringBuilder();
            byte[] buffer = new byte[1024];
            int size = input.read(buffer);
            while (size > -1) {
                str.append(new String(buffer, 0, size, charset));
                size = input.read(buffer);
            }
            retorno = str.toString();
            return retorno;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
            return retorno;
        }
    }

    public static String lerArquivoXls(File arquivo, boolean protocoloAlvaro) throws Exception {
        return StringUtil.lerArquivoXls(new FileInputStream(arquivo), protocoloAlvaro);
    }

    public static String lerArquivoXls(InputStream input, boolean protocoloAlvaro) throws Exception {
        StringBuilder buf = new StringBuilder();
        try {
            new WorkbookFactory();
            Workbook workbook = WorkbookFactory.create((InputStream)input);
            Sheet sheet = null;
            if (protocoloAlvaro) {
                sheet = workbook.getSheet("Dados Obrigat\u00f3rios");
                if (StringUtil.isNullPlanilha(sheet)) {
                    sheet = workbook.getSheet("Dados");
                }
            } else {
                sheet = workbook.getSheetAt(0);
            }
            if (!StringUtil.isNullPlanilha(sheet)) {
                for (Row row : sheet) {
                    Iterator cellIterator = row.cellIterator();
                    boolean qt = false;
                    while (cellIterator.hasNext()) {
                        Cell cell = (Cell)cellIterator.next();
                        switch (cell.getCellType()) {
                            case 0: {
                                buf.append(cell.getNumericCellValue()).append(";");
                                break;
                            }
                            case 1: {
                                buf.append(cell.getStringCellValue()).append(";");
                            }
                        }
                    }
                    buf.replace(buf.length() - 1, buf.length(), "\n");
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            return buf.toString();
        }
    }

    private static boolean isNullPlanilha(Sheet sheet) {
        return sheet == null;
    }

    public static boolean escreverArquivoTexto(String nomeArquivo, String texto) throws Exception, IOException {
        return StringUtil.escreverArquivoTexto(nomeArquivo, texto, false);
    }

    public static boolean escreverArquivoTexto(String nomeArquivo, String texto, boolean adicionar) throws Exception, IOException {
        boolean retorno = false;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(nomeArquivo, adicionar));
            out.write(texto);
            retorno = true;
            return retorno;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            return retorno;
        }
    }

    public static String criarArquivo(String arquivo, String xml) throws Exception, IOException {
        File temp = null;
        BufferedWriter out = null;
        try {
            temp = File.createTempFile(arquivo, ".xml");
            out = new BufferedWriter(new FileWriter(temp));
            out.write(xml);
            temp.deleteOnExit();
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            return temp.getAbsolutePath();
        }
    }

    public static void compactarParaZip(String arqSaida, String arqEntrada, String nomeArquivo) throws IOException {
        byte[] dados = new byte[4096];
        BufferedInputStream origem = null;
        ZipOutputStream saida = null;
        try {
            int cont;
            FileOutputStream destino = new FileOutputStream(new File(arqSaida));
            saida = new ZipOutputStream(new BufferedOutputStream(destino));
            File file = new File(arqEntrada);
            FileInputStream streamDeEntrada = new FileInputStream(file);
            origem = new BufferedInputStream(streamDeEntrada, 4096);
            ZipEntry entry = new ZipEntry(nomeArquivo);
            saida.putNextEntry(entry);
            while ((cont = origem.read(dados, 0, 4096)) != -1) {
                saida.write(dados, 0, cont);
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (origem != null) {
                origem.close();
            }
            if (saida != null) {
                saida.close();
            }
        }
    }

    public static boolean escreverArquivoTexto(String nomeArquivo, String texto, String codificacao) throws IOException, Exception {
        boolean retorno = false;
        BufferedWriter out = null;
        try {
            out = Funcoes.textoVazio(codificacao) ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(nomeArquivo))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(nomeArquivo), codificacao));
            out.write(texto);
            retorno = true;
            return retorno;
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("ENCODING N\u00c3O SUPORTADO: \"" + codificacao + "\"\n" + e.getMessage());
        }
        finally {
            if (out != null) {
                out.close();
            }
            return retorno;
        }
    }

    public static boolean escreverArquivo(String nomeArquivo, byte[] conteudo) throws Exception {
        boolean retorno = false;
        try {
            File file = new File(nomeArquivo);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(conteudo);
            fos.close();
            System.gc();
            retorno = true;
            return retorno;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            return retorno;
        }
    }

    public static String getSubstring(String str, int comprimento, FontMetrics fm) {
        StringBuilder bui = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (fm.stringWidth(bui.append(str.charAt(i)).toString()) <= comprimento) continue;
            bui.deleteCharAt(bui.length() - 1);
            break;
        }
        return bui.toString();
    }

    public static String repeteCaractere(char ch, int vezes) {
        StringBuilder bui = new StringBuilder();
        for (int i = 0; i < vezes; ++i) {
            bui.append(ch);
        }
        return bui.toString();
    }

    public static String trocarCaractere(String str, char a, char b) {
        StringBuilder bui = new StringBuilder(str);
        for (int i = 0; i < bui.length(); ++i) {
            if (bui.charAt(i) == a) {
                bui.setCharAt(i, b);
                continue;
            }
            if (bui.charAt(i) != b) continue;
            bui.setCharAt(i, a);
        }
        return bui.toString();
    }

    public static String removeCaractere(String str, char ch) {
        int i;
        if (str == null) {
            return "";
        }
        StringBuilder bui = new StringBuilder(str);
        while ((i = bui.indexOf(String.valueOf(ch))) > -1) {
            bui.deleteCharAt(i);
        }
        return bui.toString();
    }

    public static String removerTags(String str) {
        StringBuilder bui = new StringBuilder(str);
        int abre = bui.indexOf("<");
        int fecha = bui.indexOf(">");
        while (abre > -1 && abre < fecha) {
            bui.delete(abre, fecha + 1);
            if (abre > 0) {
                bui.insert(abre, ' ');
            }
            abre = bui.indexOf("<");
            fecha = bui.indexOf(">");
        }
        return bui.toString();
    }

    public static String removerTagsXML(String xml, String tag) {
        StringBuilder bui = new StringBuilder(xml);
        int abre = bui.indexOf("<" + tag + ">");
        int fecha = bui.indexOf("</" + tag + ">");
        while (abre > -1 && abre < fecha) {
            bui.delete(abre, fecha + 1);
            if (abre > 0) {
                bui.insert(abre, ' ');
            }
            abre = bui.indexOf("<" + tag + ">");
            fecha = bui.indexOf("</" + tag + ">");
        }
        return bui.toString();
    }

    public static String removerTagCompletaXML(String xml, String tag, boolean removerTodas) {
        StringBuilder bui = new StringBuilder(xml);
        int abre = bui.indexOf("<" + tag + ">");
        int fecha = bui.indexOf("</" + tag + ">") + tag.length() + 3;
        while (abre > -1 && abre < fecha) {
            bui.delete(abre, fecha);
            abre = bui.indexOf("<" + tag + ">");
            fecha = bui.indexOf("</" + tag + ">") + tag.length() + 3;
        }
        return bui.toString();
    }

    public static String[] separarLinhas(String str) {
        ArrayList<String> linhas = new ArrayList<String>();
        if (str != null && str.length() > 0) {
            int from = 0;
            int pos = str.indexOf(10);
            while (pos > -1) {
                linhas.add(str.substring(from, pos));
                from = pos + 1;
                pos = str.indexOf(10, from);
            }
            linhas.add(str.substring(from, str.length()));
        }
        return linhas.toArray(new String[linhas.size()]);
    }

    public static String concatenarLinhas(String[] linhas) {
        StringBuilder bui = new StringBuilder();
        for (int i = 0; i < linhas.length; ++i) {
            if (i > 0) {
                bui.append('\n');
            }
            bui.append(linhas[i]);
        }
        return bui.toString();
    }

    public static void ordenar(String[] str) {
        Arrays.sort(str, new Comparator(){

            public int compare(Object a, Object b) {
                return ((String)a).compareToIgnoreCase((String)b);
            }
        });
    }

    public static int[] getLinhaColuna(String str, int pos, int tamanhoTab) {
        if (pos < 0 || pos > str.length()) {
            return new int[]{0, 0};
        }
        int linha = 1;
        int coluna = 1;
        for (int i = 0; i < str.length() && i != pos; ++i) {
            if (str.charAt(i) == '\n') {
                ++linha;
                coluna = 1;
                continue;
            }
            if (str.charAt(i) == '\r') {
                coluna = 1;
                continue;
            }
            if (str.charAt(i) == '\t') {
                coluna += tamanhoTab;
                continue;
            }
            ++coluna;
        }
        return new int[]{linha, coluna};
    }

    public static String getHexadecimal(Color cor) {
        StringBuilder bui = new StringBuilder("#");
        bui.append(Funcoes.preencheZero(Integer.toHexString(cor.getRed()), 2));
        bui.append(Funcoes.preencheZero(Integer.toHexString(cor.getGreen()), 2));
        bui.append(Funcoes.preencheZero(Integer.toHexString(cor.getBlue()), 2));
        return bui.toString().toUpperCase();
    }

    public static int[] getIntervalo(String exp) {
        if (exp != null && exp.matches("[0-9|\\-|,| ]*")) {
            PilhaInt pilha = new PilhaInt();
            String[] blocos = StringUtil.removeCaractere(exp, ' ').split(",");
            for (int i = 0; i < blocos.length; ++i) {
                String[] tmp = blocos[i].split("-");
                int ultNum = -1;
                for (int j = 0; j < tmp.length; ++j) {
                    if (!tmp[j].matches("[0-9]+")) continue;
                    if (ultNum == -1) {
                        ultNum = Integer.parseInt(tmp[j]);
                        pilha.por(ultNum);
                        continue;
                    }
                    int num = Integer.parseInt(tmp[j]);
                    while (ultNum != num) {
                        pilha.por(ultNum < num ? ++ultNum : --ultNum);
                    }
                }
            }
            return pilha.paraArray();
        }
        return new int[0];
    }

    public static String formataSegundos(long seg) {
        StringBuilder bui = new StringBuilder();
        for (long div = 3600L; div > 0L; div /= 60L) {
            bui.append(bui.length() > 0 ? ":" : "");
            long aux = seg / div;
            bui.append(aux < 10L ? "0" : "");
            bui.append(aux);
            seg %= div;
        }
        return bui.toString();
    }

    public static String textoXML(String texto) {
        StringBuilder bui = new StringBuilder();
        if (texto != null) {
            block102: for (int i = 0; i < texto.length(); ++i) {
                switch (texto.charAt(i)) {
                    case '<': {
                        bui.append("&lt;");
                        continue block102;
                    }
                    case '>': {
                        bui.append("&gt;");
                        continue block102;
                    }
                    case '\"': {
                        bui.append("&quot;");
                        continue block102;
                    }
                    case '\'': {
                        bui.append("&apos;");
                        continue block102;
                    }
                    case '&': {
                        bui.append("&amp;");
                        continue block102;
                    }
                    case '\u00a1': {
                        bui.append("&iexcl;");
                        continue block102;
                    }
                    case '\u00a2': {
                        bui.append("&cent;");
                        continue block102;
                    }
                    case '\u00a3': {
                        bui.append("&pound;");
                        continue block102;
                    }
                    case '\u00a4': {
                        bui.append("&curren;");
                        continue block102;
                    }
                    case '\u00a5': {
                        bui.append("&yen;");
                        continue block102;
                    }
                    case '\u00a6': {
                        bui.append("&brvbar;");
                        continue block102;
                    }
                    case '\u00a7': {
                        bui.append("&sect;");
                        continue block102;
                    }
                    case '\u00a8': {
                        bui.append("&uml;");
                        continue block102;
                    }
                    case '\u00a9': {
                        bui.append("&copy;");
                        continue block102;
                    }
                    case '\u00aa': {
                        bui.append("&ordf;");
                        continue block102;
                    }
                    case '\u00ab': {
                        bui.append("&laquo;");
                        continue block102;
                    }
                    case '\u00ac': {
                        bui.append("&not;");
                        continue block102;
                    }
                    case '\u00ad': {
                        bui.append("&shy;");
                        continue block102;
                    }
                    case '\u00ae': {
                        bui.append("&reg;");
                        continue block102;
                    }
                    case '\u00af': {
                        bui.append("&macr;");
                        continue block102;
                    }
                    case '\u00b0': {
                        bui.append("&deg;");
                        continue block102;
                    }
                    case '\u00b1': {
                        bui.append("&plusmn;");
                        continue block102;
                    }
                    case '\u00b2': {
                        bui.append("&sup2;");
                        continue block102;
                    }
                    case '\u00b3': {
                        bui.append("&sup3;");
                        continue block102;
                    }
                    case '\u00b4': {
                        bui.append("&acute;");
                        continue block102;
                    }
                    case '\u00b5': {
                        bui.append("&micro;");
                        continue block102;
                    }
                    case '\u00b6': {
                        bui.append("&para;");
                        continue block102;
                    }
                    case '\u00b7': {
                        bui.append("&middot;");
                        continue block102;
                    }
                    case '\u00b8': {
                        bui.append("&cedil;");
                        continue block102;
                    }
                    case '\u00b9': {
                        bui.append("&sup1;");
                        continue block102;
                    }
                    case '\u00ba': {
                        bui.append("&ordm;");
                        continue block102;
                    }
                    case '\u00bb': {
                        bui.append("&raquo;");
                        continue block102;
                    }
                    case '\u00bc': {
                        bui.append("&frac14;");
                        continue block102;
                    }
                    case '\u00bd': {
                        bui.append("&frac12;");
                        continue block102;
                    }
                    case '\u00be': {
                        bui.append("&frac34;");
                        continue block102;
                    }
                    case '\u00bf': {
                        bui.append("&iquest;");
                        continue block102;
                    }
                    case '\u00c0': {
                        bui.append("&Agrave;");
                        continue block102;
                    }
                    case '\u00c1': {
                        bui.append("&Aacute;");
                        continue block102;
                    }
                    case '\u00c2': {
                        bui.append("&Acirc;");
                        continue block102;
                    }
                    case '\u00c3': {
                        bui.append("&Atilde;");
                        continue block102;
                    }
                    case '\u00c4': {
                        bui.append("&Auml;");
                        continue block102;
                    }
                    case '\u00c5': {
                        bui.append("&Aring;");
                        continue block102;
                    }
                    case '\u00c6': {
                        bui.append("&AElig;");
                        continue block102;
                    }
                    case '\u00c7': {
                        bui.append("&Ccedil;");
                        continue block102;
                    }
                    case '\u00c8': {
                        bui.append("&Egrave;");
                        continue block102;
                    }
                    case '\u00c9': {
                        bui.append("&Eacute;");
                        continue block102;
                    }
                    case '\u00ca': {
                        bui.append("&Ecirc;");
                        continue block102;
                    }
                    case '\u00cb': {
                        bui.append("&Euml;");
                        continue block102;
                    }
                    case '\u00cc': {
                        bui.append("&Igrave;");
                        continue block102;
                    }
                    case '\u00cd': {
                        bui.append("&Iacute;");
                        continue block102;
                    }
                    case '\u00ce': {
                        bui.append("&Icirc;");
                        continue block102;
                    }
                    case '\u00cf': {
                        bui.append("&Iuml;");
                        continue block102;
                    }
                    case '\u00d0': {
                        bui.append("&ETH;");
                        continue block102;
                    }
                    case '\u00d1': {
                        bui.append("&Ntilde;");
                        continue block102;
                    }
                    case '\u00d2': {
                        bui.append("&Ograve;");
                        continue block102;
                    }
                    case '\u00d3': {
                        bui.append("&Oacute;");
                        continue block102;
                    }
                    case '\u00d4': {
                        bui.append("&Ocirc;");
                        continue block102;
                    }
                    case '\u00d5': {
                        bui.append("&Otilde;");
                        continue block102;
                    }
                    case '\u00d6': {
                        bui.append("&Ouml;");
                        continue block102;
                    }
                    case '\u00d7': {
                        bui.append("&times;");
                        continue block102;
                    }
                    case '\u00d8': {
                        bui.append("&Oslash;");
                        continue block102;
                    }
                    case '\u00d9': {
                        bui.append("&Ugrave;");
                        continue block102;
                    }
                    case '\u00da': {
                        bui.append("&Uacute;");
                        continue block102;
                    }
                    case '\u00db': {
                        bui.append("&Ucirc;");
                        continue block102;
                    }
                    case '\u00dc': {
                        bui.append("&Uuml;");
                        continue block102;
                    }
                    case '\u00dd': {
                        bui.append("&Yacute;");
                        continue block102;
                    }
                    case '\u00de': {
                        bui.append("&THORN;");
                        continue block102;
                    }
                    case '\u00df': {
                        bui.append("&szlig;");
                        continue block102;
                    }
                    case '\u00e0': {
                        bui.append("&agrave;");
                        continue block102;
                    }
                    case '\u00e1': {
                        bui.append("&aacute;");
                        continue block102;
                    }
                    case '\u00e2': {
                        bui.append("&acirc;");
                        continue block102;
                    }
                    case '\u00e3': {
                        bui.append("&atilde;");
                        continue block102;
                    }
                    case '\u00e4': {
                        bui.append("&auml;");
                        continue block102;
                    }
                    case '\u00e5': {
                        bui.append("&aring;");
                        continue block102;
                    }
                    case '\u00e6': {
                        bui.append("&aelig;");
                        continue block102;
                    }
                    case '\u00e7': {
                        bui.append("&ccedil;");
                        continue block102;
                    }
                    case '\u00e8': {
                        bui.append("&egrave;");
                        continue block102;
                    }
                    case '\u00e9': {
                        bui.append("&eacute;");
                        continue block102;
                    }
                    case '\u00ea': {
                        bui.append("&ecirc;");
                        continue block102;
                    }
                    case '\u00eb': {
                        bui.append("&euml;");
                        continue block102;
                    }
                    case '\u00ec': {
                        bui.append("&igrave;");
                        continue block102;
                    }
                    case '\u00ed': {
                        bui.append("&iacute;");
                        continue block102;
                    }
                    case '\u00ee': {
                        bui.append("&icirc;");
                        continue block102;
                    }
                    case '\u00ef': {
                        bui.append("&iuml;");
                        continue block102;
                    }
                    case '\u00f0': {
                        bui.append("&eth;");
                        continue block102;
                    }
                    case '\u00f1': {
                        bui.append("&ntilde;");
                        continue block102;
                    }
                    case '\u00f2': {
                        bui.append("&ograve;");
                        continue block102;
                    }
                    case '\u00f3': {
                        bui.append("&oacute;");
                        continue block102;
                    }
                    case '\u00f4': {
                        bui.append("&ocirc;");
                        continue block102;
                    }
                    case '\u00f5': {
                        bui.append("&otilde;");
                        continue block102;
                    }
                    case '\u00f6': {
                        bui.append("&ouml;");
                        continue block102;
                    }
                    case '\u00f7': {
                        bui.append("&divide;");
                        continue block102;
                    }
                    case '\u00f8': {
                        bui.append("&oslash;");
                        continue block102;
                    }
                    case '\u00f9': {
                        bui.append("&ugrave;");
                        continue block102;
                    }
                    case '\u00fa': {
                        bui.append("&uacute;");
                        continue block102;
                    }
                    case '\u00fb': {
                        bui.append("&ucirc;");
                        continue block102;
                    }
                    case '\u00fc': {
                        bui.append("&uuml;");
                        continue block102;
                    }
                    case '\u00fd': {
                        bui.append("&yacute;");
                        continue block102;
                    }
                    case '\u00fe': {
                        bui.append("&thorn;");
                        continue block102;
                    }
                    case '\u00ff': {
                        bui.append("&yuml;");
                        continue block102;
                    }
                    default: {
                        bui.append(texto.charAt(i));
                    }
                }
            }
        }
        return bui.toString();
    }

    public static String textoXMLEnvioWebService(String texto) {
        StringBuilder bui = new StringBuilder();
        if (texto != null) {
            block102: for (int i = 0; i < texto.length(); ++i) {
                switch (texto.charAt(i)) {
                    case '<': {
                        bui.append("");
                        continue block102;
                    }
                    case '>': {
                        bui.append("");
                        continue block102;
                    }
                    case '\"': {
                        bui.append("");
                        continue block102;
                    }
                    case '\'': {
                        bui.append("");
                        continue block102;
                    }
                    case '&': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00a1': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00a2': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00a3': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00a4': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00a5': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00a6': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00a7': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00a8': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00a9': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00aa': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ab': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ac': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ad': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ae': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00af': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b0': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b1': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b2': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b3': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b4': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b5': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b6': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b7': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b8': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00b9': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ba': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00bb': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00bc': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00bd': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00be': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00bf': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c0': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c1': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c2': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c3': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c4': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c5': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c6': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c7': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c8': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00c9': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ca': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00cb': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00cc': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00cd': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ce': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00cf': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d0': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d1': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d2': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d3': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d4': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d5': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d6': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d7': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d8': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00d9': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00da': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00db': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00dc': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00dd': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00de': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00df': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e0': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e1': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e2': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e3': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e4': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e5': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e6': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e7': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e8': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00e9': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ea': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00eb': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ec': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ed': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ee': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ef': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f0': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f1': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f2': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f3': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f4': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f5': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f6': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f7': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f8': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00f9': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00fa': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00fb': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00fc': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00fd': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00fe': {
                        bui.append("");
                        continue block102;
                    }
                    case '\u00ff': {
                        bui.append("");
                        continue block102;
                    }
                    default: {
                        bui.append(texto.charAt(i));
                    }
                }
            }
        }
        return bui.toString();
    }

    public static String xmlToTexto(String texto) {
        if (texto == null) {
            return "";
        }
        texto = texto.replaceAll("&lt;", "<");
        texto = texto.replaceAll("&gt;", ">");
        texto = texto.replaceAll("&quot;", "\"");
        texto = texto.replaceAll("&apos;", "'");
        texto = texto.replaceAll("&amp;", "&");
        texto = texto.replaceAll("&iexcl;", "\u00a1");
        texto = texto.replaceAll("&cent;", "\u00a2");
        texto = texto.replaceAll("&pound;", "\u00a3");
        texto = texto.replaceAll("&curren;", "\u00a4");
        texto = texto.replaceAll("&yen;", "\u00a5");
        texto = texto.replaceAll("&brvbar;", "\u00a6");
        texto = texto.replaceAll("&sect;", "\u00a7");
        texto = texto.replaceAll("&uml;", "\u00a8");
        texto = texto.replaceAll("&copy;", "\u00a9");
        texto = texto.replaceAll("&ordf;", "\u00aa");
        texto = texto.replaceAll("&laquo;", "\u00ab");
        texto = texto.replaceAll("&not;", "\u00ac");
        texto = texto.replaceAll("&shy;", "\u00ad");
        texto = texto.replaceAll("&reg;", "\u00ae");
        texto = texto.replaceAll("&macr;", "\u00af");
        texto = texto.replaceAll("&deg;", "\u00b0");
        texto = texto.replaceAll("&plusmn;", "\u00b1");
        texto = texto.replaceAll("&sup2;", "\u00b2");
        texto = texto.replaceAll("&sup3;", "\u00b3");
        texto = texto.replaceAll("&acute;", "\u00b4");
        texto = texto.replaceAll("&micro;", "\u00b5");
        texto = texto.replaceAll("&para;", "\u00b6");
        texto = texto.replaceAll("&middot;", "\u00b7");
        texto = texto.replaceAll("&cedil;", "\u00b8");
        texto = texto.replaceAll("&sup1;", "\u00b9");
        texto = texto.replaceAll("&ordm;", "\u00ba");
        texto = texto.replaceAll("&raquo;", "\u00bb");
        texto = texto.replaceAll("&frac14;", "\u00bc");
        texto = texto.replaceAll("&frac12;", "\u00bd");
        texto = texto.replaceAll("&frac34;", "\u00be");
        texto = texto.replaceAll("&iquest;", "\u00bf");
        texto = texto.replaceAll("&Agrave;", "\u00c0");
        texto = texto.replaceAll("&Aacute;", "\u00c1");
        texto = texto.replaceAll("&Acirc;", "\u00c2");
        texto = texto.replaceAll("&Atilde;", "\u00c3");
        texto = texto.replaceAll("&Auml;", "\u00c4");
        texto = texto.replaceAll("&Aring;", "\u00c5");
        texto = texto.replaceAll("&AElig;", "\u00c6");
        texto = texto.replaceAll("&Ccedil;", "\u00c7");
        texto = texto.replaceAll("&Egrave;", "\u00c8");
        texto = texto.replaceAll("&Eacute;", "\u00c9");
        texto = texto.replaceAll("&Ecirc;", "\u00ca");
        texto = texto.replaceAll("&Euml;", "\u00cb");
        texto = texto.replaceAll("&Igrave;", "\u00cc");
        texto = texto.replaceAll("&Iacute;", "\u00cd");
        texto = texto.replaceAll("&Icirc;", "\u00ce");
        texto = texto.replaceAll("&Iuml;", "\u00cf");
        texto = texto.replaceAll("&ETH;", "\u00d0");
        texto = texto.replaceAll("&Ntilde;", "\u00d1");
        texto = texto.replaceAll("&Ograve;", "\u00d2");
        texto = texto.replaceAll("&Oacute;", "\u00d3");
        texto = texto.replaceAll("&Ocirc;", "\u00d4");
        texto = texto.replaceAll("&Otilde;", "\u00d5");
        texto = texto.replaceAll("&Ouml;", "\u00d6");
        texto = texto.replaceAll("&times;", "\u00d7");
        texto = texto.replaceAll("&Oslash;", "\u00d8");
        texto = texto.replaceAll("&Ugrave;", "\u00d9");
        texto = texto.replaceAll("&Uacute;", "\u00da");
        texto = texto.replaceAll("&Ucirc;", "\u00db");
        texto = texto.replaceAll("&Uuml;", "\u00dc");
        texto = texto.replaceAll("&Yacute;", "\u00dd");
        texto = texto.replaceAll("&THORN;", "\u00de");
        texto = texto.replaceAll("&szlig;", "\u00df");
        texto = texto.replaceAll("&agrave;", "\u00e0");
        texto = texto.replaceAll("&aacute;", "\u00e1");
        texto = texto.replaceAll("&acirc;", "\u00e2");
        texto = texto.replaceAll("&atilde;", "\u00e3");
        texto = texto.replaceAll("&auml;", "\u00e4");
        texto = texto.replaceAll("&aring;", "\u00e5");
        texto = texto.replaceAll("&aelig;", "\u00e6");
        texto = texto.replaceAll("&ccedil;", "\u00e7");
        texto = texto.replaceAll("&egrave;", "\u00e8");
        texto = texto.replaceAll("&eacute;", "\u00e9");
        texto = texto.replaceAll("&ecirc;", "\u00ea");
        texto = texto.replaceAll("&euml;", "\u00eb");
        texto = texto.replaceAll("&igrave;", "\u00ec");
        texto = texto.replaceAll("&iacute;", "\u00ed");
        texto = texto.replaceAll("&icirc;", "\u00ee");
        texto = texto.replaceAll("&iuml;", "\u00ef");
        texto = texto.replaceAll("&eth;", "\u00f0");
        texto = texto.replaceAll("&ntilde;", "\u00f1");
        texto = texto.replaceAll("&ograve;", "\u00f2");
        texto = texto.replaceAll("&oacute;", "\u00f3");
        texto = texto.replaceAll("&ocirc;", "\u00f4");
        texto = texto.replaceAll("&otilde;", "\u00f5");
        texto = texto.replaceAll("&ouml;", "\u00f6");
        texto = texto.replaceAll("&divide;", "\u00f7");
        texto = texto.replaceAll("&oslash;", "\u00f8");
        texto = texto.replaceAll("&ugrave;", "\u00f9");
        texto = texto.replaceAll("&uacute;", "\u00fa");
        texto = texto.replaceAll("&ucirc;", "\u00fb");
        texto = texto.replaceAll("&uuml;", "\u00fc");
        texto = texto.replaceAll("&yacute;", "\u00fd");
        texto = texto.replaceAll("&thorn;", "\u00fe");
        texto = texto.replaceAll("&yuml;", "\u00ff");
        return texto;
    }

    public static String quebrarEmColunas(String str, int tamanho) {
        StringBuilder bui = new StringBuilder(str);
        int indice = 0;
        int contador = 1;
        while (indice < bui.length()) {
            if (contador >= tamanho && Character.isWhitespace(bui.charAt(indice))) {
                bui.insert(indice + 1, '\n');
                contador = 0;
                ++indice;
            }
            ++indice;
            ++contador;
        }
        return bui.toString();
    }

    public static List<String> quebrarEmColunas(String str, int largura, FontMetrics fontMetrics) {
        ArrayList<String> cols = new ArrayList<String>();
        if (str != null && fontMetrics != null) {
            int posIni = 0;
            int posFin = 0;
            int len = str.length() - 1;
            while (posFin < len) {
                int tmp;
                while (posFin < len && str.charAt(posFin) != '\n' && fontMetrics.stringWidth(str.substring(posIni, posFin + 1)) < largura) {
                    ++posFin;
                }
                for (tmp = posFin; tmp > posIni && tmp < len && !Character.isWhitespace(str.charAt(tmp)); --tmp) {
                }
                posFin = tmp;
                while (tmp > posIni && str.charAt(tmp) != '\n' && Character.isWhitespace(str.charAt(tmp))) {
                    --tmp;
                }
                cols.add(str.substring(posIni, str.charAt(tmp) == '\n' ? tmp : tmp + 1));
                if (str.charAt(tmp - 1) != '\n') {
                    for (tmp = posFin + 1; tmp < len && str.charAt(tmp) != '\n' && Character.isWhitespace(str.charAt(tmp)); ++tmp) {
                    }
                }
                posIni = posFin = tmp;
            }
        }
        return cols;
    }

    public static String formatarColuna(String str, int tamanho, char alin) {
        if (str.length() > tamanho) {
            return str.substring(0, tamanho);
        }
        int vezes = (tamanho - str.length()) / (alin == 'c' ? 2 : 1);
        StringBuilder bui = new StringBuilder(str);
        char[] tmp = new char[vezes];
        Arrays.fill(tmp, ' ');
        String s = new String(tmp);
        if (alin == 'e' || alin == 'c') {
            bui.append(s);
        }
        if (alin == 'd' || alin == 'c') {
            bui.insert(0, s);
        }
        if (bui.length() < tamanho) {
            bui.append(' ');
        }
        return bui.toString();
    }

    public static String getStringProgresso(String titulo, JProgressBar progress) {
        StringBuilder bui = new StringBuilder(titulo);
        bui.append((int)(progress.getPercentComplete() * 100.0));
        bui.append(" %");
        return bui.toString();
    }

    public static String preencheString(String str, int tamanho, char c, int orientacao) {
        return StringUtil.preencheString(new StringBuilder(str), tamanho, c, orientacao).toString();
    }

    public static StringBuilder preencheString(StringBuilder str, int tamanho, char c, int orientacao) {
        int vezes = tamanho - str.length();
        if (orientacao == 2) {
            vezes /= 2;
        }
        for (int i = 0; i < vezes; ++i) {
            if (orientacao == 0 || orientacao == 2) {
                str.append(c);
            }
            if (orientacao != 1 && orientacao != 2) continue;
            str.insert(0, c);
        }
        if (str.length() < tamanho) {
            str.append(c);
        }
        return str;
    }

    public static StringBuilder preencheStringOcorrencias(StringBuilder str, int num_ocorrencias, char c, int orientacao) {
        int vezes = num_ocorrencias - StringUtil.contaOcorrencias(str, c);
        if (orientacao == 2) {
            vezes /= 2;
        }
        while (vezes > 0) {
            if (orientacao == 0 || orientacao == 2) {
                str.append(c);
            }
            if (orientacao == 1 || orientacao == 2) {
                str.insert(0, c);
            }
            --vezes;
        }
        if (StringUtil.contaOcorrencias(str, c) < num_ocorrencias) {
            str.append(c);
        }
        return str;
    }

    public static int contaOcorrencias(StringBuilder str, char c) {
        return StringUtil.contaOcorrencias(str.toString(), c);
    }

    public static int contaOcorrencias(String str, char c) {
        int ocorrencias = 0;
        int off = 0;
        while ((off = str.indexOf(c, off) + 1) > 0) {
            ++ocorrencias;
        }
        return ocorrencias;
    }

    public static int contaOcorrencias(String str, String substring) {
        int ocorrencias = 0;
        int off = 0;
        while ((off = str.indexOf(substring, off) + 1) > 0) {
            ++ocorrencias;
        }
        return ocorrencias;
    }

    public static String formatFloat(String text) {
        if (text != null) {
            int dot = text.indexOf(".");
            if (dot < 0 && text.length() > 0) {
                text = text + ".00";
            } else if (dot < 0 && text.length() == 0) {
                text = text + "0.00";
            } else {
                int diff = text.length() - 1 - dot;
                if (diff > 2) {
                    while (diff > 3 || text.endsWith("0") && diff > 2) {
                        text = text.substring(0, text.length() - 1);
                        dot = text.indexOf(".");
                        diff = text.length() - 1 - dot;
                    }
                } else if (diff < 2) {
                    while (diff > 0) {
                        text = text + "0";
                        --diff;
                    }
                }
            }
            dot = text.indexOf(".");
            if (dot == text.length() - 1) {
                text = text + "00";
            }
            while (text.startsWith("0") && dot > 2) {
                text = text.substring(1);
                dot = text.indexOf(".");
            }
            return text;
        }
        return null;
    }

    public static String removeZerosEsquerda(String str) {
        int pos;
        if (str == null) {
            return null;
        }
        StringBuilder bui = new StringBuilder(str);
        for (pos = 0; pos < bui.length() && bui.charAt(pos) == '0'; ++pos) {
        }
        if (pos <= bui.length()) {
            bui.delete(0, pos);
        }
        if (bui.length() == 0 || bui.charAt(0) == '.' || bui.charAt(0) == ',') {
            bui.insert(0, '0');
        }
        return bui.toString();
    }

    public static String replaceSpecialChars(String s) {
        s = s.replaceAll(String.valueOf('\u0001'), "<SOH>");
        s = s.replaceAll(String.valueOf('\u0002'), "<STX>");
        s = s.replaceAll(String.valueOf('\u0003'), "<ETX>");
        s = s.replaceAll(String.valueOf('\u0004'), "<EOT>");
        s = s.replaceAll(String.valueOf('\u0006'), "<ACK>");
        s = s.replaceAll(String.valueOf('\u0015'), "<NAK>");
        s = s.replaceAll(String.valueOf('\u007f'), "<DEL>");
        s = s.replaceAll(String.valueOf('\u0010'), "<DLE>");
        s = s.replaceAll(String.valueOf('\u0005'), "<ENQ>");
        s = s.replaceAll(String.valueOf('\u0016'), "<SYN>");
        s = s.replaceAll(String.valueOf('\u0017'), "<ETB>");
        s = s.replaceAll(String.valueOf('\u0018'), "<CAN>");
        s = s.replaceAll(String.valueOf('\u0000'), "<NUL>");
        s = s.replaceAll(String.valueOf('\n'), "<LF>");
        s = s.replaceAll(String.valueOf('\r'), "<CR>");
        s = s.replaceAll(String.valueOf(' '), "<SP>");
        return s;
    }

    public static String[] dividir(String str, int tamanho) {
        if (str.length() <= tamanho) {
            return new String[]{str};
        }
        int fatias = str.length() / tamanho + 1;
        String[] dividido = new String[fatias];
        for (int i = 0; i < fatias - 1; ++i) {
            dividido[i] = str.substring(0, tamanho);
            str = str.substring(tamanho);
        }
        dividido[fatias - 1] = str;
        return dividido;
    }

    public static String notNull(Object str) {
        return str == null ? "" : str.toString();
    }

    public static String encriptar(long numero) {
        int i;
        StringBuilder bui = new StringBuilder();
        Random ran = new Random();
        String strNum = String.valueOf(numero);
        int pos = ran.nextInt(100);
        if (pos > 100 - strNum.length() || pos < 4) {
            pos = 100 - strNum.length();
        }
        String strPos = (pos < 10 ? "0" : "") + String.valueOf(pos) + (strNum.length() < 10 ? "0" : "") + String.valueOf(strNum.length());
        for (i = 0; i < 4; ++i) {
            bui.append(NUM[strPos.charAt(i) - 48]);
        }
        for (i = 0; i < 96 - strNum.length(); ++i) {
            bui.append((char)(ran.nextInt(26) + 65));
        }
        for (i = 0; i < strNum.length(); ++i) {
            bui.insert(pos++, NUM[strNum.charAt(i) - 48]);
        }
        return bui.toString();
    }

    public static long desencriptar(String valor) {
        if (valor.length() == 100) {
            int pos = Integer.parseInt("" + StringUtil.getNumero(valor.charAt(0)) + StringUtil.getNumero(valor.charAt(1)));
            int len = Integer.parseInt("" + StringUtil.getNumero(valor.charAt(2)) + StringUtil.getNumero(valor.charAt(3)));
            StringBuilder bui = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                bui.append(StringUtil.getNumero(valor.charAt(pos + i)));
            }
            return Long.parseLong(bui.toString());
        }
        return 0L;
    }

    private static char getNumero(char letra) {
        for (int i = 0; i < NUM.length; ++i) {
            if (NUM[i] != letra) continue;
            return (char)(i + 48);
        }
        return '\u0000';
    }

    public static String rootXML(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return "";
        }
        StringBuilder retorno = new StringBuilder("");
        boolean aberto = false;
        for (int i = 0; i < xml.length(); ++i) {
            if (xml.charAt(i) == '<') {
                aberto = true;
                continue;
            }
            if (xml.charAt(i) == '>' && aberto) break;
            if (!aberto) continue;
            retorno.append(xml.charAt(i));
        }
        return retorno.toString();
    }

    public static String getXMLDeMap(Map<String, Object> map) {
        StringBuilder bui = new StringBuilder();
        if (map != null) {
            for (String chave : map.keySet()) {
                if (map.get(chave) == null) continue;
                bui.append("<item><campo>");
                bui.append(chave);
                bui.append("</campo><valor>");
                bui.append(map.get(chave));
                bui.append("</valor></item>");
                bui.append("\n");
            }
        }
        return bui.toString();
    }

    public static Map<String, Object> getMapDeXML(String xml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (xml != null) {
            for (String item : StringUtil.getListValores(xml, "item")) {
                map.put(StringUtil.getValor(item, "campo"), StringUtil.getValor(item, "valor"));
            }
        }
        return map;
    }

    public static String getXMLDeList(List<?> list) {
        StringBuilder bui = new StringBuilder();
        if (list != null) {
            for (Object item : list) {
                bui.append("<item>").append(item).append("</item>");
                bui.append("\n");
            }
        }
        return bui.toString();
    }

    public static List<String> getListDeXML(String xml) {
        ArrayList<String> list = new ArrayList<String>();
        if (xml != null) {
            list.addAll(StringUtil.getListValores(xml, "item"));
        }
        return list;
    }

    public static String compactar(String str) throws IOException {
        return StringUtil.compactar(str, 9, null);
    }

    public static String compactar(String str, final int nivelCompressao, String charset) throws IOException {
        String retorno = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream os = new GZIPOutputStream((OutputStream)baos){
                {
                    super(x0);
                    this.def.setLevel(nivelCompressao);
                }
            };
            if (Funcoes.textoVazio(charset)) {
                ((OutputStream)os).write(str.getBytes());
            } else {
                ((OutputStream)os).write(str.getBytes(charset));
            }
            ((OutputStream)os).close();
            retorno = new Base64().encodeAsString(baos.toByteArray());
            return retorno;
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            return retorno;
        }
    }

    public static String descompactar(IntegracaoUtil.VersaoXML versao, String str, String charset) throws GZipException, DataFormatException {
        if (versao == IntegracaoUtil.VersaoXML.VERSAO_1_0_0) {
            return StringUtil.descompactarVersao1_0_0(str);
        }
        if (versao == IntegracaoUtil.VersaoXML.VERSAO_2_0_0) {
            return StringUtil.descompactarVersao2_0_0(str, charset);
        }
        if (versao == IntegracaoUtil.VersaoXML.VERSAO_3_0_0) {
            return StringUtil.descompactarVersao2_0_0(str, "");
        }
        return null;
    }

    private static String descompactarVersao2_0_0(String str, String charset) throws GZipException {
        GZIPInputStream gzipInputStream = null;
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] aux = str.getBytes();
            ByteArrayInputStream bais = new ByteArrayInputStream(new Base64().decode(aux));
            gzipInputStream = new GZIPInputStream(bais);
            str = null;
            aux = null;
            bais.close();
            bais = null;
            System.gc();
            byte[] buf = new byte[128];
            while ((len = gzipInputStream.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            gzipInputStream.close();
            gzipInputStream = null;
            System.gc();
            if (Funcoes.textoVazio(charset)) {
                return baos.toString();
            }
            return baos.toString(charset);
        }
        catch (IOException e) {
            throw new GZipException(e);
        }
    }

    public static String getCharsetIntegracao(String parametroLocal) {
        String charset = Tipos.getCharset(parametroLocal);
        charset = !Funcoes.textoVazio(charset) ? (!charset.equals(Tipos.getCharset("P")) ? charset : "") : "";
        return charset;
    }

    private static String descompactarVersao1_0_0(String str) throws DataFormatException {
        if (str != null && str.length() > 0) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int off = 0;
                int size = 0;
                for (int i = 0; i < str.length(); ++i) {
                    boolean fimStr;
                    boolean bl = fimStr = i == str.length() - 1;
                    if (str.charAt(i) != ',' && !fimStr) continue;
                    baos.write(Byte.parseByte(str.substring(off, fimStr ? i + 1 : i)));
                    off = i + 1;
                }
                StringBuilder bui = new StringBuilder();
                byte[] bytes = new byte[1024];
                Inflater inflater = new Inflater(false);
                inflater.setInput(baos.toByteArray());
                while (!inflater.finished()) {
                    size = inflater.inflate(bytes);
                    bui.append(new String(bytes, 0, size));
                }
                String string = bui.toString();
                return string;
            }
            catch (DataFormatException e) {
                throw new DataFormatException(e.getMessage());
            }
            finally {
                return str;
            }
        }
        return str;
    }

    public static String concatenarExtensao(String str, String ext) {
        if (!str.toUpperCase().endsWith(ext.toUpperCase())) {
            str = str + ext;
        }
        return str;
    }

    public static String tratarEntidadesHTML(String str) {
        return StringUtil.tratarEntidadesHTML(str, true);
    }

    public static String tratarEntidadesHTML(String str, boolean trocarEspacos) {
        return StringUtil.tratarEntidadesHTML(str, trocarEspacos, true);
    }

    public static String tratarEntidadesHTML(String str, boolean trocarEspacos, boolean trocarMaiorMenorEnter) {
        StringBuilder bui = new StringBuilder();
        if (str != null) {
            int i = 0;
            block6: while (i < str.length()) {
                switch (str.charAt(i)) {
                    case '\n': 
                    case '\r': {
                        if (!trocarMaiorMenorEnter) {
                            ++i;
                            continue block6;
                        }
                        bui.append("<br>");
                        if (++i >= str.length() || (str.charAt(i - 1) != '\n' || str.charAt(i) != '\r') && (str.charAt(i - 1) != '\r' || str.charAt(i) != '\n')) continue block6;
                        ++i;
                        continue block6;
                    }
                    case ' ': {
                        if (trocarEspacos && i - 1 > -1 && str.charAt(i - 1) == ' ') {
                            bui.append(entidadesHTML.get(str.charAt(i)));
                        } else {
                            bui.append(str.charAt(i));
                        }
                        ++i;
                        continue block6;
                    }
                    case '&': 
                    case '<': 
                    case '>': {
                        bui.append(trocarMaiorMenorEnter ? entidadesHTML.get(str.charAt(i)) : Character.valueOf(str.charAt(i)));
                        ++i;
                        continue block6;
                    }
                    case '\"': 
                    case '\u00a0': 
                    case '\u00a1': 
                    case '\u00a2': 
                    case '\u00a3': 
                    case '\u00a4': 
                    case '\u00a5': 
                    case '\u00a6': 
                    case '\u00a7': 
                    case '\u00a8': 
                    case '\u00a9': 
                    case '\u00aa': 
                    case '\u00ab': 
                    case '\u00ac': 
                    case '\u00ad': 
                    case '\u00ae': 
                    case '\u00af': 
                    case '\u00b0': 
                    case '\u00b1': 
                    case '\u00b2': 
                    case '\u00b3': 
                    case '\u00b4': 
                    case '\u00b5': 
                    case '\u00b6': 
                    case '\u00b7': 
                    case '\u00b8': 
                    case '\u00b9': 
                    case '\u00ba': 
                    case '\u00bb': 
                    case '\u00bc': 
                    case '\u00bd': 
                    case '\u00be': 
                    case '\u00bf': 
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c4': 
                    case '\u00c5': 
                    case '\u00c6': 
                    case '\u00c7': 
                    case '\u00c8': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': 
                    case '\u00cc': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': 
                    case '\u00d0': 
                    case '\u00d1': 
                    case '\u00d2': 
                    case '\u00d3': 
                    case '\u00d4': 
                    case '\u00d5': 
                    case '\u00d6': 
                    case '\u00d7': 
                    case '\u00d8': 
                    case '\u00d9': 
                    case '\u00da': 
                    case '\u00db': 
                    case '\u00dc': 
                    case '\u00dd': 
                    case '\u00de': 
                    case '\u00df': 
                    case '\u00e0': 
                    case '\u00e1': 
                    case '\u00e2': 
                    case '\u00e3': 
                    case '\u00e4': 
                    case '\u00e5': 
                    case '\u00e6': 
                    case '\u00e7': 
                    case '\u00e8': 
                    case '\u00e9': 
                    case '\u00ea': 
                    case '\u00eb': 
                    case '\u00ec': 
                    case '\u00ed': 
                    case '\u00ee': 
                    case '\u00ef': 
                    case '\u00f0': 
                    case '\u00f1': 
                    case '\u00f2': 
                    case '\u00f3': 
                    case '\u00f4': 
                    case '\u00f5': 
                    case '\u00f6': 
                    case '\u00f7': 
                    case '\u00f8': 
                    case '\u00f9': 
                    case '\u00fa': 
                    case '\u00fb': 
                    case '\u00fc': 
                    case '\u00fd': 
                    case '\u00fe': 
                    case '\u00ff': {
                        bui.append(entidadesHTML.get(str.charAt(i)));
                        ++i;
                        continue block6;
                    }
                }
                bui.append(str.charAt(i));
                ++i;
            }
        }
        return bui.toString();
    }

    public static String[] getArrayString(Object o) {
        ArrayList<String> array = new ArrayList<String>();
        if (o instanceof Object[]) {
            for (Object tmp : (Object[])o) {
                array.add(StringUtil.notNull(tmp));
            }
        }
        return array.toArray(new String[array.size()]);
    }

    public static String arrayParaString(String[] array) {
        StringBuilder bui = new StringBuilder();
        if (array.length > 0) {
            bui.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                bui.append(", ").append(array[i]);
            }
        }
        return bui.toString();
    }

    public static String arrayParaString(Integer[] array) {
        StringBuilder bui = new StringBuilder();
        if (array.length > 0) {
            bui.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                bui.append(", ").append(array[i].toString());
            }
        }
        return bui.toString();
    }

    public static String converteArrayCharString(char[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        String retorno = "";
        for (char c : array) {
            retorno = retorno + c;
        }
        return retorno;
    }

    public static String listParaString(List<String> list) {
        StringBuilder bui = new StringBuilder();
        if (list.size() > 0) {
            bui.append(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                bui.append(", ").append(list.get(i));
            }
        }
        return bui.toString();
    }

    public static String testaTamanhoString(String s, int tamanho) {
        if (s.length() <= tamanho) {
            return s;
        }
        return s.substring(0, tamanho);
    }

    public static String limpaString(String s, String[] caracteres) {
        StringBuilder buf = new StringBuilder("");
        if (s != null && !Funcoes.textoVazio(s)) {
            for (char c : s.toCharArray()) {
                if (ArraysUtil.indice((Object[])caracteres, String.valueOf(c)) >= 0) continue;
                buf.append(c);
            }
        }
        return buf.toString();
    }

    public static String calcularCodigoHash(String c) throws NoSuchAlgorithmException {
        if (c != null) {
            MessageDigest m = MessageDigest.getInstance("MD5");
            byte[] calculo = m.digest(c.getBytes());
            StringBuilder buf = new StringBuilder();
            for (byte b : calculo) {
                buf.append(Funcoes.preencheZero(Integer.toHexString(0xFF & b), 2));
            }
            return buf.toString();
        }
        return "";
    }

    public static String converteHtmlParaAcentos(String html) {
        if (html == null) {
            return "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int tag : entidadesHTML.keySet()) {
            map.put(entidadesHTML.get(tag), String.valueOf((char)tag));
        }
        boolean abriu = false;
        String acento = "";
        StringBuilder buf = new StringBuilder();
        for (char c : html.toCharArray()) {
            if (!abriu) {
                boolean bl = abriu = c == '&';
            }
            if (abriu) {
                acento = acento + c;
                if (c != ';') continue;
                abriu = false;
                buf.append((String)map.get(acento));
                acento = "";
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String converteHtmlParaAcentos(String html, boolean trocaBrPorLn) {
        return trocaBrPorLn ? StringUtil.converteHtmlParaAcentos(html).replace("<br>", "\n") : StringUtil.converteHtmlParaAcentos(html);
    }

    public static String implode(Collection colecao, String delimitador) {
        StringBuilder bui = new StringBuilder();
        StringUtil.implode(colecao, delimitador, bui);
        return bui.toString();
    }

    public static void implode(Collection colecao, String delimitador, StringBuilder bui) {
        Iterator itens = colecao.iterator();
        while (itens.hasNext()) {
            bui.append(itens.next());
            if (!itens.hasNext()) continue;
            bui.append(delimitador);
        }
    }

    public static void implode(Collection colecao, String delimitador, StringBuilder bui, boolean isSql) {
        Iterator itens = colecao.iterator();
        while (itens.hasNext()) {
            if (isSql) {
                bui.append(" '");
            }
            bui.append(itens.next());
            if (isSql) {
                bui.append("' ");
            }
            if (!itens.hasNext()) continue;
            bui.append(delimitador);
        }
    }

    public static String implode(String[] array, String delimitador) {
        StringBuilder bui = new StringBuilder();
        StringUtil.implode(array, delimitador, bui);
        return bui.toString();
    }

    public static void implode(String[] array, String delimitador, StringBuilder bui) {
        boolean primeiro = true;
        for (String string : array) {
            if (primeiro) {
                primeiro = false;
            } else {
                bui.append(delimitador);
            }
            bui.append(string);
        }
    }

    public static String arrumaEtiqueta(String message) {
        String command = message;
        String newCommand = "";
        String c = "";
        if (command != null && command.trim().length() > 0) {
            char[] a = command.toCharArray();
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == '[' && a[i + 1] != '[') {
                    c = c + a[i];
                    ++i;
                    while (a[i] != ']') {
                        c = c + a[i];
                        ++i;
                    }
                    c = c + a[i];
                    newCommand = newCommand + StringUtil.parseStringToConstant(c);
                    c = "";
                    continue;
                }
                newCommand = newCommand + a[i];
            }
        }
        return newCommand;
    }

    public static String parseStringToConstant(String command) {
        if (command.equalsIgnoreCase(sNUL)) {
            return String.valueOf('\u0000');
        }
        if (command.equalsIgnoreCase(sSOH)) {
            return String.valueOf('\u0001');
        }
        if (command.equalsIgnoreCase(sSTX)) {
            return String.valueOf('\u0002');
        }
        if (command.equalsIgnoreCase(sETX)) {
            return String.valueOf('\u0003');
        }
        if (command.equalsIgnoreCase(sEOT)) {
            return String.valueOf('\u0004');
        }
        if (command.equalsIgnoreCase(sENQ)) {
            return String.valueOf('\u0005');
        }
        if (command.equalsIgnoreCase(sACK)) {
            return String.valueOf('\u0006');
        }
        if (command.equalsIgnoreCase(sSB)) {
            return String.valueOf('\u000b');
        }
        if (command.equalsIgnoreCase(sDLE)) {
            return String.valueOf('\u0010');
        }
        if (command.equalsIgnoreCase(sDC1)) {
            return String.valueOf('\u0011');
        }
        if (command.equalsIgnoreCase(sNAK)) {
            return String.valueOf('\u0015');
        }
        if (command.equalsIgnoreCase(sSYN)) {
            return String.valueOf('\u0016');
        }
        if (command.equalsIgnoreCase(sETB)) {
            return String.valueOf('\u0017');
        }
        if (command.equalsIgnoreCase(sCAN)) {
            return String.valueOf('\u0018');
        }
        if (command.equalsIgnoreCase(sEB)) {
            return String.valueOf('\u001c');
        }
        if (command.equalsIgnoreCase(sSP)) {
            return String.valueOf(' ');
        }
        if (command.equalsIgnoreCase(sDEL)) {
            return String.valueOf('\u007f');
        }
        if (command.equalsIgnoreCase(sFD)) {
            return String.valueOf('\u00fd');
        }
        return "";
    }

    public static String parseEtiqueta(String message) {
        String newMessage = "";
        if (message != null && message.length() > 0) {
            char[] a = message.toCharArray();
            for (int i = 0; i < a.length; ++i) {
                char c = a[i];
                newMessage = c == '\u0000' ? newMessage + sNUL : (c == '\u0001' ? newMessage + sSOH : (c == '\u0002' ? newMessage + sSTX : (c == '\u0003' ? newMessage + sETX : (c == '\u0004' ? newMessage + sEOT : (c == '\u0005' ? newMessage + sENQ : (c == '\u0006' ? newMessage + sACK : (c == '\u0010' ? newMessage + sDLE : (c == '\u0015' ? newMessage + sNAK : (c == '\u0016' ? newMessage + sSYN : (c == '\u0017' ? newMessage + sETB : (c == '\u0018' ? newMessage + sCAN : (c == '\u007f' ? newMessage + sDEL : (c == '\u00fd' ? newMessage + sFD : (c == '\u001c' ? newMessage + sEB : newMessage + c))))))))))))));
            }
        }
        return newMessage;
    }

    public static String removeEspacosDuplicados(String string) {
        String patternStr = "\\s+";
        String replaceStr = " ";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll(replaceStr);
        return string;
    }

    public static ArrayList<String> explode(String lista, String delimitador) {
        if (Funcoes.textoVazio(lista) || delimitador == null || delimitador.length() == 0) {
            return null;
        }
        ArrayList<String> retorno = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(lista, delimitador);
        while (tokenizer.hasMoreTokens()) {
            retorno.add(tokenizer.nextToken());
        }
        return retorno;
    }

    public static String textoDBEscape(String texto) {
        StringBuilder bui = new StringBuilder();
        bui.append("E'");
        if (texto != null) {
            for (int i = 0; i < texto.length(); ++i) {
                bui.append(StringUtil.tratarUnicode(texto.charAt(i), true, true));
            }
        }
        bui.append("'");
        return bui.toString();
    }

    public static String textoDBEscape(String texto, boolean isXml, boolean isGravarBanco) {
        StringBuilder bui = new StringBuilder();
        bui.append("E'");
        if (texto != null) {
            for (int i = 0; i < texto.length(); ++i) {
                bui.append(StringUtil.tratarUnicode(texto.charAt(i), isXml, isGravarBanco));
            }
        }
        bui.append("'");
        return bui.toString();
    }

    public static String trataCaracteresEspeciais(String s) {
        String temp = Normalizer.normalize(s, Normalizer.Form.NFD);
        return temp.replaceAll("[^\\p{ASCII}]", "");
    }

    public static String tratarUnicode(String texto) {
        return StringUtil.tratarUnicode(texto, false);
    }

    public static String tratarUnicode(String texto, boolean isXml) {
        if (Funcoes.textoVazio(texto)) {
            return texto;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < texto.length(); ++i) {
            buf.append(StringUtil.tratarUnicode(texto.charAt(i), isXml));
        }
        return buf.toString();
    }

    public static String tratarUnicode(String texto, boolean isXml, boolean isResultado) {
        if (Funcoes.textoVazio(texto)) {
            return texto;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < texto.length(); ++i) {
            buf.append(StringUtil.tratarUnicode(texto.charAt(i), isXml, isResultado));
        }
        return buf.toString();
    }

    public static String tratarUnicode(char c) {
        return StringUtil.tratarUnicode(c, false);
    }

    public static String tratarUnicode(char c, boolean isXml) {
        return StringUtil.tratarUnicode(c, isXml, false);
    }

    public static String tratarUnicodeWeb(String texto, boolean isXml) {
        if (Funcoes.textoVazio(texto)) {
            return texto;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < texto.length(); ++i) {
            buf.append(StringUtil.tratarUnicodeWeb(texto.charAt(i), isXml));
        }
        return buf.toString();
    }

    public static String tratarUnicodeWeb(char c, boolean isXml) {
        StringBuilder bui = new StringBuilder();
        if (isXml && c == '\u2013') {
            bui.append("-");
        } else if (isXml && (c == '\n' || c == '\u000b' || c == '\r')) {
            bui.append(c);
        } else if (c == '\u0092' || c == '\u2019' || c == '`' || c == '\u00b4' || c == '\u00b4') {
            if (isXml && (c == '\u0092' || c == '\u2019' || c == '\u00b4')) {
                bui.append("");
            } else if (!isXml) {
                if (c == '`') {
                    bui.append('`');
                } else if (c == '\u00b4') {
                    bui.append('\u00b4');
                } else {
                    bui.append(c);
                }
            } else if (c == '`') {
                bui.append('`');
            } else if (c == '\u00b4') {
                bui.append('\u00b4');
            } else {
                bui.append(c);
            }
        } else if (c == '\'') {
            if (isXml) {
                bui.append("'").append(c);
            } else {
                bui.append(c);
            }
        } else if (c == '\u201c' || c == '\u201d') {
            if (isXml) {
                bui.append("");
            } else {
                bui.append("\"");
            }
        } else if (c == '\u221e' || c == '\u2013' || c == '\u25ba' || c == '\u200e') {
            bui.append(" ");
        } else if (c == '\\') {
            if (!isXml) {
                bui.append(c);
            } else {
                bui.append("\\").append(c);
            }
        } else if (c == '/') {
            bui.append(c);
        } else if (c == '\u0161' || c == '\u015b') {
            bui.append("s");
        } else if (c == '\u015a') {
            bui.append("S");
        } else if (c == '\u2022') {
            bui.append(".");
        } else if (c == '\u0155') {
            bui.append("r");
        } else if (c == '\u0154') {
            bui.append("R");
        } else if (c == '\u0139') {
            bui.append("L");
        } else if (c == '\u1e54') {
            bui.append("P");
        } else if (c == '\u1e55') {
            bui.append("p");
        } else if (c == '\u1e4d') {
            bui.append("o");
        } else if (c == '\u01f5') {
            bui.append("g");
        } else if (c == '\u01f4') {
            bui.append("G");
        } else if (c == '\u01d8' || c == '\u0169') {
            bui.append("u");
        } else if (c == '\u0168') {
            bui.append("U");
        } else if (c == '\u1e7c') {
            bui.append("V");
        } else if (c == '\u1e7d') {
            bui.append("v");
        } else if (c == '\u1e83') {
            bui.append("w");
        } else if (c == '\u1e82') {
            bui.append("W");
        } else if (c == '\u1ef9') {
            bui.append("y");
        } else if (c == '\u1ef8') {
            bui.append("Y");
        } else if (c == '\u0192' || c == '\u25ba' || c == '\ufffd' || c == '\u20ac' || c == '\u03bc' || c == '\u0632' || c == '\u0635' || c == '\u200e' || c == '\u20ac' || c == '\uc4b9' || c == '\uc4ba' || c == '\uc594' || c == '\uc595' || c == '\uc59a' || c == '\uc59b' || c == '\uc692' || c == '\ucebc' || c == '\ud915' || c == '\udc74' || c == '\ue1b9' || c == '\ue280' || c == '\ue288' || c == '\ue296' || c == '\uefbd' || c == '\uefbf' || c == '\u221e' || c == '\uff7d' || c > '\u00ff' || c < ' ' && c != '\n' && c != '\u000b' && c != '\r' || c > '~' && c < '\u00a0') {
            bui.append(" ");
        } else {
            bui.append(c);
        }
        return bui.toString();
    }

    public static String tratarUnicode(char c, boolean isXml, boolean isGravarBanco) {
        StringBuilder bui = new StringBuilder();
        if (isXml && c == '\u2013') {
            bui.append("-");
        } else if (isXml && (c == '\n' || c == '\u000b' || c == '\r')) {
            bui.append(c);
        } else if (c == '\u0092' || c == '\u2019' || c == '`' || c == '\u00b4' || c == '\u00b4') {
            if (isXml && !isGravarBanco && (c == '\u0092' || c == '\u2019' || c == '\u00b4')) {
                bui.append("");
            } else if (isGravarBanco && !isXml) {
                if (c == '`') {
                    bui.append('`');
                } else if (c == '\u00b4') {
                    bui.append('\u00b4');
                } else {
                    bui.append(c);
                }
            } else if (c == '`') {
                bui.append('`');
            } else if (c == '\u00b4') {
                bui.append('\u00b4');
            } else {
                bui.append(c);
            }
        } else if (c == '\'') {
            if (isXml && isGravarBanco) {
                bui.append("'").append(c);
            } else {
                bui.append(c);
            }
        } else if (c == '\u201c' || c == '\u201d') {
            if (isXml) {
                bui.append("");
            } else {
                bui.append("\"");
            }
        } else if (c == '\u221e' || c == '\u2013' || c == '\u25ba' || c == '\u200e') {
            bui.append(" ");
        } else if (c == '\\') {
            if (!isXml || isGravarBanco) {
                bui.append(c);
            } else {
                bui.append("\\").append(c);
            }
        } else if (c == '/') {
            bui.append(c);
        } else if (c == '\u0161' || c == '\u015b') {
            bui.append("s");
        } else if (c == '\u015a') {
            bui.append("S");
        } else if (c == '\u2022') {
            bui.append(".");
        } else if (c == '\u0155') {
            bui.append("r");
        } else if (c == '\u0154') {
            bui.append("R");
        } else if (c == '\u0139') {
            bui.append("L");
        } else if (c == '\u1e54') {
            bui.append("P");
        } else if (c == '\u1e55') {
            bui.append("p");
        } else if (c == '\u1e4d') {
            bui.append("o");
        } else if (c == '\u01f5') {
            bui.append("g");
        } else if (c == '\u01f4') {
            bui.append("G");
        } else if (c == '\u01d8' || c == '\u0169') {
            bui.append("u");
        } else if (c == '\u0168') {
            bui.append("U");
        } else if (c == '\u1e7c') {
            bui.append("V");
        } else if (c == '\u1e7d') {
            bui.append("v");
        } else if (c == '\u1e83') {
            bui.append("w");
        } else if (c == '\u1e82') {
            bui.append("W");
        } else if (c == '\u1ef9') {
            bui.append("y");
        } else if (c == '\u1ef8') {
            bui.append("Y");
        } else if (c == '\u0192' || c == '\u25ba' || c == '\ufffd' || c == '\u20ac' || c == '\u03bc' || c == '\u0632' || c == '\u0635' || c == '\u200e' || c == '\u20ac' || c == '\uc4b9' || c == '\uc4ba' || c == '\uc594' || c == '\uc595' || c == '\uc59a' || c == '\uc59b' || c == '\uc692' || c == '\ucebc' || c == '\ud915' || c == '\udc74' || c == '\ue1b9' || c == '\ue280' || c == '\ue288' || c == '\ue296' || c == '\uefbd' || c == '\uefbf' || c == '\u221e' || c == '\uff7d' || c > '\u00ff' || c < ' ' && c != '\n' && c != '\u000b' && c != '\r' && c != '\t' || c > '~' && c < '\u00a0') {
            bui.append(" ");
        } else {
            bui.append(c);
        }
        return bui.toString();
    }

    public static String tratarUnicodeXml(String comando, String tag) {
        StringBuilder buf = new StringBuilder(comando);
        int posicaoInicial = buf.toString().toLowerCase().indexOf(tag) + 1;
        int posicaoFinal = buf.toString().toLowerCase().indexOf(tag.substring(0, 1) + "/" + tag.substring(1));
        int tamTag = tag.length() - 1;
        String paraCorrigir = buf.substring(posicaoInicial + tamTag, posicaoFinal);
        String novoTexto = StringUtil.tratarUnicode(paraCorrigir, true);
        buf.delete(posicaoInicial + tamTag, posicaoFinal);
        buf.insert(posicaoInicial + tamTag, novoTexto);
        return buf.toString();
    }

    public static String trocaTextoIntegracao(String texto) {
        StringBuilder bui = new StringBuilder();
        if (texto != null) {
            for (int i = 0; i < texto.length(); ++i) {
                if (texto.charAt(i) == '\u221e' || texto.charAt(i) == '\u2013' || texto.charAt(i) == '\u25ba') {
                    bui.append(" ");
                    continue;
                }
                if (texto.charAt(i) == '\u201c' || texto.charAt(i) == '\u201d' || texto.charAt(i) == '\ue2809d' || texto.charAt(i) == '\ue2809c' || texto.charAt(i) == '\u201c' || texto.charAt(i) == '\u0093') {
                    bui.append("\"");
                    continue;
                }
                if (texto.charAt(i) == '\u00e2') {
                    bui.append("\u00e2");
                    continue;
                }
                if (texto.charAt(i) == '\u0161') {
                    bui.append("s");
                    continue;
                }
                if (texto.charAt(i) == '\u00ef') {
                    bui.append("i");
                    continue;
                }
                if (texto.charAt(i) == '\u00e1') {
                    bui.append("\u00e1");
                    continue;
                }
                if (texto.charAt(i) == '\uff7d') {
                    bui.append("\u00c7");
                    continue;
                }
                if (texto.charAt(i) == '\ue280a2' || texto.charAt(i) == '\u2022') {
                    bui.append(".");
                    continue;
                }
                if (texto.charAt(i) == '\u00df' || texto.charAt(i) == '\ufffd' || texto.charAt(i) == '\ue282ac' || texto.charAt(i) == '\uc595' || texto.charAt(i) == '\uc594' || texto.charAt(i) == '\uc4b9' || texto.charAt(i) == '\uc692' || texto.charAt(i) == '\uefbfbd' || texto.charAt(i) == '\uc59b' || texto.charAt(i) == '\ue1b994' || texto.charAt(i) == '\ue2889e' || texto.charAt(i) == '\ue1b995' || texto.charAt(i) == '\ue1b98d' || texto.charAt(i) == '\ue28093' || texto.charAt(i) == '\uc4ba' || texto.charAt(i) == '\uc59a' || texto.charAt(i) == '\uefbdbd' || texto.charAt(i) == '\ue296ba' || texto.charAt(i) == '\ucebc' || texto.charAt(i) == '\ud8b2' || texto.charAt(i) == '\ud8b5' || texto.charAt(i) == '\ue2808e' || texto.charAt(i) == '\u20ac' || texto.charAt(i) == '\u200e' || texto.charAt(i) == '\uc4b9' || texto.charAt(i) == '\uc4ba' || texto.charAt(i) == '\uc594' || texto.charAt(i) == '\uc595' || texto.charAt(i) == '\uc59a' || texto.charAt(i) == '\uc59b' || texto.charAt(i) == '\uc692' || texto.charAt(i) == '\ucebc' || texto.charAt(i) == '\ud8b2' || texto.charAt(i) == '\ud8b5' || texto.charAt(i) == '\ue1b9' || texto.charAt(i) == '\ue280' || texto.charAt(i) == '\ue288' || texto.charAt(i) == '\ue296' || texto.charAt(i) == '\uefbd' || texto.charAt(i) == '\uefbf') {
                    bui.append(" ");
                    continue;
                }
                bui.append(texto.charAt(i));
            }
        }
        return bui.toString();
    }

    public static String removeCaracteresNaoNumericos(String textoOriginal) {
        if (textoOriginal == null) {
            return null;
        }
        textoOriginal = StringUtil.tratarUnicode(textoOriginal);
        StringBuilder novoTexto = new StringBuilder();
        char[] arrayTextoOriginal = textoOriginal.toCharArray();
        for (int i = 0; i < arrayTextoOriginal.length; ++i) {
            char valChar = arrayTextoOriginal[i];
            if (valChar < '0' || valChar > '9') continue;
            novoTexto.append(arrayTextoOriginal[i]);
        }
        return novoTexto.toString();
    }

    public static String getValorTagRelacionada(String xml, String nomeAtributo, String valorAtributo) {
        if (Funcoes.textoVazio(xml) || Funcoes.textoVazio(nomeAtributo) || Funcoes.textoVazio(valorAtributo)) {
            return null;
        }
        int indiceAux = 0;
        int indiceAtributo;
        while ((indiceAtributo = xml.indexOf(" " + nomeAtributo + "=", indiceAux)) != -1) {
            int indiceFechaTag = xml.indexOf(">", indiceAtributo);
            String valorAtributoAux = xml.substring(indiceAtributo + nomeAtributo.length() + 2, indiceFechaTag);
            if (valorAtributo.equalsIgnoreCase(valorAtributoAux = valorAtributoAux.replaceAll("\"", ""))) {
                int indiceAbreProximaTag = xml.indexOf("<", indiceFechaTag);
                if (indiceAbreProximaTag == -1) {
                    indiceAbreProximaTag = xml.length() - 1;
                }
                return xml.substring(indiceFechaTag + 1, indiceAbreProximaTag);
            }
            indiceAux = indiceFechaTag;
        }
        return null;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String replaceBuilder(String text, String searchString, String replacement) {
        return StringUtil.replaceBuilder(text, searchString, replacement, -1);
    }

    public static String replaceBuilder(String text, String searchString, String replacement, int max) {
        if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String limpaCdata(String valor) {
        return StringUtil.replaceBuilder(StringUtil.replaceBuilder(StringUtil.replaceBuilder(StringUtil.replaceBuilder(StringUtil.replaceBuilder(StringUtil.replaceBuilder(StringUtil.replaceBuilder(StringUtil.replaceBuilder(valor, " ]]>", ""), "<![CDATA[ ", ""), " ]]", ""), "![CDATA[ ", ""), "]]>", ""), "<![CDATA[", ""), "]]", ""), "![CDATA[", "");
    }

    public static String preencheCData(String valor, boolean semEspaco) {
        StringBuilder retorno = new StringBuilder();
        if (Funcoes.textoVazio(valor) || valor != null && !valor.contains("<![CDATA[")) {
            retorno.append("<![CDATA[").append(semEspaco ? "" : " ").append(valor);
        }
        if (Funcoes.textoVazio(valor) || valor != null && !valor.contains("]]>")) {
            retorno.append(semEspaco ? "" : " ").append("]]>");
        }
        return retorno.toString();
    }

    public static String escreveCabecalho(String codificado) {
        if (!codificado.contains("<?xml version=")) {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.escreveHeader("1.0", "ISO-8859-1");
            xml.escrever("Resultados", codificado);
            return xml.getXML();
        }
        return codificado;
    }

    public static String preencheCData(String valor) {
        return StringUtil.preencheCData(valor, false);
    }

    public static String trataEntidadesXML(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return texto;
        }
        texto.replace("&", "&amp;");
        texto.replace("\"", "&quot;");
        texto.replace("'", "&apos;");
        texto.replace("<", "&lt;");
        texto.replace(">", "&gt;");
        return texto;
    }

    public static String limpaXmlEnvioWebService(String valor) {
        return StringUtil.textoXMLEnvioWebService(StringUtil.tratarUnicode(StringUtil.textoDB(StringUtil.removerAcentos(valor)))).trim();
    }

    public static String substituirCaracteresEspeciais(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            return StringUtil.removerAcentos(s).replace(" ", "%20");
        }
    }

    public static Map<String, String> descompactarZip(String path) throws IOException {
        byte[] buffer = new byte[1024];
        int BUFFER = 2048;
        HashMap<String, String> files = new HashMap<String, String>();
        try (ZipInputStream zinstream = null;){
            zinstream = new ZipInputStream(new FileInputStream(path));
            ZipEntry zentry = zinstream.getNextEntry();
            while (zentry != null) {
                int n;
                String entryName = zentry.getName();
                StringBuilder b = new StringBuilder();
                while ((n = zinstream.read(buffer)) > -1) {
                    b.append(new String(buffer).replaceAll(String.valueOf('\u0000'), ""));
                    buffer = new byte[1024];
                }
                if (Funcoes.textoVazio(b.toString())) {
                    zinstream.closeEntry();
                    zentry = zinstream.getNextEntry();
                    continue;
                }
                files.put(entryName, b.toString());
                zinstream.closeEntry();
                zentry = zinstream.getNextEntry();
            }
        }
        return files;
    }

    static {
        entidadesHTML.put(32, "&nbsp;");
        entidadesHTML.put(34, "&quot;");
        entidadesHTML.put(38, "&amp;");
        entidadesHTML.put(60, "&lt;");
        entidadesHTML.put(62, "&gt;");
        entidadesHTML.put(160, "&nbsp;");
        entidadesHTML.put(161, "&iexcl;");
        entidadesHTML.put(162, "&cent;");
        entidadesHTML.put(163, "&pound;");
        entidadesHTML.put(164, "&curren;");
        entidadesHTML.put(165, "&yen;");
        entidadesHTML.put(166, "&brvbar;");
        entidadesHTML.put(167, "&sect;");
        entidadesHTML.put(168, "&uml;");
        entidadesHTML.put(169, "&copy;");
        entidadesHTML.put(170, "&ordf;");
        entidadesHTML.put(171, "&laquo;");
        entidadesHTML.put(172, "&not;");
        entidadesHTML.put(173, "&shy;");
        entidadesHTML.put(174, "&reg;");
        entidadesHTML.put(175, "&macr;");
        entidadesHTML.put(176, "&deg;");
        entidadesHTML.put(177, "&plusmn;");
        entidadesHTML.put(178, "&sup2;");
        entidadesHTML.put(179, "&sup3;");
        entidadesHTML.put(180, "&acute;");
        entidadesHTML.put(181, "&micro;");
        entidadesHTML.put(182, "&para;");
        entidadesHTML.put(183, "&middot;");
        entidadesHTML.put(184, "&cedil;");
        entidadesHTML.put(185, "&sup1;");
        entidadesHTML.put(186, "&ordm;");
        entidadesHTML.put(187, "&raquo;");
        entidadesHTML.put(188, "&frac14;");
        entidadesHTML.put(189, "&frac12;");
        entidadesHTML.put(190, "&frac34;");
        entidadesHTML.put(191, "&iquest;");
        entidadesHTML.put(192, "&Agrave;");
        entidadesHTML.put(193, "&Aacute;");
        entidadesHTML.put(194, "&Acirc;");
        entidadesHTML.put(195, "&Atilde;");
        entidadesHTML.put(196, "&Auml;");
        entidadesHTML.put(197, "&Aring;");
        entidadesHTML.put(198, "&AElig;");
        entidadesHTML.put(199, "&Ccedil;");
        entidadesHTML.put(200, "&Egrave;");
        entidadesHTML.put(201, "&Eacute;");
        entidadesHTML.put(202, "&Ecirc;");
        entidadesHTML.put(203, "&Euml;");
        entidadesHTML.put(204, "&Igrave;");
        entidadesHTML.put(205, "&Iacute;");
        entidadesHTML.put(206, "&Icirc;");
        entidadesHTML.put(207, "&Iuml;");
        entidadesHTML.put(208, "&ETH;");
        entidadesHTML.put(209, "&Ntilde;");
        entidadesHTML.put(210, "&Ograve;");
        entidadesHTML.put(211, "&Oacute;");
        entidadesHTML.put(212, "&Ocirc;");
        entidadesHTML.put(213, "&Otilde;");
        entidadesHTML.put(214, "&Ouml;");
        entidadesHTML.put(215, "&times;");
        entidadesHTML.put(216, "&Oslash;");
        entidadesHTML.put(217, "&Ugrave;");
        entidadesHTML.put(218, "&Uacute;");
        entidadesHTML.put(219, "&Ucirc;");
        entidadesHTML.put(220, "&Uuml;");
        entidadesHTML.put(221, "&Yacute;");
        entidadesHTML.put(222, "&THORN;");
        entidadesHTML.put(223, "&szlig;");
        entidadesHTML.put(224, "&agrave;");
        entidadesHTML.put(225, "&aacute;");
        entidadesHTML.put(226, "&acirc;");
        entidadesHTML.put(227, "&atilde;");
        entidadesHTML.put(228, "&auml;");
        entidadesHTML.put(229, "&aring;");
        entidadesHTML.put(230, "&aelig;");
        entidadesHTML.put(231, "&ccedil;");
        entidadesHTML.put(232, "&egrave;");
        entidadesHTML.put(233, "&eacute;");
        entidadesHTML.put(234, "&ecirc;");
        entidadesHTML.put(235, "&euml;");
        entidadesHTML.put(236, "&igrave;");
        entidadesHTML.put(237, "&iacute;");
        entidadesHTML.put(238, "&icirc;");
        entidadesHTML.put(239, "&iuml;");
        entidadesHTML.put(240, "&eth;");
        entidadesHTML.put(241, "&ntilde;");
        entidadesHTML.put(242, "&ograve;");
        entidadesHTML.put(243, "&oacute;");
        entidadesHTML.put(244, "&ocirc;");
        entidadesHTML.put(245, "&otilde;");
        entidadesHTML.put(246, "&ouml;");
        entidadesHTML.put(247, "&divide;");
        entidadesHTML.put(248, "&oslash;");
        entidadesHTML.put(249, "&ugrave;");
        entidadesHTML.put(250, "&uacute;");
        entidadesHTML.put(251, "&ucirc;");
        entidadesHTML.put(252, "&uuml;");
        entidadesHTML.put(253, "&yacute;");
        entidadesHTML.put(254, "&thorn;");
        entidadesHTML.put(255, "&yuml;");
        TAG_RELACIONAMENTO = "tag=";
    }
}

