/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.laboratorio.Laboratorio;
import jalis.util.ThreadFinalizadaListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class SplashMensagem {
    private ArrayList<ThreadFinalizadaListener> listenerList = new ArrayList();
    private ThreadMostrar thread;
    private boolean isFinalizada = false;

    public void setFinalizada(boolean isFinalizada) {
        this.isFinalizada = isFinalizada;
    }

    public static SplashMensagem getInstancia(Component componentPai) {
        SplashMensagem splash = null;
        if (Laboratorio.splashAtiva == null) {
            Laboratorio.splashAtiva = splash = new SplashMensagem();
        } else {
            splash = Laboratorio.splashAtiva;
            splash.setFinalizada(false);
        }
        splash.setThreadMostrar(new ThreadMostrar(componentPai));
        splash.removerTodosThreadListener();
        if (componentPai != null && componentPai instanceof ThreadFinalizadaListener) {
            splash.addThreadListener((ThreadFinalizadaListener)((Object)componentPai));
        }
        return splash;
    }

    private void setThreadMostrar(ThreadMostrar threadMostrar) {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        this.thread = threadMostrar;
    }

    public void mostrar(String text) {
        if (this.thread != null) {
            this.fireIniciouExecucao();
            this.setText(text);
            this.thread.start();
        }
    }

    public void setText(String text) {
        if (this.thread != null) {
            this.thread.setText(text);
        }
    }

    public void apagar() {
        if (this.thread != null) {
            this.fireTerminouExecucao();
            Thread threadApagar = new Thread(){

                @Override
                public void run() {
                    SplashMensagem.this.thread.interrupt();
                }
            };
            threadApagar.start();
        }
    }

    public void addThreadListener(ThreadFinalizadaListener listener) {
        if (this.listenerList.contains(listener)) {
            return;
        }
        this.listenerList.add(listener);
    }

    public void removeThreadListener(ThreadFinalizadaListener listener) {
        this.listenerList.remove(listener);
    }

    public void removerTodosThreadListener() {
        this.listenerList.clear();
    }

    private void fireIniciouExecucao() {
        for (ThreadFinalizadaListener listener : this.listenerList) {
            listener.threadIniciada(new EventObject(this));
            if (!(listener instanceof JComponent)) continue;
            ((JComponent)((Object)listener)).paintImmediately(((JComponent)((Object)listener)).getBounds());
        }
    }

    private void fireTerminouExecucao() {
        for (ThreadFinalizadaListener listener : this.listenerList) {
            listener.threadFinalizada(new EventObject(this));
            if (!(listener instanceof JComponent)) continue;
            ((JComponent)((Object)listener)).paintImmediately(((JComponent)((Object)listener)).getBounds());
        }
    }

    static class ThreadMostrar
    extends Thread {
        private JDialog janela;
        private JLabel labelMensagem = new JLabel();
        private JLabel labelIcone = null;
        private Component componentePai;
        private Point posicao;
        private boolean textoAlterado = false;
        private boolean podeDormir = true;
        private boolean parar = false;
        private static final int WIDTH_GIF = 0;
        private static final int HEIGHT_GIF = 32;

        public ThreadMostrar(Component componentPai) {
            super("thread_mensagem");
            this.setPriority(1);
            this.labelMensagem.setHorizontalAlignment(0);
            this.janela = new JDialog(componentPai instanceof Window ? (Window)componentPai : Laboratorio.getInstancia());
            this.janela.setUndecorated(true);
            this.janela.setBackground(Color.WHITE);
            this.janela.getContentPane().setBackground(Color.WHITE);
            this.janela.add((Component)this.labelMensagem, "Center");
            if (componentPai != null) {
                this.componentePai = componentPai;
                if (!this.componentePai.isValid()) {
                    Container aux;
                    for (aux = componentPai.getParent(); aux != null && !aux.isValid(); aux = aux.getParent()) {
                    }
                    if (aux != null) {
                        this.janela.setLocationRelativeTo(aux);
                    } else {
                        this.janela.setLocationRelativeTo(Laboratorio.getInstancia());
                    }
                }
                this.janela.setLocationRelativeTo(this.componentePai);
            } else {
                this.janela.setLocationRelativeTo(Laboratorio.getInstancia());
            }
            this.posicao = this.janela.getLocation();
            this.setText("Aguarde...");
        }

        public synchronized void setText(String text) {
            FontMetrics met = this.labelMensagem.getFontMetrics(this.labelMensagem.getFont());
            int width = met.stringWidth(text);
            int height = 42;
            this.labelMensagem.setText(text);
            this.labelMensagem.setPreferredSize(new Dimension(width += 40, height));
            this.labelMensagem.setMinimumSize(new Dimension(width, height));
            this.janela.setSize(width, height);
            this.janela.pack();
            this.janela.setLocation((int)(this.posicao.getX() - (double)(width / 2)), (int)(this.posicao.getY() - (double)(height / 2)));
            this.textoAlterado = true;
        }

        @Override
        public void run() {
            if (this.janela != null) {
                this.janela.setVisible(true);
            }
            try {
                this.textoAlterado = true;
                this.labelMensagem.paintImmediately(this.labelMensagem.getBounds());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean i = false;
            try {
                while (Laboratorio.splashAtiva != null && !this.parar) {
                    if (this.textoAlterado) {
                        this.labelMensagem.invalidate();
                        this.labelMensagem.paintImmediately(this.labelMensagem.getBounds());
                        this.textoAlterado = false;
                    }
                    ThreadMostrar.sleep(10L);
                    if (!this.podeDormir) continue;
                    ThreadMostrar.sleep(1000L);
                    this.podeDormir = false;
                }
                if (this.janela != null) {
                    while (this.janela.isVisible()) {
                        this.janela.setVisible(false);
                        ThreadMostrar.sleep(10L);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public synchronized void interrupt() {
            if (this.janela != null) {
                this.parar = true;
                this.janela.setVisible(false);
            }
        }
    }
}

