/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitaCep
extends JDialog {
    private JLabel labelCEP = new JLabel("Informe o CEP para pesquisa");
    private TTextField textCEP = new TTextField(9, 9);
    private JButton buttonOk = new JButton("OK");
    private JButton buttonCancel = new JButton("Cancelar");
    private JPanel topPanel;
    private JPanel bottomPanel;
    private Component parent;
    private String response;

    public SolicitaCep(Component parent) {
        super(new JFrame(), "CEP", true);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.parent = parent;
        this.init();
    }

    public String getResponse() {
        return this.response;
    }

    private void init() {
        this.setResizable(false);
        this.defineFrame();
        this.setLocationRelativeTo(this.parent);
        this.setLocationByPlatform(false);
        this.setSize(260, 125);
        this.setPreferredSize(this.getSize());
        this.pack();
        this.setVisible(true);
    }

    private void defineFrame() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(ScreenUtil.criarBordaVazia());
        this.add((Component)p, "Center");
        this.defineTopPanel();
        this.defineButtonCancel();
        this.defineButtonOk();
        p.add((Component)this.topPanel, "Center");
        p.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOk, this.buttonCancel), "South");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.topPanel.add((Component)this.labelCEP, c);
        ++c.gridy;
        c.fill = 2;
        c.weightx = 1.0;
        this.topPanel.add((Component)this.textCEP, c);
    }

    private void defineButtonOk() {
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.textoVazio(SolicitaCep.this.textCEP)) {
                    Funcoes.mensagem(SolicitaCep.this.parent, "CEP n\u00e3o informado", 1);
                } else {
                    SolicitaCep.this.response = new String(SolicitaCep.this.textCEP.getText());
                }
                SolicitaCep.this.setVisible(false);
            }
        });
    }

    private void defineButtonCancel() {
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolicitaCep.this.setVisible(false);
            }
        });
    }

    private void defineTopPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.topPanel = new JPanel(layout);
        this.defineFieldCep();
    }

    private void defineFieldCep() {
        this.textCEP.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SolicitaCep.this.buttonOk.doClick();
                }
            }
        });
    }
}

