/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.util.ArraysUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ScreenUtil {
    public static final double ZOOM_PADRAO = 1.0;

    public static AWTEvent consumirEventoAtual() {
        try {
            return Toolkit.getDefaultToolkit().getSystemEventQueue().getNextEvent();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Point getCentralizado(Rectangle pai, Dimension filho) {
        int x = pai.x + (pai.width - filho.width) / 2;
        int y = pai.y + (pai.height - filho.height) / 2;
        return new Point(x, y);
    }

    public static void centralizar(Component comp) {
        Dimension dlgSize = comp.getSize();
        Dimension frmSize = null;
        if (comp.getParent() == null || comp.getParent().getWidth() == 0 && comp.getParent().getHeight() == 0) {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            frmSize = new Dimension(gd.getDisplayMode().getWidth(), gd.getDisplayMode().getHeight());
        } else {
            frmSize = new Dimension((int)((double)comp.getParent().getWidth() + 2.0 * comp.getParent().getLocationOnScreen().getX()), (int)((double)comp.getParent().getHeight() + 2.0 * comp.getParent().getLocationOnScreen().getY()));
        }
        int posX = (int)((frmSize.getWidth() - dlgSize.getWidth()) / 2.0);
        int posY = (int)((frmSize.getHeight() - dlgSize.getHeight()) / 2.0);
        comp.setLocation(posX, posY);
    }

    public static void maximizar(Component comp) {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension dim = kit.getScreenSize();
        Insets marg = kit.getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        marg.bottom = marg.bottom == 0 ? 25 : marg.bottom;
        comp.setBounds(marg.left, marg.top, dim.width - marg.left - marg.right, dim.height - marg.top - marg.bottom);
    }

    public static String[] getNomes(Container cont) {
        return ScreenUtil.getNomes(cont, Object.class);
    }

    public static String[] getNomes(Container cont, Class inst) {
        ArrayList<String> tmp = new ArrayList<String>();
        Component[] comp = cont.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!inst.isInstance(comp[i])) continue;
            tmp.add(comp[i].getName());
        }
        return tmp.toArray(new String[0]);
    }

    public static Component getComponenteComNome(Object[] comp, String nome) {
        for (int i = 0; i < comp.length; ++i) {
            String tmp;
            if (!(comp[i] instanceof Component) || (tmp = ((Component)comp[i]).getName()) == null || !tmp.equalsIgnoreCase(nome)) continue;
            return (Component)comp[i];
        }
        return null;
    }

    public static Component getComponenteComNome(Container cont, String nome) {
        Component[] comp = cont.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            String tmp = comp[i].getName();
            if (tmp == null || !tmp.equalsIgnoreCase(nome)) continue;
            return comp[i];
        }
        return null;
    }

    public static Dimension getAreaOcupada(Component[] comp) {
        int altura = 0;
        int largura = 0;
        for (int i = 0; i < comp.length; ++i) {
            int tmp = comp[i].getY() + comp[i].getHeight();
            if (tmp > altura) {
                altura = tmp;
            }
            if ((tmp = comp[i].getX() + comp[i].getWidth()) <= largura) continue;
            largura = tmp;
        }
        return new Dimension(largura, altura);
    }

    public static Dimension getAreaOcupada(List<Component> comps) {
        return ScreenUtil.getAreaOcupada(comps, 1.0);
    }

    public static Dimension getAreaOcupada(List<Component> comps, double zoom) {
        return ScreenUtil.getAreaOcupada(comps, zoom, false);
    }

    public static Dimension getAreaOcupada(List<Component> comps, double zoom, boolean ignorarNaoImprimir) {
        double altura = 0.0;
        double largura = 0.0;
        for (Component c : comps) {
            Rectangle bounds = c.getBounds();
            if (ignorarNaoImprimir && c instanceof ComponenteImpressao && !((ComponenteImpressao)((Object)c)).imprimir() || c instanceof ComponenteResultado && !((ComponenteResultado)((Object)c)).imprimir() || c instanceof ComponenteDigitacao && !((ComponenteDigitacao)((Object)c)).imprimir()) continue;
            double tmp = (double)(bounds.y + bounds.height) * zoom;
            if (tmp > altura) {
                altura = tmp;
            }
            if (!((tmp = (double)(bounds.x + bounds.width) * zoom) > largura)) continue;
            largura = tmp;
        }
        return new Dimension((int)largura, (int)altura);
    }

    public static void removerMargem(Container cont) {
        ScreenUtil.removerMargem(cont.getComponents());
    }

    public static void removerMargem(Component[] c) {
        int margemX = 0;
        int margemY = 0;
        for (Component comp : c) {
            if (comp.getX() > 0 && margemX > comp.getX()) {
                margemX = comp.getX();
            }
            if (comp.getY() <= 0 || margemY <= comp.getY()) continue;
            margemY = comp.getY();
        }
        for (Component comp : c) {
            comp.setBounds(comp.getX() - margemX, comp.getY() - margemY, comp.getWidth(), comp.getHeight());
        }
    }

    public static void removerMargem(List<Component> c) {
        int margemX = -1;
        int margemY = -1;
        for (Component comp : c) {
            if (comp.getX() > 0 && (margemX == -1 || margemX > comp.getX())) {
                margemX = comp.getX();
            }
            if (comp.getY() <= 0 || margemY != -1 && margemY <= comp.getY()) continue;
            margemY = comp.getY();
        }
        for (Component comp : c) {
            comp.setBounds(comp.getX() - (margemX == -1 ? 0 : margemX), comp.getY() - (margemY == -1 ? 0 : margemY), comp.getWidth(), comp.getHeight());
        }
    }

    public static void removeCampo(Container cont, String nome) {
        Component c = ScreenUtil.getComponenteComNome(cont, nome);
        while (c != null) {
            cont.remove(c);
            c = ScreenUtil.getComponenteComNome(cont, nome);
        }
    }

    public static void removeCampo(Container cont, Class tipo) {
        Component[] c = cont.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!tipo.isInstance(c[i])) continue;
            cont.remove(c[i]);
        }
    }

    public static void setMargem(Container cont, int esquerda, int superior) {
        Component[] comp = cont.getComponents();
        ScreenUtil.setMargem(comp, esquerda, superior);
    }

    public static void setMargem(Component[] c, int esquerda, int superior) {
        ScreenUtil.removerMargem(c);
        for (Component comp : c) {
            comp.setBounds(comp.getX() + esquerda, comp.getY() + superior, comp.getWidth(), comp.getHeight());
        }
    }

    public static void setMargem(List<Component> c, int esquerda, int superior) {
        ScreenUtil.removerMargem(c);
        for (Component comp : c) {
            comp.setBounds(comp.getX() + esquerda, comp.getY() + superior, comp.getWidth(), comp.getHeight());
        }
    }

    public static int indiceComponente(Container con, Component comp) {
        Component[] c = con.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != comp) continue;
            return i;
        }
        return -1;
    }

    public static float getMilimetros(float pixels) {
        return pixels * 0.35277778f;
    }

    public static float getCentimetros(float pixels) {
        return pixels * 0.035277776f;
    }

    public static float getPixelsDeMilimetros(float mm) {
        return mm * 2.8346457f;
    }

    public static float getPixelsDeCentimetros(float cm) {
        return cm * 28.346457f;
    }

    public static Rectangle getRetanguloDeSelecao(Rectangle rec) {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        if (rec != null) {
            x = rec.x - 2;
            y = rec.y - 2;
            w = rec.width + 5;
            h = rec.height + 5;
        }
        return new Rectangle(x, y, w, h);
    }

    public static Rectangle[] getCaixasDeSelecao(Rectangle rec) {
        ArrayList<Rectangle> array = new ArrayList<Rectangle>();
        if (rec != null) {
            array.add(new Rectangle(rec.x + rec.width / 2 - 2, rec.y, 5, 5));
            array.add(new Rectangle(rec.x + rec.width / 2 - 2, rec.y + rec.height - 5, 5, 5));
            array.add(new Rectangle(rec.x + rec.width - 5, rec.y + rec.height / 2 - 2, 5, 5));
            array.add(new Rectangle(rec.x, rec.y + rec.height / 2 - 2, 5, 5));
            array.add(new Rectangle(rec.x + rec.width - 5, rec.y, 5, 5));
            array.add(new Rectangle(rec.x, rec.y, 5, 5));
            array.add(new Rectangle(rec.x + rec.width - 5, rec.y + rec.height - 5, 5, 5));
            array.add(new Rectangle(rec.x, rec.y + rec.height - 5, 5, 5));
        }
        return array.toArray(new Rectangle[array.size()]);
    }

    public static boolean contemPonto(Rectangle[] rec, Point pt) {
        return ScreenUtil.indiceRetanguloContemPonto(rec, pt) > -1;
    }

    public static int indiceRetanguloContemPonto(Rectangle[] rec, Point pt) {
        if (rec != null && pt != null) {
            for (int i = 0; i < rec.length; ++i) {
                if (rec[i] == null || !rec[i].contains(pt)) continue;
                return i;
            }
        }
        return -1;
    }

    public static void pintarRetangulos(Graphics g, Rectangle[] rec) {
        if (g != null && rec != null) {
            for (int i = 0; i < rec.length; ++i) {
                g.fillRect(rec[i].x, rec[i].y, rec[i].width, rec[i].height);
            }
        }
    }

    public static void desenharRetangulos(Graphics g, Rectangle[] rec) {
        if (g != null && rec != null) {
            for (int i = 0; i < rec.length; ++i) {
                g.drawRect(rec[i].x, rec[i].y, rec[i].width, rec[i].height);
            }
        }
    }

    public static void desenharRetangulos(Graphics g, Rectangle2D.Float[] rec) {
        if (g != null && rec != null) {
            for (Rectangle2D.Float r : rec) {
                g.drawRect((int)r.x, (int)r.y, (int)r.width, (int)r.height);
            }
        }
    }

    public static Dimension getTamanhoString(String str, Font fonte) {
        FontMetrics met;
        if (str != null && fonte != null && (met = new JLabel().getFontMetrics(fonte)) != null) {
            return new Dimension(met.stringWidth(str), met.getHeight());
        }
        return new Dimension();
    }

    public static void setBorda(Component[] c, Border borda) {
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof JComponent)) continue;
            ((JComponent)c[i]).setBorder(new CompoundBorder(borda, BorderFactory.createEmptyBorder(0, 2, 0, 0)));
        }
    }

    public static ImageIcon getImagemScreen(Rectangle rec) {
        ImageIcon imagem = null;
        try {
            imagem = new ImageIcon(new Robot().createScreenCapture(rec));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ScreenUtil: 580");
        }
        return imagem;
    }

    public static void ordenarXY(Component[] c) {
        int j;
        int i;
        for (i = 0; i < c.length - 1; ++i) {
            for (j = i + 1; j < c.length; ++j) {
                if (c[j].getY() >= c[i].getY()) continue;
                ArraysUtil.trocar(c, i, j);
            }
        }
        for (i = 0; i < c.length - 1; ++i) {
            for (j = i + 1; j < c.length; ++j) {
                if (Math.abs(c[j].getY() - c[i].getY()) >= 10 || c[j].getX() >= c[i].getX()) continue;
                ArraysUtil.trocar(c, i, j);
            }
        }
    }

    public static void inserirOrdenadoXY(Component c, List<Component> list) {
        if (c != null && list != null) {
            int pos = 0;
            Rectangle rec = c.getBounds();
            for (Component comp : list) {
                Rectangle tmp = comp.getBounds();
                if (Math.abs(rec.y - tmp.y) < 10 && rec.x < tmp.x || rec.y < tmp.y) break;
                ++pos;
            }
            list.add(pos, c);
        }
    }

    public static void requisitarFoco(final Component c) {
        if (c != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (c.isFocusable() && c.isEnabled()) {
                        c.requestFocus();
                    } else {
                        c.transferFocus();
                    }
                }
            });
        }
    }

    public static void posicionaTextoTopo(JTextArea texto) {
        texto.setCaretPosition(0);
    }

    public static void posicionaTextoTopo(JTextPane texto) {
        texto.setCaretPosition(0);
    }

    public static boolean interceptaY(Rectangle a, Rectangle b) {
        boolean res = false;
        res = b.y >= a.y ? b.y <= a.y + a.height : b.y + b.height >= a.y;
        return res;
    }

    public static void addActionMap(JComponent comp, KeyStroke tecla, Object chave, Action acao) {
        comp.getInputMap(1).put(tecla, chave);
        comp.getInputMap(0).put(tecla, chave);
        comp.getInputMap(2).put(tecla, chave);
        comp.getActionMap().put(chave, acao);
    }

    public static void addDocumentListener(Document doc, final Runnable acao) {
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                acao.run();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                acao.run();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public static Color escurecerCor(Color original, int fator) {
        int r = Math.max(original.getRed() - fator, 0);
        int g = Math.max(original.getGreen() - fator, 0);
        int b = Math.max(original.getBlue() - fator, 0);
        return new Color(r, g, b);
    }

    public static Color clarearCor(Color original, int fator) {
        int r = Math.min(original.getRed() + fator, 255);
        int g = Math.min(original.getGreen() + fator, 255);
        int b = Math.min(original.getBlue() + fator, 255);
        return new Color(r, g, b);
    }

    public static void montaSaidaTextArea(final JTextArea t) {
        t.setToolTipText("Ctrl + ENTER - pr\u00f3ximo campo");
        t.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && (e.isControlDown() || t.getText().endsWith("\n\n"))) {
                    FocusManager.getCurrentManager().focusNextComponent();
                }
            }
        });
    }

    public static void habilitarDesabilitarComponentes(Container c, boolean habilitado) {
        if (c != null) {
            for (Component comp : c.getComponents()) {
                comp.setEnabled(habilitado);
            }
        }
    }

    public static Border criarBordaVazia() {
        return BorderFactory.createEmptyBorder(5, 5, 5, 5);
    }
}

