/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class NumeroLinhas
extends JComponent
implements DocumentListener,
PropertyChangeListener {
    private JTextPane text;
    private int qtdeLinhas;

    public NumeroLinhas(JTextPane text) {
        Funcoes.validarNaoNull(text, "text");
        this.text = text;
        text.getDocument().addDocumentListener(this);
        text.addPropertyChangeListener("document", this);
        this.setBackground(Color.white);
        this.setForeground(Color.blue);
        this.atualizar();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Document doc = (Document)evt.getOldValue();
        doc.removeDocumentListener(this);
        doc = (Document)evt.getNewValue();
        doc.addDocumentListener(this);
    }

    private void atualizar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int linhas = StringUtil.contaOcorrencias(NumeroLinhas.this.text.getText(), '\n') + 1;
                if (linhas != NumeroLinhas.this.qtdeLinhas) {
                    FontMetrics fm = NumeroLinhas.this.getFontMetrics(NumeroLinhas.this.text.getFont());
                    int width = fm.stringWidth(String.valueOf(linhas < 100 ? 99 : linhas)) + 5;
                    NumeroLinhas.this.setPreferredSize(new Dimension(width, ((NumeroLinhas)NumeroLinhas.this).text.getPreferredSize().height + fm.getHeight()));
                    NumeroLinhas.this.qtdeLinhas = linhas;
                    NumeroLinhas.this.revalidate();
                    NumeroLinhas.this.repaint();
                }
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        Rectangle rec = g.getClipBounds();
        Dimension size = this.getPreferredSize();
        g.setColor(this.getBackground());
        g.fillRect(rec.x, rec.y, rec.width, rec.height);
        g.setColor(this.getForeground());
        FontMetrics fm = this.getFontMetrics(this.text.getFont());
        int y = this.text.getMargin().top + fm.getHeight() - fm.getDescent();
        for (int i = 1; i <= this.qtdeLinhas; ++i) {
            String n = String.valueOf(i);
            g.drawString(n, size.width - fm.stringWidth(n) - 4, y);
            y += fm.getHeight();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.atualizar();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.atualizar();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.atualizar();
    }
}

