/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class NovoDialogoFiltro
extends JDialog
implements DisposeListener,
ActionListener,
ThreadFinalizadaListener {
    private final int LARGURA_JANELA = 530;
    private final int ALTURA_JANELA = 480;
    private final int LARGURA_COMBO_FILTRO = 120;
    private final int LARGURA_COMBO_CONDICAO = 105;
    private final int LARGURA_BOTAO_FILTRAR = 70;
    private final int LARGURA_BOTAO_MARCAR = 80;
    private final int LARGURA_BOTAO_DESMARCAR = 90;
    private final int LARGURA_BOTAO_MARCAR_TODOS = 115;
    private final int LARGURA_BOTAO_DESMARCAR_TODOS = 120;
    private final int CONDICAO_INICIE_COM = 0;
    private final int CONDICAO_TERMINE_COM = 1;
    private final int CONDICAO_CONTENHA = 2;
    private final int CONDICAO_SEJA_IGUAL = 3;
    private JPanel panelLocalizados = new JPanel(new GridBagLayout());
    private JPanel panelSelecionados = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelLocalizadosFiltro = new JPanel(new GridBagLayout());
    private JPanel panelLocalizadosDados = new JPanel(new BorderLayout());
    private JPanel panelLocalizadosLocalizar = new JPanel(new BorderLayout());
    private JPanel panelLocalizadosBotoes = new JPanel(new FlowLayout(0));
    private JPanel panelSelecionadosDados = new JPanel(new BorderLayout());
    private JPanel panelSelecionadosLocalizar = new JPanel(new BorderLayout());
    private JPanel panelSelecionadosBotoes = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesEsquerda = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesDireita = new JPanel(new FlowLayout(2));
    private JLabel labelFiltro = new JLabel("Filtro:");
    private JLabel labelQue = new JLabel(" que ");
    private JLabel labelLocalizarLocalizados = new JLabel("Localizar:");
    private JLabel labelLocalizarSelecionados = new JLabel("Localizar:");
    private JComboBox comboFiltro = new JComboBox();
    private JComboBox comboCondicao = new JComboBox<String>(new String[]{"inicie com", "termine com", "contenha", "seja igual a"});
    private JButton buttonFiltrarLocalizados = new JButton("Filtrar");
    private JButton buttonMarcarLocalizados = new JButton("Selecionar");
    private JButton buttonMarcarTodosLocalizados = new JButton("Selecionar Todos");
    private JButton buttonDesmarcarSelecionados = new JButton("Desmarcar");
    private JButton buttonDesmarcarTodosSelecionados = new JButton("Desmarcar Todos");
    private JButton buttonInverterSelecao = new JButton("Inverter Sele\u00e7\u00e3o");
    private JButton buttonOk = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private TTextField textFiltroLocalizados = new TTextField();
    private TTextField textLocalizarLocalizados = new TTextField();
    private TTextField textLocalizarSelecionados = new TTextField();
    private JScrollPane scrollLocalizados = new JScrollPane();
    private JScrollPane scrollSelecionados = new JScrollPane();
    private JTable tableLocalizados = new JTable();
    private JTable tableSelecionados = new JTable();
    private ModeloGridTable modeloLocalizados = null;
    private ModeloGridTable modeloSelecionados = null;
    private boolean ok = false;
    private String[] campos = null;
    private String[] colunas = null;
    private int[] tamanhoColunas;
    private String tabela;
    private boolean considerarComoSelect;
    private String filtroInicial;
    private int colunaOrdenacao;
    private ResultSetMetaData metadadosPesquisa;
    private boolean executandoBusca = false;

    public NovoDialogoFiltro(Window pai, String titulo, boolean isModal) {
        super(pai, titulo);
        this.setModal(isModal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.montaTela();
        ScreenUtil.centralizar(this);
    }

    public static NovoDialogoFiltro novaInstancia(Object pai, String titulo) {
        if (pai instanceof Window) {
            return new NovoDialogoFiltro((Window)pai, titulo, true);
        }
        return null;
    }

    private void montaTela() {
        this.configuraComponentes();
        this.montaPanelPrincipal();
        this.montaPanelLocalizados();
        this.montaPanelSelecionados();
        this.montaPanelBotoes();
        this.instalaListeners();
        this.setSize(new Dimension(530, 480));
        Funcoes.defineUpperCase(this.getContentPane(), ParametrosGerais.getUpperCase());
        Funcoes.montaEnter((JComponent)this.getContentPane());
    }

    private void instalaListeners() {
        this.buttonFiltrarLocalizados.addActionListener(this);
        this.buttonMarcarLocalizados.addActionListener(this);
        this.buttonMarcarTodosLocalizados.addActionListener(this);
        this.buttonDesmarcarSelecionados.addActionListener(this);
        this.buttonDesmarcarTodosSelecionados.addActionListener(this);
        this.buttonInverterSelecao.addActionListener(this);
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.textLocalizarLocalizados.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NovoDialogoFiltro.this.localizar(NovoDialogoFiltro.this.tableLocalizados, NovoDialogoFiltro.this.textLocalizarLocalizados.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NovoDialogoFiltro.this.localizar(NovoDialogoFiltro.this.tableLocalizados, NovoDialogoFiltro.this.textLocalizarLocalizados.getText());
            }

            @Override
            @Deprecated
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.textLocalizarSelecionados.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NovoDialogoFiltro.this.localizar(NovoDialogoFiltro.this.tableSelecionados, NovoDialogoFiltro.this.textLocalizarSelecionados.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NovoDialogoFiltro.this.localizar(NovoDialogoFiltro.this.tableSelecionados, NovoDialogoFiltro.this.textLocalizarSelecionados.getText());
            }

            @Override
            @Deprecated
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.tableLocalizados.addKeyListener(new KeyListener(){

            @Override
            @Deprecated
            public void keyTyped(KeyEvent e) {
            }

            @Override
            @Deprecated
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    NovoDialogoFiltro.this.marcarLocalizado();
                }
            }
        });
        this.tableSelecionados.addKeyListener(new KeyListener(){

            @Override
            @Deprecated
            public void keyTyped(KeyEvent e) {
            }

            @Override
            @Deprecated
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    NovoDialogoFiltro.this.desmarcarSelecionado();
                }
            }
        });
        this.comboFiltro.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String coluna = e.getItem().toString();
                    NovoDialogoFiltro.this.atualizaCombo(coluna);
                }
            }
        });
    }

    private void atualizaCombo(String coluna) {
        if (this.metadadosPesquisa != null && this.modeloSelecionados != null) {
            int pos = this.modeloSelecionados.findColumn(coluna) + 1;
            int tipo = 0;
            try {
                tipo = this.metadadosPesquisa.getColumnType(pos);
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar tipo da coluna.\n" + e1.getMessage(), e1.getStackTrace());
            }
            this.textFiltroLocalizados.clear();
            if (tipo == -5 || tipo == 4 || tipo == 5 || tipo == -6) {
                this.textFiltroLocalizados.setDocument(12, 1);
                this.textFiltroLocalizados.setMaskDecimal("############");
            } else if (tipo == 3 || tipo == 8 || tipo == 6 || tipo == 2 || tipo == 7) {
                this.textFiltroLocalizados.setDocument(17, 2);
                this.textFiltroLocalizados.setMaskDecimal("############.####");
            } else if (tipo == 91 || tipo == 93) {
                this.textFiltroLocalizados.setDocument(10, 4);
                this.textFiltroLocalizados.setMaskDecimal("##/##/####");
            } else if (tipo == 92) {
                this.textFiltroLocalizados.setDocument(5, 6);
                this.textFiltroLocalizados.setMaskDecimal("##:##");
            } else {
                this.textFiltroLocalizados.setDocument(40, 3);
                this.textFiltroLocalizados.setMaskDecimal("");
            }
        }
    }

    private void localizar(JTable tabela, String texto) {
        ModeloGridTable modelo = (ModeloGridTable)tabela.getModel();
        if (modelo != null && texto != null) {
            texto = texto.toUpperCase();
            int coluna = modelo.getColunaOrdenacao();
            if (coluna > -1) {
                for (int i = 0; i < modelo.getRowCount(); ++i) {
                    if (modelo.getValueAt(i, coluna) == null) continue;
                    String valor = modelo.getValueAt(i, coluna).toString().toUpperCase();
                    if (valor != null) {
                        valor = StringUtil.removerAcentos(valor);
                    }
                    if (!valor.startsWith(StringUtil.removerAcentos(texto))) continue;
                    tabela.setRowSelectionInterval(i, i);
                    tabela.scrollRectToVisible(tabela.getCellRect(i, 0, false));
                    break;
                }
            }
        }
    }

    private void configuraComponentes() {
        this.comboFiltro.setPreferredSize(new Dimension(120, 20));
        this.comboFiltro.setMinimumSize(new Dimension(120, 20));
        this.comboCondicao.setPreferredSize(new Dimension(105, 20));
        this.comboCondicao.setMinimumSize(new Dimension(105, 20));
        this.textFiltroLocalizados.setPreferredSize(new Dimension(20, 20));
        this.textFiltroLocalizados.setMinimumSize(new Dimension(20, 20));
        this.textLocalizarLocalizados.setPreferredSize(new Dimension(20, 20));
        this.textLocalizarLocalizados.setMinimumSize(new Dimension(20, 20));
        this.buttonFiltrarLocalizados.setMnemonic('r');
        this.buttonFiltrarLocalizados.setPreferredSize(new Dimension(70, 20));
        this.buttonFiltrarLocalizados.setMinimumSize(new Dimension(70, 20));
        this.buttonFiltrarLocalizados.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMarcarLocalizados.setMnemonic('S');
        this.buttonMarcarLocalizados.setPreferredSize(new Dimension(80, 20));
        this.buttonMarcarLocalizados.setMinimumSize(new Dimension(80, 20));
        this.buttonMarcarLocalizados.setMargin(new Insets(1, 1, 1, 1));
        this.buttonDesmarcarSelecionados.setMnemonic('D');
        this.buttonDesmarcarSelecionados.setPreferredSize(new Dimension(90, 20));
        this.buttonDesmarcarSelecionados.setMinimumSize(new Dimension(90, 20));
        this.buttonDesmarcarSelecionados.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMarcarTodosLocalizados.setMnemonic('T');
        this.buttonMarcarTodosLocalizados.setPreferredSize(new Dimension(115, 20));
        this.buttonMarcarTodosLocalizados.setMinimumSize(new Dimension(115, 20));
        this.buttonMarcarTodosLocalizados.setMargin(new Insets(1, 1, 1, 1));
        this.buttonDesmarcarTodosSelecionados.setMnemonic('e');
        this.buttonDesmarcarTodosSelecionados.setPreferredSize(new Dimension(120, 20));
        this.buttonDesmarcarTodosSelecionados.setMinimumSize(new Dimension(120, 20));
        this.buttonDesmarcarTodosSelecionados.setMargin(new Insets(1, 1, 1, 1));
        this.labelFiltro.setDisplayedMnemonic('F');
        this.labelFiltro.setLabelFor(this.comboFiltro);
        this.labelLocalizarLocalizados.setDisplayedMnemonic('L');
        this.labelLocalizarLocalizados.setLabelFor(this.textLocalizarLocalizados);
        this.labelLocalizarSelecionados.setDisplayedMnemonic('a');
        this.labelLocalizarSelecionados.setLabelFor(this.textLocalizarSelecionados);
        this.buttonInverterSelecao.setMnemonic('I');
        this.buttonOk.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
    }

    private void montaPanelPrincipal() {
        JPanel panelPrincipal = (JPanel)this.getContentPane();
        panelPrincipal.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 0.55;
        panelPrincipal.add((Component)this.panelLocalizados, c);
        ++c.gridy;
        c.weighty = 0.45;
        panelPrincipal.add((Component)this.panelSelecionados, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        panelPrincipal.add((Component)this.panelBotoes, c);
    }

    private void montaPanelLocalizados() {
        this.panelLocalizados.setBorder(new TitledBorder("Localizados"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        this.panelLocalizados.add((Component)this.panelLocalizadosFiltro, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.panelLocalizados.add((Component)this.panelLocalizadosDados, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.panelLocalizados.add((Component)this.panelLocalizadosLocalizar, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelLocalizados.add((Component)this.panelLocalizadosBotoes, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelLocalizadosFiltro.add((Component)this.labelFiltro, c);
        ++c.gridx;
        this.panelLocalizadosFiltro.add((Component)this.comboFiltro, c);
        ++c.gridx;
        this.panelLocalizadosFiltro.add((Component)this.labelQue, c);
        ++c.gridx;
        this.panelLocalizadosFiltro.add((Component)this.comboCondicao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelLocalizadosFiltro.add((Component)this.textFiltroLocalizados, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelLocalizadosFiltro.add((Component)this.buttonFiltrarLocalizados, c);
        this.scrollLocalizados.setViewportView(this.tableLocalizados);
        this.panelLocalizadosDados.add((Component)this.scrollLocalizados, "Center");
        this.scrollLocalizados.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.panelLocalizadosLocalizar.add((Component)this.labelLocalizarLocalizados, "West");
        this.panelLocalizadosLocalizar.add((Component)this.textLocalizarLocalizados, "Center");
        this.panelLocalizadosLocalizar.add((Component)this.buttonMarcarLocalizados, "East");
        this.panelLocalizadosBotoes.add(this.buttonMarcarTodosLocalizados);
    }

    private void montaPanelSelecionados() {
        this.panelSelecionados.setBorder(new TitledBorder("Selecionados"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        this.panelSelecionados.add((Component)this.panelSelecionadosDados, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.panelSelecionados.add((Component)this.panelSelecionadosLocalizar, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelSelecionados.add((Component)this.panelSelecionadosBotoes, c);
        this.scrollSelecionados.setViewportView(this.tableSelecionados);
        this.panelSelecionadosDados.add((Component)this.scrollSelecionados, "Center");
        this.scrollSelecionados.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.panelSelecionadosLocalizar.add((Component)this.labelLocalizarSelecionados, "West");
        this.panelSelecionadosLocalizar.add((Component)this.textLocalizarSelecionados, "Center");
        this.panelSelecionadosLocalizar.add((Component)this.buttonDesmarcarSelecionados, "East");
        this.panelSelecionadosBotoes.add(this.buttonDesmarcarTodosSelecionados);
    }

    private void montaPanelBotoes() {
        this.panelBotoesEsquerda.add(this.buttonInverterSelecao);
        this.panelBotoesDireita.add(this.buttonOk);
        this.panelBotoesDireita.add(this.buttonCancelar);
        this.panelBotoes.add((Component)this.panelBotoesEsquerda, "West");
        this.panelBotoes.add((Component)this.panelBotoesDireita, "East");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFiltrarLocalizados) {
            this.filtrar();
        } else if (e.getSource() == this.buttonMarcarLocalizados) {
            this.marcarLocalizado();
        } else if (e.getSource() == this.buttonMarcarTodosLocalizados) {
            this.marcarTodosLocalizados();
        } else if (e.getSource() == this.buttonDesmarcarSelecionados) {
            this.desmarcarSelecionado();
        } else if (e.getSource() == this.buttonDesmarcarTodosSelecionados) {
            this.desmarcarTodosSelecionados();
        } else if (e.getSource() == this.buttonInverterSelecao) {
            this.inverterSelecao();
        } else if (e.getSource() == this.buttonOk) {
            this.acaoOk();
        } else if (e.getSource() == this.buttonCancelar) {
            this.acaoCancelar();
        }
    }

    private void acaoCancelar() {
        this.ok = false;
        this.setVisible(false);
    }

    private void acaoOk() {
        this.ok = true;
        this.setVisible(false);
    }

    private void inverterSelecao() {
        Item item;
        int i;
        ArrayList<Item> localizados = new ArrayList<Item>();
        for (i = 0; i < this.modeloLocalizados.getRowCount(); ++i) {
            localizados.add((Item)this.modeloLocalizados.getValueAt(i, this.modeloLocalizados.getColumnCount() - 1));
        }
        this.modeloLocalizados.clear();
        for (i = 0; i < this.modeloSelecionados.getRowCount(); ++i) {
            item = (Item)this.modeloSelecionados.getValueAt(i, this.modeloSelecionados.getColumnCount() - 1);
            item.setSelecionado(false);
            if (!item.isValido()) continue;
            this.modeloLocalizados.addLine(ArraysUtil.concatenar(item.getCampos(), new Object[]{false, item}));
        }
        this.modeloSelecionados.clear();
        for (i = 0; i < localizados.size(); ++i) {
            item = (Item)localizados.get(i);
            item.setValido(true);
            item.setSelecionado(true);
            this.modeloSelecionados.addLine(ArraysUtil.concatenar(item.getCampos(), new Object[]{true, item}));
        }
        this.modeloLocalizados.ordenarColunaSemTrocarSentido(this.modeloLocalizados.getColunaOrdenacao());
        this.modeloSelecionados.ordenarColunaSemTrocarSentido(this.modeloSelecionados.getColunaOrdenacao());
    }

    private void desmarcarTodosSelecionados() {
        int qtde = this.modeloSelecionados.getRowCount();
        for (int i = 0; i < qtde; ++i) {
            Item item = (Item)this.modeloSelecionados.getValueAt(i, this.modeloSelecionados.getColumnCount() - 1);
            item.setSelecionado(false);
            if (!item.isValido()) continue;
            this.modeloLocalizados.addLine(ArraysUtil.concatenar(item.getCampos(), new Object[]{false, item}));
        }
        this.modeloSelecionados.clear();
        this.modeloLocalizados.ordenarColunaSemTrocarSentido(this.modeloLocalizados.getColunaOrdenacao());
    }

    private void desmarcarSelecionado() {
        int row = this.tableSelecionados.getSelectedRow();
        if (row > -1) {
            this.desmarcarSelecionado(row, true);
        }
    }

    private void desmarcarSelecionado(int row, boolean isRemover) {
        if (row > -1) {
            Item aux = (Item)this.modeloSelecionados.getValueAt(row, this.modeloSelecionados.getColumnCount() - 1);
            if (aux != null) {
                aux.setSelecionado(false);
            }
            if (aux != null && aux.isValido()) {
                this.modeloLocalizados.addLine(ArraysUtil.concatenar(aux.campos, new Object[]{false, aux}));
            }
            if (isRemover) {
                this.modeloSelecionados.removeLine(row);
                if (this.tableSelecionados.getRowCount() > row) {
                    this.tableSelecionados.getSelectionModel().setSelectionInterval(row, row);
                } else if (this.tableSelecionados.getRowCount() > 0) {
                    this.tableSelecionados.getSelectionModel().setSelectionInterval(this.tableSelecionados.getRowCount() - 1, this.tableSelecionados.getRowCount() - 1);
                }
            }
            this.modeloLocalizados.ordenarColunaSemTrocarSentido(this.modeloLocalizados.getColunaOrdenacao());
        }
    }

    private void marcarTodosLocalizados() {
        int qtde = this.modeloLocalizados.getRowCount();
        for (int i = 0; i < qtde; ++i) {
            Item item = (Item)this.modeloLocalizados.getValueAt(i, this.modeloLocalizados.getColumnCount() - 1);
            item.setSelecionado(true);
            item.setValido(true);
            this.modeloSelecionados.addLine(ArraysUtil.concatenar(item.getCampos(), new Object[]{true, item}));
        }
        this.modeloLocalizados.clear();
    }

    private void marcarLocalizado() {
        int row = this.tableLocalizados.getSelectedRow();
        if (row > -1) {
            this.marcarLocalizado(row, true);
        }
    }

    private void marcarLocalizado(int row, boolean isRemover) {
        if (row > -1) {
            Item aux = (Item)this.modeloLocalizados.getValueAt(row, this.modeloLocalizados.getColumnCount() - 1);
            if (aux != null) {
                aux.setSelecionado(true);
            }
            if (aux != null) {
                aux.setValido(true);
                this.modeloSelecionados.addLine(ArraysUtil.concatenar(aux.campos, new Object[]{true, aux}));
            }
            if (isRemover) {
                this.modeloLocalizados.removeLine(row);
                if (this.tableLocalizados.getRowCount() > row) {
                    this.tableLocalizados.getSelectionModel().setSelectionInterval(row, row);
                } else if (this.tableLocalizados.getRowCount() > 0) {
                    this.tableLocalizados.getSelectionModel().setSelectionInterval(this.tableLocalizados.getRowCount() - 1, this.tableLocalizados.getRowCount() - 1);
                }
            }
            this.modeloSelecionados.ordenarColunaSemTrocarSentido(this.modeloSelecionados.getColunaOrdenacao());
        }
    }

    private void filtrar() {
        String filtro;
        String pesquisa = "";
        String valor = this.textFiltroLocalizados.getText();
        String string = filtro = this.filtroInicial == null ? null : this.filtroInicial.toString();
        if (!Funcoes.textoVazio(valor)) {
            filtro = filtro != null && !Funcoes.textoVazio(filtro) ? filtro + " and " : "";
            int tipo = -1;
            try {
                tipo = this.metadadosPesquisa.getColumnType(this.comboFiltro.getSelectedIndex() + 1);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar metadados.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            filtro = tipo == 12 ? filtro + "to_ascii(" + this.campos[this.comboFiltro.getSelectedIndex()] + ")" : filtro + this.campos[this.comboFiltro.getSelectedIndex()];
            int aux = this.comboCondicao.getSelectedIndex();
            String esq = null;
            String dir = null;
            if (tipo == 4 || tipo == 6) {
                switch (aux) {
                    case 0: {
                        esq = " >= ";
                        break;
                    }
                    case 1: {
                        esq = " <= ";
                        break;
                    }
                    case 2: {
                        esq = " = ";
                        break;
                    }
                    case 3: {
                        esq = " = ";
                    }
                }
                pesquisa = esq + valor;
            } else if (tipo == 12) {
                switch (aux) {
                    case 0: {
                        esq = " ilike upper(to_ascii('";
                        dir = "%')) ";
                        break;
                    }
                    case 1: {
                        esq = " ilike upper(to_ascii('%";
                        dir = "')) ";
                        break;
                    }
                    case 2: {
                        esq = " ilike upper(to_ascii('%";
                        dir = "%')) ";
                        break;
                    }
                    case 3: {
                        esq = " ilike upper(to_ascii('";
                        dir = "')) ";
                    }
                }
                pesquisa = esq + valor + dir;
            } else if (tipo == 91) {
                switch (aux) {
                    case 0: {
                        esq = " >= '";
                        dir = "' ";
                        break;
                    }
                    case 1: {
                        esq = " <= '";
                        dir = "' ";
                        break;
                    }
                    default: {
                        esq = " = '";
                        dir = "' ";
                    }
                }
                pesquisa = esq + Funcoes.formataData("yyyy-MM-dd", valor) + dir;
            }
            filtro = filtro + pesquisa;
        }
        SplashMensagem telaEspera = SplashMensagem.getInstancia(this);
        telaEspera.mostrar("Aguarde...");
        this.buscar(this.tabela, this.considerarComoSelect, filtro, this.colunaOrdenacao, this.campos, false, false);
        telaEspera.apagar();
    }

    private void controlaCampos() {
        boolean enabled = !this.executandoBusca;
        this.comboFiltro.setEnabled(enabled);
        this.comboCondicao.setEnabled(enabled);
        this.textFiltroLocalizados.setEnabled(enabled);
        this.buttonFiltrarLocalizados.setEnabled(enabled);
        this.tableLocalizados.setEnabled(enabled);
        this.textLocalizarLocalizados.setEnabled(enabled);
        this.buttonMarcarLocalizados.setEnabled(enabled);
        this.buttonMarcarTodosLocalizados.setEnabled(enabled);
        this.tableSelecionados.setEnabled(enabled);
        this.textLocalizarSelecionados.setEnabled(enabled);
        this.buttonDesmarcarSelecionados.setEnabled(enabled);
        this.buttonDesmarcarTodosSelecionados.setEnabled(enabled);
        this.buttonInverterSelecao.setEnabled(enabled);
        this.buttonOk.setEnabled(enabled);
        this.buttonCancelar.setEnabled(enabled);
    }

    public boolean ok() {
        return this.ok;
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro) {
        this.setDados(null, tabela, campos, colunas, tamanhoColunas, filtro, false, 0, true);
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, int colunaOrdenacao) {
        this.setDados(null, tabela, campos, colunas, tamanhoColunas, filtro, false, colunaOrdenacao, true);
    }

    public void setDados(Object[] selecionados, String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro) {
        this.setDados(selecionados, tabela, campos, colunas, tamanhoColunas, filtro, false, 0, true);
    }

    public void setDados(Object[] selecionados, String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, int colunaOrdenacao) {
        this.setDados(selecionados, tabela, campos, colunas, tamanhoColunas, filtro, false, colunaOrdenacao, true);
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, boolean considerarComoSelect) {
        this.setDados(null, tabela, campos, colunas, tamanhoColunas, filtro, considerarComoSelect, 0, true);
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, boolean considerarComoSelect, int colunaOrdenacao) {
        this.setDados(null, tabela, campos, colunas, tamanhoColunas, filtro, considerarComoSelect, colunaOrdenacao, true);
    }

    public void setDados(Object[] selecionados, String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, boolean considerarComoSelect, int colunaOrdenacao, boolean executarAoAbrir) {
        if (tabela != null && campos != null && colunas != null && tamanhoColunas != null && campos.length == colunas.length && campos.length == tamanhoColunas.length) {
            this.comboFiltro.removeAllItems();
            for (String s : colunas) {
                this.comboFiltro.addItem(s);
            }
            this.tamanhoColunas = this.getTamanhoColunas(tamanhoColunas, colunas);
            this.colunas = ArraysUtil.concatenar(colunas, new String[]{" "});
            this.campos = ArraysUtil.concatenar(campos, new String[]{" "});
            this.tabela = tabela;
            this.considerarComoSelect = considerarComoSelect;
            this.filtroInicial = filtro;
            this.colunaOrdenacao = colunaOrdenacao;
            if (executarAoAbrir) {
                this.buscar(tabela, considerarComoSelect, filtro, colunaOrdenacao, campos, false, true);
            } else {
                this.buscar(tabela, considerarComoSelect, filtro, colunaOrdenacao, campos, true, true);
            }
            if (selecionados != null && selecionados.length > 0) {
                this.marcarSelecionados(selecionados);
            }
            if (colunas != null && colunas.length > 0) {
                this.comboFiltro.setSelectedItem(colunas[colunaOrdenacao - 1]);
                this.atualizaCombo(colunas[colunaOrdenacao - 1]);
            }
        }
    }

    private void marcarSelecionados(Object[] selecionados) {
        if (selecionados != null && this.modeloSelecionados != null) {
            for (int i = 0; i < selecionados.length; ++i) {
                int k;
                Object[] aux = (Object[])selecionados[i];
                Item item = new Item(aux);
                boolean encontrado = false;
                Item itemEncontrado = null;
                for (k = 0; k < this.modeloLocalizados.getRowCount(); ++k) {
                    itemEncontrado = (Item)this.modeloLocalizados.getValueAt(k, this.modeloLocalizados.getColumnCount() - 1);
                    if (!item.equals(itemEncontrado)) continue;
                    encontrado = true;
                    break;
                }
                if (encontrado) {
                    itemEncontrado.setValido(true);
                    itemEncontrado.setSelecionado(true);
                    this.modeloLocalizados.removeLine(k);
                    this.modeloSelecionados.addLine(ArraysUtil.concatenar(itemEncontrado.getCampos(), new Object[]{itemEncontrado.isSelecionado(), itemEncontrado}));
                    continue;
                }
                item.setValido(false);
                item.setSelecionado(true);
                this.modeloSelecionados.addLine(ArraysUtil.concatenar(aux, new Object[]{true, item}));
            }
        }
    }

    private void buscar(String tabela, boolean considerarComoSelect, String filtro, int colunaOrdenacao, String[] campos, boolean pegarMetadados, boolean configurandoBusca) {
        StringBuilder buf = new StringBuilder();
        if (!considerarComoSelect) {
            buf.append("select ");
            for (int i = 0; i < campos.length && !Funcoes.textoVazio(campos[i].trim()); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(campos[i]);
            }
            buf.append(" from ");
            buf.append(tabela);
        } else {
            buf.append(tabela);
        }
        if (!pegarMetadados && !Funcoes.textoVazio(filtro)) {
            buf.append(" where ");
            buf.append(filtro);
        }
        if (pegarMetadados) {
            buf.append(" limit 0 ");
        }
        try {
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            this.metadadosPesquisa = rs.getMetaData();
            ArrayList<Object[]> dados = this.carregarDadosResultSet(rs, this.colunas.length - 1);
            this.carregarDadosTabela(colunaOrdenacao, dados, configurandoBusca);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da pesquisa.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private int[] getTamanhoColunas(int[] tamanhoColunas, String[] colunas) {
        if (this.tableLocalizados != null) {
            for (int i = 0; i < colunas.length; ++i) {
                if (tamanhoColunas[i] <= 0) continue;
                int aux = this.tableLocalizados.getFontMetrics(this.tableLocalizados.getTableHeader().getFont()).stringWidth(colunas[i]) + 20;
                tamanhoColunas[i] = tamanhoColunas[i] > aux ? tamanhoColunas[i] : aux;
            }
            tamanhoColunas = ArraysUtil.concatenar(tamanhoColunas, new int[]{20, -1});
            return tamanhoColunas;
        }
        return null;
    }

    private ArrayList<Object[]> carregarDadosResultSet(ResultSet rs, int qtdeColunas) throws SQLException {
        if (rs != null) {
            ArrayList<Object[]> lista = new ArrayList<Object[]>();
            while (rs.next()) {
                Object[] aux = new Object[qtdeColunas];
                for (int i = 0; i < qtdeColunas; ++i) {
                    aux[i] = rs.getObject(i + 1);
                }
                lista.add(aux);
            }
            if (lista.size() == 0) {
                return null;
            }
            return lista;
        }
        return null;
    }

    private void carregarDadosTabela(int colunaOrdernacao, ArrayList<Object[]> dados, boolean configurandoBusca) {
        if (this.colunas != null) {
            int i;
            this.modeloLocalizados = this.criarModelo(this.colunas, this.tableLocalizados);
            this.tableLocalizados.setModel(this.modeloLocalizados);
            this.modeloLocalizados.setColumnSize(this.tamanhoColunas, this.tableLocalizados);
            this.tableLocalizados.getTableHeader().addMouseListener(this.modeloLocalizados);
            this.tableLocalizados.removeColumn(this.tableLocalizados.getColumn("Objeto"));
            this.tableLocalizados.setSelectionMode(0);
            if (configurandoBusca) {
                this.modeloSelecionados = this.criarModelo(this.colunas, this.tableSelecionados);
                this.tableSelecionados.setModel(this.modeloSelecionados);
                this.modeloSelecionados.setColumnSize(this.tamanhoColunas, this.tableSelecionados);
                this.tableSelecionados.getTableHeader().addMouseListener(this.modeloSelecionados);
                this.tableSelecionados.removeColumn(this.tableSelecionados.getColumn("Objeto"));
                this.tableSelecionados.setSelectionMode(0);
                this.modeloSelecionados.ordenarColunaSemTrocarSentido(colunaOrdernacao - 1);
            }
            for (i = 0; i < this.modeloSelecionados.getRowCount(); ++i) {
                ((Item)this.modeloSelecionados.getValueAt(i, this.modeloSelecionados.getColumnCount() - 1)).setValido(false);
            }
            if (dados != null) {
                for (i = 0; i < dados.size(); ++i) {
                    Object[] aux = dados.get(i);
                    Item item = new Item(aux);
                    boolean encontrado = false;
                    Item itemEncontrado = null;
                    for (int j = 0; j < this.modeloSelecionados.getRowCount(); ++j) {
                        itemEncontrado = (Item)this.modeloSelecionados.getValueAt(j, this.modeloSelecionados.getColumnCount() - 1);
                        if (!item.equals(itemEncontrado)) continue;
                        encontrado = true;
                        break;
                    }
                    if (encontrado) {
                        itemEncontrado.setValido(true);
                        continue;
                    }
                    this.modeloLocalizados.addLine(ArraysUtil.concatenar(aux, new Object[]{item.isSelecionado(), item}));
                }
            }
            this.modeloLocalizados.ordenarColunaSemTrocarSentido(colunaOrdernacao - 1);
        }
    }

    private ModeloGridTable criarModelo(String[] colunas, final JTable tabela) {
        colunas = ArraysUtil.concatenar(colunas, new String[]{"Objeto"});
        final ModeloGridTable modelo = new ModeloGridTable(colunas){

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == this.getColumnCount() - 2;
            }

            public Class getColumnClass(int c) {
                if (c == this.getColumnCount() - 2) {
                    return Boolean.class;
                }
                return super.getColumnClass(c);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (tabela != null) {
                        tabela.removeColumn(tabela.getColumn("Objeto"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        modelo.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0 && e.getColumn() == modelo.getColumnCount() - 2) {
                    if (tabela == NovoDialogoFiltro.this.tableLocalizados) {
                        NovoDialogoFiltro.this.marcarLocalizado(e.getFirstRow(), true);
                    } else {
                        NovoDialogoFiltro.this.desmarcarSelecionado(e.getFirstRow(), true);
                    }
                }
            }
        });
        return modelo;
    }

    public Object[] getSelecionados() {
        if (this.modeloSelecionados != null) {
            int qtde = this.modeloSelecionados.getRowCount();
            Object[] retorno = new Object[qtde];
            for (int i = 0; i < qtde; ++i) {
                Object[] aux = new Object[this.modeloSelecionados.getColumnCount() - 2];
                for (int j = 0; j < this.modeloSelecionados.getColumnCount() - 2; ++j) {
                    aux[j] = this.modeloSelecionados.getValueAt(i, j);
                }
                retorno[i] = aux;
            }
            return retorno;
        }
        return null;
    }

    public int getQtdeRegistros() {
        if (this.modeloSelecionados != null) {
            return this.modeloSelecionados.getRowCount();
        }
        return 0;
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.executandoBusca = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.executandoBusca = false;
        this.controlaCampos();
    }

    class Item {
        private Object[] campos = null;
        private boolean isSelecionado = false;
        private boolean isValido = false;

        public Item(Object[] dados) {
            this.campos = dados;
        }

        public boolean equals(Object o) {
            if (o instanceof Item) {
                Item aux = (Item)o;
                if (aux.campos.length == this.campos.length) {
                    for (int i = 0; i < aux.campos.length; ++i) {
                        if (aux.campos[i] == null || this.campos[i] == null || aux.campos[i].toString().equalsIgnoreCase(this.campos[i].toString())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public void setValido(boolean isValido) {
            this.isValido = isValido;
        }

        public boolean isValido() {
            return this.isValido;
        }

        public void setCampos(Object[] campos) {
            this.campos = campos;
        }

        public Object[] getCampos() {
            if (this.campos != null) {
                Object[] aux = new Object[this.campos.length];
                for (int i = 0; i < this.campos.length; ++i) {
                    aux[i] = this.campos[i];
                }
                return aux;
            }
            return null;
        }

        public void setSelecionado(boolean isSelecionado) {
            this.isSelecionado = isSelecionado;
        }

        public boolean isSelecionado() {
            return this.isSelecionado;
        }
    }
}

