/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.Funcoes;
import jalis.util.ListenerMostraCalendario;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class MostraCalendario
extends JPanel {
    private JPanel principal = new JPanel(new BorderLayout()){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g.drawLine(5, 47, this.getSize().width - 5, 47);
        }
    };
    private JPanel panelTopo = new JPanel(new BorderLayout());
    private JPanel panelMes = new JPanel(new FlowLayout());
    private JPanel panelAnterior = new JPanel(new FlowLayout(2));
    private JPanel panelProximo = new JPanel(new FlowLayout(2));
    private JLabel labelMesAno = new JLabel();
    private JLabel labelProximo = new JLabel("\u25ba");
    private JLabel labelAnterior = new JLabel("\u25c4");
    private JPanel dias = new JPanel(new GridLayout(0, 7, 2, 2));
    private Color corSelecionado = UIManager.getColor("Table.selectionBackground");
    private Color corDiaSelecionado = new Color(82, 145, 255);
    private JTextField campoDestino;
    private JPanel panelHoje = new JPanel(new FlowLayout());
    private String dataInicial = "";
    private String dataSelecionada = "";
    private int diaInicial = 0;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    protected SimpleDateFormat monthFormat = new SimpleDateFormat("MMMM yyyy");
    protected Calendar calendar;
    private boolean apresentarHora = false;
    private JLabel[] lDias = new JLabel[42];
    KeyListener[] listeners = null;
    private ArrayList<ListenerMostraCalendario> listener = new ArrayList();
    int pos = 0;

    public MostraCalendario() {
    }

    public MostraCalendario(JTextField owner, String dataInicial, JPopupMenu menu) {
        this.montaCalendario(owner, dataInicial, menu, false);
    }

    public void montaCalendario(JTextField owner, String dataInicial, JPopupMenu menu, boolean apresentarHora) {
        try {
            if (owner != null) {
                this.campoDestino = owner;
                this.campoDestino.setName("campoDestino");
            }
            this.apresentarHora = apresentarHora;
            this.dataInicial = dataInicial.trim().length() == 0 ? this.dateFormat.format(new Date()) : dataInicial;
            this.jbInit();
            this.setDate(dataInicial);
            for (int i = 0; i < this.lDias.length; ++i) {
                if (Funcoes.textoVazio(this.lDias[i].getText()) || Integer.parseInt(this.lDias[i].getText()) != this.diaInicial) continue;
                this.pos = i;
                this.lDias[this.pos].setBackground(this.corSelecionado);
                this.lDias[this.pos].setOpaque(true);
                break;
            }
            ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(27, 0, true), "FechaCalendario", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MostraCalendario.this.setVisible(false);
                    MostraCalendario.this.grabFocus();
                }
            });
            ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(39, 0, true), "Direita", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ++MostraCalendario.this.pos;
                    if (MostraCalendario.this.pos >= 0 && MostraCalendario.this.pos < MostraCalendario.this.lDias.length && !Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText())) {
                        MostraCalendario.this.limpaLabels();
                        MostraCalendario.this.lDias[MostraCalendario.this.pos].setBackground(MostraCalendario.this.corSelecionado);
                        MostraCalendario.this.lDias[MostraCalendario.this.pos].setOpaque(true);
                    } else {
                        MostraCalendario.this.proximo();
                        MostraCalendario.this.pos = 0;
                        while (MostraCalendario.this.pos < MostraCalendario.this.lDias.length) {
                            if (MostraCalendario.this.lDias[MostraCalendario.this.pos] != null && !Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText())) {
                                MostraCalendario.this.atualiza();
                                break;
                            }
                            ++MostraCalendario.this.pos;
                        }
                    }
                }
            });
            ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(37, 0, true), "Esquerda", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    --MostraCalendario.this.pos;
                    if (MostraCalendario.this.pos >= 0 && MostraCalendario.this.pos < MostraCalendario.this.lDias.length && !Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText())) {
                        MostraCalendario.this.limpaLabels();
                        MostraCalendario.this.lDias[MostraCalendario.this.pos].setBackground(MostraCalendario.this.corSelecionado);
                        MostraCalendario.this.lDias[MostraCalendario.this.pos].setOpaque(true);
                    } else {
                        MostraCalendario.this.anterior();
                        MostraCalendario.this.pos = MostraCalendario.this.lDias.length - 1;
                        while (MostraCalendario.this.pos >= 0) {
                            if (MostraCalendario.this.lDias[MostraCalendario.this.pos] != null && !Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText())) {
                                MostraCalendario.this.atualiza();
                                break;
                            }
                            --MostraCalendario.this.pos;
                        }
                    }
                }
            });
            ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(38, 0, true), "Acima", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int posAnt = MostraCalendario.this.pos;
                    MostraCalendario.this.pos -= 7;
                    if (MostraCalendario.this.pos >= 0 && MostraCalendario.this.pos < MostraCalendario.this.lDias.length && !Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText())) {
                        MostraCalendario.this.limpaLabels();
                        MostraCalendario.this.lDias[MostraCalendario.this.pos].setBackground(MostraCalendario.this.corSelecionado);
                        MostraCalendario.this.lDias[MostraCalendario.this.pos].setOpaque(true);
                    } else {
                        MostraCalendario.this.anterior();
                        MostraCalendario.this.pos = posAnt % 7;
                        MostraCalendario.this.pos = MostraCalendario.this.lDias.length - 1;
                        while (MostraCalendario.this.pos >= 0 && (MostraCalendario.this.pos % 7 != posAnt % 7 || Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText()))) {
                            --MostraCalendario.this.pos;
                        }
                        while (MostraCalendario.this.pos >= 0 && Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText())) {
                            --MostraCalendario.this.pos;
                        }
                        while (MostraCalendario.this.pos >= 0 && Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText())) {
                            --MostraCalendario.this.pos;
                        }
                        MostraCalendario.this.atualiza();
                    }
                }
            });
            ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(40, 0, true), "Abaixo", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int posAnt = MostraCalendario.this.pos;
                    MostraCalendario.this.pos += 7;
                    if (MostraCalendario.this.pos >= 0 && MostraCalendario.this.pos < MostraCalendario.this.lDias.length && !Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText())) {
                        MostraCalendario.this.limpaLabels();
                        MostraCalendario.this.lDias[MostraCalendario.this.pos].setBackground(MostraCalendario.this.corSelecionado);
                        MostraCalendario.this.lDias[MostraCalendario.this.pos].setOpaque(true);
                    } else {
                        MostraCalendario.this.proximo();
                        MostraCalendario.this.pos = posAnt % 7;
                        while (MostraCalendario.this.pos < MostraCalendario.this.lDias.length && Funcoes.textoVazio(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText())) {
                            ++MostraCalendario.this.pos;
                        }
                        MostraCalendario.this.atualiza();
                    }
                }
            });
            ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(10, 0, true), "Enter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MostraCalendario.this.lDias[MostraCalendario.this.pos].getText().trim().length() > 0) {
                        MostraCalendario.this.calendar.set(5, Integer.parseInt(MostraCalendario.this.lDias[MostraCalendario.this.pos].getText()));
                        MostraCalendario.this.dataSelecionada = MostraCalendario.this.dateFormat.format(MostraCalendario.this.calendar.getTime());
                        MostraCalendario.this.fireListenerMostraCalendario();
                        if (MostraCalendario.this.campoDestino != null) {
                            MostraCalendario.this.campoDestino.setText(MostraCalendario.this.dataSelecionada);
                            MostraCalendario.this.campoDestino.grabFocus();
                        }
                        if (MostraCalendario.this.getParent() instanceof JPopupMenu) {
                            ((JPopupMenu)MostraCalendario.this.getParent()).setVisible(false);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "MostraCalendario");
        }
    }

    private void limpaLabels() {
        if (this.lDias != null && this.lDias.length > 0) {
            for (int i = 0; i < this.lDias.length; ++i) {
                if (!Funcoes.textoVazio(this.lDias[i].getText()) && Integer.parseInt(this.lDias[i].getText()) == this.diaInicial) {
                    this.lDias[i].setBackground(this.corDiaSelecionado);
                    this.lDias[i].setForeground(Color.white);
                    this.lDias[i].setOpaque(true);
                    continue;
                }
                this.lDias[i].setBackground(this.labelMesAno.getBackground());
                this.lDias[i].setOpaque(false);
            }
        }
    }

    private void jbInit() throws Exception {
        int i;
        this.setName("MostraCalendario");
        this.setLayout(new BorderLayout());
        this.add((Component)this.principal, "Center");
        this.setSize(new Dimension(250, 210));
        this.panelTopo.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.BLACK));
        this.principal.setBorder(ScreenUtil.criarBordaVazia());
        this.principal.add((Component)this.panelTopo, "North");
        this.principal.add((Component)this.panelHoje, "South");
        this.panelAnterior.add(this.labelAnterior);
        this.panelProximo.add(this.labelProximo);
        this.panelTopo.add((Component)this.panelAnterior, "West");
        this.panelTopo.add((Component)this.panelProximo, "East");
        this.panelTopo.add((Component)this.panelMes, "Center");
        this.panelHoje.setPreferredSize(new Dimension(10, 15));
        JLabel labelHoje = new JLabel("Hoje: " + Funcoes.formataData("dd/MM/yyyy", new Date()));
        labelHoje.setFont(new Font(labelHoje.getFont().getFontName(), 0, 9));
        labelHoje.setCursor(Cursor.getPredefinedCursor(12));
        labelHoje.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MostraCalendario.this.setDate(Funcoes.formataData("dd/MM/yyyy", new Date()));
                MostraCalendario.this.calendar = Calendar.getInstance();
                try {
                    MostraCalendario.this.calendar.setTime(MostraCalendario.this.dateFormat.parse(MostraCalendario.this.dataInicial));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                MostraCalendario.this.atualiza();
            }
        });
        labelHoje.setName("labelHoje");
        this.panelHoje.add(labelHoje);
        this.labelMesAno.setName("labelMesAno");
        this.labelMesAno.setFont(this.labelMesAno.getFont().deriveFont(1));
        this.panelMes.add(this.labelMesAno);
        this.labelProximo.setName("labelProximo");
        this.labelProximo.setCursor(Cursor.getPredefinedCursor(12));
        this.labelProximo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MostraCalendario.this.proximo();
            }
        });
        this.labelAnterior.setName("labelAnterior");
        this.labelAnterior.setCursor(Cursor.getPredefinedCursor(12));
        this.labelAnterior.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MostraCalendario.this.anterior();
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (((JLabel)e.getSource()).getText().trim().length() > 0) {
                    MostraCalendario.this.calendar.set(5, Integer.parseInt(((JLabel)e.getSource()).getText()));
                    MostraCalendario.this.dataSelecionada = MostraCalendario.this.dateFormat.format(MostraCalendario.this.calendar.getTime());
                    MostraCalendario.this.fireListenerMostraCalendario();
                    ((JLabel)e.getSource()).setBackground(MostraCalendario.this.labelMesAno.getBackground());
                    ((JLabel)e.getSource()).setOpaque(false);
                    if (MostraCalendario.this.campoDestino != null) {
                        MostraCalendario.this.campoDestino.setText(MostraCalendario.this.apresentarHora ? MostraCalendario.this.dataSelecionada + " " + Funcoes.formataHora(new Date(), false) : MostraCalendario.this.dataSelecionada);
                        MostraCalendario.this.campoDestino.grabFocus();
                    }
                    if (MostraCalendario.this.getParent() instanceof JPopupMenu) {
                        ((JPopupMenu)MostraCalendario.this.getParent()).setVisible(false);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (((JLabel)e.getSource()).getText().trim().length() > 0) {
                    ((JLabel)e.getSource()).setBackground(MostraCalendario.this.corSelecionado);
                    ((JLabel)e.getSource()).setOpaque(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (((JLabel)e.getSource()).getText().trim().length() > 0) {
                    if (Integer.parseInt(((JLabel)e.getSource()).getText()) == MostraCalendario.this.diaInicial) {
                        ((JLabel)e.getSource()).setBackground(MostraCalendario.this.corDiaSelecionado);
                        ((JLabel)e.getSource()).setForeground(Color.white);
                        ((JLabel)e.getSource()).setOpaque(true);
                    } else {
                        ((JLabel)e.getSource()).setBackground(MostraCalendario.this.labelMesAno.getBackground());
                        ((JLabel)e.getSource()).setOpaque(false);
                    }
                }
            }
        };
        for (i = 0; i < 7; ++i) {
            JLabel label = new JLabel();
            label.setHorizontalAlignment(0);
            label.setOpaque(true);
            switch (i) {
                case 0: {
                    label.setText("Dom");
                    label.setForeground(Color.blue);
                    break;
                }
                case 1: {
                    label.setText("Seg");
                    break;
                }
                case 2: {
                    label.setText("Ter");
                    break;
                }
                case 3: {
                    label.setText("Qua");
                    break;
                }
                case 4: {
                    label.setText("Qui");
                    break;
                }
                case 5: {
                    label.setText("Sex");
                    break;
                }
                default: {
                    label.setText("S\u00e1b");
                }
            }
            this.dias.add((Component)label, i);
        }
        for (i = 0; i < this.lDias.length; ++i) {
            this.lDias[i] = new JLabel("");
            this.lDias[i].setCursor(Cursor.getPredefinedCursor(12));
            this.lDias[i].addMouseListener(mouseListener);
            this.lDias[i].setHorizontalAlignment(0);
            this.dias.add(this.lDias[i]);
        }
        this.principal.add((Component)this.dias, "Center");
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(this.dateFormat.parse(this.dataInicial));
        this.atualiza();
    }

    public void setOwner(JTextField owner) {
        if (owner != null) {
            this.campoDestino = owner;
        }
    }

    private void anterior() {
        this.calendar.add(2, -1);
        this.atualiza();
    }

    private void proximo() {
        this.calendar.add(2, 1);
        this.atualiza();
    }

    private void atualiza() {
        this.labelMesAno.setText(this.monthFormat.format(this.calendar.getTime()));
        this.calendar.set(5, 1);
        int diaInitial = this.calendar.get(7);
        int diasNoMes = this.calendar.getActualMaximum(5);
        int dia = 0;
        for (int k = 0; k < diaInitial - 1; ++k) {
            this.lDias[k].setText("");
            this.lDias[k].setOpaque(false);
            this.lDias[k].setBackground(this.labelMesAno.getBackground());
        }
        int diferenca = diaInitial - 1;
        while (dia < diasNoMes) {
            this.lDias[dia + diferenca].setText(String.valueOf(dia + 1));
            this.calendar.set(5, dia + 1);
            if (this.calendar.get(5) == this.diaInicial) {
                this.lDias[dia + diferenca].setOpaque(true);
                this.lDias[dia + diferenca].setBackground(this.corDiaSelecionado);
                this.lDias[dia + diferenca].setForeground(Color.white);
            } else {
                this.lDias[dia + diferenca].setOpaque(false);
                this.lDias[dia + diferenca].setBackground(this.labelMesAno.getBackground());
                this.lDias[dia + diferenca].setForeground(this.labelMesAno.getForeground());
            }
            if (this.calendar.get(7) == 1) {
                this.lDias[dia + diferenca].setForeground(Color.blue);
            }
            diaInitial = diaInitial == 6 ? 0 : ++diaInitial;
            ++dia;
        }
        for (int i = dia + diferenca; i < this.lDias.length; ++i) {
            this.lDias[i].setText("");
            this.lDias[i].setOpaque(false);
            this.lDias[i].setBackground(this.labelMesAno.getBackground());
        }
    }

    public String getDate() {
        return this.dataSelecionada;
    }

    public void setDate(String data) {
        this.dataInicial = data;
        SimpleDateFormat dayFormat = new SimpleDateFormat("d");
        try {
            this.diaInicial = Integer.parseInt(dayFormat.format(this.dateFormat.parse(this.dataInicial)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.atualiza();
    }

    public void addListener(ListenerMostraCalendario l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void removeListener(ListenerMostraCalendario l) {
        this.listener.remove(l);
    }

    public void fireListenerMostraCalendario() {
        for (ListenerMostraCalendario l : this.listener) {
            l.dataSelecionada(Funcoes.verificaData(this.dataSelecionada) ? Funcoes.stringToDate(this.dataSelecionada) : null);
        }
    }
}

