/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.laboratorio.Laboratorio;
import jalis.util.ArraysUtil;
import jalis.util.Comparador;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class ModeloGridTable
extends AbstractTableModel
implements MouseListener {
    public static final int SENTIDO_ASC = 1;
    public static final int SENTIDO_DESC = -1;
    protected String[] colunas;
    private ArrayList<Object[]> linhas = new ArrayList();
    private TamanhoColuna[] columnSize;
    private JTable table;
    private int ultCol = -1;
    private int ultSentido = 1;

    public ModeloGridTable(String[] columns) {
        if (columns != null) {
            this.setColumnName(columns);
        }
    }

    public ModeloGridTable(String[] columns, int[] sizes, JTable table) {
        if (columns != null) {
            this.setColumnName(columns);
        }
        if (sizes != null && table != null) {
            this.setColumnSize(sizes, table);
        }
    }

    public void setSentidoOrdenacao(int sentido) {
        if (sentido != 1 && sentido != -1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Sentido inv\u00e1lido.", null);
            this.ultSentido = 1;
        } else {
            this.ultSentido = sentido;
        }
    }

    public void changeColumnName(String newName, int pos) {
        if (this.colunas != null && this.colunas.length >= pos) {
            this.colunas[pos] = newName;
            this.fireTableStructureChanged();
            this.setColumnSize(this.columnSize, this.table);
        }
    }

    public void setColumnSize(int[] columnSize, JTable tabela) {
        ArrayList<TamanhoColuna> tamanhos = new ArrayList<TamanhoColuna>();
        for (int i = 0; i < columnSize.length; ++i) {
            tamanhos.add(new TamanhoColuna(columnSize[i], columnSize[i]));
        }
        this.setColumnSize(tamanhos.toArray(new TamanhoColuna[tamanhos.size()]), tabela);
    }

    public void setColumnSize(TamanhoColuna[] columnSize, JTable tabela) {
        if (columnSize != null && tabela != null && this.colunas.length == columnSize.length) {
            this.columnSize = columnSize;
            this.table = tabela;
            for (int i = 0; i < columnSize.length && i < tabela.getColumnCount(); ++i) {
                if (columnSize[i].getMinimo() <= 0) continue;
                tabela.getColumnModel().getColumn(i).setPreferredWidth(columnSize[i].getMinimo());
                tabela.getColumnModel().getColumn(i).setMinWidth(columnSize[i].getMinimo());
                tabela.getColumnModel().getColumn(i).setMaxWidth(columnSize[i].getMaximo());
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.linhas.get(rowIndex)[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.colunas.length;
    }

    @Override
    public int getRowCount() {
        return this.linhas.size();
    }

    public void setColumnName(String[] names) {
        if (names != null) {
            this.colunas = names;
            this.fireTableStructureChanged();
        }
    }

    public void setColumnName(int pos, String name) {
        if (name != null) {
            this.colunas[pos] = name;
            this.fireTableStructureChanged();
        }
    }

    public Object getColumn(int column) {
        return this.colunas[column];
    }

    public void addLine(Object[] line) {
        if (line != null) {
            this.linhas.add(line);
            this.fireTableDataChanged();
        }
    }

    public void copyLine(Map line) {
        Object[] o = new Object[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String s = "";
            if (this.getColumnName(i) instanceof String) {
                s = this.getColumnName(i).toString().replaceAll(" \u25bc", "").replaceAll(" \u25b2", "");
            }
            if (!line.containsKey(s)) continue;
            o[i] = line.get(s);
        }
        this.addLine(o);
    }

    public void insertLine(Object[] line, int posicao) {
        if (line != null && posicao < this.linhas.size()) {
            this.addLine(this.linhas.get(this.linhas.size() - 1));
            for (int i = this.linhas.size() - 1; i > posicao; --i) {
                this.linhas.set(i, this.linhas.get(i - 1));
            }
            this.linhas.set(posicao, line);
            this.fireTableDataChanged();
        }
    }

    public void insertColumn(String columnName) {
        if (this.colunas != null) {
            this.colunas = ArraysUtil.concatenar(this.colunas, new String[]{columnName});
            for (int i = 0; i < this.linhas.size(); ++i) {
                this.linhas.set(i, ArraysUtil.concatenar(this.linhas.get(i), new Object[]{1}));
            }
            this.fireTableStructureChanged();
        }
    }

    public void removeLine(int lineNumber) {
        this.linhas.remove(lineNumber);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.linhas.clear();
        this.fireTableDataChanged();
    }

    public HashMap<String, Object> getLine(int line) {
        if (line < this.linhas.size()) {
            HashMap<String, Object> retorno = new HashMap<String, Object>();
            for (int i = 0; i < this.colunas.length; ++i) {
                retorno.put(this.colunas[i], this.linhas.get(line)[i]);
            }
            return retorno;
        }
        return null;
    }

    public Object[] getLineValue(int line) {
        if (line < this.linhas.size()) {
            return this.linhas.get(line);
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        if (column == this.ultCol) {
            return this.colunas[column] + (this.ultSentido == 1 ? " \u25bc" : " \u25b2");
        }
        return this.colunas[column];
    }

    public String getColumnNameSemCaracterEspecial(int column) {
        return this.colunas[column];
    }

    public int localizar(int column, String value) {
        int retorno = -1;
        for (int i = 0; i < this.linhas.size(); ++i) {
            if (this.linhas.get(i)[column] == null || !this.linhas.get(i)[column].toString().equalsIgnoreCase(value)) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    public int localizarAvancado(int[] colunas, String[] valores) {
        int retorno = -1;
        for (int i = 0; i < this.linhas.size(); ++i) {
            boolean encontrou = true;
            for (int j = 0; j < colunas.length; ++j) {
                if (this.linhas.get(i)[colunas[j]] != null && this.linhas.get(i)[colunas[j]].toString().equalsIgnoreCase(valores[j])) continue;
                encontrou = false;
                break;
            }
            if (!encontrou) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    public int localizarParcial(int column, String value) {
        int retorno = -1;
        for (int i = 0; i < this.linhas.size(); ++i) {
            if (this.linhas.get(i)[column] == null || !this.linhas.get(i)[column].toString().toUpperCase().startsWith(value.toUpperCase())) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    public int localizarContendo(int column, String value) {
        int retorno = -1;
        for (int i = 0; i < this.linhas.size(); ++i) {
            if (this.linhas.get(i)[column] == null || !this.linhas.get(i)[column].toString().toUpperCase().contains(value.toUpperCase())) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.linhas.size() && columnIndex < this.linhas.get(rowIndex).length) {
            this.linhas.get((int)rowIndex)[columnIndex] = aValue;
            if (columnIndex + 1 <= this.colunas.length) {
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }

    @Override
    public int findColumn(String columnName) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!columnName.equalsIgnoreCase(this.getColumnName(i).replaceAll(" \u25bc", "").replaceAll(" \u25b2", ""))) continue;
            return i;
        }
        return -1;
    }

    public int getColunaOrdenacao() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).contains(" \u25bc") && !this.getColumnName(i).contains(" \u25b2")) continue;
            return i;
        }
        return -1;
    }

    public void ordenarColunaSemTrocarSentido(int col) {
        this.ordenarColuna(col, this.ultSentido);
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        if (this.columnSize != null && this.table != null) {
            this.setColumnSize(this.columnSize, this.table);
        }
    }

    public void ordenarColuna(int col) {
        this.ultSentido = col == this.ultCol ? (this.ultSentido *= -1) : 1;
        this.ordenarColuna(col, this.ultSentido);
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        if (this.columnSize != null && this.table != null) {
            this.setColumnSize(this.columnSize, this.table);
        }
    }

    public void ordenarColunas(int col) {
        this.ordenarColunaOrcamento(col, this.ultSentido);
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        if (this.columnSize != null && this.table != null) {
            this.setColumnSize(this.columnSize, this.table);
        }
    }

    public void ordenarColunaAvancado(int col, int colAux) {
        this.ultSentido = col == this.ultCol ? (this.ultSentido *= -1) : 1;
        this.ordenarColuna(col, this.ultSentido);
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        if (this.columnSize != null && this.table != null) {
            this.setColumnSize(this.columnSize, this.table);
        }
    }

    public void ordenarColunaAvancado(int col, int colAux, int sentido) {
        this.ordenarColunaAvancado(col, colAux, sentido, true);
    }

    public void ordenarColuna(int col, int sentido) {
        this.ordenarColuna(col, sentido, true);
    }

    public void ordenarColuna(int col, int sentido, boolean acrescentarIdentificadorColuna) {
        if (col > -1 && col < this.colunas.length) {
            if (col != this.ultCol && acrescentarIdentificadorColuna) {
                this.ultCol = col;
            }
            Object[][] tmp = (Object[][])this.linhas.toArray((T[])new Object[this.linhas.size()][]);
            Arrays.sort(tmp, new Comparador(col, sentido));
            this.linhas.clear();
            for (int i = 0; i < tmp.length; ++i) {
                this.linhas.add(tmp[i]);
            }
        }
    }

    public void ordenarColunaOrcamento(int col, int sentido) {
        ArrayList<Object[]> listaInmetro = new ArrayList<Object[]>();
        ArrayList<Object[]> listaNormal = new ArrayList<Object[]>();
        for (Object[] linha : this.linhas) {
            String numeroOrdem;
            if (null == linha[col]) continue;
            String indice = linha[col].toString();
            if (indice.startsWith("a") || indice.startsWith("A")) {
                numeroOrdem = linha[col].toString().substring(1, linha[col].toString().length());
                if (!Funcoes.isNumeric(numeroOrdem)) continue;
                linha[col] = Integer.parseInt(numeroOrdem);
                listaInmetro.add(linha);
                continue;
            }
            numeroOrdem = linha[col].toString().substring(1, linha[col].toString().length());
            if (!Funcoes.isNumeric(numeroOrdem)) continue;
            linha[col] = Integer.parseInt(numeroOrdem);
            listaNormal.add(linha);
        }
        Object[][] tmpInmetro = (Object[][])listaInmetro.toArray((T[])new Object[listaInmetro.size()][]);
        Arrays.sort(tmpInmetro, new Comparador(col, sentido));
        Object[][] tmpNormal = (Object[][])listaNormal.toArray((T[])new Object[listaNormal.size()][]);
        Arrays.sort(tmpNormal, new Comparador(col, sentido));
        this.linhas.clear();
        if (tmpInmetro.length > 0) {
            for (int i = 0; i < tmpInmetro.length; ++i) {
                this.linhas.add(tmpInmetro[i]);
            }
        }
        if (tmpNormal.length > 0) {
            for (int i = 0; i < tmpNormal.length; ++i) {
                this.linhas.add(tmpNormal[i]);
            }
        }
    }

    public ArrayList<Object[]> getLinhas() {
        return this.linhas;
    }

    public void ordenarColunaAvancado(int col, int colAux, int sentido, boolean acrescentarIdentificadorColuna) {
        if (col > -1 && col < this.colunas.length) {
            if (col != this.ultCol && acrescentarIdentificadorColuna) {
                this.ultCol = col;
            }
            Object[][] tmp = (Object[][])this.linhas.toArray((T[])new Object[this.linhas.size()][]);
            Arrays.sort(tmp, new Comparador(col, colAux, sentido));
            this.linhas.clear();
            for (int i = 0; i < tmp.length; ++i) {
                this.linhas.add(tmp[i]);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)o;
            int col = header.getColumnModel().getColumnIndexAtX(e.getX());
            Rectangle rec = header.getHeaderRect(col);
            if (col == 0) {
                rec.width -= 3;
            } else {
                rec.grow(-3, 0);
            }
            if (rec.contains(e.getPoint())) {
                this.ordenarColuna(col);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static class TamanhoColuna {
        private int minimo = 0;
        private int maximo = 0;

        public TamanhoColuna(int minimo, int maximo) {
            this.minimo = minimo;
            this.maximo = maximo;
        }

        public int getMinimo() {
            return this.minimo;
        }

        public void setMinimo(int minimo) {
            this.minimo = minimo;
        }

        public int getMaximo() {
            return this.maximo;
        }

        public void setMaximo(int maximo) {
            this.maximo = maximo;
        }
    }
}

