/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import java.util.ArrayList;
import java.util.Collection;

public class MemoryList<E>
extends ArrayList<E> {
    int last_read = -1;
    int last_inserted = -1;
    int last_set = -1;
    int last_removed = -1;

    public MemoryList(int initialCapacity) {
        super(initialCapacity);
    }

    public MemoryList() {
    }

    public MemoryList(Collection c) {
        super(c);
    }

    public int getUltimoLido() {
        return this.last_read;
    }

    public void resetUltimoLido() {
        this.last_read = -1;
    }

    public int getUltimoInserido() {
        return this.last_inserted;
    }

    public int getUltimoSubstituido() {
        return this.last_set;
    }

    public int getUltimoRemovido() {
        return this.last_removed;
    }

    @Override
    public E get(int i) {
        this.last_read = i;
        return super.get(i);
    }

    @Override
    public E set(int i, E o) {
        this.last_set = i;
        return super.set(i, o);
    }

    @Override
    public E remove(int i) {
        this.last_removed = i;
        return super.remove(i);
    }

    @Override
    public boolean remove(Object o) {
        if (super.indexOf(o) >= 0) {
            this.last_removed = super.indexOf(o);
            return super.remove(o);
        }
        return false;
    }

    @Override
    public void removeRange(int start, int end) {
        this.last_removed = start;
        super.removeRange(start, end);
    }

    @Override
    public boolean add(E o) {
        this.last_inserted = this.size();
        return super.add(o);
    }

    @Override
    public void add(int i, E o) {
        this.last_inserted = this.size();
        super.add(i, o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (super.addAll(c)) {
            this.last_inserted = this.size();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> c) {
        if (super.addAll(c)) {
            this.last_inserted = i + c.size();
            return true;
        }
        return false;
    }
}

