/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.util.HashMap;
import java.util.HashSet;

public class ManualFocusPolicy
extends FocusTraversalPolicy {
    private HashMap firstComponents = new HashMap();
    private HashMap forwardMap = new HashMap();
    private HashMap backwardMap = new HashMap();

    public void setFirstComponent(Container focusCycleRoot, Component firstComponent) {
        this.firstComponents.put(focusCycleRoot, firstComponent);
    }

    public void setNextFocusableComponent(Component left, Component right) {
        this.forwardMap.put(left, right);
        this.backwardMap.put(right, left);
    }

    public void unsetNextFocusableComponent(Component left, Component right) {
        this.forwardMap.remove(left);
        this.backwardMap.remove(right);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        Component hardCoded = aComponent;
        HashSet<Component> sanity = new HashSet<Component>();
        do {
            Component prevHardCoded = hardCoded;
            if ((hardCoded = (Component)this.forwardMap.get(hardCoded)) == null) {
                return null;
            }
            if (sanity.contains(hardCoded)) {
                return null;
            }
            sanity.add(hardCoded);
        } while (!this.accept(hardCoded));
        return hardCoded;
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        Component hardCoded = aComponent;
        HashSet<Component> sanity = new HashSet<Component>();
        do {
            Component prevHardCoded = hardCoded;
            if ((hardCoded = (Component)this.backwardMap.get(hardCoded)) == null) {
                return null;
            }
            if (sanity.contains(hardCoded)) {
                return null;
            }
            sanity.add(hardCoded);
        } while (!this.accept(hardCoded));
        return hardCoded;
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        Object obj = this.firstComponents.get(focusCycleRoot);
        if (obj != null) {
            return (Component)obj;
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        return null;
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.getFirstComponent(focusCycleRoot);
    }

    private boolean accept(Component aComponent) {
        if (!(aComponent.isVisible() && aComponent.isDisplayable() && aComponent.isFocusable() && aComponent.isEnabled())) {
            return false;
        }
        if (!(aComponent instanceof Window)) {
            for (Container enableTest = aComponent.getParent(); enableTest != null; enableTest = enableTest.getParent()) {
                if (!enableTest.isEnabled() && !enableTest.isLightweight()) {
                    return false;
                }
                if (enableTest instanceof Window) break;
            }
        }
        return true;
    }
}

