/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.ItemLegenda;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class Legenda {
    private int tamanhoFonte;
    private JPanel panel;

    public Legenda(int tamanhoFonte, Orientacoes orientacao) {
        this.tamanhoFonte = tamanhoFonte;
        this.panel = new JPanel(this.getLayoutManager(orientacao));
    }

    public Legenda(int tamanhoFonte) {
        this(10, Orientacoes.HORIZONTAL);
    }

    public Legenda() {
        this(10);
    }

    public void addItem(Color cor, String legenda) {
        this.panel.add(new ItemLegenda(this.tamanhoFonte, cor, legenda));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private LayoutManager getLayoutManager(Orientacoes orientacao) {
        LayoutManager layoutManager = null;
        switch (orientacao) {
            case HORIZONTAL: {
                layoutManager = new FlowLayout(0, 6, 2);
                break;
            }
            case VERTICAL: {
                layoutManager = new BoxLayout(this.panel, 1);
            }
        }
        return layoutManager;
    }

    public static enum Orientacoes {
        HORIZONTAL,
        VERTICAL;

    }
}

