/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.ParametrosLocais;
import jalis.comum.camera.VisualizarVideo;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.Biometria;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.LabelFotoCapturaListener;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;

public class LabelFotoCaptura
extends JLabel
implements ActionListener {
    private JLabel imagemCamera = new JLabel(ImagemUtils.carregaImagemJalis("recepcao/cad_paciente_photo.png"));
    private JLabel imagemDigital = new JLabel(ImagemUtils.carregaImagemJalis("recepcao/cad_paciente_finger.png"));
    private JPopupMenu menuCapturar = new JPopupMenu();
    private JMenu menuImpressaoDigital = ComponenteFactory.novoJMenu(this.menuCapturar, "Impress\u00e3o digital", '\u0000');
    private JMenuItem menuCapturarImpressaoDigital = ComponenteFactory.novoJMenuItem(this.menuImpressaoDigital, "Adicionar/Alterar", (ActionListener)this);
    private JMenuItem menuRemoverImpressaoDigital = ComponenteFactory.novoJMenuItem(this.menuImpressaoDigital, "Remover", (ActionListener)this);
    private JMenuItem menuVerificarImpressaoDigital = ComponenteFactory.novoJMenuItem(this.menuImpressaoDigital, "Verificar", (ActionListener)this);
    private boolean mostrarCapturaFoto = ParametrosLocais.getParametro("cameraCaptura") != null && !ParametrosLocais.getParametro("cameraCaptura").equals("Sem c\u00e2mera");
    private boolean mostrarImpressaoDigital = ParametrosLocais.existeParametro("biometriaCaptura") && !ParametrosLocais.getParametro("biometriaCaptura").equals("Sem biometria");
    private ImageIcon fotoPaciente;
    private String impressaoDigital = null;
    private FrmCadPadrao frame;
    private MouseMotion motionListener;
    private MouseListener mouseListener;
    private ArrayList<LabelFotoCapturaListener> listeners = new ArrayList();

    public LabelFotoCaptura(FrmCadPadrao f) {
        this.frame = f;
        this.add(this.imagemCamera);
        this.add(this.imagemDigital);
        this.imagemCamera.setVisible(this.mostrarCapturaFoto);
        this.imagemDigital.setVisible(this.mostrarImpressaoDigital);
        this.motionListener = new MouseMotion();
        this.mouseListener = new MouseListener();
    }

    public void controlaCampos(boolean status) {
        this.imagemCamera.setEnabled(status);
        this.imagemDigital.setEnabled(status);
        if (this.imagemCamera.isVisible()) {
            if (this.imagemCamera.isEnabled()) {
                this.imagemCamera.addMouseMotionListener(this.motionListener);
                this.imagemCamera.addMouseListener(this.mouseListener);
            } else {
                for (MouseMotionListener mouseMotionListener : this.imagemCamera.getMouseMotionListeners()) {
                    this.imagemCamera.removeMouseMotionListener(mouseMotionListener);
                }
                for (EventListener eventListener : this.imagemCamera.getMouseListeners()) {
                    this.imagemCamera.removeMouseListener((java.awt.event.MouseListener)eventListener);
                }
            }
        }
        if (this.imagemDigital.isVisible()) {
            if (this.imagemDigital.isEnabled()) {
                this.imagemDigital.addMouseListener(this.mouseListener);
                this.imagemDigital.addMouseMotionListener(this.motionListener);
            } else {
                for (EventListener eventListener : this.imagemDigital.getMouseMotionListeners()) {
                    this.imagemDigital.removeMouseMotionListener((MouseMotionListener)eventListener);
                }
                for (EventListener eventListener : this.imagemDigital.getMouseListeners()) {
                    this.imagemDigital.removeMouseListener((java.awt.event.MouseListener)eventListener);
                }
            }
        }
    }

    private void colocaFoto(ImageIcon img) {
        this.setFotoPaciente(img);
        if (this.getFotoPaciente() == null) {
            this.setText("<html><div align=center>Clique para <br>adicionar <br>imagem</div></html>");
            this.setBorder(new TitledBorder(""));
        } else {
            this.setIcon(null);
            this.setIcon(this.getFotoPaciente());
            this.setBorder(null);
            this.setText("");
        }
    }

    @Override
    public void revalidate() {
        super.revalidate();
        if (this.imagemCamera != null) {
            this.imagemCamera.setBounds(this.getWidth() - 60, this.getHeight() - 30, this.imagemCamera.getIcon().getIconWidth(), this.imagemCamera.getIcon().getIconHeight());
        }
        if (this.imagemDigital != null) {
            this.imagemDigital.setBounds(this.getWidth() - 30, this.getHeight() - 30, this.imagemDigital.getIcon().getIconWidth(), this.imagemDigital.getIcon().getIconHeight());
        }
    }

    private void capturarImpressaoDigital(boolean verificar) {
        String name;
        short id;
        if (this.mostrarImpressaoDigital && (id = Biometria.getDispositivo(name = ParametrosLocais.getParametro("biometriaCaptura"))) > -1) {
            String aux = Biometria.capturar(id, true);
            if (aux != null) {
                this.setImpressaoDigital(aux);
            }
            if (verificar && this.getImpressaoDigital() != null) {
                this.verificarImpressaoDigital(true);
            }
        }
    }

    private void verificarImpressaoDigital(boolean isRepetindo) {
        block12: {
            int resp = -1;
            if (this.mostrarImpressaoDigital) {
                if (Funcoes.textoVazio(this.getImpressaoDigital())) {
                    resp = Funcoes.mensagem(this.frame, "N\u00e3o h\u00e1 uma impress\u00e3o digital informada para o paciente.\nDeseja adicionar uma impress\u00e3o digital?", 4);
                    if (resp == 0) {
                        this.capturarImpressaoDigital(false);
                    } else {
                        return;
                    }
                }
                if (this.getImpressaoDigital() == null) {
                    return;
                }
                String name = ParametrosLocais.getParametro("biometriaCaptura");
                short id = Biometria.getDispositivo(name);
                if (id > -1) {
                    if (resp == 0 || isRepetindo) {
                        Funcoes.mensagem(this.frame, "Informe a digital novamente para confirmar.", 5);
                    } else {
                        Funcoes.mensagem(this.frame, "Informe a digital do paciente.", 5);
                    }
                    try {
                        if (!Biometria.verificar(id, this.impressaoDigital, true)) {
                            Funcoes.mensagem(this.frame, "A impress\u00e3o digital informada N\u00c3O confere com a impress\u00e3o digital j\u00e1 gravada.", 2);
                        } else {
                            Funcoes.mensagem(this.frame, "A impress\u00e3o digital coincide.", 5);
                        }
                    }
                    catch (Exception e) {
                        if (!isRepetindo) break block12;
                        Funcoes.mensagem(this.frame, "Impress\u00e3o digital n\u00e3o informada.", 2);
                        this.setImpressaoDigital(null);
                    }
                }
            }
        }
    }

    public ImageIcon getFotoPaciente() {
        return this.fotoPaciente;
    }

    public void setFotoPaciente(ImageIcon fotoPaciente) {
        this.fotoPaciente = fotoPaciente;
    }

    public String getImpressaoDigital() {
        return this.impressaoDigital;
    }

    public void setImpressaoDigital(String impressaoDigital) {
        this.impressaoDigital = impressaoDigital;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuCapturarImpressaoDigital) {
            this.capturarImpressaoDigital(true);
        } else if (e.getSource() == this.menuRemoverImpressaoDigital && Funcoes.mensagem(this.frame, "Confirma a exclus\u00e3o da impress\u00e3o digital?", 4) == 0) {
            this.setImpressaoDigital(null);
        } else {
            this.verificarImpressaoDigital(false);
        }
    }

    public void addFotoCapturaListener(LabelFotoCapturaListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == LabelFotoCaptura.this.imagemCamera) {
                VisualizarVideo video = LabelFotoCaptura.this.frame.getTopLevelAncestor() instanceof Frame ? new VisualizarVideo((Frame)LabelFotoCaptura.this.frame.getTopLevelAncestor()) : new VisualizarVideo((JDialog)LabelFotoCaptura.this.frame.getTopLevelAncestor());
                video.setVisible(true);
                if (video.isOk()) {
                    LabelFotoCaptura.this.colocaFoto(video.getImageIcon());
                    for (LabelFotoCapturaListener l : LabelFotoCaptura.this.listeners) {
                        l.fotoCapturada();
                    }
                }
                e.setSource(null);
            } else if (e.getSource() == LabelFotoCaptura.this.imagemDigital) {
                LabelFotoCaptura.this.menuCapturar.show(LabelFotoCaptura.this.imagemDigital.getParent(), LabelFotoCaptura.this.imagemDigital.getX(), LabelFotoCaptura.this.imagemDigital.getY() + LabelFotoCaptura.this.imagemDigital.getHeight());
                e.setSource(null);
            }
        }
    }

    private class MouseMotion
    extends MouseMotionAdapter {
        private MouseMotion() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getSource() == LabelFotoCaptura.this.imagemCamera) {
                LabelFotoCaptura.this.imagemCamera.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                LabelFotoCaptura.this.imagemDigital.setCursor(Cursor.getPredefinedCursor(12));
            }
            if (e.getSource() == LabelFotoCaptura.this.imagemCamera) {
                if (!LabelFotoCaptura.this.getCursor().equals(Cursor.getPredefinedCursor(0))) {
                    LabelFotoCaptura.this.imagemCamera.setCursor(Cursor.getPredefinedCursor(0));
                }
            } else if (!LabelFotoCaptura.this.getCursor().equals(Cursor.getPredefinedCursor(0))) {
                LabelFotoCaptura.this.imagemDigital.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

