/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.laboratorio.interfaceamento.comunicacao.arquivo.Arquivo;
import jalis.laboratorio.interfaceamento.comunicacao.arquivo.ArquivoException;
import jalis.util.StringUtil;
import java.util.ArrayList;

public class JalisPropertiesService {
    private static final Arquivo arquivo = new Arquivo(System.getProperty("user.home").toString() + "/jalis.properties");

    public static Integer[] getCodigoInterfaceamento() throws ArquivoException {
        if (!arquivo.existe()) {
            throw new ArquivoException("Arquivo properties do jalis n\u00e3o existe.");
        }
        for (String linha : arquivo.ler().split("\r\n")) {
            if (!linha.contains("xml_interfaceamento")) continue;
            int indiceXml = linha.indexOf("=");
            String xml = linha.substring(indiceXml);
            String[] codigo = StringUtil.getValores(xml, "equipamento_codigo");
            Integer[] codigointerface = JalisPropertiesService.toInteger(codigo);
            return codigointerface;
        }
        throw new ArquivoException("Codigo do equipamento n\u00e3o foi encontrado no arquivo properties.");
    }

    private static Integer[] toInteger(String[] codigos) {
        ArrayList<Integer> listaCodigoInterface = new ArrayList<Integer>();
        for (int i = 0; i < codigos.length; ++i) {
            if (listaCodigoInterface.contains(Integer.parseInt(codigos[i]))) continue;
            listaCodigoInterface.add(Integer.parseInt(codigos[i]));
        }
        Integer[] codigoInterface = new Integer[listaCodigoInterface.size()];
        for (int x = 0; x < listaCodigoInterface.size(); ++x) {
            codigoInterface[x] = (Integer)listaCodigoInterface.get(x);
        }
        return codigoInterface;
    }
}

