/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class JTabbedSideBar
extends JPanel {
    TabbedLayout layout = (TabbedLayout)this.getLayout();

    public JTabbedSideBar() {
        super(new TabbedLayout());
    }

    @Override
    public Component add(String label, Component content) {
        return this.add(label, null, content);
    }

    public Component add(Icon icon, Component content) {
        return this.add("", icon, content);
    }

    public Component add(String label, Icon icon, Component content) {
        JPanel tab = new JPanel(new BorderLayout());
        JButton but = new JButton(label, icon);
        tab.add((Component)but, "North");
        tab.add(content, "Center");
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JButton b = (JButton)evt.getSource();
                JTabbedSideBar.this.layout.setSelected(b.getText());
                JTabbedSideBar.this.revalidate();
            }
        });
        this.layout.setSelected(label);
        super.add(tab);
        return content;
    }

    @Override
    public Component add(Component comp) {
        return this.add("", comp);
    }

    private static class TabbedLayout
    implements LayoutManager {
        private String _selectedTab;
        private Map _components = new HashMap();

        private TabbedLayout() {
        }

        public final String getSelectedTab() {
            return this._selectedTab;
        }

        public final void setSelectedTab(String selectedTab) {
            this._selectedTab = selectedTab;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this._components.remove(comp);
        }

        @Override
        public void layoutContainer(Container parent) {
            JPanel p;
            JButton b;
            String label;
            Dimension sz = parent.getSize();
            Component[] c = parent.getComponents();
            int y = 0;
            for (int i = 0; i < c.length && !(label = (b = (JButton)(p = (JPanel)c[i]).getComponent(0)).getText()).equals(this._selectedTab); ++i) {
                Dimension pref = b.getPreferredSize();
                int h = pref.height;
                c[i].setBounds(0, y, sz.width, h);
                y += pref.height;
            }
            int higherBound = y;
            Component selected = null;
            y = sz.height;
            for (int i = c.length - 1; i >= 0; --i) {
                JPanel p2 = (JPanel)c[i];
                JButton b2 = (JButton)p2.getComponent(0);
                String label2 = b2.getText();
                if (label2.equals(this._selectedTab)) {
                    selected = p2;
                    break;
                }
                Dimension pref = b2.getPreferredSize();
                int h = pref.height;
                c[i].setBounds(0, y -= pref.height, sz.width, h);
            }
            int lowerBound = y;
            selected.setBounds(0, higherBound, sz.width, lowerBound - higherBound);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this._components.put(comp, name);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Component[] c = parent.getComponents();
            int width = 0;
            int height = 0;
            for (int i = 0; i < c.length; ++i) {
                JPanel p = (JPanel)c[i];
                JButton b = (JButton)p.getComponent(0);
                Dimension pref = b.getPreferredSize();
                height += pref.height;
                if (width >= pref.width) continue;
                width = pref.width;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Component[] c = parent.getComponents();
            int width = 0;
            int height = 0;
            for (int i = 0; i < c.length; ++i) {
                JPanel p = (JPanel)c[i];
                JButton b = (JButton)p.getComponent(0);
                Dimension pref = b.getPreferredSize();
                height += pref.height;
                if (width >= pref.width) continue;
                width = pref.width;
            }
            return new Dimension(width, height);
        }

        public void setSelected(String label) {
            this._selectedTab = label;
        }
    }
}

