/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.Funcoes;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Intervalo
implements Comparable<Intervalo> {
    private static final Map<Character, Unidades> unidadesByCoringas;
    private static final Map<Unidades, Unidade> unidades;
    private long milisegundos;

    public Intervalo(long milisegundos) {
        this.milisegundos = milisegundos;
    }

    public Intervalo(Date dataInicial, Date dataFinal) {
        this(dataFinal.getTime() - dataInicial.getTime());
    }

    public String formata(Unidades unidadeBase, String formato) {
        StringBuilder saida = new StringBuilder();
        Map<Unidades, Long> valores = this.getValores(unidadeBase);
        boolean delimitadorAberto = false;
        char coringaAtual = '\u0000';
        int qtCoringas = 0;
        for (char c : formato.toCharArray()) {
            if (c == '{') {
                delimitadorAberto = true;
                continue;
            }
            if (c == '}' && qtCoringas > 0) {
                delimitadorAberto = false;
                Long valor = valores.get((Object)unidadesByCoringas.get(Character.valueOf(coringaAtual)));
                valor = valor == null ? 0L : valor;
                saida.append(Funcoes.preencheZero(valor, qtCoringas));
                qtCoringas = 0;
                continue;
            }
            if (delimitadorAberto) {
                coringaAtual = c;
                ++qtCoringas;
                continue;
            }
            saida.append(c);
        }
        return saida.toString();
    }

    public long getMilisegundos() {
        return this.milisegundos;
    }

    public Map<Unidades, Long> getValores(Unidades unidadeBase) {
        HashMap<Unidades, Long> valores = new HashMap<Unidades, Long>();
        unidades.get((Object)unidadeBase).calcula(this.milisegundos, valores);
        return valores;
    }

    public Intervalo soma(Intervalo outroinIntervalo) {
        return new Intervalo(this.getMilisegundos() + outroinIntervalo.getMilisegundos());
    }

    public Intervalo subtrai(Intervalo outroinIntervalo) {
        return new Intervalo(this.getMilisegundos() - outroinIntervalo.getMilisegundos());
    }

    @Override
    public int compareTo(Intervalo o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        if (this.milisegundos == o.milisegundos) {
            return 0;
        }
        if (this.milisegundos > o.milisegundos) {
            return 1;
        }
        if (this.milisegundos < o.milisegundos) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.milisegundos ^ this.milisegundos >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Intervalo other = (Intervalo)obj;
        return this.milisegundos == other.milisegundos;
    }

    public String toString() {
        return this.formata(Unidades.MILISEG, "{S} milisegundo(s)");
    }

    static {
        unidades = new HashMap<Unidades, Unidade>();
        unidades.put(Unidades.MILISEG, new Unidade(Unidades.MILISEG, 0L, null));
        unidades.put(Unidades.SEGUNDO, new Unidade(Unidades.SEGUNDO, 1000L, unidades.get((Object)Unidades.MILISEG)));
        unidades.put(Unidades.MINUTO, new Unidade(Unidades.MINUTO, 60000L, unidades.get((Object)Unidades.SEGUNDO)));
        unidades.put(Unidades.HORA, new Unidade(Unidades.HORA, 3600000L, unidades.get((Object)Unidades.MINUTO)));
        unidades.put(Unidades.DIA, new Unidade(Unidades.DIA, 86400000L, unidades.get((Object)Unidades.HORA)));
        unidades.put(Unidades.MES, new Unidade(Unidades.MES, 2592000000L, unidades.get((Object)Unidades.DIA)));
        unidades.put(Unidades.ANO, new Unidade(Unidades.ANO, 31104000000L, unidades.get((Object)Unidades.MES)));
        unidadesByCoringas = new HashMap<Character, Unidades>();
        unidadesByCoringas.put(Character.valueOf('S'), Unidades.MILISEG);
        unidadesByCoringas.put(Character.valueOf('s'), Unidades.SEGUNDO);
        unidadesByCoringas.put(Character.valueOf('m'), Unidades.MINUTO);
        unidadesByCoringas.put(Character.valueOf('H'), Unidades.HORA);
        unidadesByCoringas.put(Character.valueOf('d'), Unidades.DIA);
        unidadesByCoringas.put(Character.valueOf('M'), Unidades.MES);
        unidadesByCoringas.put(Character.valueOf('y'), Unidades.ANO);
    }

    private static class Unidade {
        private Unidades unidade;
        private Unidade subUnidade;
        private long unidadeEmMilisegundos;

        public Unidade(Unidades unidade, long unidadeEmMilisegundos, Unidade subUnidade) {
            this.unidade = unidade;
            this.subUnidade = subUnidade;
            this.unidadeEmMilisegundos = unidadeEmMilisegundos;
        }

        public void calcula(long milisegundos, Map<Unidades, Long> valores) {
            long valor = 0L;
            if (this.unidadeEmMilisegundos == 0L) {
                valor = milisegundos;
            } else if (milisegundos >= this.unidadeEmMilisegundos) {
                valor = milisegundos / this.unidadeEmMilisegundos;
            }
            valores.put(this.unidade, valor);
            if (this.subUnidade != null) {
                long resto = milisegundos - this.unidadeEmMilisegundos * valor;
                this.subUnidade.calcula(resto, valores);
            }
        }
    }

    public static enum Unidades {
        MILISEG,
        SEGUNDO,
        MINUTO,
        HORA,
        DIA,
        MES,
        ANO;

    }
}

