/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.EnumMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.codec.binary.Base64;
import sun.awt.image.ToolkitImage;

public class ImagemUtils {
    public static byte[] imageToByte(Image imagem) {
        boolean transparencia = false;
        int tipo = 2;
        if (null != imagem) {
            int height;
            int width = imagem.getWidth(null);
            if (width < 0) {
                width = 294;
            }
            if ((height = imagem.getHeight(null)) < 0) {
                height = 292;
            }
            BufferedImage buffered_old = null;
            if (imagem instanceof BufferedImage) {
                buffered_old = (BufferedImage)imagem;
            } else {
                ToolkitImage tool = (ToolkitImage)imagem;
                if (null != tool.getBufferedImage()) {
                    buffered_old = tool.getBufferedImage();
                }
            }
            if (null == buffered_old) {
                return null;
            }
            byte[] imagemBytes = null;
            try {
                BufferedImage buffered_new = ImagemUtils.padronizarImagemComBiblioteca(buffered_old);
                buffered_new.createGraphics().drawImage(buffered_old, 0, 0, Color.WHITE, null);
                imagemBytes = ImagemUtils.converterBufferedImageToByteArray(buffered_new);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "imageToByte");
            }
            return imagemBytes;
        }
        return null;
    }

    public static ImageIcon criaImageIcon(String path, Class resource) {
        URL imgURL = resource.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    public static ImageIcon carregaImagemJalis(String imageName) {
        return ImagemUtils.carregaImagemJalis("jalis", imageName);
    }

    public static ImageIcon carregaImagemJalis(String packageName, String imageName) {
        try {
            return new ImageIcon(ImagemUtils.class.getResource("/" + packageName + "/imagens/" + imageName));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageIcon criarImagemLegenda(int width, int height, Color color, Color colorBorder) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        g.setBackground(Color.WHITE);
        g.setColor(colorBorder != null ? colorBorder : color);
        g.drawRect(0, 0, width - 1, height - 1);
        g.setColor(color);
        g.fillRect(1, 1, width - 2, height - 2);
        return new ImageIcon(img);
    }

    public static byte[] carregarImagem(String nomeDoArquivo) {
        byte[] imagemByte = null;
        try {
            BufferedImage bi = ImageIO.read(new File(nomeDoArquivo));
            BufferedImage imagem = ImagemUtils.padronizarImagemComBiblioteca(bi);
            imagemByte = ImagemUtils.converterBufferedImageToByteArray(imagem);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha ao carregar imagem - " + e.getMessage(), e.getStackTrace(), "carregarImagem");
        }
        return imagemByte;
    }

    public static byte[] converterBase64ParaByteArray(String imagemBase64) {
        byte[] imagemByte = null;
        try {
            BufferedImage bi = ImageIO.read(new ByteArrayInputStream(new Base64().decode(imagemBase64)));
            BufferedImage imagem = ImagemUtils.padronizarImagemComBiblioteca(bi);
            imagemByte = ImagemUtils.converterBufferedImageToByteArray(imagem);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha ao converter imagem Base64 - " + e.getMessage(), e.getStackTrace(), "converterBase64ParaBufferedImage");
        }
        return imagemByte;
    }

    public static BufferedImage padronizarImagemComBiblioteca(BufferedImage bi) throws IOException {
        return Thumbnails.of((BufferedImage[])new BufferedImage[]{bi}).size(bi.getWidth(), bi.getHeight()).outputFormat("PNG").outputQuality(1.0).asBufferedImage();
    }

    public static byte[] converterBufferedImageToByteArray(BufferedImage imagem) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imagem, "PNG", baos);
        baos.flush();
        byte[] imagemByte = baos.toByteArray();
        baos.close();
        return imagemByte;
    }

    public static String converterImagemParaBase64(Image imagem) {
        return new Base64().encodeAsString(ImagemUtils.imageToByte(imagem));
    }

    public static Image redimensionarImagemComBiblioteca(Image imagem, int width, int heigth) {
        BufferedImage bi = null;
        if (imagem instanceof BufferedImage) {
            bi = (BufferedImage)imagem;
        } else {
            ToolkitImage tool = (ToolkitImage)imagem;
            if (null != tool.getBufferedImage()) {
                bi = tool.getBufferedImage();
            }
        }
        ImageIcon icon = null;
        try {
            if (bi != null) {
                BufferedImage imagemRedimensionada = Thumbnails.of((BufferedImage[])new BufferedImage[]{bi}).forceSize(width, heigth).asBufferedImage();
                icon = new ImageIcon(imagemRedimensionada);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "Falha ao redimensionar imagem - " + e.getMessage(), e.getStackTrace(), "redimensionarImagemComBiblioteca");
        }
        return icon == null ? imagem : icon.getImage();
    }

    public static BufferedImage gerarQrCodeImagem(String textoQrCode, int largura, int altura) {
        byte[] qrCodeBytes = ImagemUtils.gerarQrCodeBytes(textoQrCode, largura, altura);
        BufferedImage imagemQrCode = null;
        if (null != qrCodeBytes) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(qrCodeBytes);
                imagemQrCode = ImageIO.read(is);
                ((InputStream)is).close();
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ImagemUtils.gerarQrCodeImagem");
            }
        }
        return imagemQrCode;
    }

    public static byte[] gerarQrCodeBytes(String textoQrCode, int largura, int altura) {
        byte[] qrCodeBytes = null;
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            int medidaPadrao = largura < altura ? largura : altura;
            BitMatrix bitMatrix = qrCodeWriter.encode(textoQrCode, BarcodeFormat.QR_CODE, medidaPadrao, medidaPadrao, new EnumMap(EncodeHintType.class));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)baos);
            qrCodeBytes = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ImagemUtils.gerarQrCodeBytes");
        }
        return qrCodeBytes;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bi;
    }

    public static BufferedImage girarImagem(Image image, int angulo) {
        ImageIcon icon = new ImageIcon(image);
        BufferedImage imagemGirada = null;
        try {
            imagemGirada = Thumbnails.of((BufferedImage[])new BufferedImage[]{ImagemUtils.toBufferedImage(icon.getImage())}).size(icon.getIconWidth(), icon.getIconHeight()).rotate((double)angulo).asBufferedImage();
        }
        catch (IOException e) {
            Funcoes.mensagem(new JDialog(), "N\u00e3o foi poss\u00edvel girar a imagem", 1);
        }
        return imagemGirada;
    }
}

