/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class HashList<E>
extends ArrayList<E> {
    private static final int HASH_TABLE_SIZE = 16383;
    private Entry[] hashArray = new Entry[16384];

    public HashList() {
    }

    public HashList(int initialCapacity) {
        super(initialCapacity);
    }

    public HashList(Collection<? extends E> c) {
        super(c);
    }

    @Override
    public boolean add(E element) {
        this.addToHashTable(element);
        return super.add(element);
    }

    @Override
    public void add(int index, E element) {
        this.addToHashTable(element);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E element : c) {
            this.addToHashTable(element);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (E element : c) {
            this.addToHashTable(element);
        }
        return super.addAll(index, c);
    }

    @Override
    public E remove(int index) {
        if (index > -1 && index < this.size()) {
            this.removeFromHashTable(this.get(index));
        }
        return super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.removeFromHashTable(o);
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.removeFromHashTable(o);
        }
        return super.removeAll(c);
    }

    @Override
    public boolean contains(Object elem) {
        Entry entry = this.hashArray[HashList.indexFor(HashList.hash(elem))];
        while (entry != null) {
            if (entry.equals(elem)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            this.removeFromHashTable(this.get(i));
        }
        super.removeRange(fromIndex, toIndex);
    }

    private void addToHashTable(Object element) {
        int h = HashList.hash(element);
        int index = HashList.indexFor(h);
        if (this.hashArray[index] == null) {
            this.hashArray[index] = new Entry<Object>(element, h);
        } else {
            Entry temp = this.hashArray[index];
            while (temp.next != null && !temp.equals(element)) {
                temp = temp.next;
            }
            if (temp.equals(element)) {
                ++temp.count;
            } else {
                temp.next = new Entry<Object>(element, h);
            }
        }
    }

    private void removeFromHashTable(Object element) {
        int h = HashList.hash(element);
        int index = HashList.indexFor(h);
        if (this.hashArray[index] != null) {
            Entry temp;
            Entry oldEntry = temp = this.hashArray[index];
            while (temp.next != null && !temp.equals(element)) {
                oldEntry = temp;
                temp = temp.next;
            }
            if (temp.equals(element)) {
                if (temp.count > 0) {
                    --temp.count;
                } else if (temp == this.hashArray[index]) {
                    this.hashArray[index] = temp.next;
                } else {
                    oldEntry.next = temp.next;
                }
            }
        }
    }

    private static int hash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    private static int indexFor(int hash) {
        return hash & 0x3FFF;
    }

    private class Entry<E>
    implements Cloneable {
        E element;
        int count;
        final int hash;
        Entry next;

        public Entry(E element, int hash) {
            this.element = element;
            this.hash = hash;
        }

        public boolean equals(Object o) {
            return this.element == o || this.element != null && this.element.equals(o);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

