/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import br.com.thread.pdfbox.pdmodel.PDDocument;
import br.com.thread.pdfbox.printing.PDFPageable;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.thread.ExportaWeb2;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.servidor.Cliente;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.MostraCalendario;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TDialog;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.postgresql.util.PGInterval;

public class Funcoes {
    private static long millisDiferecaDataHoraServidor = 0L;
    public static char[] alfabeto = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final PrintService[] impressoras = PrintServiceLookup.lookupPrintServices(null, null);
    public static final String SELECIONAR_IMPRESSORA = "Selecionar Impressora";
    private static final Action acaoEnter = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FocusManager.getCurrentManager().getActiveWindow().isActive()) {
                return;
            }
            Component owner = FocusManager.getCurrentManager().getFocusOwner();
            if (owner instanceof JButton) {
                ((JButton)owner).doClick();
            } else if (!(owner instanceof JTextArea) && !(owner instanceof JMenuItem)) {
                FocusManager.getCurrentManager().focusNextComponent();
            }
        }
    };
    public static final int ESQUERDA = 1;
    public static final int DIREITA = 2;
    public static final int MENSAGEM_ERRO = 1;
    public static final int MENSAGEM_AVISO = 2;
    public static final int MENSAGEM_COMUM = 3;
    public static final int MENSAGEM_PERGUNTA = 4;
    public static final int MENSAGEM_INFORMACAO = 5;
    public static final int MENSAGEM_PERGUNTA_LISTA_MATERIAIS = 6;

    public static boolean validaCartaoCredito(String numeroCartao, String bandeiraCartao) {
        if (numeroCartao == null || Funcoes.textoVazio(numeroCartao) || bandeiraCartao == null || Funcoes.textoVazio(bandeiraCartao)) {
            return false;
        }
        if ((bandeiraCartao = bandeiraCartao.toUpperCase()).contains("MASTERCARD") || bandeiraCartao.contains("VISA")) {
            return numeroCartao.length() == 16;
        }
        return true;
    }

    public static String getTempoPorExtenso(int quantidadeDias) {
        StringBuilder buf = new StringBuilder();
        int aux = quantidadeDias / 365;
        if (aux > 0) {
            buf.append(aux).append(aux > 1 ? " anos" : " ano");
        }
        if ((aux = quantidadeDias % 365 / 30) > 0) {
            buf.append(buf.length() > 0 ? ", " : "").append(aux).append(aux > 1 ? " meses" : " m\u00eas");
        }
        aux = quantidadeDias % 365 % 30;
        buf.append(buf.length() > 0 ? " e " : "").append(aux).append(aux > 1 ? " dias" : " dia");
        return buf.toString();
    }

    public static String getIdadePorExtenso(String dataNascimento, String dataRequisicao) {
        if (!Funcoes.textoVazio(dataNascimento)) {
            DateTime dateTime = new DateTime((Object)Funcoes.stringToDate(dataNascimento));
            DateTime dateTimeFinal = new DateTime((Object)(!Funcoes.textoVazio(dataRequisicao) ? Funcoes.stringToDate(dataRequisicao) : Calendar.getInstance().getTime()));
            Period period = new Period((ReadableInstant)dateTime, (ReadableInstant)dateTimeFinal, PeriodType.yearMonthDay());
            StringBuilder buf = new StringBuilder();
            if (period.getYears() > 0) {
                buf.append(period.getYears()).append(period.getYears() > 1 ? " anos" : " ano");
            }
            if (period.getMonths() > 0) {
                buf.append(buf.length() > 0 ? ", " : "").append(period.getMonths()).append(period.getMonths() > 1 ? " meses" : " m\u00eas");
            }
            if (period.getDays() > 0) {
                buf.append(buf.length() > 0 ? " e " : "").append(period.getDays()).append(period.getDays() > 1 ? " dias" : " dia");
            }
            return buf.toString();
        }
        return "";
    }

    public static String getIdadePorExtenso(Date dataNascimento, Date dataRequisicao) {
        if (dataNascimento != null) {
            return Funcoes.getIdadePorExtenso(Funcoes.formataData("dd/MM/yyyy", dataNascimento), dataRequisicao != null ? Funcoes.formataData("dd/MM/yyyy", dataRequisicao) : Funcoes.formataData("dd/MM/yyyy", Calendar.getInstance().getTime()));
        }
        return "";
    }

    public static int getDiaSemana(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        return calendar.get(7);
    }

    public static String getDiaSemanaPorExtenso(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        int aux = calendar.get(7);
        switch (aux) {
            case 1: {
                return "Domingo";
            }
            case 2: {
                return "Segunda-feira";
            }
            case 3: {
                return "Ter\u00e7a-feira";
            }
            case 4: {
                return "Quarta-feira";
            }
            case 5: {
                return "Quinta-feira";
            }
            case 6: {
                return "Sexta-feira";
            }
            case 7: {
                return "S\u00e1bado";
            }
        }
        return "Inexistente";
    }

    public static String preencheZero(long numero, int casas) {
        return Funcoes.preencheZero(String.valueOf(numero), casas);
    }

    public static BigDecimal calculaPercentual(double percentual, double valorAtual, boolean arrendondarCentavos, boolean isDiminuir, int casas) {
        BigDecimal valor = new BigDecimal(valorAtual).setScale(casas, ParametrosGerais.getArredondamentoPrecoExame());
        valor = isDiminuir ? valor.subtract(valor.multiply(new BigDecimal(percentual).divide(new BigDecimal(100)))) : valor.add(valor.multiply(new BigDecimal(percentual).divide(new BigDecimal(100))));
        if (arrendondarCentavos) {
            valor = valor.setScale(0, ParametrosGerais.getArredondamentoPrecoExame());
        }
        return valor;
    }

    public static String preencheZero(int numero, int casas) {
        return Funcoes.preencheZero(String.valueOf(numero), casas);
    }

    public static String preencheZero(String texto, int casas) {
        String retorno = new String(texto);
        if (texto.length() > casas) {
            return texto;
        }
        for (int i = 1; i <= casas - texto.length(); ++i) {
            retorno = "0" + retorno;
        }
        return retorno;
    }

    public static String montaLista(ArrayList<String> listaObjetos) {
        StringBuilder stringResult = new StringBuilder();
        if (listaObjetos != null && listaObjetos.size() > 0) {
            stringResult.append("(");
            for (int i = 0; i < listaObjetos.size(); ++i) {
                if (i < listaObjetos.size() - 1) {
                    stringResult.append(listaObjetos.get(i)).append(", ");
                    continue;
                }
                stringResult.append(listaObjetos.get(i)).append(") ");
            }
        }
        return stringResult.toString();
    }

    public static String preencheVazio(String texto, String caracter, int casas, int lado) {
        String retorno = new String(texto);
        if (texto.length() > casas) {
            return texto;
        }
        for (int i = 1; i <= casas - texto.length(); ++i) {
            retorno = lado == 1 ? caracter + retorno : retorno + caracter;
        }
        return retorno;
    }

    public static String preencheVazio(String texto, int casas, int lado) {
        return Funcoes.preencheVazio(texto, " ", casas, lado);
    }

    public static String preencheVazioHtml(String texto, int casas, int lado) {
        return Funcoes.preencheVazio(texto, "&nbsp;", casas, lado);
    }

    public static String formataDecimal(String modelo, double valor) {
        DecimalFormat meuFormato = new DecimalFormat(modelo);
        return meuFormato.format(valor);
    }

    public static String formataDecimal(String modelo, int valor) {
        return Funcoes.formataDecimal(modelo, (double)valor);
    }

    public static String formataDecimal(double valor) {
        return Funcoes.formataDecimal("###,##0.00", valor);
    }

    public static String formataDecimal(int valor) {
        return Funcoes.formataDecimal("###,##0.00", (double)valor);
    }

    public static String formataDecimal(double valor, int precisaoCasas) {
        DecimalFormat meuFormato = new DecimalFormat("###,##0." + Funcoes.preencheZero(0, precisaoCasas));
        meuFormato.setMinimumFractionDigits(precisaoCasas);
        meuFormato.setRoundingMode(ParametrosGerais.getArredondamentoPrecoExame());
        return meuFormato.format(valor);
    }

    public static String formataDecimal(String valor, int precisaoCasas, RoundingMode arredondamento) {
        DecimalFormat meuFormato = new DecimalFormat("###,##0." + Funcoes.preencheZero(0, precisaoCasas));
        meuFormato.setMinimumFractionDigits(precisaoCasas);
        meuFormato.setRoundingMode(arredondamento);
        return meuFormato.format(Double.parseDouble(valor));
    }

    public static String limpaDecimal(String texto) {
        if (texto == null) {
            return null;
        }
        String retorno = texto.indexOf(".") > 0 && texto.indexOf(",") > 0 ? texto.replaceAll("\\.", "").replaceAll(",", ".") : texto.replaceAll(",", ".");
        if (!Funcoes.textoVazio(retorno.replaceAll("\\,", "").replaceAll("\\.", ""))) {
            try {
                Double.parseDouble(retorno);
                return retorno;
            }
            catch (Exception e) {
                return "0";
            }
        }
        return "0";
    }

    public static String limpaDecimalValidarNumeric(String texto) {
        if (texto == null) {
            return null;
        }
        if (texto.indexOf(".") > 0 && texto.indexOf(",") > 0) {
            return texto.replaceAll("\\.", "").replaceAll(",", ".");
        }
        return texto.replaceAll(",", ".");
    }

    public static int mdc(int a, int b) {
        if (b == 0) {
            return a;
        }
        return Funcoes.mdc(b, a % b);
    }

    public static String limpaDecimal(Double valor) {
        return Funcoes.limpaDecimal(String.valueOf(valor));
    }

    public static String limpaPercentual(String texto) {
        String temp = texto;
        if (texto.indexOf("%") > 0) {
            temp = texto.substring(0, texto.indexOf("%"));
        }
        return Funcoes.limpaDecimal(temp);
    }

    public static String formataHora(Date hora, boolean showSeconds) {
        if (null == hora) {
            return "";
        }
        String formato = "HH:mm";
        if (showSeconds) {
            formato = "HH:mm:ss";
        }
        SimpleDateFormat meuFormato = new SimpleDateFormat(formato);
        return meuFormato.format(hora);
    }

    public static String formataHora(Date hora, String timezone, boolean showSeconds) {
        if (null == hora) {
            return "";
        }
        String formato = "HH:mm";
        if (showSeconds) {
            formato = "HH:mm:ss";
        }
        SimpleDateFormat meuFormato = new SimpleDateFormat(formato);
        meuFormato.setTimeZone(TimeZone.getTimeZone(timezone));
        return meuFormato.format(hora);
    }

    public static boolean validaEmail(String email) {
        return email.matches("^[\\w-]+(\\.[\\w-]+)*@([\\w-]+\\.)+[a-zA-Z]{2,7}$");
    }

    public static double desvioPadrao(List<Long> valores) {
        if (valores.size() == 1) {
            return 0.0;
        }
        double somatorio = 0.0;
        double somaValores = 0.0;
        for (int i = 0; i < valores.size(); ++i) {
            somatorio += (double)(valores.get(i) * valores.get(i));
            somaValores += (double)valores.get(i).longValue();
        }
        somaValores *= somaValores;
        return Math.sqrt((somatorio - (somaValores /= (double)valores.size())) / (double)(valores.size() - 1));
    }

    public static String formataData(String modelo, Date data) {
        if (data == null) {
            return "";
        }
        SimpleDateFormat meuFormato = new SimpleDateFormat(modelo);
        return meuFormato.format(data);
    }

    public static String formataCepPadrao(String cep) {
        StringBuffer sb = new StringBuffer(cep);
        sb.insert(5, "-");
        return sb.toString();
    }

    public static String formataData(Date data) {
        if (data == null) {
            return "";
        }
        return Funcoes.formataData("dd/MM/yyyy", data);
    }

    public static String formataDataReduzida(Date data) {
        if (data == null) {
            return "";
        }
        return Funcoes.formataData("MM/yy", data);
    }

    public static XMLGregorianCalendar converterDataEmXMLGregorianCalendar(Date data) throws DatatypeConfigurationException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(data);
        XMLGregorianCalendar xmlDate3 = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(10), cal.get(12), cal.get(13), Integer.MIN_VALUE, Integer.MIN_VALUE);
        return xmlDate3;
    }

    public static int diasPorPeriodo(String dataInicial, String dataFinal) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
        DateTime dtInicial = formatter.parseDateTime(dataInicial);
        DateTime dtFinal = formatter.parseDateTime(dataFinal);
        return Days.daysBetween((ReadablePartial)dtInicial.toLocalDate(), (ReadablePartial)dtFinal.toLocalDate()).getDays();
    }

    public static String formataData(String padrao, String data) {
        return Funcoes.formataData(padrao, Funcoes.stringToDate(data));
    }

    public static String formataDataHora(String padrao, String data) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(padrao);
            return sdf.format(sdf.parse(data));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "formataDataHora");
            return "";
        }
    }

    public static String formataDataEHora(String data) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        SimpleDateFormat sdfAux = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dataFormatada = "";
        try {
            if (!Funcoes.textoVazio(data) && !data.equalsIgnoreCase("null")) {
                dataFormatada = sdf.format(sdfAux.parse(data));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dataFormatada;
    }

    public static String formataDataEHoraESegundo(String data) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        SimpleDateFormat sdfAux = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormatada = "";
        try {
            if (!Funcoes.textoVazio(data) && !data.equalsIgnoreCase("null")) {
                dataFormatada = sdf.format(sdfAux.parse(data));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dataFormatada;
    }

    public static String formataDataEHoraESegundoDB(String data) {
        SimpleDateFormat sdfAux = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormatada = "";
        try {
            if (!Funcoes.textoVazio(data) && !data.equalsIgnoreCase("null")) {
                dataFormatada = sdf.format(sdfAux.parse(data));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dataFormatada;
    }

    public static String formatDataEHora(String data) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        SimpleDateFormat sdfAux = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        String dataFormatada = "";
        try {
            if (!Funcoes.textoVazio(data) && !data.equalsIgnoreCase("null")) {
                dataFormatada = sdfAux.format(sdf.parse(data));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dataFormatada;
    }

    public static String formatDataHora(String data) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat sdfAux = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dataFormatada = "";
        try {
            if (!Funcoes.textoVazio(data) && !data.equalsIgnoreCase("null")) {
                dataFormatada = sdf.format(sdfAux.parse(data));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dataFormatada;
    }

    public static String formataDataHora(String data) {
        return Funcoes.formataDataHora("dd/MM/yyyy HH:mm", data);
    }

    public static Date getDataHoraServidor() {
        return Funcoes.stringToDate("dd/MM/yyyy HH:mm:ss", Cliente.getInstancia().getDataHoraServidor());
    }

    public static Date getDataServidor() {
        return Funcoes.stringToDate("dd/MM/yyyy", Cliente.getInstancia().getDataServidor());
    }

    public static Date getHoraServidor() {
        return Funcoes.stringToDate("HH:mm:ss", Cliente.getInstancia().getHoraServidor());
    }

    public static Date getDataComException(String masc, String data) throws Exception {
        Date date = null;
        date = new SimpleDateFormat(masc).parse(data);
        return date;
    }

    public static Date getData(String masc, String data) {
        Date date = null;
        try {
            date = new SimpleDateFormat(masc).parse(data);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "getData");
        }
        return date;
    }

    public static Date getDataSemErrorLogger(String masc, String data) throws ParseException {
        Date date = null;
        date = new SimpleDateFormat(masc).parse(data);
        return date;
    }

    public static Date stringToDate(String formato, String data) {
        try {
            return new SimpleDateFormat(formato).parse(data);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "stringToDate");
            return new Date();
        }
    }

    public static Date stringToDate(String texto) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            return sdf.parse(texto);
        }
        catch (ParseException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "stringToDate " + texto);
            return new Date();
        }
    }

    public static String booleanToString(boolean selecionado) {
        return selecionado ? "true" : "false";
    }

    public static Date timestampToDate(String texto) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            return sdf.parse(texto.replace('-', '/'));
        }
        catch (ParseException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "timestampToDate");
            return new Date();
        }
    }

    public static Date pgDatetoDate(String texto) {
        String data;
        Date retorno = texto != null ? (Funcoes.verificaData(data = texto.substring(8, 10) + "/" + texto.substring(5, 7) + "/" + texto.substring(0, 4)) ? Funcoes.stringToDate(data) : new Date()) : new Date();
        return retorno;
    }

    public static boolean verificaTimestamp(String texto) {
        return Funcoes.verificaTimestamp("dd/MM/yyyy HH:mm", texto);
    }

    public static boolean verificaTimestamp(String formato, String texto) {
        if (texto == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(formato);
        try {
            sdf.setLenient(false);
            sdf.parse(texto);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static boolean validaIP(String ip) {
        Pattern ptn = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
        Matcher match = ptn.matcher(ip);
        return match.find();
    }

    public static boolean verificaData(String texto) {
        return Funcoes.verificaData("dd/MM/yyyy", texto);
    }

    public static boolean verificaDataAtual(String texto) {
        return Funcoes.verificaDataAtual("dd/MM/yyyy", texto);
    }

    public static boolean verificaDiaMes(String texto) {
        return Funcoes.verificaData("dd/MM", texto);
    }

    public static boolean verificaDataReduzida(String texto) {
        return Funcoes.verificaData("MM/yy", texto);
    }

    public static boolean verificaDataHora(String dataHora) {
        return Funcoes.verificaData("dd/MM/yyyy HH:mm", dataHora);
    }

    public static boolean verificaData(String formato, String texto) {
        if (texto == null) {
            return false;
        }
        Date DATA_BASE = Funcoes.stringToDate("01/01/1900");
        SimpleDateFormat sdf = new SimpleDateFormat(formato);
        try {
            sdf.setLenient(false);
            Date d = sdf.parse(texto);
            return !d.before(DATA_BASE);
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static boolean verificaDataAtual(String formato, String texto) {
        if (texto == null) {
            return false;
        }
        Date DATA_BASE = Funcoes.getDataServidor();
        SimpleDateFormat sdf = new SimpleDateFormat(formato);
        try {
            sdf.setLenient(false);
            Date d = sdf.parse(texto);
            return !d.before(DATA_BASE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean verificaHora(String texto) {
        if (texto == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        sdf.setLenient(false);
        try {
            sdf.parse(texto);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static Boolean verificaFiliaisIntegracao(String filial) {
        if (Funcoes.textoVazio(filial)) {
            return false;
        }
        String filiais = ParametrosGerais.getFiliaisIntegracao();
        if (!Funcoes.textoVazio(filiais)) {
            String[] aux = StringUtil.getValores(filiais, "filiaisIntegracao");
            for (String fil : aux[0].split(",")) {
                if (!fil.equalsIgnoreCase(filial)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean verificaIntervaloHora(String intervalo) {
        return intervalo.matches("([0-9]\\d|2[0-9]):[0-5]\\d");
    }

    public static int mensagem(Component componente, String texto, int tipoMensagem) {
        return Funcoes.mensagem(componente, texto, tipoMensagem, false);
    }

    public static int mensagem(Component componente, String texto, int tipoMensagem, boolean focoBotaoSim) {
        TDialog dialog = new TDialog();
        switch (tipoMensagem) {
            case 2: {
                return dialog.showMessage(componente, texto, 2);
            }
            case 3: {
                return dialog.showMessage(componente, texto, -1);
            }
            case 1: {
                return dialog.showMessage(componente, texto, 0);
            }
            case 5: {
                return dialog.showMessage(componente, texto, 1);
            }
            case 4: {
                return dialog.showMessage(componente, texto, 3, focoBotaoSim ? 0 : 1);
            }
            case 6: {
                return dialog.showMessage(componente, texto, 2, 3);
            }
        }
        return 0;
    }

    public static <T extends Window> int showErro(T parent, String mensagem) {
        return new TDialog().showErro(parent, "", mensagem);
    }

    public static <T extends Window> String showDigitacao(T parent, String titulo, String mensagem, String valor_Predefinido) {
        TDialog dialog = new TDialog();
        return dialog.showDigitacao(parent, titulo, mensagem, valor_Predefinido);
    }

    public static <T extends Window> int showPerguntaOpcoes(T parent, String mensagem, String[] opcoes, char[] mnemonicos) {
        return new TDialog().showPerguntaOpcoes(parent, mensagem, opcoes, mnemonicos);
    }

    public static <T extends Window> int showPerguntaOpcoes(T parent, String titulo, String mensagem, String[] opcoes, char[] mnemonicos, int icone) {
        return new TDialog().showPerguntaOpcoes(parent, titulo, mensagem, opcoes, mnemonicos, icone);
    }

    public static <T extends Window> int showPerguntaOpcoes(T parent, String mensagem, String[] opcoes) {
        return new TDialog().showPerguntaOpcoes(parent, mensagem, opcoes);
    }

    public static <T extends Window> int showAlertaOK(T parent, String mensagem) {
        return new TDialog().showAlertaOK(parent, mensagem);
    }

    public static <T extends Window> int showPerguntaSimNao(T parent, String titulo, String mensagem) {
        return new TDialog().showPerguntaSimNao(parent, titulo, mensagem, 0);
    }

    public static boolean isNumeric(String valor) {
        try {
            Double.parseDouble(Funcoes.limpaDecimalValidarNumeric(valor));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void criaBarraDescricao(JPanel painelPrincipal, String textoFormulario, String textoDescricao, String pathIcone) {
        Funcoes.criaBarraDescricao(painelPrincipal, textoFormulario, textoDescricao, pathIcone, null);
    }

    public static void criaBarraDescricao(JPanel painelPrincipal, String textoFormulario, String textoDescricao, String pathIcone, JLabel labelFoto) {
        JLabel labelFormulario = new JLabel(textoFormulario);
        JLabel labelDescricao = new JLabel(textoDescricao);
        JLabel labelIcone = new JLabel("");
        if (pathIcone != null) {
            ImageIcon icone = ImagemUtils.carregaImagemJalis(pathIcone);
            labelIcone.setIcon(icone);
            labelIcone.revalidate();
        }
        labelIcone.setPreferredSize(new Dimension(90, 80));
        labelIcone.setHorizontalAlignment(0);
        if (labelFoto != null) {
            labelFoto.setPreferredSize(new Dimension(90, 80));
            labelFoto.setHorizontalAlignment(0);
        }
        JPanel painelTopo = new JPanel(new BorderLayout());
        JPanel painelTopoCentro = new JPanel(new BorderLayout());
        painelTopo.add((Component)painelTopoCentro, "Center");
        painelTopo.add((Component)labelIcone, "West");
        if (labelFoto != null) {
            painelTopo.add((Component)labelFoto, "East");
        }
        JPanel p = ComponenteFactory.novoJPanelBorderLayout(new EmptyBorder(20, 0, 3, 5), (Component)labelFormulario, null, null, null, null);
        p.setBackground(Color.WHITE);
        painelTopoCentro.add((Component)p, "North");
        p = ComponenteFactory.novoJPanelBorderLayout(null, labelDescricao, null, null, null);
        p.setBackground(Color.WHITE);
        painelTopoCentro.add((Component)p, "Center");
        painelTopo.setBackground(Color.WHITE);
        painelTopo.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, new Color(255, 170, 0)));
        painelTopoCentro.setBackground(Color.BLUE);
        painelTopo.setPreferredSize(new Dimension(100, 80));
        labelDescricao.setFont(new Font("Arial", 0, 10));
        labelFormulario.setFont(new Font("Arial", 1, 22));
        painelTopo.setFocusable(false);
        painelPrincipal.add((Component)painelTopo, "North");
    }

    public static void habilita(JPanel painel, int status) {
        Funcoes.habilita(painel, status, false, null);
    }

    public static void habilita(JPanel painel, int status, boolean isNaoAlterar, Component compIgnorado) {
        if (painel.getComponentCount() > 0) {
            for (int i = 0; i < painel.getComponentCount(); ++i) {
                if (painel.getComponent(i) instanceof JLabel) continue;
                if (painel.getComponent(i) instanceof JPanel) {
                    Funcoes.habilita((JPanel)painel.getComponent(i), status, isNaoAlterar, compIgnorado);
                    continue;
                }
                if (painel.getComponent(i) instanceof JScrollPane) {
                    for (int j = 0; j < ((JScrollPane)painel.getComponent(i)).getViewport().getComponentCount(); ++j) {
                        ((JScrollPane)painel.getComponent(i)).getViewport().getComponent(j).setEnabled((status == 3 || status == 2) && !isNaoAlterar);
                    }
                    continue;
                }
                if (compIgnorado != null && painel.getComponent(i).equals(compIgnorado)) continue;
                painel.getComponent(i).setEnabled((status == 3 || status == 2) && !isNaoAlterar);
            }
        }
    }

    public static void limpa(JPanel painel) {
        if (painel.getComponentCount() > 0) {
            for (int i = 0; i < painel.getComponentCount(); ++i) {
                if (painel.getComponent(i) instanceof JLabel) continue;
                if (painel.getComponent(i) instanceof TTextField) {
                    ((TTextField)painel.getComponent(i)).clear();
                    continue;
                }
                if (painel.getComponent(i) instanceof JTextField) {
                    ((JTextField)painel.getComponent(i)).setText("");
                    continue;
                }
                if (painel.getComponent(i) instanceof JScrollPane) {
                    if (((JScrollPane)painel.getComponent(i)).getViewport().getComponent(0) instanceof JTextArea) {
                        ((JTextArea)((JScrollPane)painel.getComponent(i)).getViewport().getComponent(0)).setText("");
                        continue;
                    }
                    if (!(((JScrollPane)painel.getComponent(i)).getViewport().getComponent(0) instanceof JTable) || !(((JTable)((JScrollPane)painel.getComponent(i)).getViewport().getComponent(0)).getModel() instanceof ModeloGridTable)) continue;
                    ((ModeloGridTable)((JTable)((JScrollPane)painel.getComponent(i)).getViewport().getComponent(0)).getModel()).clear();
                    continue;
                }
                if (painel.getComponent(i) instanceof JCheckBox) {
                    ((JCheckBox)painel.getComponent(i)).setSelected(false);
                    continue;
                }
                if (!(painel.getComponent(i) instanceof JComboBox) || ((JComboBox)painel.getComponent(i)).getItemCount() <= 0) continue;
                ((JComboBox)painel.getComponent(i)).setSelectedIndex(0);
            }
        }
    }

    public static String calculaIdade(String dataNascimento) {
        return Funcoes.calculaIdade(dataNascimento, Funcoes.formataData(new Date()), true);
    }

    public static String calculaIdade(String dataNascimento, boolean mostraAnoMes) {
        return Funcoes.calculaIdade(dataNascimento, Funcoes.formataData(new Date()), mostraAnoMes);
    }

    public static String calculaIdade(String dataNascimento, String dataBase) {
        return Funcoes.calculaIdade(dataNascimento, dataBase, true);
    }

    public static String calculaIdade(String dataNascimento, String dataBase, boolean mostraAnoMes) {
        if (dataNascimento != null && !Funcoes.textoVazio(dataNascimento) && Funcoes.verificaData(dataNascimento) && Funcoes.verificaData(dataBase) && Funcoes.stringToDate(dataNascimento).compareTo(Funcoes.stringToDate(dataBase)) <= 0) {
            int difano = Funcoes.yearsBetween(Funcoes.stringToDate(dataNascimento), Funcoes.stringToDate(dataBase));
            int difmes = Funcoes.monthBetween(Funcoes.stringToDate(dataNascimento), Funcoes.stringToDate(dataBase));
            int difdia = Funcoes.daysBetween(Funcoes.stringToDate(dataNascimento), Funcoes.stringToDate(dataBase));
            if (difano > 0) {
                return String.valueOf(difano) + (mostraAnoMes ? " ano(s)" : "");
            }
            if (difmes > 0) {
                return String.valueOf(difmes) + (mostraAnoMes ? " mes(es)" : "");
            }
            return String.valueOf(difdia) + (mostraAnoMes ? " dia(s)" : "");
        }
        return "0" + (mostraAnoMes ? " ano(s)" : "");
    }

    public static String calculaAnoMes(String dataNascimento) {
        return Funcoes.calculaAnoMes(dataNascimento, Funcoes.formataData(new Date()));
    }

    public static String calculaAnoMes(String dataNascimento, String dataBase) {
        if (dataNascimento != null && !Funcoes.textoVazio(dataNascimento) && Funcoes.verificaData(dataNascimento) && Funcoes.verificaData(dataBase) && Funcoes.stringToDate(dataNascimento).compareTo(Funcoes.stringToDate(dataBase)) <= 0) {
            int difano = Funcoes.yearsBetween(Funcoes.stringToDate(dataNascimento));
            int difmes = Funcoes.monthBetween(Funcoes.stringToDate(dataNascimento));
            if (difano > 0) {
                return "A";
            }
            if (difmes > 0) {
                return "M";
            }
            return "D";
        }
        return "A";
    }

    public static boolean checkIntervaloIdade(int idadeIni, int idadeFim, String tipoIni, String tipoFim) {
        boolean TIPO_ANO = false;
        boolean TIPO_MES = true;
        int TIPO_DIA = 2;
        int tipoI = 0;
        int tipoF = 0;
        int idadeI = 0;
        int idadeF = 0;
        boolean retorno = true;
        if (tipoIni.substring(0, 1).equalsIgnoreCase("M")) {
            tipoI = 1;
        } else if (tipoIni.substring(0, 1).equalsIgnoreCase("D")) {
            tipoI = 2;
        }
        if (tipoFim.substring(0, 1).equalsIgnoreCase("M")) {
            tipoF = 1;
        } else if (tipoFim.substring(0, 1).equalsIgnoreCase("D")) {
            tipoF = 2;
        }
        int n = tipoI == 2 ? idadeIni : (idadeI = tipoI == 1 ? idadeIni * 30 : idadeIni * 365);
        idadeF = tipoF == 2 ? idadeFim : (tipoF == 1 ? idadeFim * 30 : idadeFim * 365);
        retorno = idadeI <= idadeF;
        return retorno;
    }

    public static boolean textoVazio(String texto) {
        return texto == null || texto.trim().length() <= 0;
    }

    public static boolean objectIsNull(Object obj) {
        return obj == null;
    }

    public static boolean textoVazioNotNullIsNumberTubo(String texto) {
        if (texto == null) {
            return false;
        }
        if (texto != null && texto.trim().length() <= 0) {
            return false;
        }
        if (texto != null && texto.trim().length() > 0 && texto.trim().equalsIgnoreCase("null")) {
            return false;
        }
        if (texto != null && texto.trim().length() > 0 && texto.trim().equalsIgnoreCase("{null}")) {
            return false;
        }
        if (texto != null && texto.trim().length() > 0 && texto.trim().contains("null")) {
            return false;
        }
        if (texto != null && texto.trim().length() > 0 && texto.trim().contains("}")) {
            return false;
        }
        if (texto != null && texto.trim().length() > 0 && texto.trim().contains("{")) {
            return false;
        }
        return Funcoes.isNumeric(texto);
    }

    public static boolean textoVazioNotNullIsText(String texto) {
        if (texto == null) {
            return false;
        }
        if (texto != null && texto.trim().length() <= 0) {
            return false;
        }
        if (texto != null && texto.trim().length() > 0 && texto.trim().equalsIgnoreCase("null")) {
            return false;
        }
        if (texto != null && texto.trim().length() > 0 && texto.trim().equalsIgnoreCase("{null}")) {
            return false;
        }
        if (texto != null && texto.trim().length() > 0 && texto.trim().contains("null")) {
            return false;
        }
        return !Funcoes.isNumeric(texto);
    }

    public static boolean textoVazio(JTextField t) {
        return Funcoes.textoVazio(t.getText());
    }

    public static void defineUpperCase(Container c, boolean upper) {
        Component[] comp = c.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (comp[i] instanceof TTextField) {
                ((TTextField)comp[i]).setUpperCase(upper);
                continue;
            }
            if (comp[i] instanceof JTextArea && ((JTextArea)comp[i]).getDocument() instanceof TTextAreaDocument) {
                ((TTextAreaDocument)((JTextArea)comp[i]).getDocument()).setUpperCase(upper);
                continue;
            }
            if (!(comp[i] instanceof Container)) continue;
            Funcoes.defineUpperCase((Container)comp[i], upper);
        }
    }

    public static void mostraData(TTextField owner, JButton botao, JPanel panelPai, boolean focus) {
        JPopupMenu menu = new JPopupMenu();
        MostraCalendario calendario = new MostraCalendario(owner, Funcoes.verificaData(owner.getText()) ? owner.getText() : Funcoes.formataData(new Date()), menu);
        menu.add(calendario);
        calendario.setDate(Funcoes.verificaData(owner.getText()) ? owner.getText() : Funcoes.formataData(new Date()));
        menu.show(panelPai, botao.getX(), botao.getY() + botao.getHeight());
    }

    public static void mostraDataHora(TTextField owner, JButton botao, JPanel panelPai, boolean focus) {
        JPopupMenu menu = new JPopupMenu();
        MostraCalendario calendario = new MostraCalendario();
        calendario.montaCalendario(owner, Funcoes.verificaData(owner.getText()) ? owner.getText() : Funcoes.formataData(new Date()), menu, true);
        menu.add(calendario);
        calendario.setDate(Funcoes.verificaData(owner.getText()) ? owner.getText() : Funcoes.formataData(new Date()));
        menu.show(panelPai, botao.getX(), botao.getY() + botao.getHeight());
        if (!Funcoes.textoVazio(owner.getText())) {
            owner.setText(owner.getText() + "" + Funcoes.formataHora(new Date(), false));
        }
    }

    public static int daysBetween(Date data) {
        return Funcoes.daysBetween(data, new Date());
    }

    public static int yearsBetween(Date data) {
        return Funcoes.yearsBetween(data, new Date());
    }

    public static int monthBetween(Date data) {
        return Funcoes.monthBetween(data, new Date());
    }

    public static Date lastDayMonth(Date data) {
        GregorianCalendar auxCalendar = new GregorianCalendar();
        auxCalendar.setTime(data);
        auxCalendar.set(5, 1);
        ((Calendar)auxCalendar).add(2, 1);
        ((Calendar)auxCalendar).add(5, -1);
        return auxCalendar.getTime();
    }

    public static Date firstDayYear(Date data) {
        GregorianCalendar primeiroDia = new GregorianCalendar();
        GregorianCalendar auxData = new GregorianCalendar();
        auxData.setTime(data);
        primeiroDia.clear();
        primeiroDia.set(auxData.get(1), 0, 1);
        return primeiroDia.getTime();
    }

    public static Date lastDayYear(Date data) {
        GregorianCalendar ultimoDia = new GregorianCalendar();
        GregorianCalendar auxData = new GregorianCalendar();
        auxData.setTime(data);
        ultimoDia.set(auxData.get(1), 11, 1);
        ultimoDia.setTime(Funcoes.lastDayMonth(ultimoDia.getTime()));
        return ultimoDia.getTime();
    }

    public static int getQtdeDiasAno(Date data) {
        return Funcoes.daysBetween(Funcoes.firstDayYear(data), Funcoes.lastDayYear(data)) + 1;
    }

    public static int minutesBetween(Date data, Date dataBase) {
        Calendar atual = Calendar.getInstance();
        GregorianCalendar novo = new GregorianCalendar();
        novo.setTime(data);
        if (dataBase != null) {
            atual.setTime(dataBase);
        }
        long millisBetween = Math.abs(atual.getTime().getTime() - novo.getTime().getTime());
        millisBetween = Math.abs(novo.getTime().getTime() - atual.getTime().getTime());
        return Math.round(millisBetween / 60000L);
    }

    public static int daysBetween(Date data, Date dataBase) {
        Calendar atual = Calendar.getInstance();
        GregorianCalendar novo = new GregorianCalendar();
        novo.setTime(data);
        if (dataBase != null) {
            atual.setTime(dataBase);
        }
        long millisBetween = Math.abs(atual.getTime().getTime() - novo.getTime().getTime());
        millisBetween = Math.abs(novo.getTime().getTime() - atual.getTime().getTime());
        return Math.round(millisBetween / 86400000L);
    }

    public static int yearsBetween(Date data, Date dataBase) {
        Calendar atual = Calendar.getInstance();
        GregorianCalendar novo = new GregorianCalendar();
        novo.setTime(data);
        if (dataBase != null) {
            atual.setTime(dataBase);
        }
        int dif = atual.get(1) - novo.get(1);
        ((Calendar)novo).add(1, dif);
        if (atual.before(novo)) {
            --dif;
        }
        return dif;
    }

    public static int monthBetween(Date data, Date dataBase) {
        Calendar atual = Calendar.getInstance();
        GregorianCalendar novo = new GregorianCalendar();
        novo.setTime(data);
        if (dataBase != null) {
            atual.setTime(dataBase);
        }
        int dif = atual.get(2) - novo.get(2);
        if (atual.get(2) == novo.get(2)) {
            dif = (atual.get(1) - novo.get(1)) * 12;
        }
        if (dif < 0) {
            dif += 12;
        }
        ((Calendar)novo).add(2, dif);
        if (atual.before(novo)) {
            --dif;
        }
        return dif;
    }

    public static void montaEnter(JComponent comp) {
        if (comp != null) {
            comp.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, true), "CHANGE_FOCUS");
            comp.getActionMap().put("CHANGE_FOCUS", acaoEnter);
        }
    }

    public static void montaEnter(JComponent ... comp) {
        for (JComponent c : comp) {
            Funcoes.montaEnter(c);
        }
    }

    public static int[] getTamanhoColunas(TableColumnModel mod) {
        if (mod != null) {
            int[] cols = new int[mod.getColumnCount()];
            for (int i = 0; i < cols.length; ++i) {
                cols[i] = mod.getColumn(i).getWidth();
            }
            return cols;
        }
        return new int[0];
    }

    public static void setTamanhoColunas(TableColumnModel mod, int[] cols) {
        if (mod != null && cols != null && mod.getColumnCount() == cols.length) {
            for (int i = 0; i < mod.getColumnCount(); ++i) {
                if (mod.getColumn(i).getIdentifier().toString().indexOf("*") >= 0) {
                    mod.removeColumn(mod.getColumn(i--));
                    continue;
                }
                mod.getColumn(i).setPreferredWidth(cols[i]);
            }
        }
    }

    public static PrintService localizarImpressora(String nomeImpressora) {
        for (int i = 0; i < impressoras.length; ++i) {
            if (!impressoras[i].getName().equalsIgnoreCase(nomeImpressora)) continue;
            return impressoras[i];
        }
        return null;
    }

    public static void imprimirPDF(byte[] byteDados, String impressora) throws Exception {
        if (Funcoes.isLinux()) {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteDados);
            HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
            HashDocAttributeSet das = new HashDocAttributeSet();
            PrintService service = Funcoes.localizarImpressora(impressora);
            DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            DocPrintJob job = service.createPrintJob();
            SimpleDoc doc = new SimpleDoc(bais, flavor, das);
            job.print(doc, pras);
        } else {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(Funcoes.localizarImpressora(impressora));
            PDDocument doc = PDDocument.load((InputStream)new ByteArrayInputStream(byteDados));
            job.setPageable((Pageable)new PDFPageable(doc));
            job.print();
        }
    }

    public static String[] getNomeImpressorasLocais(int tamanhoStringRetorno, boolean selecionarImpressora) {
        ArrayList<String> arr = new ArrayList<String>();
        PrintService impressoraPadrao = PrintServiceLookup.lookupDefaultPrintService();
        if (selecionarImpressora) {
            arr.add(SELECIONAR_IMPRESSORA);
        }
        String impPadrao = impressoraPadrao.getName();
        if (tamanhoStringRetorno > 0) {
            impPadrao = impPadrao.substring(0, impPadrao.length() > tamanhoStringRetorno ? tamanhoStringRetorno : impPadrao.length());
        }
        arr.add(impPadrao);
        for (int i = 0; i < impressoras.length; ++i) {
            if (impressoras[i] == null || arr.indexOf(impressoras[i].getName()) > -1) continue;
            String imp = impressoras[i].getName();
            if (tamanhoStringRetorno > 0) {
                imp = imp.substring(0, imp.length() > tamanhoStringRetorno ? tamanhoStringRetorno : imp.length());
            }
            if (impressoras[i].getName().equals(impressoraPadrao.getName())) continue;
            arr.add(imp);
        }
        return arr.toArray(new String[arr.size()]);
    }

    public static boolean temImpressoraPadraoConfigurada() {
        PrintService impressoraPadrao = PrintServiceLookup.lookupDefaultPrintService();
        return null != impressoraPadrao;
    }

    public static String[] getNomeImpressorasLocais() {
        return Funcoes.getNomeImpressorasLocais(0, false);
    }

    public static String getImpressoraPadrao() {
        PrintService service = PrintServiceLookup.lookupDefaultPrintService();
        if (service != null) {
            return service.getName();
        }
        return "";
    }

    public static void imagemPesquisa(JButton botao) {
        if (botao != null) {
            botao.setIcon(ImagemUtils.carregaImagemJalis("zoom.gif"));
        }
    }

    public static boolean hoje(String data) {
        if (data != null) {
            String d = Funcoes.formataData(Funcoes.stringToDate(data));
            return d.equals(Funcoes.formataData(new Date()));
        }
        return false;
    }

    public static int comparaDataHora(String dataOrigem, String dataPesquisa, String formato) {
        if (Funcoes.verificaTimestamp(formato, dataOrigem) && Funcoes.verificaTimestamp(formato, dataPesquisa)) {
            Date d = Funcoes.stringToDate(formato, dataOrigem);
            return d.compareTo(Funcoes.stringToDate(formato, dataPesquisa));
        }
        return 0;
    }

    public static int comparaData(String dataOrigem, String dataPesquisa) {
        if (Funcoes.verificaData(dataOrigem) && Funcoes.verificaData(dataPesquisa)) {
            Date d = Funcoes.stringToDate(dataOrigem);
            return d.compareTo(Funcoes.stringToDate(dataPesquisa));
        }
        return 0;
    }

    public static int comparaData(Date dataOrigem, Date dataPesquisa) {
        return dataOrigem.compareTo(dataPesquisa);
    }

    public static Date stringToTime(String hora) {
        if (Funcoes.verificaHora(hora)) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            try {
                return sdf.parse(hora);
            }
            catch (ParseException ex) {
                return new Date();
            }
        }
        return new Date();
    }

    public static int comparaHora(String horaOrigem, String horaPesquisa) {
        if (Funcoes.verificaHora(horaOrigem) && Funcoes.verificaHora(horaPesquisa)) {
            Date h1 = Funcoes.stringToTime(horaOrigem);
            Date h2 = Funcoes.stringToTime(horaPesquisa);
            return h1.compareTo(h2);
        }
        return 0;
    }

    public static String gerarSenhaWeb() {
        StringBuffer temp = new StringBuffer("");
        StringBuffer retorno = new StringBuffer("");
        Random random = new Random();
        temp.append(String.valueOf(Math.abs(random.nextInt())));
        if (temp.length() > 10) {
            temp.delete(10, temp.length());
        } else {
            while (temp.length() < 10) {
                temp.insert(0, "0");
            }
        }
        for (int i = 0; i < 10; i += 2) {
            if (Funcoes.isNumeric(temp.substring(i, i + 2))) {
                int numero = Integer.parseInt(temp.substring(i, i + 2));
                if (numero != 76 && numero != 108 && numero != 79 && numero != 111 && numero >= 65 && numero <= 90 || numero >= 97 && numero <= 129) {
                    if (numero >= 65 && numero <= 90) {
                        retorno.append(String.valueOf((char)(numero + 32)));
                        continue;
                    }
                    if (numero < 97 || numero > 129) continue;
                    retorno.append(String.valueOf((char)numero));
                    continue;
                }
                retorno.append(temp.substring(i, i + 2));
                continue;
            }
            retorno.append(temp.substring(i, i + 2));
        }
        return retorno.toString().toLowerCase();
    }

    public static void geraLogErro(Exception e, String integracao) throws IOException, Exception {
        StringBuilder erroPilha = new StringBuilder();
        for (StackTraceElement st : e.getStackTrace()) {
            erroPilha.append(String.format("%s %s.%s(%s) ", st.getFileName(), st.getClassName(), st.getMethodName(), st.getLineNumber())).append("\n");
        }
        StringUtil.escreverArquivoTexto(Funcoes.nomeArquivoErro(integracao), erroPilha.toString());
    }

    public static String nomeArquivoErro(String integracao) {
        Date dt = new Date();
        StringBuilder nome = new StringBuilder();
        nome.append(System.getProperty("user.home"));
        nome.append(integracao);
        nome.append(Funcoes.formataData("yyyyMMdd_HHmmss", dt));
        nome.append(".log");
        return nome.toString();
    }

    public static String gerarSenha(int tamanho) {
        StringBuffer temp = new StringBuffer("");
        StringBuffer retorno = new StringBuffer("");
        Random random = new Random();
        temp.append(String.valueOf(Math.abs(random.nextInt())));
        while (temp.length() < tamanho) {
            temp.insert(0, "0");
        }
        for (int i = 0; i < tamanho; i += 2) {
            if (Funcoes.isNumeric(temp.substring(i, i + 2))) {
                int numero = Integer.parseInt(temp.substring(i, i + 2));
                if (numero != 76 && numero != 108 && numero != 79 && numero != 111 && numero >= 65 && numero <= 90 || numero >= 97 && numero <= 129) {
                    if (numero >= 65 && numero <= 90) {
                        retorno.append(String.valueOf((char)(numero + 32)));
                        continue;
                    }
                    if (numero < 97 || numero > 129) continue;
                    retorno.append(String.valueOf((char)numero));
                    continue;
                }
                retorno.append(temp.substring(i, i + 2));
                continue;
            }
            retorno.append(temp.substring(i, i + 2));
        }
        return retorno.toString().toLowerCase();
    }

    public static String getDataHora() {
        Date d = new Date();
        return Funcoes.formataData(d) + " " + Funcoes.formataHora(d, false);
    }

    public static Date getDataHoraAtual() {
        return new Date(new Date().getTime() + millisDiferecaDataHoraServidor);
    }

    public static void atualizaDataHoraComServidor() {
        millisDiferecaDataHoraServidor = Funcoes.getDataHoraServidor().getTime() - new Date().getTime();
    }

    public static double arredondar(double valor, int casas) {
        StringBuffer c = new StringBuffer("#.");
        for (int i = 0; i < casas; ++i) {
            c.append("0");
        }
        String value = Funcoes.formataDecimal(c.toString(), valor);
        return Double.parseDouble(Funcoes.limpaDecimal(value));
    }

    public static double arredondarParametrizado(double valor) {
        BigDecimal aux = new BigDecimal(valor);
        aux = aux.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        return aux.doubleValue();
    }

    public static String getPortaImpressora() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.toLowerCase().indexOf("linux") > -1) {
            return "/dev/lp0";
        }
        return "lpt1";
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.toLowerCase().indexOf("linux") > -1;
    }

    public static ArrayList intervalo(String interval) {
        int i;
        ArrayList<String> a = new ArrayList<String>();
        char[] s = interval.toCharArray();
        StringBuffer buf = new StringBuffer("");
        int inicio = -1;
        int fim = -1;
        boolean aberto = false;
        for (i = 0; i < s.length; ++i) {
            if (s[i] == '-') {
                aberto = true;
                if (Funcoes.isNumeric(buf.toString())) {
                    inicio = Integer.parseInt(buf.toString());
                }
                buf.delete(0, buf.length());
                continue;
            }
            if (aberto && s[i] == ',' || aberto && !Funcoes.isNumeric(String.valueOf(s[i]))) {
                aberto = false;
                if (Funcoes.isNumeric(buf.toString())) {
                    fim = Integer.parseInt(buf.toString().trim());
                }
                buf.delete(0, buf.length());
                for (int j = inicio; j <= fim; ++j) {
                    a.add(String.valueOf(j));
                }
                continue;
            }
            if (s[i] == ',') {
                if (Funcoes.isNumeric(buf.toString())) {
                    a.add(buf.toString().trim());
                }
                buf.delete(0, buf.length());
                continue;
            }
            buf.append(s[i]);
        }
        if (aberto && Funcoes.isNumeric(buf.toString())) {
            fim = Integer.parseInt(buf.toString());
            for (i = inicio; i <= fim; ++i) {
                a.add(String.valueOf(i));
            }
        } else if (Funcoes.isNumeric(buf.toString())) {
            a.add(buf.toString().trim());
        }
        return a;
    }

    public static String intervaloComVirgulas(ArrayList a) {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < a.size(); ++i) {
            buf.append(a.get(i).toString());
            if (i >= a.size() - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public static String separaComVirgulaLimite(ArrayList a, int limite) {
        int contador = limite;
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < a.size(); ++i) {
            buf.append(a.get(i).toString());
            if (i >= a.size() - 1) continue;
            if (--contador == 0) {
                buf.append("\n");
                contador = limite;
                continue;
            }
            buf.append(",");
        }
        return buf.toString();
    }

    public static int contaNivelPlanoContas(String conta) {
        String[] nivel = conta.split("[.]");
        for (int i = nivel.length - 1; i >= 0; --i) {
            if (Funcoes.textoVazio(nivel[i])) continue;
            return i + 1;
        }
        return 0;
    }

    public static Method getMetodoComNome(Method[] met, String nome) {
        for (int i = 0; i < met.length; ++i) {
            if (!met[i].getName().equalsIgnoreCase(nome)) continue;
            return met[i];
        }
        return null;
    }

    public static boolean testaConexaoWeb(String ip, int porta) {
        boolean retorno = false;
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(ip, porta), 5000);
            retorno = socket.isConnected();
        }
        catch (IOException ex) {
            return retorno;
        }
        return retorno;
    }

    public static Date somaMeses(Date data, int meses) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(data);
        calendario.add(2, meses);
        return calendario.getTime();
    }

    public static Date subtraiMeses(Date data, int meses) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(data);
        calendario.add(2, meses * -1);
        return calendario.getTime();
    }

    public static Date somaDias(Date data, int dias) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(data);
        calendario.add(5, dias);
        return calendario.getTime();
    }

    public static Date somaMinutos(Date data, int minutos) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(data);
        calendario.add(12, minutos);
        return calendario.getTime();
    }

    public static int retornaMinutos(Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        return cal.get(12);
    }

    public static int retornaHora(Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        return cal.get(10);
    }

    public static int retornaMes(Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        return cal.get(2);
    }

    public static int retornaAno(Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        return cal.get(1);
    }

    public static Date subtraiDias(Date data, int dias) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(data);
        calendario.add(5, dias * -1);
        return calendario.getTime();
    }

    public static boolean diretorioExiste(String dir) {
        File f = new File(dir);
        return f.exists() && f.isDirectory();
    }

    public static boolean arquivoExiste(String arquivo) {
        File f = new File(arquivo);
        return f.exists();
    }

    public static boolean verificaIP(String ip) {
        return ip != null && !Funcoes.textoVazio(ip) && ip.matches("\\d{1,3}(\\.\\d{1,3}){3}");
    }

    public static String resolverDouble(String str_double) {
        StringBuilder numero = new StringBuilder(str_double);
        if (numero.indexOf(".") <= 0) {
            return null;
        }
        if (numero.indexOf("E") == 0) {
            return null;
        }
        if (numero.indexOf("E") > 0) {
            int exp;
            if (Character.isDigit(numero.charAt(0))) {
                numero.insert(0, '+');
            }
            if (Character.isDigit(numero.charAt((exp = numero.indexOf("E")) + 1))) {
                numero.insert(exp + 1, '+');
            }
            char sinalv = numero.charAt(0);
            StringBuilder valor = new StringBuilder(numero.substring(1, exp));
            char sinalp = numero.charAt(exp + 1);
            Long potencia = Math.abs(Long.parseLong(numero.substring(exp + 2)));
            int i = 0;
            while ((long)i < potencia) {
                valor = sinalp == '+' ? valor.append("0") : new StringBuilder("0").append((CharSequence)valor);
                ++i;
            }
            int ponto = valor.indexOf(".");
            valor = new StringBuilder(valor.toString().replaceFirst("\\.", ""));
            int i2 = 0;
            while ((long)i2 < potencia) {
                ponto = sinalp == '+' ? ponto + 1 : ponto - 1;
                ++i2;
            }
            valor = valor.insert(ponto, '.');
            if (sinalv == '-') {
                valor.insert(0, '-');
            }
            numero = valor;
        }
        for (int decimais = numero.length() - numero.indexOf(".") - 1; decimais > 1 && numero.charAt(numero.length() - 1) == '0'; --decimais) {
            numero.deleteCharAt(numero.length() - 1);
        }
        for (int inteiros = numero.indexOf("."); inteiros > 1 && numero.charAt(0) == '0'; --inteiros) {
            numero.deleteCharAt(0);
        }
        return numero.toString();
    }

    public static int procuraArg(String[] args, String argumento) {
        int pos = -1;
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String c = args[i];
                if (!c.trim().equalsIgnoreCase(argumento.trim())) continue;
                pos = i;
                break;
            }
        }
        return pos;
    }

    public static String limpaCampos(String texto, String ... regexRemover) {
        String retorno = texto;
        for (String s : regexRemover) {
            retorno = retorno.replaceAll(s, "");
        }
        return retorno;
    }

    public static boolean temNumero(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return false;
        }
        for (char c : texto.toCharArray()) {
            if (!String.valueOf(c).matches("\\d")) continue;
            return true;
        }
        return false;
    }

    public static String cortaString(String texto, int qtde) {
        if (texto.length() > qtde) {
            return texto.substring(0, qtde);
        }
        return Funcoes.preencheVazio(texto, qtde, 2);
    }

    public static void validarNaoNull(Object parametro, String nome) {
        if (parametro == null) {
            throw new NullPointerException("O par\u00e2metro \"" + nome + "\" n\u00e3o pode ser null");
        }
    }

    public static void validarInstanciaDe(Class<?> classe, Object parametro, String nome) {
        if (!classe.isInstance(parametro)) {
            throw new ClassCastException("O par\u00e2metro \"" + nome + "\" n\u00e3o \u00e9 inst\u00e2ncia de \"" + classe.getName() + "\"");
        }
    }

    public static void adicionarCtrlI(final Component owner, JPanel panel, final String codigoFilial, final String codigoRequisicao) {
        ScreenUtil.addActionMap(panel, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (owner instanceof Laboratorio) {
                    GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)((Laboratorio)owner).getRootPane().getGlassPane();
                    InfoRequisicao info = owner instanceof Frame ? new InfoRequisicao((Frame)owner, glassPaneMensagem) : new InfoRequisicao((Dialog)owner, glassPaneMensagem);
                    if (!Funcoes.textoVazio(codigoRequisicao) && Funcoes.isNumeric(codigoRequisicao)) {
                        info.setRequisicao(codigoFilial, Integer.parseInt(codigoRequisicao));
                    }
                    info.setVisible(true);
                    ((Laboratorio)owner).getRootPane().setGlassPane(glassPaneMensagem);
                }
            }
        });
    }

    public static void configurarHorarioVerao(boolean configurar) {
        if (configurar) {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT-2:00"));
        }
    }

    public static String dataPorExtenso(Date data, boolean mostrarDiaSemana) {
        if (data != null) {
            SimpleDateFormat dfmt = new SimpleDateFormat((mostrarDiaSemana ? "EEEE, " : "") + "d 'de' MMMM 'de' yyyy");
            return dfmt.format(data);
        }
        return null;
    }

    public static boolean isAniversario(Date dataNascimento) {
        if (dataNascimento != null) {
            Calendar calendarAtual = Calendar.getInstance();
            calendarAtual.setTime(new Date());
            Calendar calendarNascimento = Calendar.getInstance();
            calendarNascimento.setTime(dataNascimento);
            calendarNascimento.set(1, calendarAtual.get(1));
            return calendarNascimento.get(5) == calendarAtual.get(5) && calendarNascimento.get(2) == calendarAtual.get(2) && calendarNascimento.get(1) == calendarAtual.get(1);
        }
        return false;
    }

    public static String[] getFilialRequisicao(String codigo) {
        String codigoComposto = Funcoes.preencheZero(codigo, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String filial = codigoComposto.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String requisicao = codigoComposto.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        if (filial.equals(Funcoes.preencheZero(0, ParametrosGerais.getDigitosTuboFilial()))) {
            filial = Variaveis.filialPadrao;
        }
        return new String[]{filial, requisicao};
    }

    public static Integer getDDD(String telefoneCompleto) {
        if (telefoneCompleto == null || Funcoes.textoVazio(telefoneCompleto.trim())) {
            return null;
        }
        int posIni = telefoneCompleto.indexOf("(");
        int posFim = telefoneCompleto.indexOf(")");
        if (posIni > -1 && posFim > -1) {
            if (Funcoes.isNumeric(telefoneCompleto.substring(posIni + 1, posFim))) {
                return Integer.parseInt(telefoneCompleto.substring(posIni + 1, posFim));
            }
            return null;
        }
        return null;
    }

    public static Integer getTelefone(String telefoneCompleto) {
        if (telefoneCompleto == null || Funcoes.textoVazio(telefoneCompleto.trim())) {
            return null;
        }
        String tmp = StringUtil.limpaString(telefoneCompleto, new String[]{"(", ")", "-", " "}).trim();
        if (!Funcoes.textoVazio(tmp) && tmp.length() >= 8) {
            if (Funcoes.isNumeric(StringUtil.removeCaractere(tmp.substring(tmp.length() - 8), '-'))) {
                return Integer.parseInt(StringUtil.removeCaractere(tmp.substring(tmp.length() - 8), '-'));
            }
            return null;
        }
        return null;
    }

    public static String getNomeUF(String siglaUF) {
        return Estados.getNome(siglaUF);
    }

    public static Integer getCodigoIbgeUF(String siglaUF) {
        return Estados.getCodigoIbge(siglaUF);
    }

    public static int diferencaEmHoras(Date horaInicio, Date horaFinal) {
        long ini = horaInicio.getTime();
        long fim = horaFinal.getTime();
        long horas = (fim - ini) / 1000L / 3600L;
        return (int)horas;
    }

    public static int diferencaEmMinutos(Date horaInicio, Date horaFinal) {
        long ini = horaInicio.getTime();
        long fim = horaFinal.getTime();
        long horas = (fim - ini) / 1000L / 60L;
        return (int)horas;
    }

    public static String retiraStringRepetida(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return "";
        }
        char temp = ' ';
        String repete = "";
        String pathTemp = texto;
        for (int i = 0; i < texto.length(); ++i) {
            String barra = "" + texto.charAt(i);
            if (i == 0) {
                repete = "" + texto.charAt(i);
            }
            if (texto.charAt(i) == temp) {
                if (repete.charAt(0) != temp) {
                    repete = "" + temp;
                }
                repete = repete + temp;
            }
            if (i > 0 && repete.length() > 1 && !Funcoes.naoContemLetra(repete)) {
                pathTemp = pathTemp.replace(repete, "" + texto.charAt(i - 1));
                repete = "" + texto.charAt(i);
            }
            temp = texto.charAt(i);
        }
        return pathTemp;
    }

    private static boolean naoContemLetra(String string) {
        boolean encontrou = false;
        String letras = "qwertyuiop\u00e7lkjhgfdsazxcvbnm";
        for (char c : string.toLowerCase().toCharArray()) {
            encontrou = false;
            for (char ca : letras.toCharArray()) {
                if (c != ca) continue;
                encontrou = true;
                break;
            }
            if (encontrou) break;
        }
        return encontrou;
    }

    public static boolean processarFuncaoNumeroTubo(final TTextField campoFilial, TTextField campoRequisicao) {
        DescritorCodigoEtiqueta descritorCodigoEtiqueta;
        if (campoRequisicao != null && !Funcoes.textoVazio(campoRequisicao.getText()) && (descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(campoRequisicao.getText())) != null) {
            if (campoFilial != null) {
                campoFilial.setText(descritorCodigoEtiqueta.getFilial());
            }
            campoRequisicao.setText(descritorCodigoEtiqueta.getRequisicao());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (campoFilial != null) {
                        for (FocusListener listener : campoFilial.getFocusListeners()) {
                            if (!(listener instanceof JPanel)) continue;
                            listener.focusLost(new FocusEvent(campoFilial, 1005));
                        }
                    }
                }
            });
        }
        return true;
    }

    public static boolean processarFuncaoNumeroTubo(final TTextField campoFilial, JFormattedTextField campoRequisicao) {
        DescritorCodigoEtiqueta descritorCodigoEtiqueta;
        if (campoRequisicao != null && !Funcoes.textoVazio(campoRequisicao.getText()) && (descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(campoRequisicao.getText())) != null) {
            if (campoFilial != null) {
                campoFilial.setText(descritorCodigoEtiqueta.getFilial());
            }
            campoRequisicao.setText(descritorCodigoEtiqueta.getRequisicao());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (campoFilial != null) {
                        for (FocusListener listener : campoFilial.getFocusListeners()) {
                            if (!(listener instanceof JPanel)) continue;
                            listener.focusLost(new FocusEvent(campoFilial, 1005));
                        }
                    }
                }
            });
        }
        return true;
    }

    public static String[] obterSituacaoExameRequisicao() {
        return new String[]{"Coletado", "A coletar", "Falta material", "Recoleta", "Faturamento", "Salvo parcial", "Lan\u00e7ado", "Conferido", "Repeti\u00e7\u00e3o", "Impresso", "Entregue", "Em Transporte"};
    }

    public static String[] obterSituacaoExameRequisicaoTipos() {
        return new String[]{"", "T", "F", "R", "A", "P", "L", "C", "O", "I", "E"};
    }

    public static int obterSituacaoRegistroExameReq(String situacao) {
        if (Funcoes.textoVazio(situacao)) {
            return 0;
        }
        if (situacao.equalsIgnoreCase("T")) {
            return 1;
        }
        if (situacao.equalsIgnoreCase("F")) {
            return 2;
        }
        if (situacao.equalsIgnoreCase("R")) {
            return 3;
        }
        if (situacao.equalsIgnoreCase("A")) {
            return 4;
        }
        if (situacao.equalsIgnoreCase("P")) {
            return 5;
        }
        if (situacao.equalsIgnoreCase("L")) {
            return 6;
        }
        if (situacao.equalsIgnoreCase("C")) {
            return 7;
        }
        if (situacao.equalsIgnoreCase("O")) {
            return 8;
        }
        if (situacao.equalsIgnoreCase("I")) {
            return 9;
        }
        if (situacao.equalsIgnoreCase("E")) {
            return 10;
        }
        if (situacao.equalsIgnoreCase("N")) {
            return 11;
        }
        return 0;
    }

    public static boolean permiteConferirGerarPdf(String codigoFilial) {
        try {
            boolean isGerarPdfResultado = ExportaWeb2.isGerarPdfResultado(Conexao.getStatement(), codigoFilial);
            if (isGerarPdfResultado && !Variaveis.openPdfCorreto) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Vers\u00e3o da biblioteca de gera\u00e7\u00e3o de PDF de resultado est\u00e1 incorreta.\n Entre em contato com o suporte do sistema Jalis.", 2);
                return false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se pode gerar pdf para a filial.", e.getStackTrace());
            return false;
        }
        return true;
    }

    public static boolean validaPrazoSenha(Date dataUltimaSenha) {
        int qtdeDiasUltimaMudanca = Funcoes.daysBetween(dataUltimaSenha);
        return qtdeDiasUltimaMudanca < ParametrosGerais.getPrazoValidadeSenha();
    }

    public static boolean validaComplexidadeSenha(String senha) {
        int qtdeCaracter = ParametrosGerais.getQtdeCaracteresSenha();
        String pattern = "^(?=.*\\d)(?=.*[A-Z])[^\\s]{" + qtdeCaracter + ",}$";
        if (senha.length() < qtdeCaracter) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A senha deve conter no m\u00ednimo " + qtdeCaracter + " caracteres.", 2);
            return false;
        }
        if (qtdeCaracter > 1 && !senha.matches(pattern)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A senha deve conter no m\u00ednimo uma letra mai\u00fascula e um n\u00famero", 2);
            return false;
        }
        return true;
    }

    public static boolean isExportaWeb(Statement st, String filialPadrao) throws SQLException {
        FilialService filService = new FilialService();
        boolean exportaWeb = false;
        FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, filialPadrao);
        if (Funcoes.carregouVO(filialVO) && !(exportaWeb = Funcoes.isExportarBaseWeb(filialVO)) && Funcoes.carregouVO(filialVO = filService.contemAgrupamento(st, filialPadrao))) {
            exportaWeb = Funcoes.isExportarBaseWeb(filialVO);
        }
        return exportaWeb;
    }

    public static boolean carregouVO(AbstractThreadVO filialVO) {
        return filialVO != null;
    }

    public static boolean isExportarBaseWeb(FilialVOAux filialVO) {
        return !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
    }

    public static String getIntervaloParaString(PGInterval pgi, String formato) {
        StringBuilder sb = new StringBuilder("");
        if (!Funcoes.objectIsNull(pgi)) {
            if (Funcoes.textoVazio(formato)) {
                formato = "YY anos MM meses DD dias";
            }
            sb.append(formato.replace("YY", String.valueOf(pgi.getYears())).replace("MM", String.valueOf(pgi.getMonths())).replace("DD", String.valueOf(pgi.getDays())).replace("hh", String.valueOf(pgi.getHours())).replace("mm", String.valueOf(pgi.getMinutes())).replace("ss", String.valueOf(pgi.getSeconds())));
        }
        return sb.toString();
    }

    public static int getPosicaoAlfabeto(char letra) {
        int found = -1;
        for (int i = 0; i < alfabeto.length; ++i) {
            if (!String.valueOf(alfabeto[i]).equalsIgnoreCase(String.valueOf(letra))) continue;
            found = i;
            break;
        }
        return found;
    }

    public static String getChaveFilReq(String filial, String requisicao) {
        return filial + "-" + requisicao;
    }

    public static void calcularTempoExecucao(LocalDateTime inicio, String mensagem) {
        System.out.println(mensagem + " " + ChronoUnit.MILLIS.between(inicio, LocalDateTime.now()));
    }

    private static enum Estados {
        Rondonia(11, "Rond\u00f4nia", "RO"),
        Acre(12, "Acre", "AC"),
        Amazonas(13, "Amazonas", "AM"),
        Roraima(14, "Roraima", "RR"),
        Para(15, "Par\u00e1", "PA"),
        Amapa(16, "Amap\u00e1", "AP"),
        Tocantins(17, "Tocantins", "TO"),
        Maranhao(21, "Maranh\u00e3o", "MA"),
        Piaui(22, "Piau\u00ed", "PI"),
        Ceara(23, "Cear\u00e1", "CE"),
        Rio_Grande_do_Norte(24, "Rio Grande do Norte", "RN"),
        Paraiba(25, "Para\u00edba", "PB"),
        Pernambuco(26, "Pernambuco", "PE"),
        Alagoas(27, "Alagoas", "AL"),
        Sergipe(28, "Sergipe", "SE"),
        Bahia(29, "Bahia", "BA"),
        Minas_Gerais(31, "Minas Gerais", "MG"),
        Espirito_Santo(32, "Esp\u00edrito Santo", "ES"),
        Rio_de_Janeiro(33, "Rio de Janeiro", "RJ"),
        Sao_Paulo(34, "S\u00e3o Paulo", "SP"),
        Parana(41, "Paran\u00e1", "PR"),
        Santa_Catarina(42, "Santa Catarina", "SC"),
        Rio_Grande_do_Sul(43, "Rio Grande do Sul", "RS"),
        Mato_Grosso_do_Sul(50, "Mato Grosso do Sul", "MS"),
        Mato_Grosso(51, "Mato Grosso", "MT"),
        Goias(52, "Goi\u00e1s", "GO"),
        Distrito_Federal(53, "Distrito Federal", "DF");

        Integer codigo = null;
        String nome = null;
        String siglaUF = null;

        private Estados(Integer codigo, String nome, String siglaUF) {
            this.codigo = codigo;
            this.nome = nome;
            this.siglaUF = siglaUF;
        }

        public static String getNome(String siglaUF) {
            Estados[] todos = Estados.values();
            for (int i = 0; i < todos.length; ++i) {
                Estados aux = todos[i];
                if (!aux.siglaUF.equalsIgnoreCase(siglaUF)) continue;
                return aux.nome;
            }
            return null;
        }

        public static Integer getCodigoIbge(String siglaUF) {
            Estados[] todos = Estados.values();
            for (int i = 0; i < todos.length; ++i) {
                Estados aux = todos[i];
                if (!aux.siglaUF.equals(siglaUF)) continue;
                return aux.codigo;
            }
            return null;
        }
    }
}

