/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.DadosMaterialUtilizado;
import jalis.comum.dados.DadosTabelaPreco;
import jalis.comum.dados.faturamento.DadosMaterialFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Dados;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.componente.Externo;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.componente.CampoDigitacao;
import jalis.laboratorio.digitacao.componente.DadosDigitacao;
import jalis.laboratorio.digitacao.componente.ExpressaoDigitacao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.resultados.DadosConferenciaAutomatica;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.ResultadoAnterior;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.triagem.RecipienteColetaVO;
import jalis.model.vo.triagem.RecipienteTriagemVO;
import jalis.model.vo.triagem.RecipienteVO;
import jalis.service.cadastro.exame.MetodologiaService;
import jalis.util.ArraysUtil;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.ConstrutorInsert;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.postgresql.util.PGInterval;

public class ExameUtil {
    private static final String DATA_HORA_MAXIMA = "datahoramax";
    private static final String DATA_HORA_MINIMA = "datahoramin";
    private static final int CASAS_CH = 4;
    public static final int EXAME_LIBERADO = 0;
    public static final int PROIBIDO_SEXO = 2;
    public static final int PROIBIDO_IDADE = 3;
    public static final int LAYOUT_METODO_PADRAO = -1;
    private static final String SEXO_AMBOS = "A";
    private static final String SEXO_MASCULINO = "M";
    private static final String SEXO_FEMININO = "F";
    public static final int LIBERADO = 0;
    public static final int PROIBIDO = 1;
    public static final int AUTORIZAR = 4;
    public static final int PRAZO = 5;
    public static final int PROIBIDO_CONVENIO = 6;
    public static final int PROIBIDO_MATERIAL = 7;
    public static final int PROIBIDO_TABELA = 8;
    public static final int NAO_FATURAR = 9;
    public static final int CONTRASSENHA = 10;
    public static final int APENAS_FATURAMENTO = 11;
    public static final String CAMPO_FORMATO = "elm_formato";
    public static final String CAMPO_MAPA = "elm_mapa";
    public static final String CAMPO_NORMAL = "elm_normal";
    public static final String CAMPO_EXPORTAR_TEXTO = "elm_exportartexto";
    public static final String HISTORICO_POR_CODIGO = "historicoporcodigo";
    public static final String HISTORICO_POR_MNEMONICO = "historicopormnemonico";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCodigoLayout(String filial, String convenio, String destino) {
        String string;
        Statement st = Conexao.getStatement();
        try {
            string = ExameUtil.getCodigoLayout(filial, convenio, destino, st, ParametrosGerais.getLayCodigo());
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return string;
    }

    public static String getCodigoLayout(String filial, String convenio, String destino, Statement st) {
        return ExameUtil.getCodigoLayout(filial, convenio, destino, st, ParametrosGerais.getLayCodigo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCodigoLayout(String filial, String convenio, String destino, Statement st, int layoutPadrao) {
        String retorno;
        block8: {
            retorno = "null";
            if (!Funcoes.textoVazio(convenio) && !Funcoes.textoVazio(destino) && st != null) {
                try {
                    StringBuilder str = new StringBuilder("select lay_codigo from destinoconvlayout where fil_codigo = ");
                    str.append(filial);
                    str.append(" and con_codigo = ");
                    str.append(convenio);
                    str.append(" and upper(des_codigo) = (").append(StringUtil.textoDBEscape(destino)).append(")");
                    ResultSet res = st.executeQuery(str.toString());
                    if (res.next()) {
                        retorno = res.getString("lay_codigo");
                        break block8;
                    }
                    str.delete(0, str.length());
                    str.append("select lay_codigo from convenios where fil_codigo = ");
                    str.append(filial);
                    str.append(" and con_codigo = ");
                    str.append(convenio);
                    try {
                        res = st.executeQuery(str.toString());
                        retorno = res.next() && res.getString("lay_codigo") != null ? res.getString("lay_codigo") : String.valueOf(layoutPadrao);
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 126");
                }
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCabecalhoRodape(String filial, String codigoLayout) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            block5: {
                String string;
                try {
                    StringBuilder bui = new StringBuilder("select lay_cabec from layout where fil_codigo = ");
                    bui.append(filial);
                    bui.append(" and lay_codigo = ");
                    bui.append(codigoLayout);
                    ResultSet rs = Conexao.executeQuery(st, bui.toString());
                    if (!rs.next()) break block5;
                    string = rs.getString("lay_cabec");
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 162");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                Conexao.fecharStatement(st);
                return string;
            }
            Conexao.fecharStatement(st);
        }
        return "";
    }

    public static void carregarMateriaisColeta(String exame, String filial, JComboBox combo) throws SQLException {
        ExameUtil.carregarMateriaisColeta(exame, filial, combo, null, false);
    }

    public static void carregarMateriaisColeta(String exame, String filial, JComboBox combo, DadosMaterial material, boolean isTelaAgrupamentos) throws SQLException {
        Statement st = Conexao.getStatement();
        int posCombo = 0;
        if (st != null && exame != null && filial != null && combo != null) {
            try {
                combo.removeAllItems();
                StringBuilder tmp = new StringBuilder("select a.mco_codigo, a.mco_descricao, a.mco_solicitarmat, b.emc_default, ");
                tmp.append("a.mco_solicitararea, a.mco_abreviatura ");
                tmp.append("from examematcoleta b ");
                tmp.append("left join materialcoleta a on a.fil_codigo = b.fil_codigo and b.mco_codigo = a.mco_codigo ");
                tmp.append("where b.fil_codigo =" + filial + " and upper(b.exa_codigo) = upper(").append(StringUtil.textoDBEscape(exame)).append(") ");
                if (!isTelaAgrupamentos) {
                    tmp.append(" and b.emc_proibido = false ");
                }
                if (Variaveis.tipoFilialPadrao.equals(SEXO_AMBOS)) {
                    tmp.append(" order by a.mco_descricao ");
                }
                ResultSet rs = Conexao.executeQuery(st, tmp.toString());
                while (rs.next()) {
                    DadosMaterial d = new DadosMaterial(rs.getInt("mco_codigo"), rs.getString("mco_descricao"), rs.getBoolean("mco_solicitarmat"), rs.getBoolean("mco_solicitararea"));
                    d.setAbreviatura(rs.getString("mco_abreviatura"));
                    combo.addItem(d);
                    if (rs.getBoolean("emc_default") && material == null) {
                        posCombo = combo.getItemCount() - 1;
                        continue;
                    }
                    if (material == null || d.getCodigo() != material.getCodigo()) continue;
                    posCombo = combo.getItemCount() - 1;
                }
                if (combo.getItemCount() > 0) {
                    combo.setSelectedIndex(posCombo);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 205");
            }
            st.close();
        }
    }

    public static void carregarMateriaisColetaSemConvenioProibido(String exame, String filial, String codigoConvenio, JComboBox combo) throws SQLException {
        ExameUtil.carregarMateriaisColetaSemConvenioProibido(exame, filial, codigoConvenio, combo, null);
    }

    public static void carregarMateriaisColetaSemConvenioProibido(String exame, String filial, String codigoConvenio, JComboBox combo, DadosMaterial material) throws SQLException {
        Statement st = Conexao.getStatement();
        int posCombo = 0;
        if (st != null && exame != null && filial != null && combo != null) {
            try {
                combo.removeAllItems();
                StringBuilder tmp = new StringBuilder("select a.mco_codigo, a.mco_descricao, a.mco_solicitarmat, b.emc_default, ");
                tmp.append(" a.mco_solicitararea, a.mco_abreviatura, b.emc_proibido ");
                tmp.append(" from examematcoleta b ");
                tmp.append(" left join materialcoleta a on a.fil_codigo = b.fil_codigo and b.mco_codigo = a.mco_codigo ");
                tmp.append(" left join examesmatconvenio eco on b.fil_codigo = eco.fil_codigo and b.exa_codigo = eco.exa_codigo and b.mco_codigo = eco.mco_codigo and eco.eco_prazo = -1 and eco.con_codigo = ").append(codigoConvenio);
                tmp.append(" where b.fil_codigo =" + filial + " and upper(b.exa_codigo) = upper('");
                tmp.append(StringUtil.textoDB(exame));
                tmp.append("')");
                tmp.append(" and COALESCE(eco.eco_tipo, '') <> '").append("P").append("' ");
                if (Variaveis.tipoFilialPadrao.equals(SEXO_AMBOS)) {
                    tmp.append(" order by a.mco_descricao ");
                }
                ResultSet rs = Conexao.executeQuery(st, tmp.toString());
                while (rs.next()) {
                    DadosMaterial d = new DadosMaterial(rs.getInt("mco_codigo"), rs.getString("mco_descricao"), rs.getBoolean("mco_solicitarmat"), rs.getBoolean("mco_solicitararea"));
                    d.setAbreviatura(rs.getString("mco_abreviatura"));
                    d.setProibido(rs.getBoolean("emc_proibido"));
                    combo.addItem(d);
                    if (rs.getBoolean("emc_default") && material == null) {
                        posCombo = combo.getItemCount() - 1;
                        continue;
                    }
                    if (material == null || d.getCodigo() != material.getCodigo()) continue;
                    posCombo = combo.getItemCount() - 1;
                }
                if (combo.getItemCount() > 0) {
                    combo.setSelectedIndex(posCombo);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 205");
            }
            st.close();
        }
    }

    public static int localizaExame(String exame, DadosMaterial material, ModeloGridTable modelo, int colunaExame, int colunaMaterial) {
        int retorno = -1;
        if (exame != null && material != null) {
            for (int i = 0; i < modelo.getRowCount(); ++i) {
                if (modelo.getValueAt(i, colunaExame) == null || Funcoes.textoVazio((String)modelo.getValueAt(i, colunaExame)) || !((String)modelo.getValueAt(i, colunaExame)).equalsIgnoreCase(exame) || ((DadosMaterial)modelo.getValueAt(i, colunaMaterial)).getCodigo() != material.getCodigo()) continue;
                retorno = i;
                break;
            }
        }
        return retorno;
    }

    public static int localizaExame(String exame, DadosMaterial material, ModeloGridTable modelo) {
        return ExameUtil.localizaExame(exame, material, modelo, 0, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DadosExames getDadosExame(String filial, String exame, DadosMaterial material) throws SQLException {
        DadosExames dadosExames;
        Statement st = Conexao.getStatement();
        try {
            dadosExames = ExameUtil.getDadosExame(filial, exame, material, st);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return dadosExames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DadosExames getDadosExameSimples(String filial, String exame, DadosMaterial material) throws SQLException {
        DadosExames dadosExames;
        Statement st = Conexao.getStatement();
        try {
            dadosExames = ExameUtil.getDadosExameSimples(filial, exame, material, st);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return dadosExames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DadosExames getDadosExame(String filial, String exame, DadosMaterial material, Statement st) throws SQLException {
        DadosExames dadosExames = null;
        ArrayList<DadosMaterialUtilizado> matUtilizado = new ArrayList<DadosMaterialUtilizado>();
        ArrayList<String> conveniosP = new ArrayList<String>();
        ArrayList<String> conveniosAutorizacao = new ArrayList<String>();
        ArrayList<String> conveniosPrazo = new ArrayList<String>();
        ArrayList<String> conveniosNaoFaturar = new ArrayList<String>();
        ArrayList<String> conveniosContrassenha = new ArrayList<String>();
        ArrayList<String> conveniosApenasFaturamento = new ArrayList<String>();
        ArrayList<String> conveniosUrgente = new ArrayList<String>();
        HashMap<String, String> destinosPadrao = null;
        if (st != null) {
            StringBuilder buffer = new StringBuilder("");
            buffer.append("select con_codigo, eco_tipo, eco_prazo from examesmatconvenio ");
            buffer.append("where fil_codigo = ").append(filial);
            buffer.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(exame));
            buffer.append(" and mco_codigo= ").append(material.getCodigo());
            try (ResultSet rsConvenios = null;){
                rsConvenios = st.executeQuery(buffer.toString());
                conveniosP.clear();
                if (rsConvenios != null) {
                    while (rsConvenios.next()) {
                        if (rsConvenios.getString("eco_tipo").equalsIgnoreCase(SEXO_AMBOS)) {
                            conveniosAutorizacao.add(rsConvenios.getString("con_codigo"));
                            continue;
                        }
                        if (rsConvenios.getString("eco_tipo").equalsIgnoreCase("N")) {
                            conveniosNaoFaturar.add(rsConvenios.getString("con_codigo"));
                            continue;
                        }
                        if (rsConvenios.getString("eco_tipo").equalsIgnoreCase("Z")) {
                            conveniosPrazo.add(rsConvenios.getString("con_codigo"));
                            continue;
                        }
                        if (rsConvenios.getString("eco_tipo").equalsIgnoreCase("C")) {
                            conveniosContrassenha.add(rsConvenios.getString("con_codigo"));
                            continue;
                        }
                        if (rsConvenios.getString("eco_tipo").equalsIgnoreCase(SEXO_FEMININO)) {
                            conveniosApenasFaturamento.add(rsConvenios.getString("con_codigo"));
                            continue;
                        }
                        if (rsConvenios.getString("eco_tipo").equalsIgnoreCase("U")) {
                            conveniosUrgente.add(rsConvenios.getString("con_codigo"));
                            continue;
                        }
                        conveniosP.add(rsConvenios.getString("con_codigo"));
                    }
                }
            }
            buffer.delete(0, buffer.length());
            buffer.append("select a.mat_codigo, a.mex_qtde, a.mex_utilizado, b.mat_valorunit, b.mat_descricao, a.mex_cobrarbalcao, a.mex_perguntarquantidade, b.unm_codigo ");
            buffer.append("from materialexame a ");
            buffer.append("left join material b on a.fil_codigo = b.fil_codigo and a.mat_codigo = b.mat_codigo ");
            buffer.append("where a.fil_codigo = ").append(filial);
            buffer.append(" and a.exa_codigo = ").append(StringUtil.textoDBEscape(exame));
            buffer.append(" and a.mco_codigo = ").append(material.getCodigo());
            try (ResultSet rsMatUtilizado = null;){
                rsMatUtilizado = st.executeQuery(buffer.toString());
                matUtilizado.clear();
                while (rsMatUtilizado.next()) {
                    matUtilizado.add(new DadosMaterialUtilizado(rsMatUtilizado.getInt("mat_codigo"), rsMatUtilizado.getString("mat_descricao"), rsMatUtilizado.getBigDecimal("mat_valorunit"), rsMatUtilizado.getBigDecimal("mex_qtde"), rsMatUtilizado.getString("mex_utilizado"), rsMatUtilizado.getBoolean("mex_cobrarbalcao"), rsMatUtilizado.getBoolean("mex_perguntarquantidade"), rsMatUtilizado.getString("unm_codigo")));
                }
            }
            buffer.setLength(0);
            buffer.append(" select col_codigo ");
            buffer.append("       ,des_codigo ");
            buffer.append("  from examecoletadestino ");
            buffer.append(" where fil_codigo = ").append(filial);
            buffer.append("   and exa_codigo = ").append(StringUtil.textoDBEscape(exame));
            try (ResultSet rsDestinoPadrao = null;){
                rsDestinoPadrao = st.executeQuery(buffer.toString());
                if (rsDestinoPadrao != null) {
                    destinosPadrao = new HashMap<String, String>();
                    while (rsDestinoPadrao.next()) {
                        destinosPadrao.put(rsDestinoPadrao.getString("col_codigo"), rsDestinoPadrao.getString("des_codigo"));
                    }
                    if (destinosPadrao.size() == 0) {
                        destinosPadrao = null;
                    }
                }
            }
            buffer.delete(0, buffer.length());
            buffer.append(" select a.emc_instrcoleta, a.emc_preparo, a.emc_prepamostra, a.emc_inadequada, b.prz_descricao, c.exa_descricao, a.emc_referencia, a.emc_procedimento, ");
            buffer.append(" c.exa_sexo, c.exa_idademax, c.exa_idademin, c.exa_idademaxtipo, c.exa_idademintipo, a.emc_conservacao, a.emc_diasconserva, a.emc_instrucaocoleta, ");
            buffer.append(" a.emc_solicitarjejum, a.emc_temperaturainicial, a.emc_temperaturafinal, a.prz_codigo, c.exa_autorizacao, a.emc_mensagem, ");
            buffer.append(" c.exa_proibido, a.emc_pergunta, a.met_codigo, e.met_descricao, a.emc_obrigamedicamento, a.emc_marcarexterno, ");
            buffer.append(" a.emc_obrigadum, c.exa_salvaparcial, a.emc_codigoamb, a.emc_codigocbhpm, set.set_descricao, ");
            buffer.append(" a.emc_obrigapeso, a.emc_referencia, a.emc_obrigaaltura, a.emc_obrigavolume, a.emc_proibido, a.emc_obrigatempodiurese, a.emc_obrigafotopaciente, a.emc_obrigabiometriapaciente, ");
            buffer.append(" grp.grp_codigo, grp.grp_descricao, mco.mco_descricao, mco.mco_abreviatura, a.exa_codigo, a.mco_codigo, ");
            buffer.append(" case when (select count(exa_codigo) from  examematcoletalabexterno where fil_codigo = a.fil_codigo ");
            buffer.append(" and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo and met_codigo = a.met_codigo ");
            buffer.append(" and (ele_bloqueado is null or ele_bloqueado = false)) > 0 then 'Terceirizado' else '' end as terceirizado, ");
            buffer.append(" exa_coa as coa, exa_soa as soa, a.emc_limitequantificacao as limiteQuantificacao, ");
            buffer.append(" set.set_codigo as codigoSetor, a.emc_pagina as pagina, a.emc_ordem as ordem, a.emc_exigirprocedencia, c.exa_inmetro, a.emc_obrigaperiodogestacional ");
            buffer.append(" ,c.exa_corponotificacao as corponotificacao, c.exa_cabecalhonotificacao as cabecalhonotificacao  ");
            buffer.append(" from examematcoleta a ");
            buffer.append(" left join exames c on a.fil_codigo=c.fil_codigo and upper(a.exa_codigo)=upper(c.exa_codigo) ");
            buffer.append(" left join prazoentrega b on a.fil_codigo = b.fil_codigo and a.prz_codigo=b.prz_codigo ");
            buffer.append(" left join metodologia e on a.fil_codigo = e.fil_codigo and a.met_codigo=e.met_codigo ");
            buffer.append(" left join examesetor ese on c.fil_codigo = ese.fil_codigo and c.exa_codigo = ese.exa_codigo and ese.ese_default = true ");
            buffer.append(" left join setores set on ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
            buffer.append(" left join examematgrupo emg on a.fil_codigo = emg.fil_codigo and a.exa_codigo = emg.exa_codigo and a.mco_codigo = emg.mco_codigo ");
            buffer.append(" left join grupo grp on emg.fil_codigo = grp.fil_codigo and emg.grp_codigo = grp.grp_codigo ");
            buffer.append(" left join materialcoleta mco on a.fil_codigo = mco.fil_codigo and a.mco_codigo = mco.mco_codigo ");
            buffer.append(" where a.fil_codigo = ").append(filial);
            buffer.append(" and a.exa_codigo = ").append(StringUtil.textoDBEscape(exame));
            buffer.append(" and a.mco_codigo =");
            buffer.append(material.getCodigo());
            try (ResultSet rsColeta = null;){
                rsColeta = st.executeQuery(buffer.toString());
                if (rsColeta != null && rsColeta.next()) {
                    dadosExames = new DadosExames(exame, rsColeta.getString("exa_descricao"), rsColeta.getString("emc_instrcoleta"), rsColeta.getString("emc_preparo"), rsColeta.getString("emc_prepamostra"), rsColeta.getString("emc_inadequada"), rsColeta.getString("emc_referencia"), rsColeta.getString("emc_procedimento"), rsColeta.getString("emc_mensagem"), null, conveniosP.size() > 0 ? conveniosP : null, conveniosAutorizacao.size() > 0 ? conveniosAutorizacao : null, conveniosPrazo.size() > 0 ? conveniosPrazo : null, conveniosNaoFaturar.size() > 0 ? conveniosNaoFaturar : null, conveniosApenasFaturamento.size() > 0 ? conveniosApenasFaturamento : null, conveniosUrgente.size() > 0 ? conveniosUrgente : null, rsColeta.getString("prz_codigo"), rsColeta.getString("prz_descricao"), rsColeta.getBoolean("exa_proibido"), rsColeta.getString("emc_pergunta"), rsColeta.getString("emc_instrucaocoleta"), DBUtil.campoNull(rsColeta.getString("met_codigo")) ? "" : rsColeta.getString("met_codigo"), DBUtil.campoNull(rsColeta.getString("met_descricao")) ? "" : rsColeta.getString("met_descricao"), matUtilizado, rsColeta.getString("exa_sexo"), DBUtil.campoNull(rsColeta.getString("exa_idademin")) ? -1 : rsColeta.getInt("exa_idademin"), DBUtil.campoNull(rsColeta.getString("exa_idademintipo")) ? "" : rsColeta.getString("exa_idademintipo"), DBUtil.campoNull(rsColeta.getString("exa_idademax")) ? -1 : rsColeta.getInt("exa_idademax"), DBUtil.campoNull(rsColeta.getString("exa_idademaxtipo")) ? "" : rsColeta.getString("exa_idademaxtipo"), rsColeta.getString("emc_conservacao"), DBUtil.campoNull(rsColeta.getString("emc_diasconserva")) ? "" : rsColeta.getString("emc_diasconserva"), rsColeta.getString("emc_temperaturainicial"), rsColeta.getString("emc_temperaturafinal"), rsColeta.getBoolean("emc_solicitarjejum"), rsColeta.getString("exa_autorizacao"), rsColeta.getBoolean("emc_obrigamedicamento"), rsColeta.getBoolean("emc_obrigadum"), rsColeta.getBoolean("emc_marcarexterno"), rsColeta.getBoolean("exa_salvaparcial"), rsColeta.getBoolean("emc_obrigapeso"), rsColeta.getBoolean("emc_obrigaaltura"), rsColeta.getBoolean("emc_obrigavolume"), rsColeta.getBoolean("emc_obrigatempodiurese"), rsColeta.getBoolean("emc_proibido"), rsColeta.getBoolean("emc_obrigafotopaciente"), rsColeta.getBoolean("emc_obrigabiometriapaciente"), rsColeta.getBoolean("emc_exigirprocedencia"), rsColeta.getString("emc_codigoamb"), rsColeta.getString("emc_codigocbhpm"), rsColeta.getString("set_descricao"), conveniosContrassenha.size() > 0 ? conveniosContrassenha : null, BigDecimal.ZERO, destinosPadrao, rsColeta.getString("grp_codigo"), rsColeta.getString("grp_descricao"), rsColeta.getString("mco_descricao"), rsColeta.getString("mco_abreviatura"), rsColeta.getString("terceirizado"), rsColeta.getInt("mco_codigo"), rsColeta.getString("coa"), rsColeta.getString("soa"), rsColeta.getString("limiteQuantificacao"), rsColeta.getString("codigoSetor"), rsColeta.getInt("pagina"), rsColeta.getInt("ordem"), null, null, null, null, rsColeta.getString("emc_referencia"), rsColeta.getBoolean("exa_inmetro"), rsColeta.getBoolean("emc_obrigaperiodogestacional"));
                    dadosExames.setNotificacaoCorpo(rsColeta.getString("corponotificacao"));
                    dadosExames.setNotificacaoCabecalho(rsColeta.getString("cabecalhonotificacao"));
                }
            }
        }
        return dadosExames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DadosExames getDadosExameSimples(String filial, String exame, DadosMaterial material, Statement st) throws SQLException {
        DadosExames dadosExames = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" select c.exa_salvaparcial, c.exa_descricao, a.exa_codigo ");
        buffer.append(" from examematcoleta a ");
        buffer.append(" left join exames c on a.fil_codigo=c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buffer.append(" where a.fil_codigo=");
        buffer.append(filial);
        buffer.append(" and a.exa_codigo = '");
        buffer.append(exame.toUpperCase());
        buffer.append("' and a.mco_codigo=");
        buffer.append(material.getCodigo());
        try (ResultSet rsColeta = null;){
            rsColeta = st.executeQuery(buffer.toString());
            if (rsColeta != null && rsColeta.next()) {
                dadosExames = new DadosExames(rsColeta.getString("exa_codigo"), rsColeta.getString("exa_descricao"), rsColeta.getBoolean("exa_salvaparcial"));
            }
        }
        return dadosExames;
    }

    public static Date calculaDataEntrega(String filial, String prazo, String codExame, String codMaterial, String codConvenio, String destino) throws SQLException {
        return ExameUtil.calculaDataEntrega(filial, prazo, codExame, codMaterial, codConvenio, new Date(), destino, new Date());
    }

    public static Date calculaDataEntrega(String filial, String prazo, String codExame, String codMaterial, String codConvenio, Statement st) throws SQLException {
        return ExameUtil.calculaDataEntrega(filial, prazo, codExame, codMaterial, codConvenio, new Date(), st, null, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date calculaDataEntrega(String filial, String prazo, String codExame, String codMaterial, String codConvenio, Date dataBase, String destino, Date dataPadrao) throws SQLException {
        Date date;
        Statement st = Conexao.getStatement();
        try {
            date = ExameUtil.calculaDataEntrega(filial, prazo, codExame, codMaterial, codConvenio, dataBase, st, destino, dataPadrao);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return date;
    }

    public static Date antigo_calculaDataEntrega(String filial, String prazo, String codExame, String codMaterial, String codConvenio, Date dataBase, Statement st) throws SQLException {
        int REALIZA = 82;
        int CONTA = 67;
        int NAO = 78;
        int NAO_ENTREGA = 69;
        int NAO_ENTREGA_NAO_SOMA = 83;
        StringBuilder tmp = new StringBuilder();
        String prz = prazo;
        tmp.append("select prz_codigo from examematconvenioprazo ");
        tmp.append("where fil_codigo = ").append(filial);
        tmp.append(" and exa_codigo = '").append(codExame);
        tmp.append("' and mco_codigo = ").append(codMaterial);
        tmp.append(" and con_codigo = ");
        tmp.append(codConvenio);
        ResultSet rs = Conexao.executeQuery(st, tmp);
        if (rs.next()) {
            prz = rs.getString("prz_codigo");
        }
        tmp.delete(0, tmp.length());
        tmp.append("select prz_prazo, prz_dias, prz_horaentrada, prz_horasaida, prz_horasaidasabado ");
        tmp.append("from prazoentrega where fil_codigo = ");
        tmp.append(filial);
        tmp.append(" and prz_codigo = ");
        tmp.append(prz);
        String realiza = "";
        char[] dia = new char[7];
        int dias = 0;
        String horaEntrada = "";
        String horaSaida = "";
        String horaSaidaSabado = "";
        Date data = dataBase;
        boolean rotinaIniciada = false;
        rs = Conexao.executeQuery(st, tmp.toString());
        if (rs.next()) {
            realiza = rs.getString("prz_prazo").toUpperCase();
            dia = realiza.toCharArray();
            dias = rs.getInt("prz_dias");
            horaEntrada = rs.getString("prz_horaentrada");
            horaSaida = rs.getString("prz_horasaida");
            horaSaidaSabado = rs.getString("prz_horasaidasabado");
        }
        rs.close();
        if (!Funcoes.verificaHora(horaEntrada)) {
            horaEntrada = Funcoes.formataHora(new Date(), false);
        }
        if (!Funcoes.verificaHora(horaSaida)) {
            horaSaida = Funcoes.formataHora(new Date(), false);
        }
        if (!Funcoes.verificaHora(horaSaidaSabado)) {
            horaSaidaSabado = Funcoes.formataHora(new Date(), false);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        int diaSemana = calendar.get(7);
        int i = diaSemana - 1;
        block2: while (true) {
            if (dia[i] != 'R' || dia[i] == 'R' && Funcoes.hoje(Funcoes.formataData(calendar.getTime())) && Funcoes.comparaHora(horaEntrada, Funcoes.formataHora(new Date(), false)) < 0) {
                if (dia[i] == 'S' || dia[i] == 'E') {
                    calendar.add(5, 1);
                } else {
                    ExameUtil.checkFeriado(filial, calendar, 1, st);
                }
                if (dia[i] == 'C' && rotinaIniciada || dia[i] == 'R' && Funcoes.hoje(Funcoes.formataData(calendar.getTime())) && Funcoes.comparaHora(horaEntrada, Funcoes.formataHora(new Date(), false)) < 0) {
                    --dias;
                }
                if (dias == 0) {
                    break;
                }
            } else if (dia[i] == 'R') {
                boolean feriado = DBUtil.feriado(filial, Funcoes.formataData(calendar.getTime()), st);
                if (!feriado) {
                    rotinaIniciada = true;
                }
                if (dias == 0 && rotinaIniciada) break;
                if (dias == 0 && feriado) {
                    ++dias;
                }
                while (dias > 0) {
                    if (dia[i] != 'N') {
                        ExameUtil.checkFeriado(filial, calendar, 1, st);
                        i = calendar.get(7) - 1;
                        if (dia[i] != 'S') {
                            if (!rotinaIniciada) {
                                if (dia[i] != 'R' || DBUtil.feriado(filial, Funcoes.formataData(calendar.getTime()), st)) break block2;
                                rotinaIniciada = true;
                                --dias;
                            } else {
                                --dias;
                            }
                        }
                    }
                    i = (i + 1) % 7;
                }
                break;
            }
            i = (i + 1) % 7;
        }
        i = calendar.get(7) - 1;
        if (dia[i] == 'E' || dia[i] == 'S') {
            ExameUtil.checkFeriado(filial, calendar, 1, st);
            char d = dia[calendar.get(7) - 1];
            for (int contaPassada = 1; (d == 'E' || d == 'S') && contaPassada < 5; ++contaPassada) {
                ExameUtil.checkFeriado(filial, calendar, 1, st);
                d = dia[calendar.get(7) - 1];
            }
        }
        st.close();
        try {
            int diaUtil = calendar.get(7);
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            return sdf.parse(Funcoes.formataData(calendar.getTime()) + " " + (diaUtil == 7 || diaUtil == 1 ? horaSaidaSabado : horaSaida));
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date calculaDataEntrega(String filial, String prazo, String codExame, String codMaterial, String codConvenio, Date dataBase, Statement st, String destino, Date dataPadrao) throws SQLException {
        char tipoPrazo;
        int diaSemana;
        boolean feriado;
        boolean horaPermitida;
        StringBuilder tmp = new StringBuilder();
        tmp.append(" select prz_codigo from examematconvenioprazo ");
        tmp.append("  where fil_codigo = ").append(filial);
        tmp.append("    and exa_codigo = '").append(codExame).append("' ");
        tmp.append("    and mco_codigo = ").append(codMaterial);
        tmp.append("    and con_codigo = ").append(codConvenio);
        try (ResultSet rs = null;){
            rs = st.executeQuery(tmp.toString());
            if (rs.next()) {
                prazo = rs.getString("prz_codigo");
            }
        }
        tmp.setLength(0);
        tmp.append(" select prz_prazo ");
        tmp.append("       ,prz_dias ");
        tmp.append("       ,prz_horaentrada ");
        tmp.append("       ,prz_horasaida ");
        tmp.append("       ,prz_horasaidasabado ");
        tmp.append("       ,COALESCE(prz_avisar, false) as avisar ");
        tmp.append("   from prazoentrega ");
        tmp.append("  where fil_codigo = ").append(filial);
        tmp.append("    and prz_codigo = ").append(prazo);
        char[] dia = new char[7];
        int dias = 0;
        String horaEntrada = "";
        String horaSaida = "";
        String horaSaidaSabado = "";
        try {
            rs = st.executeQuery(tmp.toString());
            if (rs.next()) {
                if (rs.getBoolean("avisar") || rs.getString("prz_prazo").toUpperCase().indexOf(String.valueOf(TipoPrazoEntrega.R.tipo)) < 0 && rs.getString("prz_prazo").toUpperCase().indexOf(String.valueOf(TipoPrazoEntrega.G.tipo)) < 0 || rs.getString("prz_prazo").toUpperCase().indexOf(String.valueOf(TipoPrazoEntrega.N.tipo)) < 0 && rs.getString("prz_prazo").toUpperCase().indexOf(String.valueOf(TipoPrazoEntrega.R.tipo)) < 0 && rs.getString("prz_prazo").toUpperCase().indexOf(String.valueOf(TipoPrazoEntrega.C.tipo)) < 0) {
                    Date date = null;
                    return date;
                }
                dia = rs.getString("prz_prazo").toUpperCase().toCharArray();
                dias = rs.getInt("prz_dias");
                horaEntrada = rs.getString("prz_horaentrada");
                horaSaida = rs.getString("prz_horasaida");
                horaSaidaSabado = rs.getString("prz_horasaidasabado");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        if (!Funcoes.textoVazio(destino)) {
            tmp.setLength(0);
            tmp.append(" select des_horasaida ");
            tmp.append("       ,des_horasaidasabado ");
            tmp.append("   from destino ");
            tmp.append("  where fil_codigo = ").append(filial);
            tmp.append("\t\tand\tdes_codigo = '").append(destino).append("' ");
            rs = st.executeQuery(tmp.toString());
            if (rs.next()) {
                if (!Funcoes.textoVazio(rs.getString("des_horasaida"))) {
                    horaSaida = rs.getString("des_horasaida");
                }
                if (!Funcoes.textoVazio(rs.getString("des_horasaidasabado"))) {
                    horaSaidaSabado = rs.getString("des_horasaidasabado");
                }
            }
            rs.close();
        }
        if (!Funcoes.verificaHora(horaSaida)) {
            horaSaida = Funcoes.formataHora(dataPadrao, false);
        }
        if (!Funcoes.verificaHora(horaSaidaSabado)) {
            horaSaidaSabado = Funcoes.formataHora(dataPadrao, false);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dataBase);
        boolean bl = horaPermitida = horaEntrada == null || Funcoes.comparaHora(horaEntrada, Funcoes.formataHora(dataBase, false)) > 0;
        while (true) {
            if (feriado = DBUtil.feriado(filial, Funcoes.formataData(calendar.getTime()), st)) {
                calendar.add(5, 1);
            } else {
                diaSemana = calendar.get(7) - 1;
                tipoPrazo = dia[diaSemana];
                if (TipoPrazoEntrega.getIniciaRotina(tipoPrazo) && horaPermitida) break;
                calendar.add(5, 1);
            }
            horaPermitida = true;
        }
        while (dias > 0) {
            feriado = DBUtil.feriado(filial, Funcoes.formataData(calendar.getTime()), st);
            if (feriado) {
                calendar.add(5, 1);
                continue;
            }
            diaSemana = calendar.get(7) - 1;
            tipoPrazo = dia[diaSemana];
            if (dias > 0) {
                calendar.add(5, 1);
            }
            if (!TipoPrazoEntrega.getSomaPrazo(tipoPrazo)) continue;
            --dias;
        }
        while (true) {
            if (feriado = DBUtil.feriado(filial, Funcoes.formataData(calendar.getTime()), st)) {
                calendar.add(5, 1);
                continue;
            }
            diaSemana = calendar.get(7) - 1;
            tipoPrazo = dia[diaSemana];
            if (TipoPrazoEntrega.getEntrega(tipoPrazo)) break;
            calendar.add(5, 1);
        }
        try {
            int diaUtil = calendar.get(7);
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            return sdf.parse(Funcoes.formataData(calendar.getTime()) + " " + (diaUtil == 7 || diaUtil == 1 ? horaSaidaSabado : horaSaida));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void checkFeriado(Calendar calendario, int dias) {
        ExameUtil.checkFeriado(calendario, dias, Conexao.getStatement());
    }

    private static void checkFeriado(Calendar calendario, int dias, Statement st) {
        ExameUtil.checkFeriado(Variaveis.filialPadrao, calendario, dias, st);
    }

    private static void checkFeriado(String filial, Calendar calendario, int dias, Statement st) {
        for (int i = 1; i <= dias; ++i) {
            calendario.add(5, dias);
            if (!DBUtil.feriado(filial, Funcoes.formataData(calendario.getTime()), st)) continue;
            ExameUtil.checkFeriado(filial, calendario, 1, st);
        }
    }

    public static BigDecimal calculaPrecoExameConvenio(String filial, String exame, int material, int convenio, Integer codigoRequisicao, Double percentualBalcaoExames, Integer codigoMetodologia) throws SQLException {
        return ExameUtil.calculaPrecoExameConvenio(Conexao.getStatement(), filial, exame, material, convenio, codigoRequisicao, percentualBalcaoExames, codigoMetodologia);
    }

    public static BigDecimal calculaPrecoExameConvenio(Statement st, String filial, String exame, int material, int convenio, Integer codigoRequisicao, Double percentualBalcaoExames, Integer codigoMetodologia) throws SQLException {
        DadosMaterial m = ExameUtil.getDadosMaterial(filial, material, st);
        DadosConvenios c = ConvenioUtil.getDadosConvenios(filial, convenio, st);
        DadosExames e = ExameUtil.getDadosExame(filial, exame, m, st);
        int situacao = ExameUtil.calculaPrecoExame(filial, e, m, c, true, false, false, codigoRequisicao, percentualBalcaoExames, codigoMetodologia, st);
        if (situacao == 0 || situacao == 4 || situacao == 5) {
            return e.getValorExame();
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal calculaPrecoExameConvenio(Statement st, String filial, String exame, int material, int convenio, Integer codigoRequisicao, Double percentualBalcaoExames, Integer codigoMetodologia, boolean precoMetodologia, RoundingMode arredondamentoPrecoExame, int parametrosCasasPrecoExame) throws SQLException {
        DadosMaterial m = ExameUtil.getDadosMaterial(filial, material, st);
        DadosConvenios c = ConvenioUtil.getDadosConvenios(filial, convenio, st);
        DadosExames e = ExameUtil.getDadosExame(filial, exame, m, st);
        int situacao = ExameUtil.calculaPrecoExame(filial, e, m, c, true, false, false, codigoRequisicao, percentualBalcaoExames, codigoMetodologia, st, 1, precoMetodologia, parametrosCasasPrecoExame, arredondamentoPrecoExame, true, true);
        if (situacao == 0 || situacao == 4 || situacao == 5) {
            return e.getValorExame();
        }
        return BigDecimal.ZERO;
    }

    public static boolean isExameProibidoConvenio(String filial, String codigoExame, Integer codigoMaterial, Integer codigoConvenio, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select eco_tipo ");
        buf.append("   from examesmatconvenio ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and exa_codigo = '").append(codigoExame).append("' ");
        buf.append("    and mco_codigo = ").append(codigoMaterial);
        buf.append("    and con_codigo = ").append(codigoConvenio);
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            String situacao = rs.getString("eco_tipo");
            return situacao != null && situacao.equalsIgnoreCase("P");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int calculaPrecoExame(String filial, DadosExames exame, DadosMaterial material, DadosConvenios convenio, boolean calcularValorConvenio, boolean isFaturamento, boolean isAdicionandoExame, Integer codigoRequisicao, Double percentualBalcaoExames, Integer codigoMetodologia, Integer quantidade) throws SQLException {
        int n;
        Statement st = Conexao.getStatement();
        try {
            n = ExameUtil.calculaPrecoExame(filial, exame, material, convenio, calcularValorConvenio, isFaturamento, isAdicionandoExame, codigoRequisicao, percentualBalcaoExames, codigoMetodologia, st, quantidade);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int calculaPrecoExame(String filial, DadosExames exame, DadosMaterial material, DadosConvenios convenio, boolean calcularValorConvenio, boolean isFaturamento, boolean isAdicionandoExame, Integer codigoRequisicao, Double percentualBalcaoExames, Integer codigoMetodologia) throws SQLException {
        int n;
        Statement st = Conexao.getStatement();
        try {
            n = ExameUtil.calculaPrecoExame(filial, exame, material, convenio, calcularValorConvenio, isFaturamento, isAdicionandoExame, codigoRequisicao, percentualBalcaoExames, codigoMetodologia, st, 1);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return n;
    }

    public static int calculaPrecoExame(String filial, DadosExames exame, DadosMaterial material, DadosConvenios convenio, boolean calcularValorConvenio, boolean isFaturamento, boolean isAdicionandoExame, Integer codigoRequisicao, Double percentualBalcaoExames, Integer codigoMetodologia, Statement st) throws SQLException {
        return ExameUtil.calculaPrecoExame(filial, exame, material, convenio, calcularValorConvenio, isFaturamento, isAdicionandoExame, codigoRequisicao, percentualBalcaoExames, codigoMetodologia, st, 1);
    }

    public static int calculaPrecoExame(String filial, DadosExames exame, DadosMaterial material, DadosConvenios convenio, boolean calcularValorConvenio, boolean isFaturamento, boolean isAdicionandoExame, Integer codigoRequisicao, Double percentualBalcaoExames, Integer codigoMetodologia, Statement st, Integer quantidadeExame) throws SQLException {
        return ExameUtil.calculaPrecoExame(filial, exame, material, convenio, calcularValorConvenio, isFaturamento, isAdicionandoExame, codigoRequisicao, percentualBalcaoExames, codigoMetodologia, st, quantidadeExame, ParametrosGerais.getPrecoMetodologia(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame(), true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int calculaPrecoExame(String filial, DadosExames exame, DadosMaterial material, DadosConvenios convenio, boolean calcularValorConvenio, boolean isFaturamento, boolean isAdicionandoExame, Integer codigoRequisicao, Double percentualBalcaoExames, Integer codigoMetodologia, Statement st, Integer quantidadeExame, boolean utilizarPrecoMetodologia, int casasPrecoExame, RoundingMode roundPrecoExame, boolean reconectarStatement, boolean apresentarMensagem) throws SQLException {
        BigDecimal percentualBalcaoExamesAux;
        BigDecimal valorUCO;
        StringBuilder buf = new StringBuilder("");
        DadosTabelaPreco tabela = null;
        BigDecimal valorTemp = BigDecimal.ZERO;
        BigDecimal percentualTemp = BigDecimal.ZERO;
        BigDecimal valorPorteTemp = BigDecimal.ZERO;
        String porteTemp = "";
        boolean exameNaoLocalizado = true;
        int autorizacaoConvenio = 0;
        if (convenio == null) {
            return 0;
        }
        if (convenio.isUtilizarPrecoDiferenciado()) {
            buf.setLength(0);
            buf.append(" select a.cpr_valor ");
            buf.append("       ,coalesce(a.cpr_percentual, 0) as cpr_percentual ");
            buf.append("       ,coalesce(c.tpp_valor, 0) as tpp_Valor ");
            buf.append("       ,c.tpp_porte ");
            buf.append("   from conveniospreco a ");
            buf.append("   left join tabelaprecoexamesporte c on a.fil_codigo = c.fil_codigo and a.tpe_codigo = c.tpe_codigo and a.tpp_porte = c.tpp_porte ");
            buf.append("  where a.fil_codigo = ").append(filial);
            buf.append("    and a.exa_codigo = ").append(StringUtil.textoDBEscape(exame.getCodigo()));
            buf.append("    and a.mco_codigo = ").append(material.getCodigo());
            buf.append("    and a.con_codigo = ").append(convenio.getCodigo());
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                if (rs.next()) {
                    valorTemp = rs.getBigDecimal("cpr_valor");
                    percentualTemp = rs.getBigDecimal("cpr_percentual");
                    valorPorteTemp = rs.getBigDecimal("tpp_valor");
                    porteTemp = rs.getString("tpp_porte");
                    exameNaoLocalizado = false;
                }
            }
        }
        buf.setLength(0);
        buf.append(" select tpe.tpe_codigo ");
        if (utilizarPrecoMetodologia && codigoMetodologia != null) {
            buf.append("       ,COALESCE(dtm.dtm_codamb, dtp.dtp_codamb) as dtp_codamb ");
            buf.append("       ,COALESCE(dtm.dtm_proibido, dtp.dtp_proibido) as dtp_proibido ");
            buf.append("       ,COALESCE(dtm.dtm_valor, dtp.dtp_valor) as dtp_valor ");
            buf.append("       ,COALESCE(dtm.dtm_percentual, dtp.dtp_percentual) as dtp_percentual ");
        } else {
            buf.append("       ,dtp.dtp_codamb ");
            buf.append("       ,dtp.dtp_proibido ");
            buf.append("       ,dtp.dtp_valor ");
            buf.append("       ,dtp.dtp_percentual ");
        }
        buf.append("       ,tpe.tpe_tipocbhpm ");
        buf.append("       ,tpp.tpp_valor ");
        buf.append("       ,tpe.tpe_uco ");
        buf.append("       ,tpp.tpp_porte ");
        buf.append("   from tabelaprecoexames tpe ");
        buf.append("   left join detalhetabelapreco dtp on tpe.fil_codigo = dtp.fil_codigo and tpe.tpe_codigo = dtp.tpe_codigo and upper(dtp.exa_codigo) = upper('").append(exame.getCodigo()).append("') and dtp.mco_codigo = ").append(material.getCodigo());
        if (utilizarPrecoMetodologia && codigoMetodologia != null) {
            buf.append("   left join detalhetabelaprecometodologia dtm on tpe.fil_codigo = dtm.fil_codigo and tpe.tpe_codigo = dtm.tpe_codigo and upper(dtm.exa_codigo) = upper('").append(exame.getCodigo()).append("') and dtm.mco_codigo = ").append(material.getCodigo()).append(" and dtm.met_codigo = ").append(codigoMetodologia);
        }
        buf.append("   left join tabelaprecoexamesporte tpp on tpe.fil_codigo = tpp.fil_codigo and tpe.tpe_codigo = tpp.tpe_codigo and dtp.tpp_porte = tpp.tpp_porte");
        buf.append("  where tpe.fil_codigo = ").append(filial);
        buf.append("    and tpe.tpe_codigo = ").append(convenio.getTabela());
        ResultSet rsTabelas = st.executeQuery(buf.toString());
        if (rsTabelas.next()) {
            if (rsTabelas.getBoolean("tpe_tipocbhpm")) {
                if (!convenio.isUtilizarPrecoDiferenciado() || exameNaoLocalizado) {
                    valorTemp = rsTabelas.getBigDecimal("dtp_valor");
                    percentualTemp = rsTabelas.getBigDecimal("dtp_percentual");
                    valorPorteTemp = rsTabelas.getBigDecimal("tpp_valor");
                    porteTemp = rsTabelas.getString("tpp_porte");
                }
                tabela = new DadosTabelaPreco(rsTabelas.getInt("tpe_codigo"), rsTabelas.getString("dtp_codamb"), rsTabelas.getBoolean("dtp_proibido"), percentualTemp, valorTemp, porteTemp, valorPorteTemp, rsTabelas.getBigDecimal("tpe_uco"));
            } else {
                if (!convenio.isUtilizarPrecoDiferenciado() || exameNaoLocalizado) {
                    valorTemp = rsTabelas.getBigDecimal("dtp_valor");
                }
                tabela = new DadosTabelaPreco(rsTabelas.getInt("tpe_codigo"), rsTabelas.getString("dtp_codamb"), rsTabelas.getBoolean("dtp_proibido"), valorTemp);
            }
        }
        rsTabelas.close();
        exame.setTabelaPreco(tabela);
        try {
            int proibido;
            int n = isAdicionandoExame ? ExameUtil.proibidoConvenio(exame, convenio) : (proibido = ExameUtil.isExameProibidoConvenio(filial, exame.getCodigo(), material.getCodigo(), convenio.getCodigo(), st) ? 6 : 0);
            if (isAdicionandoExame) {
                exame.setApenasFaturamento(proibido == 11);
            }
            if (tabela == null || tabela.getProibido() || exame.getProibido() || exame.getMaterialProibido() || proibido == 6) {
                if (isAdicionandoExame) {
                    return tabela == null || tabela.getProibido() ? 8 : (exame.getProibido() ? 1 : (exame.getMaterialProibido() ? 7 : proibido));
                }
                exame.setProibido(true);
            } else if (proibido != 0 && proibido != 9 && proibido != 11 && isAdicionandoExame) {
                if (!calcularValorConvenio || proibido != 4) {
                    autorizacaoConvenio = proibido;
                }
            } else if (proibido == 9) {
                if (!isAdicionandoExame) {
                    return proibido;
                }
                exame.setNaoFaturar(true);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar situa\u00e7\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
        }
        if (codigoRequisicao != null) {
            buf.setLength(0);
            buf.append(" select COALESCE(exr_naofaturar, false) as naofaturar ");
            buf.append("   from examerequisicao ");
            buf.append("  where fil_codigo = ").append(filial);
            buf.append("    and req_codigo = ").append(codigoRequisicao);
            buf.append("    and exa_codigo = '").append(exame.getCodigo()).append("' ");
            buf.append("    and mco_codigo = ").append(material.getCodigo());
            buf.append("    and exr_excluido = false ");
            try (ResultSet rsAux = null;){
                rsAux = st.executeQuery(buf.toString());
                if (rsAux.next()) {
                    exame.setNaoFaturar(rsAux.getBoolean("naofaturar"));
                }
            }
        }
        int casasMaterial = 4;
        if (!Funcoes.objectIsNull(convenio) && convenio.getConvenioUtilizarCasasDecimais()) {
            casasPrecoExame = convenio.getConvenioCasasPrecoExame();
            roundPrecoExame = convenio.getConvenioTipoArredondamentoPrecoRoundingMode();
        }
        BigDecimal valorTabela = (tabela == null || tabela.getValor() == null ? BigDecimal.ZERO : tabela.getValor()).setScale(3, roundPrecoExame);
        BigDecimal valorFinal = BigDecimal.ZERO.setScale(3, roundPrecoExame);
        if (!Funcoes.textoVazio(convenio.getIndiceReajuste())) {
            String[] indices;
            for (String indice : indices = convenio.getIndiceReajuste().split("\\+")) {
                if (!Funcoes.isNumeric(indice)) continue;
                BigDecimal percIndice = new BigDecimal(Funcoes.limpaDecimal(indice));
                valorTabela = valorTabela.add(valorTabela.multiply(percIndice).divide(new BigDecimal("100").setScale(3, roundPrecoExame))).setScale(3, roundPrecoExame);
            }
        }
        exame.setValorCH(valorTabela);
        if (tabela != null) {
            exame.setAMB(tabela.getAMB());
        }
        exame.setMateriaisFaturamento(new ArrayList<DadosMaterialFaturamento>());
        BigDecimal auxMaterial = BigDecimal.ZERO.setScale(casasMaterial, roundPrecoExame);
        BigDecimal auxMaterialBalcao = BigDecimal.ZERO.setScale(casasMaterial, roundPrecoExame);
        for (int i = 0; i < exame.getMatUtilizado().size(); ++i) {
            BigDecimal perc;
            DadosMaterialUtilizado m = (DadosMaterialUtilizado)exame.getMatUtilizado().get(i);
            DadosMaterialFaturamento mat = new DadosMaterialFaturamento();
            mat.setCodigo(m.getCodigo());
            mat.setDescricao(m.getDescricao());
            mat.setQuantidade(m.getQtde());
            mat.setValor(BigDecimal.ZERO);
            BigDecimal valor = m.getValor() == null ? BigDecimal.ZERO : m.getValor();
            BigDecimal qtde = m.getQtde() == null ? BigDecimal.ZERO : m.getQtde();
            BigDecimal aux = valor.multiply(qtde).setScale(casasMaterial, roundPrecoExame);
            if (isFaturamento) {
                if (convenio.getCobraMaterial()) {
                    if (m.getCobrarBalcao()) {
                        perc = new BigDecimal(String.valueOf(convenio.getPercentualBalcaoMaterial()));
                        BigDecimal auxBalcao = aux.multiply(perc).divide(new BigDecimal("100"), casasMaterial, roundPrecoExame);
                        auxMaterialBalcao = auxMaterialBalcao.add(auxBalcao);
                        aux = aux.subtract(auxBalcao);
                    }
                    auxMaterial = auxMaterial.add(aux).setScale(casasMaterial, roundPrecoExame);
                    mat.setValor(aux.divide(mat.getQuantidade(), roundPrecoExame).setScale(casasMaterial, roundPrecoExame));
                }
                exame.addMaterialFaturamento(mat);
                continue;
            }
            if (convenio.getCobraMaterial()) {
                auxMaterial = auxMaterial.add(aux).setScale(casasMaterial, roundPrecoExame);
            }
            if (!m.getCobrarBalcao()) continue;
            perc = new BigDecimal(String.valueOf(convenio.getPercentualBalcaoMaterial()));
            auxMaterialBalcao = auxMaterialBalcao.add(aux.multiply(perc).divide(new BigDecimal("100"), casasMaterial, roundPrecoExame));
        }
        BigDecimal valorPorte = tabela.getValorPorte() == null ? BigDecimal.ZERO : tabela.getValorPorte().setScale(3, RoundingMode.HALF_DOWN);
        BigDecimal bigDecimal = valorUCO = tabela.getUco() == null ? BigDecimal.ZERO : tabela.getUco().setScale(3, roundPrecoExame);
        if (tabela.isTipoCBHPM()) {
            if (convenio.getAcrescimoPorte() > 0.0) {
                valorPorte = valorPorte.add(valorPorte.multiply(new BigDecimal(String.valueOf(convenio.getAcrescimoPorte()))).setScale(3, roundPrecoExame).divide(new BigDecimal("100").setScale(3, roundPrecoExame), roundPrecoExame));
                valorPorte = valorPorte.setScale(3, roundPrecoExame);
            }
            if (convenio.getAcrescimoUCO() > 0.0) {
                valorUCO = valorUCO.add(valorUCO.multiply(new BigDecimal(String.valueOf(convenio.getAcrescimoUCO()))).setScale(3, roundPrecoExame).divide(new BigDecimal("100").setScale(3, roundPrecoExame), roundPrecoExame));
                valorUCO = valorUCO.setScale(3, roundPrecoExame);
            }
            if (convenio.getDescontoPorte() > 0.0) {
                valorPorte = valorPorte.subtract(valorPorte.multiply(new BigDecimal(String.valueOf(convenio.getDescontoPorte())).divide(new BigDecimal("100").setScale(3, roundPrecoExame))));
                valorPorte = valorPorte.setScale(3, roundPrecoExame);
            }
            if (convenio.getDescontoUCO() > 0.0) {
                valorUCO = valorUCO.subtract(valorUCO.multiply(new BigDecimal(String.valueOf(convenio.getDescontoUCO())).setScale(3, roundPrecoExame).divide(new BigDecimal("100").setScale(3, roundPrecoExame))));
                valorUCO = valorUCO.setScale(3, roundPrecoExame);
            }
            valorFinal = valorTabela.multiply(valorPorte).add(tabela.getCusto().multiply(valorUCO)).setScale(casasPrecoExame, roundPrecoExame);
        } else {
            valorFinal = convenio.getTipoCalculo().equalsIgnoreCase(SEXO_MASCULINO) ? valorTabela.setScale(casasPrecoExame, roundPrecoExame).multiply(convenio.getCH().setScale(4, roundPrecoExame)) : valorTabela.setScale(casasPrecoExame, roundPrecoExame).divide(convenio.getCH() == BigDecimal.ZERO ? BigDecimal.ONE : convenio.getCH().setScale(4, roundPrecoExame), roundPrecoExame);
        }
        valorFinal = valorFinal.setScale(casasPrecoExame, roundPrecoExame);
        if (isFaturamento) {
            auxMaterialBalcao = BigDecimal.ZERO;
        } else {
            auxMaterial = BigDecimal.ZERO;
        }
        BigDecimal vlAdd = BigDecimal.ZERO;
        if (convenio.getAcrescimo() > 0.0) {
            vlAdd = valorFinal.multiply(new BigDecimal(String.valueOf(convenio.getAcrescimo()))).divide(new BigDecimal("100"));
        }
        BigDecimal vlSub = BigDecimal.ZERO;
        if (convenio.getBonus() > 0.0) {
            vlSub = valorFinal.multiply(new BigDecimal(String.valueOf(convenio.getBonus()))).divide(new BigDecimal("100"));
        }
        valorFinal = valorFinal.add(vlAdd).setScale(casasPrecoExame, roundPrecoExame);
        valorFinal = valorFinal.subtract(vlSub).setScale(casasPrecoExame, roundPrecoExame);
        BigDecimal bigDecimal2 = percentualBalcaoExamesAux = percentualBalcaoExames == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(percentualBalcaoExames));
        if (convenio.isPerguntarPercentualBalcaoExames() && codigoRequisicao != null && percentualBalcaoExames == null) {
            buf.setLength(0);
            buf.append(" select exr_vlrbalcaoconvenio ");
            buf.append("   from examerequisicao ");
            buf.append("  where fil_codigo =  ").append(filial);
            buf.append("    and req_codigo = ").append(codigoRequisicao);
            buf.append("    and mco_codigo = ").append(material.getCodigo());
            buf.append("    and upper(exa_codigo) = upper('").append(exame.getCodigo()).append("') ");
            ResultSet rsPercentual = st.executeQuery(buf.toString());
            if (rsPercentual.next()) {
                percentualBalcaoExamesAux = rsPercentual.getBigDecimal("exr_vlrbalcaoconvenio");
                if (rsPercentual != null) {
                    rsPercentual.close();
                }
            } else {
                buf.setLength(0);
                buf.append(" select exr.exr_vlrbalcaoconvenio ");
                buf.append("   from requisicao req ");
                buf.append("   join examerequisicao exr on req.fil_codigo = req.fil_codigo and req.req_codigo = exr.req_codigo ");
                buf.append("   join exameagrupaexameconvenio eac on exr.fil_codigo = eac.fil_codigo and exr.exa_codigo = eac.exa_codigo and exr.mco_codigo = eac.mco_codigo and req.con_codigo = eac.con_codigo ");
                buf.append("  where req.fil_codigo = ").append(filial);
                buf.append("    and req.req_codigo = ").append(codigoRequisicao);
                buf.append("    and upper(eac.exa_kodigo) = upper('").append(exame.getCodigo()).append("') ");
                buf.append("    and exr.mco_codigo = ").append(material.getCodigo());
                buf.append("    and eac.aec_tipo   = '").append(SEXO_FEMININO).append("' ");
                if (rsPercentual != null) {
                    rsPercentual.close();
                }
                if ((rsPercentual = st.executeQuery(buf.toString())).next()) {
                    percentualBalcaoExamesAux = rsPercentual.getBigDecimal("exr_vlrbalcaoconvenio");
                    if (rsPercentual != null) {
                        rsPercentual.close();
                    }
                } else {
                    buf.setLength(0);
                    buf.append(" select exr.exr_vlrbalcaoconvenio ");
                    buf.append("   from agrupaexameconvenio      a ");
                    buf.append("   join exameagrupaexameconvenio eae on a.fil_codigo = eae.fil_codigo and a.exa_codigo = eae.exa_codigo and a.mco_codigo = eae.mco_codigo and eae.aec_tipo = '").append(SEXO_FEMININO).append("' and a.con_codigo = eae.con_codigo ");
                    buf.append("   join examerequisicao          exr on eae.fil_codigo = exr.fil_codigo and eae.exa_codigo = exr.exa_codigo and eae.mco_codigo = exr.mco_codigo ");
                    buf.append("  where exr.fil_codigo = ").append(filial);
                    buf.append("    and eae.exa_kodigo = '").append(exame.getCodigo()).append("' ");
                    buf.append("    and eae.mco_kodigo = ").append(material.getCodigo());
                    buf.append("    and exr.req_codigo = ").append(codigoRequisicao);
                    buf.append("    and a.aec_ignorarconvenio ");
                    if (rsPercentual != null) {
                        rsPercentual.close();
                    }
                    try {
                        rsPercentual = st.executeQuery(buf.toString());
                        if (rsPercentual.next()) {
                            percentualBalcaoExamesAux = rsPercentual.getBigDecimal("exr_vlrbalcaoconvenio");
                        }
                    }
                    finally {
                        if (rsPercentual != null) {
                            rsPercentual.close();
                        }
                    }
                }
            }
        }
        if (percentualBalcaoExamesAux == null) {
            percentualBalcaoExamesAux = BigDecimal.ZERO;
        }
        if (!calcularValorConvenio) {
            BigDecimal perc;
            if (isFaturamento) {
                if (convenio.isPerguntarPercentualBalcaoExames()) {
                    perc = new BigDecimal("100").subtract(percentualBalcaoExamesAux.setScale(casasPrecoExame, roundPrecoExame));
                    valorFinal = valorFinal.multiply(perc).divide(new BigDecimal("100").setScale(casasPrecoExame, roundPrecoExame), roundPrecoExame);
                } else {
                    perc = new BigDecimal("100").subtract(new BigDecimal(String.valueOf(convenio.getPercentualBalcao())));
                    valorFinal = valorFinal.multiply(perc).divide(new BigDecimal("100").setScale(casasPrecoExame, roundPrecoExame), roundPrecoExame);
                }
            } else {
                perc = BigDecimal.ZERO;
                BigDecimal percCompl = BigDecimal.ZERO;
                perc = convenio.isPerguntarPercentualBalcaoExames() ? percentualBalcaoExamesAux : new BigDecimal(convenio.getPercentualBalcao());
                percCompl = new BigDecimal(100).subtract(perc);
                BigDecimal valorCaixa = valorFinal.multiply(perc).divide(new BigDecimal("100").setScale(casasPrecoExame, roundPrecoExame), roundPrecoExame);
                BigDecimal valorFaturado = valorFinal.multiply(percCompl).divide(new BigDecimal("100").setScale(casasPrecoExame, roundPrecoExame), roundPrecoExame);
                BigDecimal diferenca = valorFinal.subtract(valorCaixa.add(valorFaturado));
                valorFinal = valorCaixa.add(diferenca);
            }
        }
        if (tabela.isTipoCBHPM()) {
            exame.setCusto(tabela.getCusto());
            exame.setPercentual(tabela.getValor());
            exame.setUco(valorUCO);
            exame.setValorPorte(valorPorte);
            exame.setPorte(tabela.getCodigoPorte());
        }
        exame.setValorUnitarioExame(valorFinal.setScale(casasPrecoExame, roundPrecoExame));
        valorFinal = valorFinal.multiply(new BigDecimal(quantidadeExame.toString()));
        exame.setValorExame(valorFinal.setScale(casasPrecoExame, roundPrecoExame));
        valorFinal = valorFinal.add(auxMaterial).add(auxMaterialBalcao);
        valorFinal = valorFinal.setScale(casasPrecoExame, roundPrecoExame);
        exame.setValor(valorFinal);
        exame.setValorMaterial(auxMaterial);
        exame.setValorMaterialBalcao(auxMaterialBalcao);
        return autorizacaoConvenio;
    }

    public static int proibidoConvenio(DadosExames exame, DadosConvenios convenio) {
        int i = -1;
        if (exame.getConvenios() != null && exame.getConvenios().size() > 0) {
            i = exame.getConvenios().indexOf(String.valueOf(convenio.getCodigo()));
        }
        if (i > -1) {
            return 6;
        }
        if (exame.getConveniosAutorizacao() != null && exame.getConveniosAutorizacao().size() > 0) {
            i = exame.getConveniosAutorizacao().indexOf(String.valueOf(convenio.getCodigo()));
        }
        if (i > -1) {
            return 4;
        }
        if (exame.getConveniosPrazo() != null && exame.getConveniosPrazo().size() > 0) {
            i = exame.getConveniosPrazo().indexOf(String.valueOf(convenio.getCodigo()));
        }
        if (i > -1) {
            return 5;
        }
        if (exame.getConveniosNaoFaturar() != null && exame.getConveniosNaoFaturar().size() > 0) {
            i = exame.getConveniosNaoFaturar().indexOf(String.valueOf(convenio.getCodigo()));
        }
        if (i > -1) {
            return 9;
        }
        if (exame.getConveniosContrassenha() != null && exame.getConveniosContrassenha().size() > 0) {
            i = exame.getConveniosContrassenha().indexOf(String.valueOf(convenio.getCodigo()));
        }
        if (i > -1) {
            return 10;
        }
        if (exame.getConveniosApenasFaturamento() != null && exame.getConveniosApenasFaturamento().size() > 0) {
            i = exame.getConveniosApenasFaturamento().indexOf(String.valueOf(convenio.getCodigo()));
        }
        if (i > -1) {
            return 11;
        }
        return 0;
    }

    public static int verificaIdadeSexo(DadosExames exame, String sexo, String idade) {
        if (exame == null) {
            return 2;
        }
        if (!(sexo == null || sexo.length() <= 0 || exame.getSexo().equalsIgnoreCase(SEXO_AMBOS) || sexo.substring(0, 1).equalsIgnoreCase(exame.getSexo()) || sexo.substring(0, 1).equalsIgnoreCase("I"))) {
            return 2;
        }
        if (idade != null && exame.getIdadeMin() > 0 || exame.getIdadeMax() > 0) {
            String am = ExameUtil.pegaAnoIdade(idade, true);
            int idadePac = Integer.parseInt(ExameUtil.pegaAnoIdade(idade, false)) * (am.equalsIgnoreCase(SEXO_AMBOS) ? 365 : (am.equalsIgnoreCase(SEXO_MASCULINO) ? 30 : 1));
            am = exame.getTipoIdadeMin();
            int idadeMin = exame.getIdadeMin() * (am.equalsIgnoreCase(SEXO_AMBOS) ? 365 : (am.equalsIgnoreCase(SEXO_MASCULINO) ? 30 : 1));
            am = exame.getTipoIdadeMax();
            int idadeMax = exame.getIdadeMax() * (am.equalsIgnoreCase(SEXO_AMBOS) ? 365 : (am.equalsIgnoreCase(SEXO_MASCULINO) ? 30 : 1));
            if (idadePac < idadeMin || idadePac > idadeMax) {
                return 3;
            }
        }
        return 0;
    }

    public static String pegaAnoIdade(String idade, boolean anomes) {
        String s = idade;
        if (Funcoes.textoVazio(s)) {
            if (!anomes) {
                return "0";
            }
            return SEXO_AMBOS;
        }
        if (s.indexOf(" ") > -1) {
            s = !anomes ? s.substring(0, s.indexOf(" ")) : s.substring(s.indexOf(" "), s.indexOf(" ") + 2);
        }
        return s.trim().toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DadosMaterial getDadosMaterial(String filial, int codigo) throws SQLException {
        DadosMaterial dadosMaterial;
        Statement st = Conexao.getStatement();
        try {
            dadosMaterial = ExameUtil.getDadosMaterial(filial, codigo, st);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return dadosMaterial;
    }

    public static DadosMaterial getDadosMaterial(String filial, int codigo, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder("select mco_codigo, mco_descricao, mco_solicitarmat, mco_abreviatura, mco_solicitararea ");
        buf.append("from materialcoleta ");
        buf.append("where fil_codigo = ");
        buf.append(filial);
        buf.append(" and mco_codigo = ");
        buf.append(String.valueOf(codigo));
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            DadosMaterial mat = new DadosMaterial(rs.getInt("mco_codigo"), rs.getString("mco_descricao"), rs.getBoolean("mco_solicitarmat"), rs.getBoolean("mco_solicitararea"));
            mat.setAbreviatura(rs.getString("mco_abreviatura"));
            return mat;
        }
        return null;
    }

    public static String pegaLayoutIdade(String filial, int idade, String tipoIdade, String layout, String exame, int codigoMaterial, int codigoMetodo, String campoRetorno) {
        return ExameUtil.pegaLayoutIdade(filial, idade, tipoIdade, layout, exame, codigoMaterial, codigoMetodo, campoRetorno, null);
    }

    public static String pegaLayoutIdade(String filial, int idade, String tipoIdade, String layout, String exame, int codigoMaterial, int codigoMetodo, String campoRetorno, Registro reg) {
        return ExameUtil.pegaLayoutIdade(filial, idade, tipoIdade, layout, exame, codigoMaterial, codigoMetodo, campoRetorno, reg, false);
    }

    public static String pegaLayoutIdade(String filial, int idade, String tipoIdade, String layout, String exame, int codigoMaterial, int codigoMetodo, String campoRetorno, Registro reg, boolean validarVazio) {
        Statement st = Conexao.getStatement();
        String retorno = ExameUtil.pegaLayoutIdade(filial, idade, tipoIdade, layout, exame, codigoMaterial, codigoMetodo, campoRetorno, reg, false, st);
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static String pegaLayoutIdade(String filial, int idade, String tipoIdade, String layout, String exame, int codigoMaterial, int codigoMetodo, String campoRetorno, Registro reg, boolean validarVazio, Statement st) {
        if (st != null) {
            try {
                int linha = 0;
                int codLay = StringUtil.validaInteiro(layout) ? Integer.parseInt(layout) : -1;
                ResultSet rs = st.executeQuery(ExameUtil.sqlPegaLayoutIdade(filial, exame, codigoMaterial, codigoMetodo, campoRetorno, validarVazio, tipoIdade, idade));
                boolean continuar = rs.next();
                while (continuar) {
                    boolean interValido = rs.getBoolean("intervaloValido");
                    boolean idadeZero = rs.getBoolean("idadeZero");
                    if (linha == 0 && rs.getBoolean("ela_padrao")) {
                        linha = rs.getRow();
                    }
                    if (codLay == rs.getInt("lay_codigo") && (idadeZero || interValido) && !Funcoes.textoVazio(rs.getString(campoRetorno))) {
                        linha = rs.getRow();
                        if (interValido) {
                            continuar = false;
                            break;
                        }
                    }
                    if (!continuar) continue;
                    continuar = rs.next();
                }
                if (linha > 0) {
                    rs.absolute(linha);
                    if (reg != null) {
                        reg.carregar(rs);
                        reg.setValor("formatoPadrao", reg.getString(campoRetorno));
                        reg.setValor("metodoSelecionado", codigoMetodo);
                        ExameUtil.carregaRegistroMetodosIdade(filial, exame, codigoMaterial, rs.getString("lay_codigo"), reg);
                        return reg.getString(campoRetorno);
                    }
                    return rs.getString(campoRetorno);
                }
                rs.close();
                st.close();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 860");
            }
        }
        return "";
    }

    private static String sqlPegaLayoutIdade(String filial, String exame, int codigoMaterial, int codigoMetodo, String campoRetorno, boolean validarVazio, String tipoIdade, int idade) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select b.lay_codigo, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo, b.ela_padrao, ");
        buf.append(!validarVazio ? " c." + campoRetorno : " length(trim(c." + campoRetorno + ")) = 0 as " + campoRetorno);
        buf.append(" ,intervalo_valido(b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo, '").append(tipoIdade).append("', ").append(idade).append(") as intervaloValido, ");
        buf.append(" (b.ela_idadeini = 0 and B.ela_idadefim = 0) as idadeZero ");
        buf.append(" from examematcoleta a ");
        buf.append(" join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append(" left join examelayoutmetodo c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo and ");
        buf.append(" b.mco_codigo = c.mco_codigo and b.ela_idadeini = c.ela_idadeini and b.ela_idadefim = c.ela_idadefim and ");
        buf.append(" b.ela_idadeinitipo = c.ela_idadeinitipo and b.ela_idadefimtipo = c.ela_idadefimtipo and ");
        buf.append(" b.lay_codigo = c.lay_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append(" and a.exa_codigo = '").append(exame).append("' ");
        buf.append(" and a.mco_codigo = ").append(codigoMaterial);
        buf.append(" and c.met_codigo = ").append(codigoMetodo == -1 ? " a.met_codigo " : String.valueOf(codigoMetodo));
        buf.append(" order by b.ela_padrao desc ");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void carregaRegistroMetodosIdade(String filial, String exame, int material, String layout, Registro reg) {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("select a.elm_formato, b.met_codigo, b.met_descricao from examelayoutmetodo a ");
        bui.append("left join metodologia b on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.exa_codigo = '").append(exame).append("'");
        bui.append(" and a.mco_codigo = ").append(material);
        bui.append(" and a.lay_codigo = ").append(layout);
        bui.append(" and a.ela_idadeini = ").append(reg.getString("ela_idadeini"));
        bui.append(" and a.ela_idadefim = ").append(reg.getString("ela_idadefim"));
        bui.append(" and a.ela_idadefimtipo = '").append(reg.getString("ela_idadefimtipo")).append("' ");
        bui.append(" and a.ela_idadeinitipo = '").append(reg.getString("ela_idadeinitipo")).append("'");
        try {
            ResultSet rs = Conexao.executeQueryPerformance(st, bui.toString());
            reg.setValor("metodos", new ModeloResultSet(rs, "C\u00f3digo", "met_codigo", "Descri\u00e7\u00e3o", "met_descricao"));
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public static boolean intervaloValido(int idadeInicial, int idadeFinal, String tipoIni, String tipoFin, String tipoIdade, int idadePaciente) {
        if (tipoIdade != null) {
            int idPac = tipoIdade.equalsIgnoreCase(SEXO_AMBOS) ? idadePaciente * 365 : (tipoIdade.equalsIgnoreCase(SEXO_MASCULINO) ? idadePaciente * 31 : idadePaciente);
            int idIni = tipoIni.equalsIgnoreCase(SEXO_AMBOS) ? idadeInicial * 365 : (tipoIni.equalsIgnoreCase(SEXO_MASCULINO) ? idadeInicial * 31 : idadeInicial);
            int idFin = tipoFin.equalsIgnoreCase(SEXO_AMBOS) ? idadeFinal * 365 : (tipoFin.equalsIgnoreCase(SEXO_MASCULINO) ? idadeFinal * 31 : idadeFinal);
            return idIni <= idPac && idPac <= idFin;
        }
        return false;
    }

    public static String getCodigoAMB(String filial, String exame, int material, int convenio, Integer codigoMetodologia) throws SQLException {
        Statement st = Conexao.getStatement();
        String retorno = ExameUtil.getCodigoAMB(filial, exame, material, convenio, codigoMetodologia, st, ParametrosGerais.getPrecoMetodologia());
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static String getCodigoAMB(String filial, String exame, int material, int convenio, Integer codigoMetodologia, Statement st, boolean precoMetodologia) throws SQLException {
        String retorno = "";
        StringBuilder buf = new StringBuilder();
        if (precoMetodologia && codigoMetodologia != null) {
            buf.append(" select COALESCE(NULLIF(a.dtm_codamb, ''), dtp.dtp_codamb) as dtp_codamb ");
            buf.append("   from convenios b ");
            buf.append("   left join detalhetabelaprecometodologia a on b.fil_codigo = a.fil_codigo and b.tpe_codigo = a.tpe_codigo and a.met_codigo = ").append(codigoMetodologia).append(" and a.exa_codigo = '").append(exame).append("' and a.mco_codigo = ").append(material);
            buf.append("   left join detalhetabelapreco dtp on b.fil_codigo = dtp.fil_codigo and b.tpe_codigo = dtp.tpe_codigo and dtp.exa_codigo = '").append(exame).append("' and dtp.mco_codigo = ").append(material);
            buf.append("  where b.fil_codigo = ").append(filial);
            buf.append("    and b.con_codigo = ").append(String.valueOf(convenio));
        } else {
            buf.append(" select a.dtp_codamb ");
            buf.append("   from convenios b ");
            buf.append("   join detalhetabelapreco a on b.fil_codigo = a.fil_codigo and b.tpe_codigo = a.tpe_codigo ");
            buf.append("  where b.fil_codigo = ").append(filial);
            buf.append("    and b.con_codigo = ").append(String.valueOf(convenio));
            buf.append("    and a.exa_codigo = '").append(exame).append("' ");
            buf.append("    and a.mco_codigo = ").append(String.valueOf(material));
        }
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            retorno = rs.getString("dtp_codamb");
        }
        rs.close();
        return retorno;
    }

    public static int getPrazoConvenio(String filial, String exame, int material, int convenio) throws SQLException {
        int retorno = -1;
        StringBuilder buf = new StringBuilder("select eco_prazo ");
        buf.append("from examesmatconvenio ");
        buf.append("where fil_codigo = ");
        buf.append(filial);
        buf.append(" and exa_codigo = '");
        buf.append(exame);
        buf.append("' and mco_codigo = ");
        buf.append(material);
        buf.append(" and con_codigo = ");
        buf.append(String.valueOf(convenio));
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            retorno = rs.getInt("eco_prazo");
        }
        rs.close();
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static Map<String, Map<String, String>> getHistoricos(String codigoExame, String filial) {
        return ExameUtil.getHistoricosPerformance(codigoExame, filial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, String>> getHistoricosPerformance(String codigoExame, String filial) {
        HashMap<String, String> his = new HashMap<String, String>();
        HashMap<String, String> mne = new HashMap<String, String>();
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                if (codigoExame == null) {
                    bui.append("select his_codigo, his_descricao, his_mnemonico from historicos where fil_codigo = ");
                } else {
                    bui.append("select a.his_codigo, b.his_descricao, b.his_mnemonico from examehistorico a ");
                    bui.append("left join historicos b on a.fil_codigo  = b.fil_codigo and a.his_codigo = b.his_codigo where a.exa_codigo = '");
                    bui.append(codigoExame);
                    bui.append("' and a.fil_codigo = ");
                }
                bui.append(filial);
                ResultSet rs = Conexao.executeQueryPerformance(st, bui.toString());
                while (rs.next()) {
                    his.put(rs.getString("his_codigo"), rs.getString("his_descricao"));
                    if (DBUtil.campoNull(rs.getString("his_mnemonico")) || Funcoes.textoVazio(rs.getString("his_mnemonico"))) continue;
                    mne.put(rs.getString("his_mnemonico"), rs.getString("his_descricao"));
                }
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 1004");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        HashMap<String, Map<String, String>> retorno = new HashMap<String, Map<String, String>>();
        retorno.put(HISTORICO_POR_CODIGO, his);
        retorno.put(HISTORICO_POR_MNEMONICO, mne);
        return retorno;
    }

    public static Map<String, Object> getDadosCabecalhoRequisicao(Statement st, Statement stTemp, String filial, String codigoRequisicao, boolean fecharStatement, boolean bloqueiNomePaciente, HashMap<Object, Object> mapPerformance) {
        return ExameUtil.getDadosCabecalhoRequisicao(st, stTemp, filial, codigoRequisicao, fecharStatement, bloqueiNomePaciente, mapPerformance, false, Variaveis.tipoFilialPadrao, Variaveis.login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Object> getDadosCabecalhoRequisicao(Statement st, Statement stTemp, String filial, String codigoRequisicao, boolean fecharStatement, boolean bloqueiNomePaciente, HashMap<Object, Object> mapPerformance, boolean enviarErrosConsole, String filialPadrao, String variaveisLogin) {
        HashMap<String, Object> tabela = new HashMap<String, Object>();
        if (st == null || codigoRequisicao == null || Funcoes.textoVazio(codigoRequisicao)) return tabela;
        StringBuilder buf = new StringBuilder();
        try {
            buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
            buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
            buf.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
            buf.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
            buf.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao,");
            buf.append("a.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, ");
            buf.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, ");
            buf.append("a.req_guia as guiaRequisicao, a.req_complementodestino as complementoDestinoRequisicao, ");
            buf.append("a.req_descricaoproduto as descricaoProdutoRequisicao, a.req_datafabricacao as dataFabricacaoProdutoRequisicao,");
            buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao,");
            buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, a.req_datavalidade as dataValidadeProdutoRequisicao,");
            buf.append("a.req_marcaproduto as marcaProdutoRequisicao, a.req_lacreproduto as lacreProdutoRequisicao,");
            buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao,");
            buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao,");
            buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao,");
            buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao,");
            buf.append("a.req_programa as programaRequisicao, ");
            buf.append("a.req_partidaproduto as partidaProdutoRequisicao,  ");
            buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
            buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, unm.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
            buf.append("a.req_datacoletaproduto as dataColetaProdutoRequisicao, ");
            buf.append("a.req_horacoletaproduto as horaColetaProdutoRequisicao, ");
            buf.append("a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao, ");
            buf.append("a.req_horarecebimentoproduto as horaRecebimentoProdutoRequisicao, ");
            buf.append("a.req_localcoletaproduto as localColetaProdutoRequisicao, ");
            buf.append("a.req_fornecedorproduto as fornecedorProdutoRequisicao, ");
            buf.append("a.req_nrsolicitacaoproduto as numeroSolicitacaoProdutoRequisicao, ");
            buf.append("a.req_cartaosus as cartaoSUSRequisicao, ");
            if (filialPadrao.equals(SEXO_AMBOS)) {
                buf.append("pal.pal_codigo as codigoProdutoAlimento, ");
                buf.append("pal.pal_descricao as descricaoProdutoAlimento, ");
                buf.append("cpl.cpl_codigo as codigoCategoriaProdutoAlimento, ");
                buf.append("cpl.cpl_descricao as descricaoCategoriaProdutoAlimento, ");
                buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
                buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
                buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ent.ent_fone as foneResponsavelRequisicao,");
                buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ent.ent_email as emailResponsavelRequisicao, ");
                buf.append("a.pai_codigo as codigoPaisProdutoRequisicao, pais.pai_nome as descricaoPaisProdutoRequisicao, ");
                buf.append("a.req_datacertificadoalimentos as dataCertificadoProdutoRequisicao, ");
                buf.append("a.req_numerocertificadoalimentos as numeroCertificadoProdutoRequisicao, ");
                buf.append("a.req_tcaalimentos as termoColetaAmostraProdutoRequisicao, ");
                buf.append("CASE WHEN a.req_nrsuplemento = 0 THEN '' ELSE 's' || a.req_nrsuplemento END  as suplementoRequisicao, ");
            } else {
                buf.append("'' as codigoProdutoAlimento, ");
                buf.append("'' as descricaoProdutoAlimento, ");
                buf.append("'' as codigoCategoriaProdutoAlimento, ");
                buf.append("'' as descricaoCategoriaProdutoAlimento, ");
            }
            buf.append("a.req_anoprpproduto as anoPRPProdutoRequisicao, a.req_cicloprpproduto as cicloPRPProdutoRequisicao, ");
            buf.append("a.req_amostraprpproduto as amostraPRPProdutoRequisicao, a.req_amostrasupprpproduto as amostraSupervisaoPRPProdutoRequisicao, ");
            buf.append("a.req_horainicioturnoprpproduto as horaInicioTurnoPRPProdutoRequisicao, a.req_linhaprpproduto as linhaPRPProdutoRequisicao, ");
            buf.append("a.req_volumeabateprpproduto as volumeAbatePRPProdutoRequisicao, a.req_turnoprpproduto as turnoPRPProdutoRequisicao, ");
            buf.append("a.req_areaproduto as areaProdutoRequisicao, ");
            buf.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao, ");
            buf.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario, h.usr_assinatura as assinaturaUsuario, ");
            buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, a.req_prontuario as prontuarioRequisicao,  ");
            buf.append("a.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
            buf.append("k.cid_codigo as codigoCidadeConvenio, k.cid_nome as descricaoCidadeConvenio, k.cid_uf as estadoCidadeConvenio, ");
            buf.append("l.cid_codigo as codigoCidadeMedico, l.cid_nome as descricaoCidadeMedico, l.cid_uf as estadoCidadeMedico, ");
            buf.append("m.cid_codigo as codigoCidadeDestino, m.cid_nome as descricaoCidadeDestino, m.cid_uf as estadoCidadeDestino, ");
            buf.append("n.cid_codigo as codigoCidadeColeta, n.cid_nome as descricaoCidadeColeta, n.cid_uf as estadoCidadeColeta, ");
            buf.append("p.bai_codigo as codigoBairroConvenio, p.bai_descricao as descricaoBairroConvenio, ");
            buf.append("q.bai_codigo as codigoBairroMedico, q.bai_descricao as descricaoBairroMedico, ");
            buf.append("r.bai_codigo as codigoBairroDestino, r.bai_descricao as descricaoBairroDestino, ");
            buf.append("s.bai_codigo as codigoBairroColeta, s.bai_descricao as descricaoBairroColeta, ");
            buf.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino, ");
            buf.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta, ");
            buf.append("uns.uns_codigo as codigoUnidadeSaude, uns.uns_descricao as descricaoUnidadeSaude, uns.uns_endereco as enderecoUnidadeSaude, uns.uns_complemento as complementoUnidadeSaude, uns.uns_cep as cepUnidadeSaude, uns.uns_fone as foneUnidadeSaude, ");
            buf.append("d.med_conselho as conselhoMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico,d.med_numeroendereco as numeroEnderecoMedico, d.med_tipologradouroendereco as tipoLogradouroMedico, d.med_numeroendereco as numeroEnderecoMedico, d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico, ");
            buf.append("c.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio, c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio, ");
            buf.append("g.sit_descricao as descricaoSituacaoExame, ");
            buf.append("0 as quantidadeAlteracoesRequisicao, 0 as quantidadeAlteracoesComConferenciaRequisicao, ");
            buf.append("null as codigoUltimoMotivoAlteracao, '' as descricaoUltimoMotivoAlteracao, null as dataUltimoMotivoAlteracao, '' as motivoUltimoMotivoAlteracao, ");
            buf.append("null as codigoUltimoMotivoAlteracaoComConferenciaRequisicao, '' as descricaoUltimoMotivoAlteracaoComConferenciaRequisicao, null as dataUltimoMotivoAlteracaoComConferenciaRequisicao, '' as motivoUltimoMotivoAlteracaoComConferenciaRequisicao, ");
            buf.append("false as examesIncompletosRequisicao, ");
            buf.append("usulog.usr_codigo as codigoUsuarioLogado, usulog.usr_nome as nomeUsuarioLogado, usulog.usr_assinatura as assinaturaUsuarioLogado, ");
            buf.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_nomesocial as nomeSocialPaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, ");
            buf.append("le.lae_descricao as descricaoLaboratorioExternoExame ");
            buf.append("from requisicao a ");
            buf.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and a.med_crm = d.med_crm and a.med_uf = d.med_uf ");
            buf.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
            buf.append("left join loteexternoexamerequisicao as lr on a.fil_codigo = lr.fil_codigo and a.req_codigo = lr.req_codigo ");
            buf.append("left join labexterno le on le.lae_codigo = lr.lae_codigo and le.fil_codigo = lr.fil_codigo ");
            buf.append("left join destino e on a.fil_codigo = e.fil_codigo and a.des_codigo = e.des_codigo ");
            buf.append("left join coletas f on a.fil_codigo = f.fil_codigo and a.col_codigo = f.col_codigo ");
            buf.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
            buf.append("left join usuario h on upper(a.usr_codigo) = h.usr_codigo ");
            buf.append("left join usuario usulog on usulog.usr_codigo = '").append(variaveisLogin).append("'");
            buf.append("left join cidades k on c.fil_codigo = k.fil_codigo and c.cid_codigo = k.cid_codigo ");
            buf.append("left join cidades l on d.fil_codigo = l.fil_codigo and d.cid_codigo = l.cid_codigo ");
            buf.append("left join cidades m on e.fil_codigo = m.fil_codigo and e.cid_codigo = m.cid_codigo ");
            buf.append("left join cidades n on f.fil_codigo = n.fil_codigo and f.cid_codigo = n.cid_codigo ");
            buf.append("left join bairro p on c.fil_codigo = p.fil_codigo and c.bai_codigo = p.bai_codigo ");
            buf.append("left join bairro q on d.fil_codigo = q.fil_codigo and d.bai_codigo = q.bai_codigo ");
            buf.append("left join bairro r on e.fil_codigo = r.fil_codigo and e.bai_codigo = r.bai_codigo ");
            buf.append("left join bairro s on f.fil_codigo = s.fil_codigo and f.bai_codigo = s.bai_codigo ");
            buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
            buf.append("left join unidademedida unm on a.fil_codigo = unm.fil_codigo and a.unm_codigo = unm.unm_codigo ");
            buf.append("left join unidadesaude uns on a.fil_codigo = uns.fil_codigo and a.uns_codigo = uns.uns_codigo ");
            buf.append("join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
            if (filialPadrao.equals(SEXO_AMBOS)) {
                buf.append("left join categoriaprodutoalimentos cpl on a.fil_codigo = cpl.fil_codigo and a.cpl_codigo = cpl.cpl_codigo ");
                buf.append("left join produtoalimentos pal on a.fil_codigo = pal.fil_codigo and pal.pal_codigo = a.pal_codigo and cpl.cpl_codigo = pal.cpl_codigo ");
                buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
                buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
                buf.append("left join pais pais on a.fil_codigo = pais.fil_codigo and a.pai_codigo = pais.pai_codigo ");
            }
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(codigoRequisicao);
            Registro alteracoes = null;
            Registro alteracoesComConferencia = null;
            int quantidadeAlteracoesRequisicao = 0;
            int quantidadeAlteracoesComConferenciaRequisicao = 0;
            int maiorQuantidadeRetificacaoLaudo = 0;
            if (mapPerformance != null && !mapPerformance.isEmpty()) {
                alteracoes = mapPerformance.get("alteracoes") != null ? (Registro)mapPerformance.get("alteracoes") : null;
                alteracoesComConferencia = mapPerformance.get("alteracoesComConferencia") != null ? (Registro)mapPerformance.get("alteracoesComConferencia") : null;
                quantidadeAlteracoesRequisicao = mapPerformance.get("quantidadeAlteracoesRequisicao") != null ? (Integer)mapPerformance.get("quantidadeAlteracoesRequisicao") : null;
                quantidadeAlteracoesComConferenciaRequisicao = mapPerformance.get("quantidadeAlteracoesComConferenciaRequisicao") != null ? (Integer)mapPerformance.get("quantidadeAlteracoesComConferenciaRequisicao") : null;
                maiorQuantidadeRetificacaoLaudo = mapPerformance.get("maiorQuantidadeRetificacaoLaudo") != null ? (Integer)mapPerformance.get("maiorQuantidadeRetificacaoLaudo") : null;
            } else {
                alteracoes = Impressao.getDadosAlteracoesRequisicao(stTemp, filial, codigoRequisicao);
                alteracoesComConferencia = Impressao.getDadosAlteracoesRequisicaoComConferencia(stTemp, filial, codigoRequisicao);
                quantidadeAlteracoesRequisicao = Impressao.getQuantidadeAlteracoesRequisicao(st, filial, codigoRequisicao);
                quantidadeAlteracoesComConferenciaRequisicao = Impressao.getQuantidadeAlteracoesRequisicaoComConferencia(st, filial, codigoRequisicao);
                maiorQuantidadeRetificacaoLaudo = Impressao.getMaiorQuantidadeRetificacoesLaudo(stTemp, filial, codigoRequisicao);
            }
            StringBuilder bui = new StringBuilder();
            bui.append("select filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, ");
            bui.append("filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, ");
            bui.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial, ");
            bui.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial ");
            bui.append("from filiais_postocoleta filial ");
            bui.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
            bui.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
            bui.append("where filial.fil_codigo = ").append(filial);
            try (ResultSet rs = null;){
                rs = st.executeQuery(bui.toString());
                while (rs.next()) {
                    ResultSetMetaData meta = rs.getMetaData();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        String campo = meta.getColumnName(i);
                        tabela.put(campo, rs.getObject(campo));
                    }
                }
            }
            bui.setLength(0);
            bui.append("select j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_nomesocial as nomeSocialPaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, ");
            bui.append("j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente, ");
            bui.append("j.pac_idade as idadePaciente, j.pac_anomes as anoMesPaciente, j.pac_diabetico as diabeticoPaciente, j.pac_fumante as fumantePaciente, ");
            bui.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente,  j.pac_passaporte as passaportePaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, ");
            bui.append("j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente, j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoEnderecoPaciente, j.pac_cartaosus as cartaoSUSPaciente, ");
            bui.append("j.pac_endereco as enderecoPaciente,j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroPaciente, j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente, ");
            bui.append("j.pac_mae as maePaciente, j.pac_pai as paiPaciente, ");
            bui.append("j.bai_codigocobranca as codigoBairroCobrancaPaciente, t2.bai_descricao as descricaoBairroCobrancaPaciente,");
            bui.append("j.cid_codigocobranca as codigoCidadeCobrancaPaciente, o2.cid_nome as descricaoCidadeCobrancaPaciente, o2.cid_uf as estadoCidadeCobrancaPaciente,");
            bui.append("j.pac_razaosocial as razaoSocialPaciente, j.pac_cnpj as cnpjPaciente, j.pac_ie as inscricaoEstadualPaciente,");
            bui.append("j.pac_proprietario as proprietarioPaciente, j.pac_sif as sifPaciente, j.pac_enderecocobranca as enderecoCobrancaPaciente, j.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, j.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
            bui.append("j.pac_complementocobranca as complementoCobrancaPaciente, j.pac_cepcobranca as cepCobrancaPaciente, j.pac_fonecobranca as foneCobrancaPaciente,");
            bui.append("j.pac_responsavelcobranca as responsavelCobrancaPaciente, j.pac_codigoapoiado as codigoApoiadoPaciente, ");
            bui.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente, ");
            bui.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente, ");
            if (filialPadrao.equals(SEXO_AMBOS)) {
                bui.append("pco.pco_nome as nomeResponsavelRequisicao_, pco.pco_fone as foneResponsavelRequisicao_,");
                bui.append("pco.pco_cargo as cargoResponsavelRequisicao_, pco.pco_email as emailResponsavelRequisicao_, ");
            }
            if (filialPadrao.equals("V")) {
                bui.append("especie.epc_codigo as codigoEspecie, especie.epc_descricao as descricaoEspecie, especie.epc_cientifico as cientificoEspecie, ");
                bui.append("raca.rac_codigo as codigoRaca, raca.rac_descricao as descricaoRaca, raca.rac_cientifico as cientificoRaca, ");
            }
            bui.append("j.pac_pelagem as pelagemPaciente, ");
            bui.append("entempresapaciente.ent_codigo as codigoEmpresaPaciente, entempresapaciente.ent_fantasia as fantasiaEmpresaPaciente, ");
            bui.append("entempresapaciente.ent_razaosocial as razaoSocialEmpresaPaciente, entempresapaciente.ent_fone as foneEmpresaPaciente, a.req_procedencia as procedenciaRequisicao ");
            bui.append(", age(a.req_data, j.pac_datanasc) as idadeRequisicaoPaciente ");
            bui.append(", '' as idadeExtensoRequisicao, a.req_periodogestacional as periodoGestacionalRequisicao, a.req_data as dataRequisicao ");
            bui.append("from requisicao a ");
            bui.append("join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
            if (filialPadrao.equals(SEXO_AMBOS)) {
                bui.append("left join pacientescontatos pco on a.fil_codigo = pco.fil_codigo and a.pac_codigo = pco.pac_codigo and a.pco_codigo = pco.pco_codigo ");
            }
            if (filialPadrao.equals("V")) {
                bui.append("left join especie on j.fil_codigo = especie.fil_codigo and j.epc_codigo = especie.epc_codigo ");
                bui.append("left join raca on especie.fil_codigo = raca.fil_codigo and especie.epc_codigo = raca.epc_codigo and j.rac_codigo = raca.rac_codigo ");
            }
            bui.append("left join entidade entempresapaciente on j.fil_codigo = entempresapaciente.fil_codigo and j.ent_codempresa = entempresapaciente.ent_codigo ");
            bui.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
            bui.append("left join cidades o2 on j.fil_codigo = o2.fil_codigo and j.cid_codigocobranca = o2.cid_codigo ");
            bui.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
            bui.append("left join bairro t2 on j.fil_codigo = t2.fil_codigo and j.bai_codigocobranca = t2.bai_codigo ");
            bui.append("where a.fil_codigo = ");
            bui.append(filial);
            bui.append(" and a.req_codigo = ");
            bui.append(codigoRequisicao);
            try (ResultSet rs2 = null;){
                rs2 = st.executeQuery(bui.toString());
                while (rs2.next()) {
                    ResultSetMetaData meta = rs2.getMetaData();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        String campo = meta.getColumnName(i);
                        Object valor = rs2.getObject(campo);
                        if (campo.equalsIgnoreCase("tipoEnderecoPaciente")) {
                            valor = valor == null ? null : Tipos.tipoLogradouroDescricao(valor.toString());
                        } else if (campo.equalsIgnoreCase("idadeRequisicaoPaciente")) {
                            valor = Funcoes.getIntervaloParaString((PGInterval)rs2.getObject("idadeRequisicaoPaciente"), null);
                        } else if (campo.equalsIgnoreCase("idadeExtensoRequisicao") && !Funcoes.textoVazio(Funcoes.formataData(rs2.getDate("dataNascimentoPaciente")))) {
                            valor = Funcoes.getIdadePorExtenso(Funcoes.formataData(rs2.getDate("dataNascimentoPaciente")), Funcoes.formataData(rs2.getDate("dataRequisicao")));
                        }
                        tabela.put(campo, valor);
                    }
                }
            }
            try (ResultSet res = null;){
                res = st.executeQuery(buf.toString());
                while (res.next()) {
                    ResultSetMetaData meta = res.getMetaData();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        String campo = meta.getColumnName(i);
                        Object valor = res.getObject(campo);
                        if (campo.equalsIgnoreCase("idadePaciente") && res.getDate("dataNascimentoPaciente") != null) {
                            tabela.put(campo, Funcoes.calculaIdade(Funcoes.formataData(res.getDate("dataNascimentoPaciente")), false));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("anoMesPaciente") && res.getDate("dataNascimentoPaciente") != null) {
                            tabela.put(campo, Funcoes.calculaAnoMes(Funcoes.formataData(res.getDate("dataNascimentoPaciente"))));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("fumantePaciente")) {
                            tabela.put(campo, Tipos.tipoFumanteDiabetico(res.getString("fumantePaciente")));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("diabeticoPaciente")) {
                            tabela.put(campo, Tipos.tipoFumanteDiabetico(res.getString("diabeticoPaciente")));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("quantidadeAlteracoesRequisicao")) {
                            tabela.put(campo, quantidadeAlteracoesRequisicao);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("quantidadeAlteracoesComConferenciaRequisicao")) {
                            tabela.put(campo, quantidadeAlteracoesComConferenciaRequisicao);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("maiorQuantidadeRetificacoesLaudo")) {
                            tabela.put(campo, maiorQuantidadeRetificacaoLaudo);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("codigoUltimoMotivoAlteracao")) {
                            tabela.put(campo, alteracoes != null ? alteracoes.getValor("mva_codigo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoUltimoMotivoAlteracao")) {
                            tabela.put(campo, alteracoes != null ? alteracoes.getValor("mva_descricao") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataUltimoMotivoAlteracao")) {
                            tabela.put(campo, alteracoes != null ? alteracoes.getValor("rlo_datahora") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("motivoUltimoMotivoAlteracao")) {
                            tabela.put(campo, alteracoes != null ? alteracoes.getValor("rlo_descricaomotivo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("codigoUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                            tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("mva_codigo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                            tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("mva_descricao") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                            tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("rlo_datahora") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("motivoUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                            tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("rlo_descricaomotivo") : null);
                            continue;
                        }
                        tabela.put(campo, res.getObject(campo));
                    }
                }
            }
            if (!fecharStatement) return tabela;
        }
        catch (Exception ex) {
            try {
                if (!enviarErrosConsole) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExameUtil: 1864 \n" + buf.toString());
                } else {
                    ex.printStackTrace();
                }
                if (!fecharStatement) return tabela;
            }
            catch (Throwable throwable) {
                if (!fecharStatement) throw throwable;
                Conexao.fecharStatement(st, stTemp);
                throw throwable;
            }
            Conexao.fecharStatement(st, stTemp);
            return tabela;
        }
        Conexao.fecharStatement(st, stTemp);
        return tabela;
    }

    public static Map<String, Object> getDadosExameRequisicao2(Statement st, Statement stTemp, String codigoRequisicao, String codigoExame, String codigoMaterial, String filial, boolean fecharStatement, boolean bloquearNome, boolean impressao) {
        return ExameUtil.getDadosExameRequisicao2(st, stTemp, codigoRequisicao, codigoExame, codigoMaterial, filial, fecharStatement, bloquearNome, null, impressao);
    }

    public static Map<String, Object> getDadosExameRequisicao2(Statement st, Statement stTemp, String codigoRequisicao, String codigoExame, String codigoMaterial, String filial, boolean fecharStatement, boolean bloquearNome, Map<String, Object> dadosCabecalho, boolean impressao) {
        return ExameUtil.getDadosExameRequisicao2(st, stTemp, codigoRequisicao, codigoExame, codigoMaterial, filial, fecharStatement, bloquearNome, dadosCabecalho, impressao, ParametrosGerais.getConferencia(), false, ParametrosGerais.getPrecoMetodologia(), Variaveis.tipoFilialPadrao, Variaveis.login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Object> getDadosExameRequisicao2(Statement st, Statement stTemp, String codigoRequisicao, String codigoExame, String codigoMaterial, String filial, boolean fecharStatement, boolean bloquearNome, Map<String, Object> dadosCabecalho, boolean impressao, boolean considerarConferencia, boolean enviarErrosConsole, boolean pesquisarPrecoPorMetodologia, String filialPadrao, String variaveisLogin) {
        HashMap<String, Object> tabela = new HashMap<String, Object>();
        HashMap<Object, Object> mapPerformance = new HashMap<Object, Object>();
        StringBuilder sqlTemp = new StringBuilder();
        if (st == null || codigoRequisicao == null || Funcoes.textoVazio(codigoRequisicao)) return tabela;
        try {
            String sqlAlteracoesOficiais;
            ResultSet rs;
            String getWhere = ExameUtil.getCodicaoFilialExameMaterialRequisicao(filial, codigoRequisicao, codigoExame, codigoMaterial);
            ExameUtil.executaConsultaSeparadaPerformance(stTemp, mapPerformance, sqlTemp, "resultadoRetificadoExame", getWhere);
            if (!Funcoes.textoVazio(codigoExame) && !Funcoes.textoVazio(codigoMaterial)) {
                ExameUtil.consultaDadosUltimaRetificacaoPerformance(stTemp, mapPerformance, sqlTemp, getWhere);
            }
            Date[] datas = Impressao.pegaUltimaDataExameRequisicao(st, filial, codigoRequisicao);
            Date dataUltimaDigitacao = null;
            Date dataUltimaConferencia = null;
            Date dataUltimaColeta = null;
            if (datas != null && datas.length == 3) {
                dataUltimaDigitacao = datas[0];
                dataUltimaConferencia = datas[1];
                dataUltimaColeta = datas[2];
            }
            mapPerformance.put("dataUltimaDigitacao", datas[0]);
            mapPerformance.put("dataUltimaConferencia", datas[1]);
            mapPerformance.put("dataUltimaColeta", datas[2]);
            HashMap<String, Registro> mapDatas = Impressao.pegaDataHistoricoSituacoes(stTemp, filial, codigoRequisicao, "", "", false, "I", "L", "C");
            Date dataPrimeiraColeta = Impressao.pegaPrimeiraDataExameRequisicao(st, filial, codigoRequisicao);
            mapPerformance.put("dataPrimeiraColeta", dataPrimeiraColeta);
            Date dataPrimeiraImpressao = mapDatas.get("I") == null ? null : mapDatas.get("I").getDate(DATA_HORA_MINIMA);
            mapPerformance.put("dataPrimeiraImpressao", dataPrimeiraImpressao == null ? "" : dataPrimeiraImpressao);
            Date dataPrimeiraDigitacao = mapDatas.get("L") == null ? null : mapDatas.get("L").getDate(DATA_HORA_MINIMA);
            mapPerformance.put("dataPrimeiraDigitacao", dataPrimeiraDigitacao == null ? "" : dataPrimeiraDigitacao);
            Date dataPrimeiraConferencia = mapDatas.get("C") == null ? null : mapDatas.get("C").getDate(DATA_HORA_MINIMA);
            mapPerformance.put("dataPrimeiraConferencia", dataPrimeiraConferencia == null ? null : dataPrimeiraConferencia);
            boolean temExamesIncompletos = Impressao.verificaExamesEmAndamento(st, filial, codigoRequisicao, considerarConferencia);
            mapPerformance.put("temExamesIncompletos", temExamesIncompletos);
            boolean temExamesCertificadosInmetro = false;
            if (Variaveis.tipoFilialPadrao.equals(SEXO_AMBOS)) {
                temExamesCertificadosInmetro = Impressao.verificaExamesCertificadosInmetro(st, filial, codigoRequisicao);
            }
            mapPerformance.put("temExamesCertificadosInmetro", temExamesCertificadosInmetro);
            String datasColeta = Impressao.pegaDatasColetaExames(st, filial, codigoRequisicao);
            mapPerformance.put("datasColeta", datasColeta);
            Registro alteracoes = null;
            Registro alteracoesComConferencia = null;
            Registro alteracoesOficiais = null;
            Registro alteracoesComConferenciaOficiais = null;
            mapPerformance.put("alteracoes", alteracoes);
            mapPerformance.put("alteracoesComConferencia", alteracoesComConferencia);
            mapPerformance.put("alteracoesOficiais", alteracoesOficiais);
            mapPerformance.put("alteracoesComConferenciaOficiais", alteracoesComConferenciaOficiais);
            String sqlAlteracoes = ExameUtil.getSQLAlteracoes(filial, codigoRequisicao, "C");
            ResultSet resultSet = stTemp.executeQuery(sqlAlteracoes);
            if (resultSet.next()) {
                do {
                    if (resultSet.getString("rlo_tipo").equalsIgnoreCase("C")) {
                        alteracoesComConferencia = new Registro(resultSet);
                        mapPerformance.put("alteracoesComConferencia", alteracoesComConferencia);
                        continue;
                    }
                    if (null == alteracoesComConferencia) continue;
                    alteracoes = new Registro(resultSet);
                    mapPerformance.put("alteracoes", alteracoes);
                } while (resultSet.next());
            }
            if ((rs = stTemp.executeQuery(sqlAlteracoesOficiais = ExameUtil.getSQLAlteracoes(filial, codigoRequisicao, "D"))).next()) {
                do {
                    if (rs.getString("rlo_tipo").equalsIgnoreCase("D")) {
                        alteracoesComConferenciaOficiais = new Registro(rs);
                        mapPerformance.put("alteracoesComConferenciaOficiais", alteracoesComConferenciaOficiais);
                        continue;
                    }
                    if (null == alteracoesComConferenciaOficiais) continue;
                    alteracoesOficiais = new Registro(rs);
                    mapPerformance.put("alteracoesOficiais", alteracoesOficiais);
                } while (rs.next());
            }
            int maiorQuantidadeRetificacaoLaudo = Impressao.getMaiorQuantidadeRetificacoesLaudo(stTemp, filial, codigoRequisicao);
            mapPerformance.put("maiorQuantidadeRetificacaoLaudo", maiorQuantidadeRetificacaoLaudo);
            int quantidadeAlteracoesRequisicao = 0;
            int quantidadeAlteracoesComConferenciaRequisicao = 0;
            mapPerformance.put("quantidadeAlteracoesRequisicao", quantidadeAlteracoesRequisicao);
            mapPerformance.put("quantidadeAlteracoesComConferenciaRequisicao", quantidadeAlteracoesComConferenciaRequisicao);
            try {
                resultSet = stTemp.executeQuery(ExameUtil.getSqlQuantidadeAlteracao(codigoRequisicao, filial));
                if (resultSet.next()) {
                    do {
                        if (resultSet.getString("rlo_tipo").equalsIgnoreCase(SEXO_AMBOS)) {
                            quantidadeAlteracoesRequisicao = resultSet.getInt(2);
                            mapPerformance.put("quantidadeAlteracoesRequisicao", quantidadeAlteracoesRequisicao);
                            continue;
                        }
                        quantidadeAlteracoesComConferenciaRequisicao = resultSet.getInt(2);
                        mapPerformance.put("quantidadeAlteracoesComConferenciaRequisicao", quantidadeAlteracoesComConferenciaRequisicao);
                    } while (resultSet.next());
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            if (dadosCabecalho == null || dadosCabecalho.size() == 0) {
                dadosCabecalho = ExameUtil.getDadosCabecalhoRequisicao(st, stTemp, filial, codigoRequisicao, false, bloquearNome, mapPerformance, enviarErrosConsole, filialPadrao, variaveisLogin);
            }
            tabela.putAll(dadosCabecalho);
            try (ResultSet res = null;){
                res = st.executeQuery(ExameUtil.getSqlDadosExameRequisicao(codigoRequisicao, codigoExame, codigoMaterial, filial));
                if (res.next()) {
                    ResultSetMetaData meta = res.getMetaData();
                    ResultSet rsColeta = stTemp.executeQuery(Impressao.getSqlDescricaoVolumeRecipientesColetaTriagemExameRequisicao(filial, res.getString("codigoExame"), res.getString("codigoMaterial"), true));
                    String[] recepienteVolumeColeta = Impressao.pegaDescricaoRecipientesColetaTriagemExameRequisicao(rsColeta);
                    ResultSet rsTriagem = stTemp.executeQuery(Impressao.getSqlDescricaoVolumeRecipientesColetaTriagemExameRequisicao(filial, res.getString("codigoExame"), res.getString("codigoMaterial"), false));
                    String[] recepienteVolumeTriagem = Impressao.pegaDescricaoRecipientesColetaTriagemExameRequisicao(rsTriagem);
                    Date dataImpressaoEtqTriagemInicial = Impressao.getDataImpressaoEtqTriagemInicial(stTemp, filial, codigoRequisicao);
                    Date dataImpressaoEtqTriagemFinal = Impressao.getDataImpressaoEtqTriagemFinal(stTemp, filial, codigoRequisicao);
                    Date dataImpressaoEtqColetaInicial = Impressao.getDataImpressaoEtqColetaInicial(stTemp, filial, codigoRequisicao);
                    Date dataImpressaoEtqColetaFinal = Impressao.getDataImpressaoEtqColetaFinal(stTemp, filial, codigoRequisicao);
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        String campo = meta.getColumnName(i);
                        Object valor = res.getObject(campo);
                        if (campo.equalsIgnoreCase("dataUltimoExameDigitadoRequisicao")) {
                            tabela.put(campo, dataUltimaDigitacao);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("resultadoRetificadoExame")) {
                            tabela.put(campo, mapPerformance.get("resultadoRetificadoExame"));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataUltimoExameConferidoRequisicao")) {
                            tabela.put(campo, dataUltimaConferencia);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataImpressaoEtqTriagemInicial")) {
                            tabela.put(campo, dataImpressaoEtqTriagemInicial);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataImpressaoEtqTriagemFinal")) {
                            tabela.put(campo, dataImpressaoEtqTriagemFinal);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataImpressaoEtqColetaInicial")) {
                            tabela.put(campo, dataImpressaoEtqColetaInicial);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataImpressaoEtqColetaFinal")) {
                            tabela.put(campo, dataImpressaoEtqColetaFinal);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataPrimeiraColetaRequisicao")) {
                            tabela.put(campo, dataPrimeiraColeta);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataUltimaColetaRequisicao")) {
                            tabela.put(campo, dataUltimaColeta);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("datasColetaRequisicao")) {
                            tabela.put(campo, datasColeta);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataPrimeiraDigitacaoRequisicao")) {
                            tabela.put(campo, dataPrimeiraDigitacao);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataPrimeiraConferenciaRequisicao")) {
                            tabela.put(campo, dataPrimeiraConferencia);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("examesIncompletosRequisicao")) {
                            tabela.put(campo, temExamesIncompletos);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataPrimeiraImpressaoRequisicao")) {
                            tabela.put(campo, dataPrimeiraImpressao);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataHoraUltimaImpressaoExame")) {
                            HashMap<String, Registro> mapData = Impressao.pegaDataHistoricoSituacoes(stTemp, filial, codigoRequisicao, res.getString("codigoExame"), res.getString("codigoMaterial"), true, "I");
                            Date dataHoraUltimaImpressaoExame = mapData.get("I") == null ? null : mapData.get("I").getDate(DATA_HORA_MAXIMA);
                            tabela.put(campo, dataHoraUltimaImpressaoExame == null ? "" : dataHoraUltimaImpressaoExame);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("possuiExameCertificadoInmetro")) {
                            tabela.put(campo, temExamesCertificadosInmetro);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("tempoDiureseExame")) {
                            tabela.put(campo, res.getString("tempoDiureseExame"));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("maiorQuantidadeRetificacoesLaudo")) {
                            tabela.put(campo, maiorQuantidadeRetificacaoLaudo);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("quantidadeAlteracoesRequisicao")) {
                            tabela.put(campo, quantidadeAlteracoesRequisicao);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("quantidadeAlteracoesComConferenciaRequisicao")) {
                            tabela.put(campo, quantidadeAlteracoesComConferenciaRequisicao);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("hashResultado")) {
                            String hashResultado = Impressao.pegaHashExameRequisicao(stTemp, filial, codigoRequisicao, res.getString("codigoExame"), res.getString("codigoMaterial"));
                            tabela.put(campo, hashResultado);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("idadePaciente") && res.getDate("dataNascimentoPaciente") != null) {
                            tabela.put(campo, Funcoes.calculaIdade(Funcoes.formataData(res.getDate("dataNascimentoPaciente")), false));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("anoMesPaciente") && res.getDate("dataNascimentoPaciente") != null) {
                            tabela.put(campo, Funcoes.calculaAnoMes(Funcoes.formataData(res.getDate("dataNascimentoPaciente"))));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("fumantePaciente")) {
                            tabela.put(campo, Tipos.tipoFumanteDiabetico(res.getString("fumantePaciente")));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("codigoAMBExame")) {
                            String codigoConvenio = ExameUtil.buscaCodigoConvenio(stTemp, codigoRequisicao, filial);
                            String codigoAMB = !Funcoes.textoVazio(codigoConvenio) ? Impressao.pegaAMB(stTemp, filial, res.getString("codigoExame"), res.getString("codigoMaterial"), codigoConvenio, res.getString("codigoMetodo"), pesquisarPrecoPorMetodologia) : "";
                            tabela.put(campo, codigoAMB);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("diabeticoPaciente")) {
                            tabela.put(campo, Tipos.tipoFumanteDiabetico(res.getString("diabeticoPaciente")));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("codigoUltimoMotivoAlteracao")) {
                            tabela.put(campo, alteracoes != null ? alteracoes.getValor("mva_codigo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoUltimoMotivoAlteracao")) {
                            tabela.put(campo, alteracoes != null ? alteracoes.getValor("mva_descricao") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataUltimoMotivoAlteracao")) {
                            tabela.put(campo, alteracoes != null ? alteracoes.getValor("rlo_datahora") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("motivoUltimoMotivoAlteracao")) {
                            tabela.put(campo, alteracoes != null ? alteracoes.getValor("rlo_descricaomotivo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("codigoUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                            tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("mva_codigo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                            tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("mva_descricao") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                            tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("rlo_datahora") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("motivoUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                            tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("rlo_descricaomotivo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("codigoUltimoMotivoAlteracaoOficial")) {
                            tabela.put(campo, alteracoesOficiais != null ? alteracoesOficiais.getValor("mva_codigo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoUltimoMotivoAlteracaoOficial")) {
                            tabela.put(campo, alteracoesOficiais != null ? alteracoesOficiais.getValor("mva_descricao") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataUltimoMotivoAlteracaoOficial")) {
                            tabela.put(campo, alteracoesOficiais != null ? alteracoesOficiais.getValor("rlo_datahora") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("motivoUltimoMotivoAlteracaoOficial")) {
                            tabela.put(campo, alteracoesOficiais != null ? alteracoesOficiais.getValor("rlo_descricaomotivo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("codigoUltimoMotivoAlteracaoComConferenciaRequisicaoOficial")) {
                            tabela.put(campo, alteracoesComConferenciaOficiais != null ? alteracoesComConferenciaOficiais.getValor("mva_codigo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoUltimoMotivoAlteracaoComConferenciaRequisicaoOficial")) {
                            tabela.put(campo, alteracoesComConferenciaOficiais != null ? alteracoesComConferenciaOficiais.getValor("mva_descricao") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataUltimoMotivoAlteracaoComConferenciaRequisicaoOficial")) {
                            tabela.put(campo, alteracoesComConferenciaOficiais != null ? alteracoesComConferenciaOficiais.getValor("rlo_datahora") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("motivoUltimoMotivoAlteracaoComConferenciaRequisicaoOficial")) {
                            tabela.put(campo, alteracoesComConferenciaOficiais != null ? alteracoesComConferenciaOficiais.getValor("rlo_descricaomotivo") : null);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoRecipientesColetaExame")) {
                            tabela.put(campo, recepienteVolumeColeta[0]);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoRecipientesTriagemExame")) {
                            tabela.put(campo, recepienteVolumeTriagem[0]);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("volumeRecipientesColetaExame")) {
                            tabela.put(campo, recepienteVolumeColeta[1]);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("volumeRecipientesTriagemExame")) {
                            tabela.put(campo, recepienteVolumeTriagem[1]);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("exa_salvaparcial")) {
                            tabela.put(campo, valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("codigoExame")) {
                            tabela.put(campo, valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoExame")) {
                            tabela.put(campo, valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("assinaturausuariodigitacao") && valor != null) {
                            tabela.put(campo, valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("assinaturausuarioconferencia") && valor != null) {
                            tabela.put(campo, valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("assinaturaUsuario") && valor != null) {
                            tabela.put(campo, valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("razaoAssinatura") && impressao) {
                            tabela.put(campo, ImpressaoResultados.getRazaoAssinatura());
                            continue;
                        }
                        if (campo.equalsIgnoreCase("motivoUltimaRetificacao")) {
                            tabela.put(campo, mapPerformance.get("motivoUltimaRetificacao"));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("usuarioUltimaRetificacao")) {
                            tabela.put(campo, mapPerformance.get("usuarioUltimaRetificacao"));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("dataHoraUltimaRetificacao")) {
                            tabela.put(campo, mapPerformance.get("dataHoraUltimaRetificacao"));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("descricaoLaboratorioExternoExame")) {
                            if (Funcoes.textoVazio(codigoExame) || Funcoes.textoVazio(codigoMaterial)) continue;
                            tabela.put(campo, valor);
                            continue;
                        }
                        tabela.put(campo, res.getObject(campo));
                    }
                }
            }
            try {
                res = st.executeQuery(ExameUtil.getSqlMedicamento(codigoRequisicao, filial));
                int n = 1;
                while (res.next() && n <= 10) {
                    String codigo = Funcoes.formataDecimal("00", n++);
                    tabela.put("codigoMedicamento" + codigo, res.getObject("codigoMedicamento"));
                    tabela.put("descricaoMedicamento" + codigo, res.getObject("descricaoMedicamento"));
                    tabela.put("dosagemMedicamento" + codigo, res.getObject("dosagemMedicamento"));
                    tabela.put("horaDosagemMedicamento" + codigo, res.getObject("horaDosagemMedicamento"));
                    tabela.put("dataDosagemMedicamento" + codigo, res.getObject("dataDosagemMedicamento"));
                }
            }
            finally {
                if (res != null) {
                    res.close();
                }
            }
            tabela.put("dataAtual", new Date());
            if (!fecharStatement) return tabela;
        }
        catch (Exception e) {
            try {
                if (!enviarErrosConsole) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 1157");
                } else {
                    e.printStackTrace();
                }
                if (!fecharStatement) return tabela;
            }
            catch (Throwable throwable) {
                if (!fecharStatement) throw throwable;
                Conexao.fecharStatement(st, stTemp);
                throw throwable;
            }
            Conexao.fecharStatement(st, stTemp);
            return tabela;
        }
        Conexao.fecharStatement(st, stTemp);
        return tabela;
    }

    private static String getSqlMedicamento(String codigoRequisicao, String filial) {
        StringBuilder buf = new StringBuilder();
        buf.append("select a.mto_codigo as codigoMedicamento, b.mto_descricao as descricaoMedicamento, ");
        buf.append("a.rem_dosagem as dosagemMedicamento, a.rem_horadose as horaDosagemMedicamento, ");
        buf.append("a.rem_datadose as dataDosagemMedicamento from requisicaoMedicamento a ");
        buf.append("left join medicamentos b on a.fil_codigo = b.fil_codigo and a.mto_codigo = b.mto_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(codigoRequisicao);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executaConsultaSeparadaPerformance(Statement stTemp, HashMap<Object, Object> mapPerformance, StringBuilder sqlTemp, String atributo, String where) throws SQLException {
        try (ResultSet rsTemp = null;){
            sqlTemp.append(" select count(ehl_codigo) as resultadoRetificadoExame from examerequisicaohistoricolaudo ");
            rsTemp = stTemp.executeQuery(sqlTemp.append(where).toString());
            if (rsTemp.next()) {
                mapPerformance.put(atributo, rsTemp.getString(atributo));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void consultaDadosUltimaRetificacaoPerformance(Statement stTemp, HashMap<Object, Object> mapPerformance, StringBuilder sqlTemp, String where) throws SQLException {
        try (ResultSet rsTemp = null;){
            StringBuilder b = new StringBuilder();
            b.append(" select ehl_motivo as motivoUltimaRetificacao, usr_codigo as usuarioUltimaRetificacao, ehl_datahora as dataHoraUltimaRetificacao ");
            b.append(" from examerequisicaohistoricolaudo ");
            b.append(where);
            b.append(" order by ehl_datahora desc limit 1 ");
            rsTemp = stTemp.executeQuery(b.toString());
            if (rsTemp.next()) {
                mapPerformance.put("dataHoraUltimaRetificacao", rsTemp.getDate("dataHoraUltimaRetificacao"));
                mapPerformance.put("motivoUltimaRetificacao", rsTemp.getString("motivoUltimaRetificacao"));
                mapPerformance.put("usuarioUltimaRetificacao", rsTemp.getString("usuarioUltimaRetificacao"));
            }
        }
    }

    private static String getCodicaoFilialExameMaterialRequisicao(String filial, String codigoRequisicao, String codigoExame, String codigoMaterial) {
        StringBuilder sql = new StringBuilder(" where fil_codigo = ").append(filial);
        sql.append(" and req_codigo = ").append(codigoRequisicao).append(" and exa_codigo = '").append(codigoExame).append("' and mco_codigo = ").append(codigoMaterial);
        return sql.toString();
    }

    private static String getSQLAlteracoes(String filial, String codigoRequisicao, String tipoAlteracao) {
        StringBuilder sql = new StringBuilder();
        sql.append(" (select a.rlo_tipo, a.mva_codigo, a.rlo_descricaomotivo, a.rlo_datahora, b.mva_descricao ");
        sql.append(" from requisicaolog a left join motivoalteracao b on a.fil_codigo = b.fil_codigo and a.mva_codigo = b.mva_codigo ");
        sql.append(" where a.fil_codigo = ").append(filial);
        sql.append(" and a.req_codigo = ").append(codigoRequisicao);
        sql.append(" and a.rlo_tipo = ").append(StringUtil.textoDBEscape(SEXO_AMBOS));
        sql.append(" order by a.rlo_codigo desc limit 1 )");
        sql.append(" union ");
        sql.append(" (select a.rlo_tipo, a.mva_codigo, a.rlo_descricaomotivo, a.rlo_datahora, b.mva_descricao      ");
        sql.append(" from requisicaolog a left join motivoalteracao b on a.fil_codigo = b.fil_codigo and a.mva_codigo = b.mva_codigo ");
        sql.append(" where a.fil_codigo = ").append(filial);
        sql.append(" and a.req_codigo = ").append(codigoRequisicao);
        sql.append(" and a.rlo_tipo = ").append(StringUtil.textoDBEscape(tipoAlteracao));
        sql.append(" order by a.rlo_codigo desc limit 1 )");
        sql.append(" order by rlo_tipo desc ");
        return sql.toString();
    }

    public static Map<String, Object> getDadosExameRequisicao(String codigoRequisicao, String codigoExame, String codigoMaterial, String filial, boolean bloqueiaNomePaciente, boolean impressao) {
        return ExameUtil.getDadosExameRequisicao2(Conexao.getStatement(), Conexao.getStatement(), codigoRequisicao, codigoExame, codigoMaterial, filial, true, bloqueiaNomePaciente, impressao);
    }

    public static Map<String, Object> getDadosExameRequisicao(Statement st, Statement stTemp, String codigoRequisicao, String codigoExame, String codigoMaterial, String filial, boolean fecharStatement, boolean bloqueiaNomePaciente, boolean impressao) {
        return ExameUtil.getDadosExameRequisicao2(st, stTemp, codigoRequisicao, codigoExame, codigoMaterial, filial, fecharStatement, bloqueiaNomePaciente, true);
    }

    public static Map<String, Object> getDadosExameRequisicao(Statement st, Statement stTemp, String codigoRequisicao, String codigoExame, String codigoMaterial, String filial, boolean fecharStatement, Map<String, Object> dadosCabecalho, boolean impressao) {
        return ExameUtil.getDadosExameRequisicao2(st, stTemp, codigoRequisicao, codigoExame, codigoMaterial, filial, fecharStatement, false, dadosCabecalho, true, ParametrosGerais.getConferencia(), false, ParametrosGerais.getPrecoMetodologia(), Variaveis.tipoFilialPadrao, Variaveis.login);
    }

    public static Map<String, Object> getDadosExameRequisicao(Statement st, Statement stTemp, String codigoRequisicao, String codigoExame, String codigoMaterial, String filial, boolean fecharStatement, Map<String, Object> dadosCabecalho, boolean bloquearNomePaciente, boolean exigirConferencia, boolean pesquisarPrecoPorMetodologia) {
        return ExameUtil.getDadosExameRequisicao2(st, stTemp, codigoRequisicao, codigoExame, codigoMaterial, filial, fecharStatement, bloquearNomePaciente, dadosCabecalho, true, exigirConferencia, false, pesquisarPrecoPorMetodologia, Variaveis.tipoFilialPadrao, Variaveis.login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static Map<String, Object> getDadosExameRequisicao_antigo(Statement st, Statement stTemp, String codigoRequisicao, String codigoExame, String codigoMaterial, String filial, boolean fecharStatement, boolean bloqueiaNomePaciente) {
        HashMap<String, Object> tabela = new HashMap<String, Object>();
        if (st == null || codigoRequisicao == null || Funcoes.textoVazio(codigoRequisicao)) return tabela;
        StringBuffer buf = new StringBuffer();
        try {
            buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
            buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
            buf.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
            buf.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
            buf.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao,");
            buf.append("a.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, ");
            buf.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, ");
            buf.append("a.req_guia as guiaRequisicao, a.req_complementodestino as complementoDestinoRequisicao, ");
            buf.append("null as dataPrimeiraColetaRequisicao, null as dataUltimaColetaRequisicao, null as datasColetaRequisicao, ");
            buf.append("a.req_descricaoproduto as descricaoProdutoRequisicao, a.req_datafabricacao as dataFabricacaoProdutoRequisicao,");
            buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao,");
            buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, a.req_datavalidade as dataValidadeProdutoRequisicao,");
            buf.append("a.req_marcaproduto as marcaProdutoRequisicao, a.req_lacreproduto as lacreProdutoRequisicao,");
            buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao,");
            buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao,");
            buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao,");
            buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao,");
            buf.append("a.req_partidaproduto as partidaProdutoRequisicao, '' as hashResultado, ");
            buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
            buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, unm.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
            buf.append("tmc.tmc_descricao as descricaoTipoMaterialColeta, tmc.tmc_codigo as codigoTipoMaterialColeta, ");
            buf.append("tmc.tmc_valorincerteza as valorIncertezaTipoMaterialColeta, ");
            buf.append("a.req_datacoletaproduto as dataColetaProdutoRequisicao, ");
            buf.append("a.req_horacoletaproduto as horaColetaProdutoRequisicao, ");
            buf.append("a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao, ");
            buf.append("a.req_horarecebimentoproduto as horaRecebimentoProdutoRequisicao, ");
            buf.append("a.req_localcoletaproduto as localColetaProdutoRequisicao, ");
            buf.append("a.req_nrsolicitacaoproduto as numeroSolicitacaoProdutoRequisicao, ");
            buf.append("'' as dataUltimoExameDigitadoRequisicao, '' as dataUltimoExameConferidoRequisicao, ");
            buf.append(" (select count(ehl_codigo) from examerequisicaohistoricolaudo where fil_codigo = b.fil_codigo and req_codigo = b.req_codigo and exa_codigo = b.exa_codigo and mco_codigo = b.mco_codigo) as resultadoRetificadoExame, ");
            if (Variaveis.tipoFilialPadrao.equals(SEXO_AMBOS)) {
                buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
                buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
                buf.append("pco.pco_nome as nomeResponsavelRequisicao_, pco.pco_fone as foneResponsavelRequisicao_,");
                buf.append("pco.pco_cargo as cargoResponsavelRequisicao_, pco.pco_email as emailResponsavelRequisicao_, ");
                buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ent.ent_fone as foneResponsavelRequisicao,");
                buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ent.ent_email as emailResponsavelRequisicao, ");
            }
            buf.append("a.req_anoprpproduto as anoPRPProdutoRequisicao, a.req_cicloprpproduto as cicloPRPProdutoRequisicao, ");
            buf.append("a.req_amostraprpproduto as amostraPRPProdutoRequisicao, a.req_amostrasupprpproduto as amostraSupervisaoPRPProdutoRequisicao, ");
            buf.append("a.req_horainicioturnoprpproduto as horaInicioTurnoPRPProdutoRequisicao, a.req_linhaprpproduto as linhaPRPProdutoRequisicao, ");
            buf.append("a.req_volumeabateprpproduto as volumeAbatePRPProdutoRequisicao, a.req_turnoprpproduto as turnoPRPProdutoRequisicao, ");
            buf.append("a.req_areaproduto as areaProdutoRequisicao, ");
            buf.append("j.bai_codigocobranca as codigoBairroCobrancaPaciente, t2.bai_descricao as descricaoBairroCobrancaPaciente,");
            buf.append("j.cid_codigocobranca as codigoCidadeCobrancaPaciente, o2.cid_nome as descricaoCidadeCobrancaPaciente, o2.cid_uf as estadoCidadeCobrancaPaciente,");
            buf.append("j.pac_razaosocial as razaoSocialPaciente, j.pac_cnpj as cnpjPaciente, j.pac_ie as inscricaoEstadualPaciente,");
            buf.append("j.pac_proprietario as proprietarioPaciente, j.pac_sif as sifPaciente, j.pac_enderecocobranca as enderecoCobrancaPaciente, j.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, j.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente");
            buf.append("j.pac_complementocobranca as complementoCobrancaPaciente, j.pac_cepcobranca as cepCobrancaPaciente, j.pac_fonecobranca as foneCobrancaPaciente,");
            buf.append("j.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
            buf.append("j.pac_pelagem as pelagemPaciente, ");
            if (Variaveis.tipoFilialPadrao.equals("V")) {
                buf.append("especie.epc_codigo as codigoEspecie, especie.epc_descricao as descricaoEspecie, especie.epc_cientifico as cientificoEspecie, ");
                buf.append("raca.rac_codigo as codigoRaca, raca.rac_descricao as descricaoRaca, raca.rac_cientifico as cientificoRaca, ");
            }
            buf.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao, ");
            buf.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario, h.usr_assinatura as assinaturaUsuario, ");
            buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, ");
            buf.append("a.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
            buf.append("k.cid_codigo as codigoCidadeConvenio, k.cid_nome as descricaoCidadeConvenio, k.cid_uf as estadoCidadeConvenio, ");
            buf.append("l.cid_codigo as codigoCidadeMedico, l.cid_nome as descricaoCidadeMedico, l.cid_uf as estadoCidadeMedico, ");
            buf.append("m.cid_codigo as codigoCidadeDestino, m.cid_nome as descricaoCidadeDestino, m.cid_uf as estadoCidadeDestino, ");
            buf.append("n.cid_codigo as codigoCidadeColeta, n.cid_nome as descricaoCidadeColeta, n.cid_uf as estadoCidadeColeta, ");
            buf.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente, ");
            buf.append("p.bai_codigo as codigoBairroConvenio, p.bai_descricao as descricaoBairroConvenio, ");
            buf.append("q.bai_codigo as codigoBairroMedico, q.bai_descricao as descricaoBairroMedico, ");
            buf.append("r.bai_codigo as codigoBairroDestino, r.bai_descricao as descricaoBairroDestino, ");
            buf.append("s.bai_codigo as codigoBairroColeta, s.bai_descricao as descricaoBairroColeta, ");
            buf.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente, ");
            buf.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino, ");
            buf.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta, ");
            buf.append("uns.uns_codigo as codigoUnidadeSaude, uns.uns_descricao as descricaoUnidadeSaude, uns.uns_endereco as enderecoUnidadeSaude, uns.uns_complemento as complementoUnidadeSaude, uns.uns_cep as cepUnidadeSaude, uns.uns_fone as foneUnidadeSaude, ");
            buf.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, ");
            buf.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial, ");
            buf.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial, ");
            buf.append("d.med_conselho as conselhoMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico,d.med_tipologradouroendereco as tipoLogradouroMedico, d.med_numeroendereco as numeroCadastroMedico, d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico, ");
            buf.append("c.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio, c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio, ");
            if (bloqueiaNomePaciente) {
                buf.append("j.pac_codigo as codigoPaciente, 'Visualiza\u00e7\u00e3o n\u00e3o permitida' as nomePaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente, ");
            } else {
                buf.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente, ");
            }
            buf.append("j.pac_idade as idadePaciente, j.pac_anomes as anoMesPaciente, j.pac_diabetico as diabeticoPaciente, j.pac_fumante as fumantePaciente, ");
            buf.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente, ");
            buf.append("pac_tipologradouroendereco as tipoLogradouroEndereco, j.pac_endereco as enderecoPaciente, j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente, b.exr_vlrch as valorCH, ");
            buf.append("j.pac_mae as maePaciente, j.pac_pai as paiPaciente, ");
            buf.append("CASE WHEN b.exr_intervaloJejum is null then TO_CHAR(b.exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(b.exr_intervaloJejum,'HH24:MI:SS') end as tempoJejumExame, ");
            buf.append("b.exr_tempodiurese as tempoDiureseExame, b.exr_volumediurese as volumeDiureseExame, b.exr_matexterno as materialExternoExame, ");
            buf.append("b.exa_codigo as codigoExame, w.exa_descricao as descricaoExame, b.exr_vlrchexame as ambExame, b.exr_vlrchexame as chExame, b.exr_vlrexame as valorExame, b.exr_vlrmaterial as valorMateriaisExame, b.exr_situacao as situacaoExame, g.sit_descricao as descricaoSituacaoExame, ");
            buf.append("v.mco_descricao as descricaoMaterial, v.mco_codigo as codigoMaterial, v.mco_abreviatura as abreviaturaMaterial, b.exr_datamaterial as dataColetaExame, b.exr_datamaterial as horaColetaExame, ");
            buf.append("u.emc_referencia as valorReferenciaExame, ");
            buf.append("b.usr_codmaterial as usuarioColetaExame, prazo.prz_descricao as descricaoPrazo, prazo.prz_codigo as codigoPrazo, ");
            buf.append("metodo.met_codigo as codigoMetodo, metodo.met_referencia as referenciaMetodo, ");
            buf.append("w.exa_soa as codigoSOAExame, w.exa_coa as codigoCOAExame, null as dataPrimeiraImpressaoRequisicao, ");
            buf.append("w.exa_inmetro as certificadoInmetroExame, false as possuiExameCertificadoInmetro, ");
            buf.append("0 as quantidadeAlteracoesRequisicao, 0 as quantidadeAlteracoesComConferenciaRequisicao, ");
            buf.append("null as codigoUltimoMotivoAlteracao, '' as descricaoUltimoMotivoAlteracao, null as dataUltimoMotivoAlteracao, '' as motivoUltimoMotivoAlteracao, ");
            buf.append("null as codigoUltimoMotivoAlteracaoComConferenciaRequisicao, '' as descricaoUltimoMotivoAlteracaoComConferenciaRequisicao, null as dataUltimoMotivoAlteracaoComConferenciaRequisicao, '' as motivoUltimoMotivoAlteracaoComConferenciaRequisicao, ");
            buf.append("false as examesIncompletosRequisicao, ");
            buf.append("coalesce(b.exr_urgente, false) as urgenteExame, ");
            buf.append("metodo.met_descricao as descricaoMetodo, b.exr_descricaomaterial as materialInformadoExame, b.exr_dataentregaprev as dataEntregaExame, b.exr_dataentregaprev as horaEntregaExame, b.exr_datadigita as dataDigitacaoExame, b.exr_dataassina as dataConferenciaExame, ");
            buf.append("usudig.usr_codigo as codigoUsuarioDigitacao, usudig.usr_nome as nomeUsuarioDigitacao, usudig.usr_assinatura as assinaturaUsuarioDigitacao, ");
            buf.append("usuass.usr_codigo as codigoUsuarioConferencia, usuass.usr_nome as nomeUsuarioConferencia, usuass.usr_assinatura as assinaturaUsuarioConferencia, b.exr_codautorizacao as autorizacaoExame, ");
            buf.append("usulog.usr_codigo as codigoUsuarioLogado, usulog.usr_nome as nomeUsuarioLogado, usulog.usr_assinatura as assinaturaUsuarioLogado, ");
            buf.append("setores.set_codigo as codigoSetorExamePadrao, setores.set_descricao as descricaoSetorExamePadrao, setores.set_responsavel as responsavelSetorExamePadrao, setores.set_sigla as siglaSetorExamePadrao ");
            buf.append("from requisicao a ");
            buf.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
            if (Variaveis.tipoFilialPadrao.equals(SEXO_AMBOS)) {
                buf.append("left join pacientescontatos pco on a.fil_codigo = pco.fil_codigo and a.pac_codigo = pco.pac_codigo and a.pco_codigo = pco.pco_codigo ");
            }
            buf.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and a.med_crm = d.med_crm and a.med_uf = d.med_uf ");
            buf.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
            buf.append("left join examematcoleta u on b.fil_codigo = u.fil_codigo and b.exa_codigo = u.exa_codigo and b.mco_codigo = u.mco_codigo ");
            buf.append("left join materialcoleta v on u.fil_codigo = v.fil_codigo and u.mco_codigo = v.mco_codigo ");
            buf.append("left join tipomaterialcoleta tmc on v.fil_codigo = tmc.fil_codigo and v.tmc_codigo = tmc.tmc_codigo ");
            buf.append("left join exames w on b.fil_codigo = w.fil_codigo and b.exa_codigo = w.exa_codigo ");
            buf.append("left join examesetor examesetor on w.fil_codigo = examesetor.fil_codigo and w.exa_codigo = examesetor.exa_codigo and examesetor.ese_default = true ");
            buf.append("left join prazoentrega prazo on u.fil_codigo = prazo.fil_codigo and u.prz_codigo = prazo.prz_codigo ");
            buf.append("left join metodologia metodo on u.fil_codigo = metodo.fil_codigo and u.met_codigo = metodo.met_codigo ");
            buf.append("left join destino e on a.fil_codigo = e.fil_codigo and a.des_codigo = e.des_codigo ");
            buf.append("left join coletas f on a.fil_codigo = f.fil_codigo and a.col_codigo = f.col_codigo ");
            buf.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
            buf.append("left join usuario h on upper(a.usr_codigo) = h.usr_codigo ");
            buf.append("left join usuario usudig on usudig.usr_codigo = b.usr_coddigitador ");
            buf.append("left join usuario usuass on usuass.usr_codigo = b.usr_codassina ");
            buf.append("left join usuario usulog on usulog.usr_codigo = '").append(Variaveis.login).append("'");
            buf.append("left join cidades k on c.fil_codigo = k.fil_codigo and c.cid_codigo = k.cid_codigo ");
            buf.append("left join cidades l on d.fil_codigo = l.fil_codigo and d.cid_codigo = l.cid_codigo ");
            buf.append("left join cidades m on e.fil_codigo = m.fil_codigo and e.cid_codigo = m.cid_codigo ");
            buf.append("left join cidades n on f.fil_codigo = n.fil_codigo and f.cid_codigo = n.cid_codigo ");
            buf.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
            buf.append("left join cidades o2 on j.fil_codigo = o2.fil_codigo and j.cid_codigocobranca = o2.cid_codigo ");
            buf.append("left join bairro p on c.fil_codigo = p.fil_codigo and c.bai_codigo = p.bai_codigo ");
            buf.append("left join bairro q on d.fil_codigo = q.fil_codigo and d.bai_codigo = q.bai_codigo ");
            buf.append("left join bairro r on e.fil_codigo = r.fil_codigo and e.bai_codigo = r.bai_codigo ");
            buf.append("left join bairro s on f.fil_codigo = s.fil_codigo and f.bai_codigo = s.bai_codigo ");
            buf.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
            buf.append("left join bairro t2 on j.fil_codigo = t2.fil_codigo and j.bai_codigocobranca = t2.bai_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
            buf.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
            buf.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
            buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
            buf.append("left join setores setores on examesetor.fil_codigo = setores.fil_codigo and examesetor.set_codigo = setores.set_codigo ");
            buf.append("left join unidademedida unm on a.fil_codigo = unm.fil_codigo and a.unm_codigo = unm.unm_codigo ");
            buf.append("left join unidadesaude uns on a.fil_codigo = uns.fil_codigo and a.uns_codigo = uns.uns_codigo ");
            if (Variaveis.tipoFilialPadrao.equals(SEXO_AMBOS)) {
                buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
                buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
            }
            if (Variaveis.tipoFilialPadrao.equals("V")) {
                buf.append("left join especie on j.fil_codigo = especie.fil_codigo and j.epc_codigo = especie.epc_codigo ");
                buf.append("left join raca on especie.fil_codigo = raca.fil_codigo and especie.epc_codigo = raca.epc_codigo and j.rac_codigo = raca.rac_codigo ");
            }
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(codigoRequisicao);
            if (codigoExame != null && codigoMaterial != null && codigoExame.length() > 0 && codigoMaterial.length() > 0) {
                buf.append(" and b.exa_codigo = '");
                buf.append(codigoExame);
                buf.append("' and b.mco_codigo = ");
                buf.append(codigoMaterial);
            }
            Date dataUltimaDigitacao = Impressao.pegaUltimaDataExameRequisicao(st, filial, codigoRequisicao, "exr_datadigita");
            Date dataUltimaConferencia = Impressao.pegaUltimaDataExameRequisicao(st, filial, codigoRequisicao, "exr_dataassina");
            Date dataUltimaColeta = Impressao.pegaUltimaDataExameRequisicao(st, filial, codigoRequisicao, "exr_datamaterial");
            Date dataPrimeiraColeta = Impressao.pegaPrimeiraDataExameRequisicao(st, filial, codigoRequisicao);
            Date dataPrimeiraImpressao = Impressao.pegaPrimeiraDataHistoricoSituacoes(stTemp, filial, codigoRequisicao, "I");
            boolean temExamesIncompletos = Impressao.verificaExamesEmAndamento(st, filial, codigoRequisicao);
            boolean temExamesCertificadosInmetro = Impressao.verificaExamesCertificadosInmetro(st, filial, codigoRequisicao);
            int quantidadeAlteracoesRequisicao = Impressao.getQuantidadeAlteracoesRequisicao(st, filial, codigoRequisicao);
            int quantidadeAlteracoesComConferenciaRequisicao = Impressao.getQuantidadeAlteracoesRequisicaoComConferencia(st, filial, codigoRequisicao);
            String datasColeta = Impressao.pegaDatasColetaExames(st, filial, codigoRequisicao);
            Registro alteracoes = Impressao.getDadosAlteracoesRequisicao(stTemp, filial, codigoRequisicao);
            Registro alteracoesComConferencia = Impressao.getDadosAlteracoesRequisicaoComConferencia(stTemp, filial, codigoRequisicao);
            ResultSet res = st.executeQuery(buf.toString());
            if (res.next()) {
                ResultSetMetaData meta = res.getMetaData();
                String hashResultado = Impressao.pegaHashExameRequisicao(stTemp, filial, codigoRequisicao, res.getString("codigoExame"), res.getString("codigoMaterial"));
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    String campo = meta.getColumnName(i);
                    Object valor = res.getObject(campo);
                    if (campo.equalsIgnoreCase("idadePaciente") && res.getDate("dataNascimentoPaciente") != null) {
                        tabela.put(campo, Funcoes.calculaIdade(Funcoes.formataData(res.getDate("dataNascimentoPaciente")), false));
                        continue;
                    }
                    if (campo.equalsIgnoreCase("anoMesPaciente") && res.getDate("dataNascimentoPaciente") != null) {
                        tabela.put(campo, Funcoes.calculaAnoMes(Funcoes.formataData(res.getDate("dataNascimentoPaciente"))));
                        continue;
                    }
                    if (campo.equalsIgnoreCase("fumantePaciente")) {
                        tabela.put(campo, Tipos.tipoFumanteDiabetico(res.getString("fumantePaciente")));
                        continue;
                    }
                    if (campo.equalsIgnoreCase("diabeticoPaciente")) {
                        tabela.put(campo, Tipos.tipoFumanteDiabetico(res.getString("diabeticoPaciente")));
                        continue;
                    }
                    if (campo.equalsIgnoreCase("dataUltimoExameDigitadoRequisicao")) {
                        tabela.put(campo, dataUltimaDigitacao);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("dataUltimoExameConferidoRequisicao")) {
                        tabela.put(campo, dataUltimaConferencia);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("dataPrimeiraColetaRequisicao")) {
                        tabela.put(campo, dataPrimeiraColeta);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("dataUltimaColetaRequisicao")) {
                        tabela.put(campo, dataUltimaColeta);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("datasColetaRequisicao")) {
                        tabela.put(campo, datasColeta);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("examesIncompletosRequisicao")) {
                        tabela.put(campo, temExamesIncompletos);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("dataPrimeiraImpressaoRequisicao")) {
                        tabela.put(campo, dataPrimeiraImpressao);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("possuiExameCertificadoInmetro")) {
                        tabela.put(campo, temExamesCertificadosInmetro);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("quantidadeAlteracoesRequisicao")) {
                        tabela.put(campo, quantidadeAlteracoesRequisicao);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("quantidadeAlteracoesComConferenciaRequisicao")) {
                        tabela.put(campo, quantidadeAlteracoesComConferenciaRequisicao);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("codigoUltimoMotivoAlteracao")) {
                        tabela.put(campo, alteracoes != null ? alteracoes.getValor("mva_codigo") : null);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("descricaoUltimoMotivoAlteracao")) {
                        tabela.put(campo, alteracoes != null ? alteracoes.getValor("mva_descricao") : null);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("dataUltimoMotivoAlteracao")) {
                        tabela.put(campo, alteracoes != null ? alteracoes.getValor("rlo_datahora") : null);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("motivoUltimoMotivoAlteracao")) {
                        tabela.put(campo, alteracoes != null ? alteracoes.getValor("rlo_descricaomotivo") : null);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("codigoUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                        tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("mva_codigo") : null);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("descricaoUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                        tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("mva_descricao") : null);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("dataUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                        tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("rlo_datahora") : null);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("motivoUltimoMotivoAlteracaoComConferenciaRequisicao")) {
                        tabela.put(campo, alteracoesComConferencia != null ? alteracoesComConferencia.getValor("rlo_descricaomotivo") : null);
                        continue;
                    }
                    if (campo.equalsIgnoreCase("tempoDiureseExame")) {
                        tabela.put(campo, res.getString("tempoDiureseExame"));
                        continue;
                    }
                    if (campo.equalsIgnoreCase("hashResultado")) {
                        tabela.put(campo, hashResultado);
                        continue;
                    }
                    if (valor == null) continue;
                    tabela.put(campo, res.getObject(campo));
                }
            }
            buf.delete(0, buf.length());
            buf.append("select a.mto_codigo as codigoMedicamento, b.mto_descricao as descricaoMedicamento, ");
            buf.append("a.rem_dosagem as dosagemMedicamento, a.rem_horadose as horaDosagemMedicamento, ");
            buf.append("a.rem_datadose as dataDosagemMedicamento from requisicaoMedicamento a ");
            buf.append("left join medicamentos b on a.fil_codigo = b.fil_codigo and a.mto_codigo = b.mto_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(codigoRequisicao);
            try {
                res = st.executeQuery(buf.toString());
                int n = 1;
                while (res.next() && n <= 10) {
                    String codigo = Funcoes.formataDecimal("00", n++);
                    tabela.put("codigoMedicamento" + codigo, res.getObject("codigoMedicamento"));
                    tabela.put("descricaoMedicamento" + codigo, res.getObject("descricaoMedicamento"));
                    tabela.put("dosagemMedicamento" + codigo, res.getObject("dosagemMedicamento"));
                    tabela.put("horaDosagemMedicamento" + codigo, res.getObject("horaDosagemMedicamento"));
                    tabela.put("dataDosagemMedicamento" + codigo, res.getObject("dataDosagemMedicamento"));
                }
                tabela.put("dataAtual", new Date());
            }
            finally {
                if (res != null) {
                    res.close();
                }
            }
            if (!fecharStatement) return tabela;
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 1157 \n" + buf.toString());
                if (!fecharStatement) return tabela;
            }
            catch (Throwable throwable) {
                if (!fecharStatement) throw throwable;
                Conexao.fecharStatement(st, stTemp);
                throw throwable;
            }
            Conexao.fecharStatement(st, stTemp);
            return tabela;
        }
        Conexao.fecharStatement(st, stTemp);
        return tabela;
    }

    public static List<ResultadoAnterior> getResultadosAnterioresExame(String filial, String codigoRequisicao, String codPaciente, String codExame, String codMaterial, String codMetodo) {
        Statement st = Conexao.getStatement();
        return ExameUtil.getResultadosAnterioresExame(st, filial, codigoRequisicao, codPaciente, codExame, codMaterial, codMetodo, ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente(), ParametrosGerais.getCopiaPaciente(), ParametrosGerais.isUtilizaMetodoParaBuscarResultadoAnterior(), ParametrosGerais.getOrdenarExamesAnteriores(), Variaveis.filialPadrao, Variaveis.tipoFilialPadrao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResultadoAnterior> getResultadosAnterioresExame(Statement st, String filial, String codigoRequisicao, String codPaciente, String codExame, String codMaterial, String codMetodo, boolean pesquisarAnterioresAutocopiaPaciente, String dadosAutocopiaPaciente, boolean pesquisarMetodoResultadoAnterior, String ordemResultadosAnteriores, String filialPadrao, String tipoFilialPadrao) {
        ArrayList<ResultadoAnterior> resAnt = new ArrayList<ResultadoAnterior>();
        if (codExame != null) {
            StringBuilder bui = new StringBuilder();
            if (st != null) {
                block21: {
                    try {
                        ResultSet rs;
                        ModeloResultSet mrs;
                        ArrayList<Object> filiais = new ArrayList();
                        filiais = ExameUtil.verificaFilial(filial, filialPadrao, pesquisarAnterioresAutocopiaPaciente, dadosAutocopiaPaciente);
                        bui.append("select a.exc_resultado, a.req_codigo, true as utilizar, b.met_codigo, a.met_codigo as met_kodigo, a.fil_codigo, a.exa_codigo, a.mco_codigo, a.pac_codigo from examescontrole a ");
                        bui.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
                        bui.append(" where a.fil_codigo in (");
                        for (int i = 0; i < filiais.size(); ++i) {
                            if (i > 0) {
                                bui.append(", ");
                            }
                            bui.append((String)filiais.get(i));
                        }
                        bui.append(") and a.pac_codigo = ");
                        bui.append(codPaciente);
                        bui.append(" and a.exa_codigo = '").append(codExame).append("' ");
                        bui.append(" and a.mco_codigo = ").append(codMaterial);
                        if (!Funcoes.textoVazio(codigoRequisicao)) {
                            bui.append(" and b.req_codigo != ").append(codigoRequisicao);
                        }
                        if (pesquisarMetodoResultadoAnterior) {
                            bui.append(" and coalesce(a.met_codigo, b.met_codigo) =  ").append(codMetodo);
                        }
                        if (ordemResultadosAnteriores.equals("C")) {
                            bui.append(" order by a.exc_data, a.exc_hora ");
                        } else {
                            bui.append(" order by a.exc_data desc, a.exc_hora desc");
                        }
                        if (tipoFilialPadrao.equals(SEXO_AMBOS)) {
                            bui.append(" limit 50 ");
                        }
                        if ((mrs = new ModeloResultSet(rs = st.executeQuery(bui.toString()), new String[0])).getRowCount() <= 0) break block21;
                        for (int i = 0; i < mrs.getRowCount(); ++i) {
                            Registro r = mrs.getRegistro(i);
                            if (Funcoes.textoVazio(r.getString("met_kodigo"))) {
                                ExameUtil.atualizaMetodoExamesControle(st, r);
                            }
                            Integer[] multiguias = null;
                            for (String string : filiais) {
                                Integer[] tmp = RecepcaoUtil.verificaMultiGuias(st, string, r.getString("req_codigo"), false, false);
                                if (tmp == null) continue;
                                if (multiguias == null) {
                                    multiguias = (Integer[])tmp.clone();
                                    continue;
                                }
                                multiguias = ArraysUtil.concatenar(multiguias, tmp);
                            }
                            if (multiguias == null || multiguias.length <= 0) continue;
                            int requisicaoAtual = r.getInt("req_codigo");
                            for (Integer reqMulti : multiguias) {
                                for (int k = 0; k < mrs.getRowCount(); ++k) {
                                    if (Funcoes.isNumeric(codigoRequisicao) && reqMulti == Integer.parseInt(codigoRequisicao)) {
                                        r.setValor("utilizar", false);
                                        continue;
                                    }
                                    if (!mrs.getRegistro(k).getBoolean("utilizar") || mrs.getRegistro(k).getInt("req_codigo") != reqMulti.intValue() || mrs.getRegistro(k).getInt("req_codigo") <= requisicaoAtual) continue;
                                    mrs.getRegistro(k).setValor("utilizar", false);
                                }
                            }
                        }
                        Integer ordem = 1;
                        for (int i = 0; i < mrs.getRowCount(); ++i) {
                            if (!mrs.getRegistro(i).getBoolean("utilizar")) continue;
                            String xmlResultado = mrs.getRegistro(i).getString("exc_resultado");
                            StringBuilder res = new StringBuilder(xmlResultado);
                            res.append("<").append("requisicao").append(">");
                            res.append(mrs.getRegistro(i).getString("req_codigo"));
                            res.append("</").append("requisicao").append(">");
                            resAnt.add(new ResultadoAnterior(mrs.getRegistro(i).getInt("req_codigo"), res.toString(), ExameUtil.getDataHoraExame(xmlResultado)));
                            Integer n = ordem;
                            Integer n2 = ordem = Integer.valueOf(ordem + 1);
                        }
                    }
                    catch (Exception e) {
                        try {
                            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 1198 \n" + bui.toString());
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                    }
                }
                Conexao.fecharStatement(st);
            }
        }
        return resAnt;
    }

    private static Date getDataHoraExame(String xmlResultado) {
        Date data = StringUtil.getDataDeString(StringUtil.getValor(xmlResultado, "dataResultado"));
        Date hora = StringUtil.getHoraMinuto(xmlResultado, "horaResultado");
        Calendar c = Calendar.getInstance();
        c.setTime(data);
        c.set(11, hora.getHours());
        c.set(12, hora.getMinutes());
        return c.getTime();
    }

    public static Map<Integer, String> getResultadosAnteriores(String filial, String codigoRequisicao, String codPaciente, String codExame, String codMaterial, String codMetodo) {
        return ExameUtil.getResultadosAnteriores(filial, codigoRequisicao, codPaciente, codExame, codMaterial, codMetodo, Conexao.getStatement(), ParametrosGerais.isUtilizaMetodoParaBuscarResultadoAnterior(), ParametrosGerais.getOrdenarExamesAnteriores(), Variaveis.tipoFilialPadrao.equals(SEXO_AMBOS), ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente(), ParametrosGerais.getCopiaPaciente(), Variaveis.filialPadrao);
    }

    public static Map<Integer, String> getResultadosAnteriores(String filial, String codigoRequisicao, String codPaciente, String codExame, String codMaterial, String codMetodo, Statement st, boolean utilizaMetodoParaBuscarResultadoAnterior, String ordenarExamesAnteriores, boolean isAlimentos, boolean pesquisarAnterioresAutocopiaPaciente, String copiaPaciente, String filialPadrao) {
        LinkedHashMap<Integer, String> resAnt = new LinkedHashMap<Integer, String>();
        if (codExame != null) {
            StringBuilder bui = new StringBuilder();
            if (st != null) {
                try {
                    ArrayList<Object> filiais = new ArrayList();
                    filiais = ExameUtil.verificaFilial(filial, filialPadrao, pesquisarAnterioresAutocopiaPaciente, copiaPaciente);
                    bui.append("select a.exc_resultado, a.req_codigo, true as utilizar, b.met_codigo, a.met_codigo as met_kodigo, a.fil_codigo, a.exa_codigo, a.mco_codigo, a.pac_codigo from examescontrole a ");
                    bui.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
                    bui.append(" where a.fil_codigo in (");
                    for (int i = 0; i < filiais.size(); ++i) {
                        if (i > 0) {
                            bui.append(", ");
                        }
                        bui.append((String)filiais.get(i));
                    }
                    bui.append(") and a.pac_codigo = ");
                    bui.append(codPaciente);
                    bui.append(" and a.exa_codigo = '").append(codExame).append("' ");
                    bui.append(" and a.mco_codigo = ").append(codMaterial);
                    if (!Funcoes.textoVazio(codigoRequisicao)) {
                        bui.append(" and b.req_codigo != ").append(codigoRequisicao);
                    }
                    if (utilizaMetodoParaBuscarResultadoAnterior) {
                        bui.append(" and coalesce(a.met_codigo, b.met_codigo) =  ").append(codMetodo);
                    }
                    if (ordenarExamesAnteriores.equals("C")) {
                        bui.append(" order by a.exc_data, a.exc_hora ");
                    } else {
                        bui.append(" order by a.exc_data desc, a.exc_hora desc");
                    }
                    if (isAlimentos) {
                        bui.append(" limit 50 ");
                    }
                    st.setPoolable(true);
                    ResultSet rs = st.executeQuery(bui.toString());
                    ModeloResultSet mrs = new ModeloResultSet(rs, new String[0]);
                    if (mrs.getRowCount() > 0) {
                        for (int i = 0; i < mrs.getRowCount(); ++i) {
                            Integer[] multiguias;
                            Registro r = mrs.getRegistro(i);
                            if (Funcoes.textoVazio(r.getString("met_kodigo"))) {
                                ExameUtil.atualizaMetodoExamesControle(st, r);
                            }
                            if ((multiguias = RecepcaoUtil.verificaMultiGuias(st, r.getString("fil_codigo"), r.getString("req_codigo"), false, false)) == null || multiguias.length <= 0) continue;
                            int requisicaoAtual = r.getInt("req_codigo");
                            for (Integer reqMulti : multiguias) {
                                for (int k = 0; k < mrs.getRowCount(); ++k) {
                                    if (Funcoes.isNumeric(codigoRequisicao) && reqMulti == Integer.parseInt(codigoRequisicao)) {
                                        r.setValor("utilizar", false);
                                        continue;
                                    }
                                    if (!mrs.getRegistro(k).getBoolean("utilizar") || mrs.getRegistro(k).getInt("req_codigo") != reqMulti.intValue() || mrs.getRegistro(k).getInt("req_codigo") <= requisicaoAtual) continue;
                                    mrs.getRegistro(k).setValor("utilizar", false);
                                }
                            }
                        }
                        Integer ordem = 1;
                        for (int i = 0; i < mrs.getRowCount(); ++i) {
                            if (!mrs.getRegistro(i).getBoolean("utilizar")) continue;
                            StringBuilder res = new StringBuilder(mrs.getRegistro(i).getString("exc_resultado"));
                            res.append("<").append("requisicao").append(">");
                            res.append(mrs.getRegistro(i).getString("req_codigo"));
                            res.append("</").append("requisicao").append(">");
                            resAnt.put(ordem, res.toString());
                            Integer n = ordem;
                            Integer n2 = ordem = Integer.valueOf(ordem + 1);
                        }
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 1198 \n" + bui.toString());
                }
            }
        }
        return resAnt;
    }

    public static HashMap<String, DadosConferenciaAutomatica> calculaMediaResultadoAnteriores(String filial, String codigoRequisicao, String codPaciente, String codExame, String codMaterial, String codMetodo, String formato, DadosConferenciaAutomatica dadosMedia) {
        List<ResultadoAnterior> anteriores = ExameUtil.getResultadosAnterioresExame(filial, codigoRequisicao, codPaciente, codExame, codMaterial, codMetodo);
        if (anteriores == null || anteriores.isEmpty()) {
            dadosMedia.setMotivo("N\u00e3o foi poss\u00edvel conferir, pois nenhum resultado anterior foi encontrado.");
            return null;
        }
        Map<String, String> camposNoLaudo = Resultado.getCamposResultadoAnterior(formato);
        Map<String, Componente> componentes = ExameUtil.getComponents(formato);
        String parametros = ExameUtil.getParametrosLayoutExame(formato);
        String conferenciaAutomatica = StringUtil.getValor(parametros, "conferenciaAutomatica");
        String tipoCalculo = StringUtil.getValor(conferenciaAutomatica, "tipoCalculo");
        Integer qtdeResultadoAnterior = StringUtil.getInt(conferenciaAutomatica, "qtdeMinResultados");
        HashMap<String, DadosConferenciaAutomatica> listaCamposProcessados = new HashMap<String, DadosConferenciaAutomatica>();
        if (qtdeResultadoAnterior != null && Funcoes.textoVazio(dadosMedia.getMotivo()) && anteriores.size() < qtdeResultadoAnterior) {
            dadosMedia.setMotivo("N\u00e3o foi poss\u00edvel conferir, pois a quantidade de resultados anteriores n\u00e3o atinge o limite informado.");
            return null;
        }
        if (camposNoLaudo.isEmpty()) {
            dadosMedia.setMotivo("N\u00e3o foi poss\u00edvel conferir, pois nenhum campo de resultado anterior foi encontrado no resultado.");
            return null;
        }
        int scale = 0;
        block0: for (Map.Entry<String, String> campoNoLaudo : camposNoLaudo.entrySet()) {
            String campo = campoNoLaudo.getValue().toLowerCase();
            if (campo.equalsIgnoreCase("dataResultado") || listaCamposProcessados.containsKey(campo)) continue;
            ComponenteEditor editor = null;
            if (componentes.containsKey(campo)) {
                Componente c = componentes.get(campo);
                if (!c.getResultadoAnterior()) continue;
                if (c instanceof ComponenteEditor) {
                    editor = (ComponenteEditor)((Object)c);
                }
            }
            if (editor == null) continue;
            BigDecimal valorResAnterior = new BigDecimal(0);
            int contaResultadoAnterior = 0;
            ArrayList<ResultadoAnterior> resultadosAnterior = new ArrayList<ResultadoAnterior>();
            Collections.sort(anteriores, (a1, a2) -> a2.getDataHora().compareTo(a1.getDataHora()));
            if (anteriores == null) continue;
            int contadorIndex = anteriores.size() - qtdeResultadoAnterior;
            for (int i = 0; i < qtdeResultadoAnterior; ++i) {
                ++contaResultadoAnterior;
                if (anteriores.size() <= contadorIndex) continue;
                ResultadoAnterior resAnterior = anteriores.get(i);
                String valor = null;
                if (!Funcoes.textoVazio(editor.getTagResultado())) {
                    valor = StringUtil.getValorAtributoTagCampo("tagResultado".toLowerCase(), editor.getTagResultado().toLowerCase(), resAnterior.getResultado());
                }
                if (Funcoes.textoVazio(valor)) {
                    valor = StringUtil.getValor(resAnterior.getResultado(), campo);
                }
                DadosConferenciaAutomatica conferencia = new DadosConferenciaAutomatica();
                conferencia.setCampo(campo);
                conferencia.setTipoCalculo(tipoCalculo);
                conferencia.setTagResultado(editor.getTagResultado());
                conferencia.setQtdeResultadoAnterior(qtdeResultadoAnterior);
                if (!Funcoes.isNumeric(valor)) {
                    conferencia.setMotivo("A m\u00e9dia n\u00e3o pode ser calculada pois o valor n\u00e3o \u00e9 num\u00e9rico");
                    listaCamposProcessados.put(campo.toLowerCase(), conferencia);
                    continue block0;
                }
                valor = Funcoes.limpaDecimal(valor);
                valorResAnterior = valorResAnterior.add(new BigDecimal(valor));
                String dataResAnt = StringUtil.getValor(resAnterior.getResultado(), "dataResultado");
                String horaResAnt = StringUtil.getValor(resAnterior.getResultado(), "horaResultado");
                String reqResAnt = StringUtil.getValor(resAnterior.getResultado(), "requisicao");
                resultadosAnterior.add(new ResultadoAnterior(Integer.parseInt(reqResAnt), valor, Funcoes.stringToDate("dd/MM/yyyy HH:mm", String.format("%s %s", dataResAnt, horaResAnt))));
                if (listaCamposProcessados.containsKey(campo) || contaResultadoAnterior != qtdeResultadoAnterior) continue;
                scale = ExameUtil.calcularScalePelaMascara(componentes, campo);
                valorResAnterior = valorResAnterior.divide(new BigDecimal(qtdeResultadoAnterior), MathContext.DECIMAL64);
                String percVariacao = Funcoes.limpaDecimal(editor.getPercentualDeVariacao().getPercentualVariacao());
                BigDecimal valorPercVariacao = valorResAnterior.divide(new BigDecimal(100)).multiply(new BigDecimal(percVariacao));
                BigDecimal acresPercVariacao = valorResAnterior.add(valorPercVariacao);
                BigDecimal subtPercVariacao = valorResAnterior.subtract(valorPercVariacao);
                conferencia.setMedia(valorResAnterior);
                conferencia.setMediaAcrescimoPercentualVariacao(acresPercVariacao);
                conferencia.setMediaSubtracaoPercentualVariacao(subtPercVariacao);
                conferencia.setPercentualVariacao(editor.getPercentualDeVariacao().getPercentualVariacao());
                conferencia.addAnteriores(resultadosAnterior);
                listaCamposProcessados.put(campo.toLowerCase(), conferencia);
            }
        }
        if (Funcoes.textoVazio(dadosMedia.getMotivo()) && listaCamposProcessados.size() == 0) {
            dadosMedia.setMotivo("N\u00e3o foi poss\u00edvel conferir, pois n\u00e3o h\u00e1 campos no resultado anterior que satisfa\u00e7am os campos do layout atual.");
        }
        return listaCamposProcessados;
    }

    private static int calcularScalePelaMascara(Map<String, Componente> componentes, String nomeCampo) {
        return ExameUtil.calcularScalePelaMascara(componentes.get(nomeCampo));
    }

    private static int calcularScalePelaMascara(Componente componente) {
        Campo campo;
        String mascara;
        int scale = 0;
        if (componente instanceof Campo && (mascara = (campo = (Campo)componente).getMascara()).contains(",")) {
            String[] separados = campo.getMascara().split(",");
            scale = separados[separados.length - 1].length();
        }
        return scale;
    }

    public static boolean validarResultadoDeConferenciaAutomatica(String fil_codigo, String req_codigo, String pac_codigo, String exa_codigo, String mco_codigo, String metCodigo, String intCodigo, Resultado resultado) {
        String parametros = StringUtil.getValor(resultado.getResultado(), "parametros");
        String xml = StringUtil.getValor(parametros, "conferenciaAutomatica");
        String tipoCalculo = StringUtil.getValor(xml, "tipoCalculo");
        DadosConferenciaAutomatica media = new DadosConferenciaAutomatica();
        try {
            MetodologiaVO met = (MetodologiaVO)new MetodologiaService().getVO(fil_codigo, metCodigo);
            media.setMetodo(met.getCodigo() + " - " + met.getDescricao());
        }
        catch (Exception met) {
            // empty catch block
        }
        HashMap<String, DadosConferenciaAutomatica> dadosConferencia = null;
        boolean isCalculouMedia = false;
        isCalculouMedia = tipoCalculo.equalsIgnoreCase("M\u00e9dia") || tipoCalculo.equalsIgnoreCase("Valores normais e m\u00e9dia") || tipoCalculo.equalsIgnoreCase("Valores normais ou m\u00e9dia");
        if (isCalculouMedia) {
            dadosConferencia = ExameUtil.calculaMediaResultadoAnteriores(fil_codigo, req_codigo, pac_codigo, exa_codigo, mco_codigo, metCodigo, resultado.getResultado(), media);
        }
        Map<String, Componente> comps = ExameUtil.getComponents(resultado.getResultado());
        List<Component> componentes = resultado.getComponentes();
        StringBuilder log = new StringBuilder();
        ArrayList<Boolean> camposValidados = new ArrayList<Boolean>();
        for (String key : comps.keySet()) {
            boolean confAutomatica;
            BigDecimal valorResultado = new BigDecimal(0);
            boolean isCampoValidado = false;
            Componente comp = comps.get(key);
            if (isCalculouMedia && !comp.getResultadoAnterior() && (!(comp instanceof Expressao) || !((Expressao)comp).getConferenciaAutomatica().equalsIgnoreCase("Sim"))) continue;
            media.setCampo(comp.getNome());
            media.setTipoCalculo(tipoCalculo);
            if (Funcoes.textoVazio(media.getMetodo())) {
                media.setMetodo(metCodigo);
            }
            boolean bl = confAutomatica = comp instanceof Campo && ((Campo)comp).getConferenciaAutomatica().equalsIgnoreCase("Sim") || comp instanceof Expressao && ((Expressao)comp).getConferenciaAutomatica().equalsIgnoreCase("Sim");
            if (!tipoCalculo.equalsIgnoreCase("Valores normais ou m\u00e9dia") && (dadosConferencia == null && isCalculouMedia || dadosConferencia != null && !dadosConferencia.containsKey(comp.getNome().toLowerCase()) && confAutomatica)) {
                ExameUtil.montaLogConferenciaAutomatica(isCampoValidado, media, log, !Funcoes.textoVazio(comp.getValorResultado()) ? comp.getValorResultado() : "0", comp);
                if (!confAutomatica) continue;
                camposValidados.add(isCampoValidado);
                continue;
            }
            if (dadosConferencia != null && (media = dadosConferencia.get(comp.getNome().toLowerCase())) == null) {
                media = new DadosConferenciaAutomatica();
                media.setCampo(comp.getNome());
                media.setTipoCalculo(tipoCalculo);
            }
            valorResultado = ExameUtil.getValorResultadoExpressao(valorResultado, comp);
            Component c = null;
            boolean isValidaCampo = confAutomatica;
            for (Component com : componentes) {
                ExpressaoDigitacao expressao;
                CampoDigitacao campo;
                if (!com.getName().toLowerCase().equalsIgnoreCase(comp.getNome())) continue;
                c = com;
                if (!tipoCalculo.equalsIgnoreCase("Valores normais ou m\u00e9dia") && !tipoCalculo.equalsIgnoreCase("Valores normais") && !tipoCalculo.equalsIgnoreCase("Valores normais e m\u00e9dia")) break;
                if (com instanceof CampoDigitacao && (campo = (CampoDigitacao)com).getDono() instanceof Campo) {
                    isValidaCampo = ((Campo)campo.getDono()).getConferenciaAutomatica().equalsIgnoreCase("sim");
                    media.setValoresNormais(campo.getValoresNormais());
                }
                if (com instanceof ExpressaoDigitacao && (expressao = (ExpressaoDigitacao)com).getDono() instanceof Componente) {
                    isValidaCampo = ((Expressao)expressao.getDono()).getConferenciaAutomatica().equalsIgnoreCase("sim");
                    media.setValoresNormais(expressao.getValoresNormais());
                }
                if (com instanceof TextoEstatico) {
                    isValidaCampo = false;
                }
                if (isValidaCampo && !tipoCalculo.equalsIgnoreCase("M\u00e9dia")) {
                    if (!Funcoes.textoVazio(media.getValoresNormais())) break;
                    media.setMotivo("N\u00e3o foi poss\u00edvel conferir automaticamente, pois n\u00e3o existe valores normais configurados.");
                    break;
                }
                media.setMotivo("Campo n\u00e3o configurado para confer\u00eancia autom\u00e1tica.");
                break;
            }
            if (!isValidaCampo) {
                isCampoValidado = true;
            } else if (isValidaCampo && valorResultado != null) {
                isCampoValidado = ExameUtil.validaResultadoTipoCalculo(c, valorResultado, media, comp);
                ExameUtil.montaLogConferenciaAutomatica(isCampoValidado, media, log, !Funcoes.textoVazio(comp.getValorResultado()) ? comp.getValorResultado() : "0", comp);
            }
            if (media == null || !isValidaCampo) continue;
            camposValidados.add(isCampoValidado);
        }
        boolean isValidado = !camposValidados.isEmpty() && !camposValidados.contains(false);
        ExameUtil.gravaLogConferenciaAutomatica(fil_codigo, req_codigo, exa_codigo, mco_codigo, intCodigo, log.toString(), isValidado);
        return isValidado;
    }

    private static BigDecimal getValorResultadoExpressao(BigDecimal valorResultado, Componente comp) {
        String valor;
        if ((comp instanceof AbstractComponente && !(comp instanceof Expressao) || comp instanceof Expressao && ((Expressao)comp).getResultadoAnterior()) && !Funcoes.textoVazio(comp.getValorResultado()) && Funcoes.isNumeric(valor = comp.getValorResultado().replace(',', '.'))) {
            valorResultado = new BigDecimal(valor);
        }
        return valorResultado;
    }

    private static boolean validaCamposValoresNormais(String tipoCalculo, DadosConferenciaAutomatica media, boolean isValidaCampo, Component com) {
        if (tipoCalculo.equalsIgnoreCase("Valores normais") || tipoCalculo.equalsIgnoreCase("Valores normais") || tipoCalculo.equalsIgnoreCase("Valores normais e m\u00e9dia")) {
            ExpressaoDigitacao expressao;
            CampoDigitacao campo;
            if (com instanceof CampoDigitacao && (campo = (CampoDigitacao)com).getDono() instanceof Campo) {
                isValidaCampo = ((Campo)campo.getDono()).getConferenciaAutomatica().equalsIgnoreCase("sim");
                media.setValoresNormais(campo.getValoresNormais());
            }
            if (com instanceof ExpressaoDigitacao && (expressao = (ExpressaoDigitacao)com).getDono() instanceof Componente) {
                isValidaCampo = ((Expressao)expressao.getDono()).getConferenciaAutomatica().equalsIgnoreCase("sim");
                media.setValoresNormais(expressao.getValoresNormais());
            }
            if (com instanceof TextoEstatico || com instanceof DadosDigitacao) {
                isValidaCampo = false;
            }
            if (isValidaCampo && !tipoCalculo.equalsIgnoreCase("M\u00e9dia")) {
                if (Funcoes.textoVazio(media.getValoresNormais())) {
                    media.setMotivo("N\u00e3o foi poss\u00edvel conferir automaticamente, pois n\u00e3o existe valores normais configurados.");
                }
            } else {
                media.setMotivo("Campo n\u00e3o configurado para confer\u00eancia autom\u00e1tica.");
            }
        }
        return isValidaCampo;
    }

    public static void removeConferenciaAutomatica(String filCodigo, String reqCodigo, String exaCodigo, String mcoCodigo, String intCodigo, String logExtra) {
        StringBuilder log = new StringBuilder(logExtra);
        log.append("Data/Hora: ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.getDataHoraAtual()));
        log.append(".\nRemovido valida\u00e7\u00e3o do exame pelo usu\u00e1rio ").append(Variaveis.login).append("\n=================\n");
        ExameUtil.gravaLogConferenciaAutomatica(filCodigo, reqCodigo, exaCodigo, mcoCodigo, intCodigo, log.toString(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaLogConferenciaAutomatica(String filCodigo, String reqCodigo, String exaCodigo, String mcoCodigo, String intCodigo, String log, boolean isValidado) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filCodigo);
        where.append("   and req_codigo = ").append(reqCodigo);
        where.append("   and exa_codigo = '").append(exaCodigo).append("' ");
        where.append("   and mco_codigo = ").append(mcoCodigo);
        where.append("   and int_codigo = ").append(intCodigo);
        try {
            buf.append("update interfaceexamerequisicao set ier_logconfautomatica = coalesce(ier_logconfautomatica, '')||");
            buf.append(StringUtil.textoDBEscape(log));
            buf.append(" , ier_confautomatica = ").append(isValidado);
            buf.append((CharSequence)where);
            Conexao.executeUpdate(filCodigo, st, buf.toString());
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar o log de confer\u00eancia autom\u00e1tica.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return;
        }
        Conexao.fecharStatement(st);
    }

    public static void atualizaDadosConferenciaAutomatica(String filCodigo, String reqCodigo, String exaCodigo, String mcoCodigo, String intCodigo) {
        ExameUtil.atualizaDadosConferenciaAutomaticaPerformance(filCodigo, reqCodigo, exaCodigo, mcoCodigo, intCodigo);
    }

    public static void atualizaDadosConferenciaAutomaticaPerformance(String filCodigo, String reqCodigo, String exaCodigo, String mcoCodigo, String intCodigo) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select coalesce(ier_confautomatica, false) as ier_confautomatica, ier_logconfautomatica from interfaceexamerequisicao");
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filCodigo);
        where.append("   and req_codigo = ").append(reqCodigo);
        where.append("   and exa_codigo = '").append(exaCodigo).append("' ");
        where.append("   and mco_codigo = ").append(mcoCodigo);
        buf.append((CharSequence)where).append("   and int_codigo = ").append(intCodigo);
        try {
            ResultSet rs = Conexao.executeQueryPerformance(st, buf);
            if (rs.next()) {
                boolean conferidoAutomaticamente = rs.getBoolean("ier_confautomatica");
                buf.setLength(0);
                buf.append("update examerequisicaoresultado set ert_logconfautomatica = ").append(StringUtil.textoDBEscape(rs.getString("ier_logconfautomatica")));
                buf.append((CharSequence)where);
                Conexao.executeUpdatePerformance(filCodigo, st, buf.toString());
                buf.setLength(0);
                buf.append("update examerequisicao set exr_confautomatica = ").append(conferidoAutomaticamente);
                buf.append((CharSequence)where);
                Conexao.executeUpdatePerformance(filCodigo, st, buf.toString());
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar o log de confer\u00eancia autom\u00e1tica.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
    }

    private static void montaLogConferenciaAutomatica(boolean isValidado, DadosConferenciaAutomatica calculo, StringBuilder log, String valorResultado, Componente comp) {
        log.append("Campo: ").append(calculo.getCampo());
        log.append(".\nTag de resultado: ").append(Funcoes.textoVazio(calculo.getTagResultado()) ? "N\u00e3o configurada" : calculo.getTagResultado());
        log.append(".\nData/Hora: ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.getDataHoraAtual()));
        log.append(".\nTipo c\u00e1lculo: ").append(calculo.getTipoCalculo());
        log.append(".\nPar\u00e2m. Utiliza metodologia ao buscar resultados anteriores: ").append(ParametrosGerais.isUtilizaMetodoParaBuscarResultadoAnterior() ? "Sim" : "N\u00e3o");
        if (!Funcoes.textoVazio(calculo.getMetodo())) {
            log.append(".\nM\u00e9todo: ").append(calculo.getMetodo());
        }
        if (!calculo.getTipoCalculo().equalsIgnoreCase("M\u00e9dia")) {
            log.append(".\nValores normais: ").append(Funcoes.textoVazio(calculo.getValoresNormais()) ? "N\u00e3o configurados" : calculo.getValoresNormais());
        }
        ExameUtil.adicionarNoLogValoresDeCalculoNaoNormais(calculo, log, comp);
        log.append(".\nValor digitado: ").append(valorResultado);
        log.append(".\nConferido: ").append(isValidado ? "SIM" : "N\u00c3O");
        if (!isValidado && !Funcoes.textoVazio(calculo.getMotivo())) {
            log.append(".\nMotivo: ").append(calculo.getMotivo());
        }
        log.append("\n=================\n");
    }

    private static void adicionarNoLogValoresDeCalculoNaoNormais(DadosConferenciaAutomatica calculo, StringBuilder log, Componente comp) {
        if (!calculo.getTipoCalculo().equalsIgnoreCase("Valores normais")) {
            int decimaisMascara = ExameUtil.calcularCasasDecimaisMascara(comp);
            if (!calculo.getAnteriores().isEmpty()) {
                log.append(".\nResultados utilizado para o c\u00e1lculo:");
                for (ResultadoAnterior resAnt : calculo.getAnteriores()) {
                    log.append(".\n").append(resAnt.toString());
                }
            }
            if (calculo.getMedia() != null) {
                log.append(".\nM\u00e9dia: ").append(Funcoes.formataDecimal(calculo.getMedia().setScale(decimaisMascara, 1).doubleValue(), decimaisMascara));
            }
            if (calculo.getMediaAcrescimoPercentualVariacao() != null && calculo.getMediaSubtracaoPercentualVariacao() != null) {
                log.append(".\nVaria\u00e7\u00e3o: ").append(calculo.getPercentualVariacao()).append("% - ");
                log.append(Funcoes.formataDecimal(calculo.getMediaSubtracaoPercentualVariacao().setScale(decimaisMascara, 1).doubleValue(), decimaisMascara)).append(" a ");
                log.append(Funcoes.formataDecimal(calculo.getMediaAcrescimoPercentualVariacao().setScale(decimaisMascara, 1).doubleValue(), decimaisMascara));
            }
            if (calculo.getQtdeResultadoAnterior() > 0) {
                log.append(".\nQtde. Resultados Anteriores: ").append(calculo.getQtdeResultadoAnterior());
            }
        }
    }

    private static int calcularCasasDecimaisMascara(Componente comp) {
        String mascara = "";
        if (comp instanceof CampoDigitacao) {
            mascara = ((CampoDigitacao)((Object)comp)).getMascara();
        } else if (comp instanceof Campo) {
            mascara = ((Campo)comp).getMascara();
        }
        int decimaisMascara = 0;
        if (!Funcoes.textoVazio(mascara) && mascara.contains(",")) {
            String[] mascaraSeparada = mascara.split(",");
            decimaisMascara = mascaraSeparada[mascaraSeparada.length - 1].length();
        }
        return decimaisMascara;
    }

    private static boolean validaResultadoTipoCalculo(Component comp, BigDecimal valorResultado, DadosConferenciaAutomatica media, Componente componente) {
        boolean isNull;
        String motivo = "";
        String valores = "";
        boolean isValidado = false;
        boolean bl = isNull = media == null || media.getMediaSubtracaoPercentualVariacao() == null || media.getMediaAcrescimoPercentualVariacao() == null || media.getMedia() == null;
        if (comp instanceof CampoDigitacao && ((CampoDigitacao)comp).getDono() instanceof Campo && !((Campo)((CampoDigitacao)comp).getDono()).getConferenciaAutomatica().equalsIgnoreCase("sim")) {
            motivo = "Campo n\u00e3o configurado para valida\u00e7\u00e3o autom\u00e1tica.";
            isValidado = true;
        } else if (comp instanceof ExpressaoDigitacao && ((ExpressaoDigitacao)comp).getDono() instanceof Expressao && !((Expressao)((ExpressaoDigitacao)comp).getDono()).getConferenciaAutomatica().equalsIgnoreCase("sim")) {
            motivo = "Campo n\u00e3o configurado para valida\u00e7\u00e3o autom\u00e1tica.";
            isValidado = true;
        } else if (!isNull && (media.getTipoCalculo().equalsIgnoreCase("M\u00e9dia") || media.getTipoCalculo().equalsIgnoreCase("Valores normais ou m\u00e9dia") || media.getTipoCalculo().equalsIgnoreCase("Valores normais e m\u00e9dia"))) {
            ExpressaoDigitacao expressao;
            CampoDigitacao campo;
            int scale = ExameUtil.calcularScalePelaMascara(componente);
            boolean isMedia = valorResultado.doubleValue() >= media.getMediaSubtracaoPercentualVariacao().setScale(scale, 1).doubleValue() && valorResultado.doubleValue() <= media.getMediaAcrescimoPercentualVariacao().setScale(scale, 1).doubleValue();
            boolean isValoresNormais = false;
            if (!isMedia && !Funcoes.textoVazio(media.getValoresNormais())) {
                int index = media.getValoresNormais().indexOf("a");
                String minAbsurdo = media.getValoresNormais().substring(0, index).trim().replace(",", ".");
                String maxAbsurdo = media.getValoresNormais().substring(index + 1).trim().replace(",", ".");
                if (valorResultado.doubleValue() > Double.parseDouble(minAbsurdo) && valorResultado.doubleValue() < Double.parseDouble(maxAbsurdo)) {
                    isValoresNormais = true;
                }
            }
            if (comp instanceof CampoDigitacao && (campo = (CampoDigitacao)comp).getDono() instanceof Campo) {
                isValoresNormais = campo.validarValoresConferenciaAutomatica();
            } else if (comp instanceof ExpressaoDigitacao && (expressao = (ExpressaoDigitacao)comp).getDono() instanceof Expressao) {
                isValoresNormais = expressao.validarValoresConferenciaAutomatica();
            }
            if (isValoresNormais) {
                if (comp instanceof CampoDigitacao && (campo = (CampoDigitacao)comp).getDono() instanceof Campo) {
                    valores = campo.getValoresNormais();
                    media.setValoresNormais(valores);
                    media.setCampo(campo.getNome());
                } else if (comp instanceof ExpressaoDigitacao && (expressao = (ExpressaoDigitacao)comp).getDono() instanceof Expressao) {
                    valores = expressao.getValoresNormais();
                    media.setValoresNormais(valores);
                    media.setCampo(expressao.getNome());
                }
            }
            if (!isMedia && !media.getTipoCalculo().equalsIgnoreCase("M\u00e9dia") && Funcoes.textoVazio(media.getValoresNormais())) {
                motivo = "N\u00e3o foi poss\u00edvel conferir automaticamente, pois n\u00e3o existe valores normais configurados.\n";
            }
            if (media.getTipoCalculo().equalsIgnoreCase("Valores normais e m\u00e9dia")) {
                isValidado = isMedia && isValoresNormais;
            } else if (media.getTipoCalculo().equalsIgnoreCase("Valores normais ou m\u00e9dia")) {
                isValidado = isMedia || isValoresNormais;
            } else if (media.getTipoCalculo().equalsIgnoreCase("M\u00e9dia")) {
                isValidado = isMedia;
            }
            if (!(isMedia || isValidado || media.getTipoCalculo().equals("Valores normais"))) {
                motivo = motivo + "N\u00e3o foi poss\u00edvel conferir automaticamente, pois o valor digitado est\u00e1 fora da varia\u00e7\u00e3o permitida.\n";
            }
            if (!(isValoresNormais || isValidado || media.getTipoCalculo().equals("M\u00e9dia"))) {
                motivo = motivo + "N\u00e3o foi poss\u00edvel conferir automaticamente, pois o valor digitado est\u00e1 fora da faixa de valores normais.";
            }
        } else if (media.getTipoCalculo().equalsIgnoreCase("Valores normais") || media.getMedia() == null && media.getTipoCalculo().equalsIgnoreCase("Valores normais ou m\u00e9dia")) {
            ExpressaoDigitacao expressao;
            CampoDigitacao campo;
            isValidado = false;
            if (comp instanceof CampoDigitacao && (campo = (CampoDigitacao)comp).getDono() instanceof Campo) {
                isValidado = campo.validarValoresConferenciaAutomatica();
            } else if (comp instanceof ExpressaoDigitacao && (expressao = (ExpressaoDigitacao)comp).getDono() instanceof Expressao) {
                isValidado = expressao.validarValoresConferenciaAutomatica();
            }
            if (isValidado) {
                if (comp instanceof CampoDigitacao && (campo = (CampoDigitacao)comp).getDono() instanceof Campo) {
                    valores = campo.getValoresNormais();
                    media.setValoresNormais(valores);
                    media.setCampo(campo.getNome());
                } else if (comp instanceof ExpressaoDigitacao && (expressao = (ExpressaoDigitacao)comp).getDono() instanceof Expressao) {
                    valores = expressao.getValoresNormais();
                    media.setValoresNormais(valores);
                    media.setCampo(expressao.getNome());
                }
            }
            if (Funcoes.textoVazio(media.getValoresNormais())) {
                motivo = "N\u00e3o foi poss\u00edvel conferir automaticamente, pois n\u00e3o existe valores normais configurados.\n";
            }
            if (!isValidado && !Funcoes.textoVazio(media.getValoresNormais())) {
                motivo = motivo + "N\u00e3o foi poss\u00edvel conferir automaticamente, pois o valor digitado est\u00e1 fora da faixa de valores normais.";
            }
        } else if (isNull || media.getTipoCalculo().equalsIgnoreCase("Desativada")) {
            return false;
        }
        if (!Funcoes.textoVazio(motivo)) {
            media.setMotivo(motivo);
        }
        return isValidado;
    }

    public static Map<String, Componente> getComponents(String xmlResultado) {
        HashMap<String, Componente> campos = new HashMap<String, Componente>();
        String atributos = StringUtil.getValor(xmlResultado, "exame");
        String tipo = StringUtil.getValor(atributos, "tipo");
        String parametros = StringUtil.getValor(xmlResultado, "parametros");
        try {
            for (String item : StringUtil.getListValores(xmlResultado, "componente")) {
                AbstractComponente compVlr;
                Componente c = (Componente)Class.forName(StringUtil.getValor(item, "tipo")).newInstance();
                c.setAtributos(StringUtil.getValor(item, "atributos"));
                if (c instanceof Campo) {
                    compVlr = (Campo)c;
                    campos.put(compVlr.getNome().toLowerCase(), compVlr);
                    continue;
                }
                if (c instanceof Dados) {
                    compVlr = (Dados)c;
                    campos.put(compVlr.getNome().toLowerCase(), compVlr);
                    continue;
                }
                if (c instanceof Expressao) {
                    compVlr = (Expressao)c;
                    campos.put(compVlr.getNome().toLowerCase(), compVlr);
                    continue;
                }
                if (!(c instanceof Externo)) continue;
                compVlr = (Externo)c;
                campos.put(compVlr.getNome().toLowerCase(), compVlr);
            }
        }
        catch (Exception e) {
            campos.clear();
        }
        return campos;
    }

    public static boolean possuiCamposForaDaReferencia(Resultado resultado) {
        if (resultado != null) {
            for (Component c : resultado.getComponentes()) {
                ExpressaoDigitacao expressao;
                CampoDigitacao campo;
                TextoEstatico texto;
                if (!(c instanceof TextoEstatico && (texto = (TextoEstatico)c).getDono() instanceof Campo && ((Campo)texto.getDono()).valorAlterado() || c instanceof CampoDigitacao && (campo = (CampoDigitacao)c).getDono() instanceof Campo && ((Campo)campo.getDono()).valorAlterado()) && (!(c instanceof ExpressaoDigitacao) || !((expressao = (ExpressaoDigitacao)c).getDono() instanceof Expressao) || !((Expressao)expressao.getDono()).valorAlterado())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getParametrosLayoutExame(String xmlResultado) {
        String atributos = StringUtil.getValor(xmlResultado, "exame");
        String parametros = StringUtil.getValor(xmlResultado, "parametros");
        return !Funcoes.textoVazio(parametros) ? parametros : null;
    }

    private static void atualizaMetodoExamesControle(Statement st, Registro r) throws SQLException {
        if (Funcoes.textoVazio(r.getString("met_codigo"))) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("update examescontrole set met_codigo = ").append(r.getString("met_codigo"));
        buf.append(" where fil_codigo = ").append(r.getString("fil_codigo"));
        buf.append(" and req_codigo = ").append(r.getString("req_codigo"));
        buf.append(" and pac_codigo = ").append(r.getString("pac_codigo"));
        buf.append(" and exa_codigo = '").append(StringUtil.textoDB(r.getString("exa_codigo"))).append("'");
        buf.append(" and mco_codigo = ").append(r.getString("mco_codigo"));
        buf.append(" and met_codigo is null ");
    }

    private static boolean temResultadoGuiaPai(Integer requisicaoPai, ModeloResultSet rs) {
        if (rs != null && requisicaoPai != null) {
            for (int i = 0; i < rs.getRowCount(); ++i) {
                Registro r = rs.getRegistro(i);
                if (r.nulo("req_codigo") || r.getInt("req_codigo") != requisicaoPai.intValue() || !r.nulo("codigoguiapai")) continue;
                return true;
            }
        }
        return false;
    }

    public static void trocarExameFaturamento(Statement st, String filial, String requisicao, String exame, String material, String novoExame, String novoMaterial) throws Exception {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> comandosParaExecutar = new ArrayList<String>();
        buf.append("select a.fat_codigo, a.fil_kodigo, a.exa_codigo, a.mco_codigo from faturaexamerequisicao a ");
        buf.append("left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(exame)).append("'");
        buf.append(" and a.mco_codigo = ").append(StringUtil.textoDB(material));
        buf.append(" and b.fat_datacancelamento is null ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            buf.setLength(0);
            buf.append("update faturaexamerequisicao set ");
            buf.append("exa_codigo = '").append(StringUtil.textoDB(novoExame)).append("', ");
            buf.append("mco_codigo = ").append(StringUtil.textoDB(novoMaterial));
            buf.append(" where fil_codigo = ").append(StringUtil.textoDB(filial));
            buf.append(" and fil_kodigo = ").append(StringUtil.textoDB(rs.getString("fil_kodigo")));
            buf.append(" and fat_codigo = ").append(StringUtil.textoDB(rs.getString("fat_codigo")));
            buf.append(" and req_codigo = ").append(StringUtil.textoDB(requisicao));
            buf.append(" and exa_codigo = '").append(StringUtil.textoDB(rs.getString("exa_codigo"))).append("'");
            buf.append(" and mco_codigo = ").append(rs.getString("mco_codigo"));
            comandosParaExecutar.add(buf.toString());
        }
        buf.setLength(0);
        buf.append("select a.fat_codigo, a.fil_kodigo, a.exa_codigo, a.mco_codigo from faturaexamerequisicao a ");
        buf.append("left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.exa_codfilho = '").append(StringUtil.textoDB(exame)).append("'");
        buf.append(" and a.mco_codfilho = ").append(StringUtil.textoDB(material));
        buf.append(" and b.fat_datacancelamento is null ");
        rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            buf.setLength(0);
            buf.append("update faturaexamerequisicao set ");
            buf.append("exa_codfilho = '").append(StringUtil.textoDB(novoExame)).append("', ");
            buf.append("mco_codfilho = ").append(StringUtil.textoDB(novoMaterial));
            buf.append(" where fil_codigo = ").append(StringUtil.textoDB(filial));
            buf.append(" and fil_kodigo = ").append(StringUtil.textoDB(rs.getString("fil_kodigo")));
            buf.append(" and fat_codigo = ").append(StringUtil.textoDB(rs.getString("fat_codigo")));
            buf.append(" and req_codigo = ").append(StringUtil.textoDB(requisicao));
            buf.append(" and exa_codfilho = '").append(StringUtil.textoDB(rs.getString("exa_codigo"))).append("'");
            buf.append(" and mco_codfilho = ").append(rs.getString("mco_codigo"));
            comandosParaExecutar.add(buf.toString());
        }
        if (comandosParaExecutar.size() > 0) {
            for (String s : comandosParaExecutar) {
                Conexao.executeUpdate(StringUtil.textoDB(filial), st, s);
            }
        }
    }

    public static int getCodigoFatura(String filial, String requisicao, String exame, String material) throws Exception {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        int retorno = -1;
        try {
            buf.append("select a.fat_codigo from faturaexamerequisicao a ");
            buf.append("left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(StringUtil.textoDB(filial));
            buf.append(" and a.req_codigo = ");
            buf.append(StringUtil.textoDB(requisicao));
            buf.append(" and a.exa_codigo = '");
            buf.append(StringUtil.textoDB(exame));
            buf.append("' and a.mco_codigo = ");
            buf.append(StringUtil.textoDB(material));
            buf.append(" and b.fat_datacancelamento is null ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            boolean faturaLocalizada = rs.next();
            if (!faturaLocalizada) {
                buf.delete(0, buf.length());
                buf.append("select a.fat_codigo, a.exa_codigo from faturaexamerequisicao a ");
                buf.append("left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
                buf.append("where a.fil_kodigo = ");
                buf.append(StringUtil.textoDB(filial));
                buf.append(" and a.req_codigo = ");
                buf.append(StringUtil.textoDB(requisicao));
                buf.append(" and a.exa_codfilho = '");
                buf.append(StringUtil.textoDB(exame));
                buf.append("' and a.mco_codfilho = ");
                buf.append(StringUtil.textoDB(material));
                buf.append(" and b.fat_datacancelamento is null ");
                rs = Conexao.executeQuery(st, buf);
                faturaLocalizada = rs.next();
            }
            if (faturaLocalizada) {
                retorno = rs.getInt("fat_codigo");
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "getCodigoFatura (1384)");
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pegaRelacionamentoExportaTextoIdade(String filial, int idade, String tipoIdade, String layout, String exame, int codigoMaterial, String codigoMetodo) {
        Statement st = Conexao.getStatement();
        String modelo = "";
        try {
            modelo = ExameUtil.pegaRelacionamentoExportaTextoIdade(filial, idade, tipoIdade, layout, exame, codigoMaterial, codigoMetodo, st);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return modelo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String pegaRelacionamentoExportaTextoIdade(String filial, int idade, String tipoIdade, String layout, String exame, int codigoMaterial, String codigoMetodo, Statement st) {
        if (st == null) return "";
        try {
            int linha = 0;
            int codLay = StringUtil.validaInteiro(layout) ? Integer.parseInt(layout) : -1;
            StringBuilder buf = new StringBuilder("select b.lay_codigo, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo, b.ela_padrao, ");
            buf.append("c.elm_exportartexto ");
            buf.append("from examematcoleta a ");
            buf.append("join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
            buf.append("left join examelayoutmetodo c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo and ");
            buf.append(" b.mco_codigo = c.mco_codigo and b.ela_idadeini = c.ela_idadeini and b.ela_idadefim = c.ela_idadefim and ");
            buf.append(" b.ela_idadeinitipo = c.ela_idadeinitipo and b.ela_idadefimtipo = c.ela_idadefimtipo and ");
            buf.append(" b.lay_codigo = c.lay_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and upper(a.exa_codigo) = upper('");
            buf.append(exame);
            buf.append("') and a.mco_codigo = ");
            buf.append(codigoMaterial);
            if (Funcoes.isNumeric(codigoMetodo)) {
                buf.append(" and c.met_codigo = ").append(codigoMetodo);
            }
            buf.append(" order by b.ela_padrao desc ");
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                boolean continuar = rs.next();
                while (continuar) {
                    boolean idadeZero;
                    boolean padrao = rs.getBoolean("ela_padrao");
                    int idIni = rs.getInt("ela_idadeini");
                    int idFin = rs.getInt("ela_idadefim");
                    String tpIni = rs.getString("ela_idadeinitipo");
                    String tpFin = rs.getString("ela_idadefimtipo");
                    boolean interValido = codLay == rs.getInt("lay_codigo") && ExameUtil.intervaloValido(idIni, idFin, tpIni, tpFin, tipoIdade, idade);
                    boolean bl = idadeZero = codLay == rs.getInt("lay_codigo") && idIni == 0 && idFin == 0;
                    if (padrao && linha == 0 || idadeZero || interValido) {
                        linha = rs.getRow();
                        if (interValido) {
                            continuar = false;
                            break;
                        }
                    }
                    if (!continuar) continue;
                    continuar = rs.next();
                }
                if (linha <= 0) return "";
                rs.absolute(linha);
                String string = rs.getString(CAMPO_EXPORTAR_TEXTO);
                return string;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameUtil: 1488");
        }
        return "";
    }

    public static ResultSet verificaAgrupamentoExame(Statement st, Integer codigoFilial, String codigoExame, Integer codigoMaterial, Integer codigoConvenio) throws SQLException {
        if (st == null || codigoFilial == null || codigoExame == null || codigoMaterial == null || codigoConvenio == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.exa_kodigo ");
        buf.append("       ,a.mco_kodigo ");
        buf.append("       ,b.exa_descricao ");
        buf.append("   from exameagrupaexameconvenio a ");
        buf.append("   left join exames b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo ");
        buf.append("  where a.fil_codigo = ").append(codigoFilial);
        buf.append("    and a.exa_codigo = '").append(codigoExame).append("' ");
        buf.append("    and a.mco_codigo = ").append(codigoMaterial);
        buf.append("    and a.con_codigo = ").append(codigoConvenio);
        buf.append("    and a.aec_tipo = '").append(SEXO_FEMININO).append("' ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs;
        }
        buf.setLength(0);
        buf.append(" select a.exa_kodigo ");
        buf.append("       ,a.mco_kodigo ");
        buf.append("       ,b.exa_descricao ");
        buf.append("   from exameagrupaexameconvenio a ");
        buf.append("   left join agrupaexameconvenio c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and a.aec_tipo = c.aec_tipo ");
        buf.append("   left join exames b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo ");
        buf.append("  where a.fil_codigo = ").append(codigoFilial);
        buf.append("    and a.exa_codigo = '").append(codigoExame).append("' ");
        buf.append("    and a.mco_codigo = ").append(codigoMaterial);
        buf.append("    and c.aec_ignorarconvenio = true ");
        buf.append("    and a.aec_tipo = '").append(SEXO_FEMININO).append("' ");
        rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs;
        }
        return null;
    }

    public static ResultSet getAgrupamentoExameRequisicao(Statement st, Integer codigoFilial, Integer codigoRequisicao, String codigoExame, Integer codigoMaterial) throws SQLException {
        if (st == null || codigoFilial == null || codigoExame == null || codigoMaterial == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select exa_codfilho ");
        buf.append("       ,mco_codfilho ");
        buf.append("   from examerequisicaoguiaagrupada ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        buf.append("    and exa_codigo = '").append(codigoExame).append("' ");
        buf.append("    and mco_codigo = ").append(codigoMaterial);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean corrigeAgrupamentoExame(Integer codigoFilial, Integer codigoRequisicao, String codigoExame, Integer codigoMaterial, Integer codigoConvenio) throws SQLException {
        boolean bl;
        Statement stAtual = Conexao.getStatement();
        Statement stRequisicao = Conexao.getStatement();
        Statement stInsert = Conexao.getStatement();
        ResultSet rsAtual = ExameUtil.verificaAgrupamentoExame(stAtual, codigoFilial, codigoExame, codigoMaterial, codigoConvenio);
        ResultSet rsRequisicao = null;
        try {
            boolean exameAlterado = false;
            if (rsAtual != null) {
                do {
                    boolean temExame = false;
                    String codigoExameAtual = rsAtual.getString("exa_kodigo");
                    Integer codigoMaterialAtual = rsAtual.getInt("mco_kodigo");
                    rsRequisicao = ExameUtil.getAgrupamentoExameRequisicao(stRequisicao, codigoFilial, codigoRequisicao, codigoExame, codigoMaterial);
                    if (rsRequisicao != null) {
                        rsRequisicao.beforeFirst();
                        while (rsRequisicao.next()) {
                            String codigoExameRequisicao = rsRequisicao.getString("exa_codfilho");
                            Integer codigoMaterialRequisicao = rsRequisicao.getInt("mco_codfilho");
                            if (!codigoExameAtual.equalsIgnoreCase(codigoExameRequisicao) || codigoMaterialAtual.intValue() != codigoMaterialRequisicao.intValue()) continue;
                            temExame = true;
                            break;
                        }
                    }
                    if (temExame) continue;
                    StringBuilder buf = new StringBuilder();
                    buf.append(" insert into examerequisicaoguiaagrupada (");
                    buf.append("             fil_codigo ");
                    buf.append("            ,exa_codigo ");
                    buf.append("            ,exa_codfilho ");
                    buf.append("            ,mco_codigo ");
                    buf.append("            ,mco_codfilho ");
                    buf.append("            ,req_codigo ");
                    buf.append("            ,exg_guia ");
                    buf.append("            ,exg_validadeguia ");
                    buf.append("            ,exg_deveguia ");
                    buf.append("            ,exg_dataguia) ");
                    buf.append("      values (");
                    buf.append("             ").append(codigoFilial);
                    buf.append("            ,'").append(codigoExame).append("' ");
                    buf.append("            ,'").append(codigoExameAtual).append("' ");
                    buf.append("            ,").append(codigoMaterial);
                    buf.append("            ,").append(codigoMaterialAtual);
                    buf.append("            ,").append(codigoRequisicao);
                    buf.append("            ,'' ");
                    buf.append("            ,null ");
                    buf.append("            ,true ");
                    buf.append("            ,null) ");
                    Conexao.executeUpdate(codigoFilial.toString(), stInsert, buf.toString());
                    exameAlterado = true;
                } while (rsAtual.next());
            }
            bl = exameAlterado || rsAtual == null && rsRequisicao != null;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar agrupamento.\n" + e.getMessage(), e.getStackTrace());
                bl2 = false;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(stAtual, stRequisicao, stInsert);
                throw throwable;
            }
            Conexao.fecharStatement(stAtual, stRequisicao, stInsert);
            return bl2;
        }
        Conexao.fecharStatement(stAtual, stRequisicao, stInsert);
        return bl;
    }

    public static void obterDataHoraExamesControle(Map<String, Object> params, boolean dataAnterioresUsandoColeta, Date dataMaterial) {
        if (dataAnterioresUsandoColeta && dataMaterial != null) {
            params.put("exc_data", Funcoes.formataData("MM/dd/yyyy", dataMaterial));
            params.put("exc_hora", Funcoes.formataData("HH:mm:ss.SSS", dataMaterial));
        } else {
            params.put("exc_data", Funcoes.formataData("MM/dd/yyyy", new Date()));
            params.put("exc_hora", Funcoes.formataData("HH:mm:ss.SSS", new Date()));
        }
    }

    public static void deletaExamesControle(Map<String, Object> params, Statement st) {
        ExameUtil.deletaExamesControlePerformance(params, st);
    }

    public static void deletaExamesControlePerformance(Map<String, Object> params, Statement st) {
        try {
            StringBuilder bui = new StringBuilder("delete from examescontrole where ");
            bui.append("fil_codigo = ").append(params.get("fil_codigo"));
            bui.append(" and pac_codigo = ").append(params.get("pac_codigo"));
            bui.append(" and exa_codigo = '").append(StringUtil.textoDB(params.get("exa_codigo").toString())).append("'");
            bui.append(" and mco_codigo = ").append(params.get("mco_codigo"));
            bui.append(" and req_codigo = ").append(params.get("req_codigo"));
            Conexao.executePerformance(String.valueOf(params.get("fil_codigo")), st, bui.toString(), false);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    public static void insereExameControle(Map<String, Object> params, Statement st, boolean insertComBdText) {
        ExameUtil.insereExameControlePerformance(params, st, insertComBdText);
    }

    public static void insereExameControlePerformance(Map<String, Object> params, Statement st, boolean insertComBdText) {
        try {
            if (insertComBdText) {
                StringBuilder query = new StringBuilder();
                query.append("insert into examescontrole(fil_codigo, pac_codigo, exa_codigo, mco_codigo, met_codigo, exc_data, exc_hora, req_codigo, exc_resultado) values(");
                query.append(params.get("fil_codigo")).append(", ");
                query.append(params.get("pac_codigo")).append(", ");
                query.append(DBUtil.bdText(String.valueOf(params.get("exa_codigo")))).append(", ");
                query.append(params.get("mco_codigo")).append(", ");
                query.append(params.get("met_codigo")).append(", ");
                query.append(DBUtil.bdText(String.valueOf(params.get("exc_data")))).append(", ");
                query.append(DBUtil.bdText(ExameUtil.getDataHoraExameControle(params))).append(", ");
                query.append(params.get("req_codigo")).append(", ");
                query.append(DBUtil.bdText(String.valueOf(params.get("exc_resultado")))).append(") ");
                Conexao.executeUpdatePerformance(String.valueOf(params.get("fil_codigo")), st, query.toString(), false);
            } else {
                ConstrutorInsert insert = new ConstrutorInsert("examescontrole");
                insert.addCampoValor("fil_codigo", params.get("fil_codigo"));
                insert.addCampoValor("pac_codigo", params.get("pac_codigo"));
                insert.addCampoValor("exa_codigo", StringUtil.textoDB(String.valueOf(params.get("exa_codigo"))), true);
                insert.addCampoValor("mco_codigo", params.get("mco_codigo"));
                insert.addCampoValor("met_codigo", params.get("met_codigo"));
                insert.addCampoValor("exc_data", String.valueOf(params.get("exc_data")), true);
                insert.addCampoValor("exc_hora", ExameUtil.getDataHoraExameControle(params), true);
                insert.addCampoValor("req_codigo", String.valueOf(params.get("req_codigo")));
                insert.addCampoValor("exc_resultado", StringUtil.textoDB(String.valueOf(params.get("exc_resultado"))), true);
                Conexao.executePerformance(String.valueOf(params.get("fil_codigo")), st, insert.getSQL(), false);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    public static String getDataHoraExameControle(Map<String, Object> params) throws ParseException, SQLException {
        String resultado = "";
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        Calendar cal = Calendar.getInstance();
        sql.append(" select to_char(COALESCE(max(exc_hora), null), 'HH24:MI:SS.MS' ) as exc_hora from examescontrole ");
        sql.append(" where fil_codigo = ").append(params.get("fil_codigo"));
        sql.append(" and pac_codigo = ").append(params.get("pac_codigo"));
        sql.append(" and exa_codigo = '").append(StringUtil.textoDB(String.valueOf(params.get("exa_codigo")))).append("'");
        sql.append(" and mco_codigo = ").append(params.get("mco_codigo"));
        sql.append(" and exc_data = '").append(params.get("exc_data")).append("' ");
        sql.append(" and exc_hora = '").append(params.get("exc_hora")).append("' limit 1 ;");
        ResultSet rs = Conexao.executeQueryPerformance(st, sql.toString());
        if (rs.next()) {
            resultado = rs.getString("exc_hora");
            if (!Funcoes.textoVazio(resultado)) {
                cal.setTime(df.parse(resultado));
                int milisegundos = cal.get(14);
                cal.add(14, 1);
                resultado = Funcoes.formataData("HH:mm:ss.SSS", cal.getTime());
                params.put("exc_hora", resultado);
                resultado = ExameUtil.getDataHoraExameControle(params);
            } else {
                resultado = String.valueOf(params.get("exc_hora"));
            }
        } else {
            resultado = String.valueOf(params.get("exc_hora"));
        }
        rs.close();
        st.close();
        return resultado;
    }

    public static List<RecipienteColetaVO> getRecipientesColeta(String codigoFilial, String exaCodigo, int codigoMaterialColetado) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select a.rec_codigo, a.rco_qtde, b.rec_descricao, a.rco_volume, b.unm_codigo, a.rco_interface ");
        buf.append("from recipcoleta a ");
        buf.append("left join recipientes b on a.fil_codigo = b.fil_codigo and a.rec_codigo=b.rec_codigo ");
        buf.append("where a.fil_codigo=");
        buf.append(codigoFilial);
        buf.append(" and upper(a.exa_codigo)=upper(").append(StringUtil.textoDBEscape(exaCodigo)).append(") and a.mco_codigo=");
        buf.append(codigoMaterialColetado);
        buf.append(" and b.rec_tipo='");
        buf.append("C");
        buf.append("'");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        ArrayList<RecipienteColetaVO> listaRecipiente = new ArrayList<RecipienteColetaVO>();
        while (rs.next()) {
            RecipienteColetaVO recipiente = new RecipienteColetaVO();
            ExameVO exame = new ExameVO();
            exame.setCodigo(exaCodigo);
            recipiente.setExame(exame);
            RecipienteVO rec = new RecipienteVO();
            rec.setCodigo(rs.getInt("rec_codigo"));
            rec.setDescricao(rs.getString("rec_descricao"));
            recipiente.setRecipiente(rec);
            MaterialColetaVO materialColeta = new MaterialColetaVO();
            materialColeta.setCodigo(codigoMaterialColetado);
            recipiente.setMatColeta(materialColeta);
            recipiente.setQuantidade(rs.getInt("rco_qtde"));
            recipiente.setVolume(rs.getBigDecimal("rco_volume"));
            recipiente.setRco_interface(rs.getBoolean("rco_interface"));
            recipiente.setUnidade(rs.getString("unm_codigo"));
            listaRecipiente.add(recipiente);
        }
        return listaRecipiente;
    }

    public static List<RecipienteTriagemVO> getRecipientesTriagem(String codigoFilial, String exaCodigo, int codigoMaterialColetado) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select a.rec_codigo, a.rtr_qtde, b.rec_descricao, a.rtr_volume, b.unm_codigo, a.rtr_interface ");
        buf.append("from reciptriagem a ");
        buf.append("left join recipientes b on a.fil_codigo = b.fil_codigo and a.rec_codigo=b.rec_codigo ");
        buf.append("where a.fil_codigo=");
        buf.append(codigoFilial);
        buf.append(" and upper(a.exa_codigo)=upper(").append(StringUtil.textoDBEscape(exaCodigo)).append(") and a.mco_codigo=");
        buf.append(codigoMaterialColetado);
        buf.append(" and b.rec_tipo='");
        buf.append("T");
        buf.append("'");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        ArrayList<RecipienteTriagemVO> listaRecipiente = new ArrayList<RecipienteTriagemVO>();
        while (rs.next()) {
            RecipienteTriagemVO recipiente = new RecipienteTriagemVO();
            ExameVO exame = new ExameVO();
            exame.setCodigo(exaCodigo);
            recipiente.setExame(exame);
            RecipienteVO rec = new RecipienteVO();
            rec.setCodigo(rs.getInt("rec_codigo"));
            rec.setDescricao(rs.getString("rec_descricao"));
            recipiente.setRecipiente(rec);
            MaterialColetaVO materialColeta = new MaterialColetaVO();
            materialColeta.setCodigo(codigoMaterialColetado);
            recipiente.setMatColeta(materialColeta);
            recipiente.setQuantidade(rs.getInt("rtr_qtde"));
            recipiente.setVolume(rs.getBigDecimal("rtr_volume"));
            recipiente.setRco_interface(rs.getBoolean("rtr_interface"));
            recipiente.setUnidade(rs.getString("unm_codigo"));
            listaRecipiente.add(recipiente);
        }
        return listaRecipiente;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void atualizaRequisicaoResultadoPDF(String retorno, String codigoExame, String codigoMaterial, String codigoFilial, String codigoRequisicao, boolean isPdf) {
        Statement st = null;
        try {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            String resultado = "''";
            String situacao = "";
            if (!Funcoes.textoVazio(retorno)) {
                resultado = StringUtil.textoDBEscape(retorno);
                situacao = "L";
            }
            buf.append("update examerequisicaoresultado set ert_resultadopdf = ");
            buf.append(resultado);
            buf.append(" where fil_codigo = ").append(codigoFilial);
            buf.append(" and req_codigo = ").append(codigoRequisicao);
            buf.append(" and exa_codigo = '").append(codigoExame).append("'");
            buf.append(" and mco_codigo = '").append(codigoMaterial).append("'");
            Conexao.executeUpdate(codigoFilial, Conexao.getStatement(), buf.toString());
            buf = new StringBuilder();
            buf.append("update examerequisicao set exr_resultadoempdf = '").append(isPdf).append("'");
            if (situacao.equalsIgnoreCase("L")) {
                buf.append(" ,exr_situacao = '").append("L").append("',");
                buf.append(" exr_datadigita = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("',");
                buf.append(" usr_coddigitador = '").append(Variaveis.login).append("'");
            }
            buf.append(" where fil_codigo = ").append(codigoFilial);
            buf.append(" and req_codigo = ").append(codigoRequisicao);
            buf.append(" and exa_codigo = '").append(codigoExame).append("'");
            buf.append(" and mco_codigo = '").append(codigoMaterial).append("'");
            Conexao.executeUpdate(codigoFilial, st, buf.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar o log de confer\u00eancia autom\u00e1tica.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return;
        }
        Conexao.fecharStatement(st);
    }

    public static ArrayList<String> verificaFilial(String filial) {
        return ExameUtil.verificaFilial(filial, Variaveis.filialPadrao, ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente(), ParametrosGerais.getCopiaPaciente());
    }

    public static ArrayList<String> verificaFilial(String filial, String filialPadrao, boolean pesquisarAnterioresAutocopiaPaciente, String copiaPaciente) {
        ArrayList<String> filiaisValidas = new ArrayList<String>();
        boolean filialAutoCopia = false;
        String string = filial = Funcoes.textoVazio(filial) ? filialPadrao : filial;
        if (filial.startsWith("0")) {
            String regex = "^0+(?!$)";
            filial = filial.replaceFirst(regex, "");
        }
        if (pesquisarAnterioresAutocopiaPaciente && !Funcoes.textoVazio(copiaPaciente)) {
            String[] str = StringUtil.getValor(copiaPaciente, "filiais").split(",");
            for (int i = 0; i < str.length; ++i) {
                if (!filial.equals(str[i])) {
                    filiaisValidas.add(str[i]);
                    continue;
                }
                filialAutoCopia = true;
            }
        }
        if (!filialAutoCopia) {
            filiaisValidas = new ArrayList();
        }
        filiaisValidas.add(filial);
        return filiaisValidas;
    }

    private static String getSqlDadosExameRequisicao(String codigoRequisicao, String codigoExame, String codigoMaterial, String filial) {
        StringBuilder buf = new StringBuilder();
        buf.append("select b.req_codigo as codigoRequisicao, usulog.usr_assinatura as assinaturaUsuario, ");
        buf.append("req.req_responsavel as responsavelPacienteRequisicao, req.req_cpfresponsavel as cpfResponsavelPacienteRequisicao, COALESCE(req.req_incapacitado, FALSE) as incapacitadoPacienteRequisicao, ");
        buf.append("null as dataPrimeiraColetaRequisicao, null as dataUltimaColetaRequisicao, null as datasColetaRequisicao, ");
        buf.append("'' as hashResultado, '' as resultadoRetificadoExame, ");
        buf.append("case when le.lex_dataestorno is null then labe.lae_descricao else '' end as descricaoLaboratorioExternoExame, ");
        buf.append("tmc.tmc_descricao as descricaoTipoMaterialColeta, tmc.tmc_codigo as codigoTipoMaterialColeta, ");
        buf.append("tmc.tmc_valorincerteza as valorIncertezaTipoMaterialColeta, ");
        buf.append("'' as dataUltimoExameDigitadoRequisicao, '' as dataUltimoExameConferidoRequisicao, '' as razaoAssinatura, '' as chaveAcessoRequisicao, ");
        buf.append("CASE WHEN b.exr_intervaloJejum is null then TO_CHAR(b.exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(b.exr_intervaloJejum,'HH24:MI:SS') end as tempoJejumExame, b.exr_vlrch as valorCH, w.exa_salvaparcial,");
        buf.append("b.exr_tempodiurese as tempoDiureseExame, b.exr_volumediurese as volumeDiureseExame, b.exr_matexterno as materialExternoExame, ");
        buf.append("b.exa_codigo as codigoExame, w.exa_descricao as descricaoExame, b.exr_vlrchexame as ambExame, b.exr_vlrchexame as chExame, b.exr_vlrexame as valorExame, b.exr_vlrmaterial as valorMateriaisExame, b.exr_situacao as situacaoExame, ");
        buf.append("v.mco_descricao as descricaoMaterial, v.mco_codigo as codigoMaterial, v.mco_abreviatura as abreviaturaMaterial, b.exr_datamaterial as dataColetaExame, b.exr_datamaterial as horaColetaExame, ");
        buf.append("u.emc_referencia as valorReferenciaExame, ");
        buf.append("b.met_codigo as codigoMetodoExame, ");
        buf.append("prazo.prz_descricao as descricaoPrazo, prazo.prz_codigo as codigoPrazo, ");
        buf.append("metodo.met_codigo as codigoMetodo, metodo.met_referencia as referenciaMetodo, ");
        buf.append("w.exa_soa as codigoSOAExame, w.exa_coa as codigoCOAExame, null as dataPrimeiraImpressaoRequisicao, null as dataHoraUltimaImpressaoExame, ");
        buf.append("null as dataPrimeiraConferenciaRequisicao , null as dataPrimeiraDigitacaoRequisicao, ");
        buf.append("w.exa_inmetro as certificadoInmetroExame, false as possuiExameCertificadoInmetro, ");
        buf.append("0 as quantidadeAlteracoesRequisicao, 0 as quantidadeAlteracoesComConferenciaRequisicao, 0 as maiorQuantidadeRetificacoesLaudo, ");
        buf.append("null as codigoUltimoMotivoAlteracao, '' as descricaoUltimoMotivoAlteracao, null as dataUltimoMotivoAlteracao, '' as motivoUltimoMotivoAlteracao, ");
        buf.append("null as codigoUltimoMotivoAlteracaoComConferenciaRequisicao, '' as descricaoUltimoMotivoAlteracaoComConferenciaRequisicao, null as dataUltimoMotivoAlteracaoComConferenciaRequisicao, '' as motivoUltimoMotivoAlteracaoComConferenciaRequisicao, ");
        buf.append("null as codigoUltimoMotivoAlteracaoOficial, '' as descricaoUltimoMotivoAlteracaoOficial, null as dataUltimoMotivoAlteracaoOficial, '' as motivoUltimoMotivoAlteracaoOficial, ");
        buf.append("null as codigoUltimoMotivoAlteracaoComConferenciaRequisicaoOficial, '' as descricaoUltimoMotivoAlteracaoComConferenciaRequisicaoOficial, ");
        buf.append("null as dataUltimoMotivoAlteracaoComConferenciaRequisicaoOficial, '' as motivoUltimoMotivoAlteracaoComConferenciaRequisicaoOficial,");
        buf.append("false as examesIncompletosRequisicao, '' as codigoAMBExame, ");
        buf.append(" '' as dataImpressaoEtqTriagemInicial, '' as dataImpressaoEtqTriagemFinal, ");
        buf.append(" '' as dataImpressaoEtqColetaInicial, '' as dataImpressaoEtqColetaFinal, ");
        buf.append("coalesce(b.exr_urgente, false) as urgenteExame, ");
        buf.append("metodo.met_descricao as descricaoMetodo, b.exr_descricaomaterial as materialInformadoExame, b.exr_dataentregaprev as dataEntregaExame, b.exr_dataentregaprev as horaEntregaExame, b.exr_datadigita as dataDigitacaoExame, b.exr_dataassina as dataConferenciaExame, ");
        buf.append("coalesce(b.exr_coletaincorreta, false) as preparoIncorretoExame, b.exr_motivocoletaincorreta as motivoPreparoIncorretoExame, ");
        buf.append("usudig.usr_codigo as codigoUsuarioDigitacao, usudig.usr_nome as nomeUsuarioDigitacao, usudig.usr_assinatura as assinaturaUsuarioDigitacao, ");
        buf.append("usuass.usr_codigo as codigoUsuarioConferencia, usuass.usr_nome as nomeUsuarioConferencia, usuass.usr_assinatura as assinaturaUsuarioConferencia, b.exr_codautorizacao as autorizacaoExame, ");
        buf.append("b.usr_codmaterial as usuarioColetaExame, usucoleta.usr_nome as nomeUsuarioColetaExame, ");
        buf.append("setores.set_codigo as codigoSetorExamePadrao, setores.set_descricao as descricaoSetorExamePadrao, setores.set_responsavel as responsavelSetorExamePadrao, setores.set_sigla as siglaSetorExamePadrao, ");
        buf.append("'' as descricaoRecipientesColetaExame, '' as volumeRecipientesColetaExame, '' as descricaoRecipientesTriagemExame, '' as volumeRecipientesTriagemExame, ");
        buf.append("u.emc_conservacao as conservacaoExame, u.emc_diasconserva as diasConservacaoExame, u.emc_temperaturainicial as temperaturaInicialConservacaoExame, u.emc_temperaturafinal as temperaturaFinalConservacaoExame, ");
        buf.append("'' as motivoUltimaRetificacao, null as dataHoraUltimaRetificacao, '' as usuarioUltimaRetificacao ");
        buf.append("from examerequisicao b ");
        buf.append("join requisicao req on b.FIL_CODIGO = req.fil_codigo AND b.req_codigo = req.req_codigo ");
        buf.append("left join loteexternoexamerequisicao as ler on ler.fil_codigo = b.fil_codigo and ler.req_codigo = b.req_codigo and ler.exa_codigo = b.exa_codigo and ler.mco_codigo = b.mco_codigo ");
        buf.append("left join loteexterno as le on le.fil_codigo = ler.fil_codigo and le.lex_codigo = ler.lex_codigo and le.lae_codigo = ler.lae_codigo ");
        buf.append("left join labexterno as labe on labe.fil_codigo = ler.fil_codigo and labe.lae_codigo = ler.lae_codigo ");
        buf.append("left join examematcoleta u on b.fil_codigo = u.fil_codigo and b.exa_codigo = u.exa_codigo and b.mco_codigo = u.mco_codigo ");
        buf.append("left join materialcoleta v on u.fil_codigo = v.fil_codigo and u.mco_codigo = v.mco_codigo ");
        buf.append("left join tipomaterialcoleta tmc on v.fil_codigo = tmc.fil_codigo and v.tmc_codigo = tmc.tmc_codigo ");
        buf.append("left join exames w on b.fil_codigo = w.fil_codigo and b.exa_codigo = w.exa_codigo ");
        buf.append("left join examesetor examesetor on w.fil_codigo = examesetor.fil_codigo and w.exa_codigo = examesetor.exa_codigo and examesetor.ese_default = true ");
        buf.append("left join setores setores on examesetor.fil_codigo = setores.fil_codigo and examesetor.set_codigo = setores.set_codigo ");
        buf.append("left join prazoentrega prazo on u.fil_codigo = prazo.fil_codigo and u.prz_codigo = prazo.prz_codigo ");
        buf.append("left join metodologia metodo on u.fil_codigo = metodo.fil_codigo and u.met_codigo = metodo.met_codigo ");
        buf.append("left join usuario usudig on usudig.usr_codigo = b.usr_coddigitador ");
        buf.append("left join usuario usuass on usuass.usr_codigo = b.usr_codassina ");
        buf.append("left join usuario usucoleta on usucoleta.usr_codigo = b.usr_codmaterial ");
        buf.append("left join usuario usulog on usulog.usr_codigo = '").append(Variaveis.login).append("'");
        buf.append("where b.fil_codigo = ");
        buf.append(filial);
        buf.append(" and b.req_codigo = ");
        buf.append(codigoRequisicao);
        if (codigoExame != null && codigoMaterial != null && codigoExame.length() > 0 && codigoMaterial.length() > 0) {
            buf.append(" and b.exa_codigo = '");
            buf.append(codigoExame);
            buf.append("' and b.mco_codigo = ");
            buf.append(codigoMaterial);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buscaCodigoConvenio(Statement st, String codigoRequisicao, String filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select con_codigo from requisicao ");
        buf.append("where fil_codigo = ").append(filial);
        buf.append("  and req_codigo = ").append(codigoRequisicao);
        String codigoConvenio = "";
        try (ResultSet resC = null;){
            resC = st.executeQuery(buf.toString());
            if (resC.next()) {
                codigoConvenio = resC.getString("con_codigo");
            }
        }
        return codigoConvenio;
    }

    private static String getSqlQuantidadeAlteracao(String codigoRequisicao, String filial) {
        StringBuilder sql = new StringBuilder();
        sql.append(" (select rlo_tipo, count(req_codigo) from requisicaolog where fil_codigo = " + filial + " and req_codigo = " + codigoRequisicao + " and rlo_tipo = '" + SEXO_AMBOS + "' group by rlo_tipo)");
        sql.append(" union ");
        sql.append(" (select rlo_tipo, count(req_codigo) from requisicaolog where fil_codigo = " + filial + " and req_codigo = " + codigoRequisicao + " and rlo_tipo = '" + "C" + "' group by rlo_tipo) ");
        return sql.toString();
    }

    public static int getQtdeExamesImportados(String codigoLabExterno, String tabela) {
        Statement st = Conexao.getStatement();
        String sql = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append(" SELECT count(*) as quantidadeExames ");
                bui.append(" FROM ").append(tabela);
                bui.append(" WHERE fil_codigo = ").append(Variaveis.filialPadrao).append(" AND \n");
                bui.append(" lae_codigo = ").append(codigoLabExterno).append(" \n");
                sql = bui.toString();
                ResultSet res = Conexao.executeQuery(st, sql);
                if (res.next()) {
                    return res.getInt("quantidadeExames");
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + sql, e.getStackTrace());
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getMaterialPadrao(String filial, String exame) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        if (st != null) {
            block5: {
                Integer n;
                try {
                    bui.append(" select a.mco_codigo as materialPadrao ");
                    bui.append(" from examematcoleta a ");
                    bui.append(" left join exames c on a.fil_codigo=c.fil_codigo and a.exa_codigo = c.exa_codigo ");
                    bui.append(" where a.fil_codigo=");
                    bui.append(filial);
                    bui.append(" and a.exa_codigo = '");
                    bui.append(exame.toUpperCase());
                    bui.append("' and a.emc_default=");
                    bui.append(true);
                    ResultSet res = Conexao.executeQuery(st, bui.toString());
                    if (!res.next()) break block5;
                    n = res.getInt("materialPadrao");
                }
                catch (SQLException e) {
                    try {
                        ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + bui.toString(), e.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                Conexao.fecharStatement(st);
                return n;
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    private static enum TipoPrazoEntrega {
        N('N', false, false, true),
        R('R', true, true, true),
        E('E', false, true, false),
        S('S', false, false, false),
        G('G', true, true, false),
        C('C', false, true, true);

        private char tipo = '\u0000';
        private boolean iniciaRotina = false;
        private boolean somaPrazo = false;
        private boolean entrega = false;

        private TipoPrazoEntrega(char tipo, boolean iniciaRotina, boolean somaPrazo, boolean entrega) {
            this.tipo = tipo;
            this.iniciaRotina = iniciaRotina;
            this.somaPrazo = somaPrazo;
            this.entrega = entrega;
        }

        public static boolean getIniciaRotina(char tipo) {
            TipoPrazoEntrega[] tipos;
            for (TipoPrazoEntrega tipoAux : tipos = TipoPrazoEntrega.values()) {
                if (tipoAux.tipo != tipo) continue;
                return tipoAux.iniciaRotina;
            }
            return false;
        }

        public static boolean getSomaPrazo(char tipo) {
            TipoPrazoEntrega[] tipos;
            for (TipoPrazoEntrega tipoAux : tipos = TipoPrazoEntrega.values()) {
                if (tipoAux.tipo != tipo) continue;
                return tipoAux.somaPrazo;
            }
            return false;
        }

        public static boolean getEntrega(char tipo) {
            TipoPrazoEntrega[] tipos;
            for (TipoPrazoEntrega tipoAux : tipos = TipoPrazoEntrega.values()) {
                if (tipoAux.tipo != tipo) continue;
                return tipoAux.entrega;
            }
            return false;
        }
    }
}

