/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.DocumentoListener;
import jalis.util.Funcoes;
import jalis.util.PadroesRegex;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class DocumentoMascara
extends PlainDocument
implements FocusListener,
CaretListener {
    private static final String PADRAO_NUMERO = "(<|>)? *\\-?\\d+(\\.\\d+)*(\\,\\d+)?";
    private static final String PADRAO_NUMERO_SEM_SINAL = "([0-9,.]+)";
    private static final String PADRAO_NUMERO_COM_SINAL = "([0-9,.\\-\\%]+)?";
    private static final String PADRAO_NUMERO_DATA_HORARIO = "(<|>)? *\\-?\\d+(\\.\\d+)*(\\,\\d+)?|(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])(/(\\d{2}|\\d{4}))?|(([01]\\d|2[0-3]):)?[0-5]\\d(:[0-5]\\d)?";
    private static final String PADRAO_TRACO = "\\- *(\\. +)*(\\, +)?";
    private static final String PADRAO_VAZIO = "[ .,<>:/]*";
    private static final String PADRAO_ZERO = "(<|>)? ?\\-?0*";
    private static final String PADRAO_ENTRADA = "[\\*-<>.,0-9%]+";
    private final String charMasc = ",./:";
    private final String charSinal = "<>-";
    private String masc = "";
    private JTextComponent text;
    private boolean processarPerdaFoco = true;
    private int tipoDocumento = 0;

    public DocumentoMascara(JTextComponent text, String masc) {
        try {
            if (masc.matches(PadroesRegex.MASCARA_NUMERO_DATA_HORARIO)) {
                this.masc = masc.replaceAll("[kdmahsKDMAHS#]", " ");
            }
            if (text != null) {
                this.text = text;
                text.addFocusListener(this);
                text.addCaretListener(this);
            }
            this.carregarMascara();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMascara: 52");
        }
    }

    public DocumentoMascara(JTextComponent text, String masc, int tipo) {
        try {
            this.tipoDocumento = tipo;
            if (masc.matches(PadroesRegex.MASCARA_NUMERO_DATA_HORARIO)) {
                this.masc = masc.replaceAll("[kdmahsKDMAHS#]", " ");
            }
            if (text != null) {
                this.text = text;
                text.addFocusListener(this);
                text.addCaretListener(this);
            }
            this.carregarMascara();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMascara: 52");
        }
    }

    public void addDocumentoListener(DocumentoListener ouvinte) {
        this.listenerList.add(DocumentoListener.class, ouvinte);
    }

    public void removeDocumentoListener(DocumentoListener ouvinte) {
        this.listenerList.remove(DocumentoListener.class, ouvinte);
    }

    public void formatarValor() {
        try {
            String tmp = this.getValor();
            if (!Funcoes.textoVazio(tmp)) {
                super.remove(0, this.getLength());
            }
            super.insertString(0, tmp, null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMascara: 83");
        }
    }

    public void setValor(String str) {
        if (str != null && (str.matches(PADRAO_NUMERO_DATA_HORARIO) || str.equals("-") || str.equals("*"))) {
            try {
                if (this.masc.matches(" +(\\. +)*(\\, +)?") && str.matches(PADRAO_NUMERO)) {
                    int vM;
                    StringBuilder bui = new StringBuilder();
                    str = this.removeEspacosZerosEsquerda(str);
                    str = StringUtil.removeCaractere(str, '.');
                    int vrgStr = str.indexOf(44);
                    int vrgMas = this.masc.indexOf(44);
                    int vS = vrgStr > -1 ? vrgStr - 1 : str.length() - 1;
                    int n = vM = vrgMas > -1 ? vrgMas - 1 : this.masc.length() - 1;
                    while (vS > -1 && (vM > -1 || str.charAt(vS) == ' ' || this.caractereDeSinal(str.charAt(vS)))) {
                        boolean inserirVlr = vM < 0 || this.masc.charAt(vM) == ' ' || str.charAt(vS) == ' ' || this.caractereDeSinal(str.charAt(vS));
                        bui.insert(0, inserirVlr ? str.charAt(vS--) : (char)'.');
                        if (vM <= -1) continue;
                        --vM;
                    }
                    if (vrgMas > -1) {
                        bui.append(',');
                        vM = vrgMas + 1;
                        vS = vrgStr + 1;
                        while (vM++ < this.masc.length()) {
                            bui.append(vS == 0 || vS >= str.length() ? (char)'0' : str.charAt(vS++));
                        }
                    }
                    str = bui.toString();
                }
                super.remove(0, this.getLength());
                super.insertString(0, str, null);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMascara: 127");
            }
        }
    }

    public int getTipoDocumento() {
        return this.tipoDocumento;
    }

    public String getValor() {
        StringBuilder bui = new StringBuilder();
        try {
            String valor = this.getText(0, this.getLength());
            if (valor.matches(PADRAO_TRACO)) {
                bui.append('-');
            } else if (valor.equals("*")) {
                bui.append('*');
            } else if (!valor.matches(PADRAO_VAZIO)) {
                int posVrg = valor.indexOf(44);
                if (posVrg > -1) {
                    bui.append(this.getValorFormatado(this.getValorPosicao(posVrg), valor.length() - posVrg));
                    char[] c = valor.substring(posVrg + 1, valor.length()).toCharArray();
                    for (int i = 0; i < c.length; ++i) {
                        bui.append(c[i] == ' ' ? (char)'0' : c[i]);
                    }
                } else if (valor.indexOf(58) > -1 || valor.indexOf(47) > -1) {
                    bui.append(valor.replace(' ', '0'));
                } else {
                    bui.append(this.getValorFormatado(this.getValorSemMascara(valor), 1));
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMascara: 159");
        }
        return bui.toString();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int pos = this.getPrimeiraPosicaoAposSinal();
        if (e.getDot() < pos && this.text != null && pos <= this.text.getText().length()) {
            this.text.setCaretPosition(pos);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.text != null) {
            this.text.setSelectionStart(0);
            this.text.setSelectionEnd(this.getLength());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.processarPerdaFoco && !this.vazio()) {
            try {
                String valor = this.getValor();
                super.remove(0, this.getLength());
                super.insertString(0, valor, null);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DocumentoMascara: 199");
            }
        } else if (this.text != null) {
            this.text.setSelectionStart(0);
            this.text.setSelectionEnd(0);
        }
    }

    public void setProcessarPerdaDeFoco(boolean processar) {
        this.processarPerdaFoco = processar;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.tipoDocumento == 2 || this.tipoDocumento == 10) {
            if (!str.matches(PADRAO_NUMERO_COM_SINAL)) {
                return;
            }
            if (Funcoes.isNumeric(str) && (str.indexOf(".") > 0 || str.indexOf(",") > 0)) {
                str = str.replaceAll("\\.", "").replaceAll("\\,", ".");
            }
        }
        if (str.matches(PADRAO_ENTRADA)) {
            char[] ch = str.toCharArray();
            int posVrg = -1;
            int posOff = offs;
            for (int i = 0; i < ch.length && posOff < this.getLength(); ++i) {
                int len = this.getLength();
                if ((ch[i] == '.' || ch[i] == ',') && (posVrg = this.getText(0, len).indexOf(",", offs + i)) > -1) {
                    String valor = this.getValorFormatado(this.getValorPosicao(posVrg), len - posVrg) + this.getText(posVrg + 1, len - posVrg - 1);
                    super.remove(0, len);
                    super.insertString(0, valor, a);
                    posOff = this.getLength() - len + posVrg + 1;
                    continue;
                }
                if (this.caractereDeMascara(ch[i])) continue;
                if (this.caractereDeSinal(ch[i])) {
                    if ((!this.masc.matches(" +(\\. +)*(\\, +)?") || posOff != 0) && (ch[i] != '-' || posOff != 2 || "<>".indexOf(this.getText(0, 1).charAt(0)) <= -1)) continue;
                    super.insertString(posOff++, String.valueOf(ch[i]), a);
                    if (ch[i] != '<' && ch[i] != '>') continue;
                    super.insertString(posOff++, " ", a);
                    continue;
                }
                if (ch[i] == '*') {
                    super.remove(0, this.getLength());
                    super.insertString(0, "*", a);
                    posOff = 1;
                    continue;
                }
                char charTmp = this.getText(posOff, 1).charAt(0);
                while (this.caractereDeMascara(charTmp) && posOff < len) {
                    if (++posOff >= len) continue;
                    charTmp = this.getText(posOff, 1).charAt(0);
                }
                if (posOff < len) {
                    super.remove(posOff, 1);
                    super.insertString(posOff, String.valueOf(ch[i]), a);
                }
                if (posOff < len - 1) {
                    charTmp = this.getText(++posOff, 1).charAt(0);
                    while (this.caractereDeMascara(charTmp) && posOff < len) {
                        if (++posOff >= len) continue;
                        charTmp = this.getText(posOff, 1).charAt(0);
                    }
                    continue;
                }
                ++posOff;
            }
            if (this.text != null) {
                this.text.setCaretPosition(posOff);
            }
            this.fireModificouValor();
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        String masc = this.getMascara(this.getText(offs, len));
        if (offs == 1 && "<>".indexOf(this.getText(0, 1).charAt(0)) > -1) {
            offs = 0;
            ++len;
        }
        super.remove(offs, len);
        super.insertString(offs, masc, null);
        if (this.vazio()) {
            this.carregarMascara();
            offs = this.getPrimeiraPosicaoAposSinal();
        }
        if (this.text != null) {
            this.text.setCaretPosition(offs);
        }
        this.fireModificouValor();
    }

    public boolean vazio() {
        boolean vazio = false;
        try {
            vazio = this.getText(0, this.getLength()).matches(PADRAO_VAZIO);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMascara: 324");
        }
        return vazio;
    }

    public void limpar() {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, this.masc, null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMascara: 339");
        }
    }

    private void carregarMascara() {
        try {
            int pos = this.getPrimeiraPosicaoAposSinal();
            super.remove(pos, this.getLength() - pos);
            super.insertString(pos, this.masc, null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMascara: 353");
        }
    }

    private int getPrimeiraPosicaoAposSinal() {
        try {
            return this.getPrimeiraPosicaoAposSinal(this.getText(0, this.getLength()));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int getPrimeiraPosicaoAposSinal(String str) {
        int pos;
        char[] tmp = str.toCharArray();
        for (pos = 0; pos < tmp.length && (this.caractereDeSinal(tmp[pos]) || pos > 0 && "<>".indexOf(tmp[pos - 1]) > -1); ++pos) {
        }
        return pos;
    }

    private boolean caractereDeMascara(char c) {
        return ",./:".indexOf(c) > -1;
    }

    private boolean caractereDeSinal(char c) {
        return "<>-".indexOf(c) > -1;
    }

    private String getValorFormatado(String valor, int pos) throws BadLocationException {
        StringBuilder bui = new StringBuilder();
        char[] vlr = valor.toCharArray();
        char[] msc = this.masc.substring(0, this.masc.length() - pos + 1).toCharArray();
        int posVlr = vlr.length - 1;
        int posMsc = msc.length - 1;
        while (posMsc >= 0 && posVlr >= 0) {
            while (posMsc >= 0 && msc[posMsc] != ' ' && !this.caractereDeSinal(vlr[posVlr]) && vlr[posVlr] != ' ') {
                bui.insert(0, msc[posMsc]);
                --posMsc;
            }
            if (posMsc < 0 || posVlr < 0) continue;
            bui.insert(0, vlr[posVlr]);
            if (--posVlr < 0 || this.caractereDeSinal(vlr[posVlr]) || vlr[posVlr] == ' ') continue;
            --posMsc;
        }
        return bui.toString();
    }

    private String getValorPosicao(int pos) throws BadLocationException {
        if (pos < this.getLength()) {
            return this.getValorSemMascara(this.getText(0, pos + 1));
        }
        return "";
    }

    private String getValorSemMascara(String str) {
        int i;
        StringBuilder bui = new StringBuilder();
        bui.append(str.substring(0, i));
        char[] c = str.toCharArray();
        for (i = this.getPrimeiraPosicaoAposSinal(str); i < c.length && (this.caractereDeMascara(c[i]) || c[i] == '0'); ++i) {
        }
        while (i < c.length && c[i] != ' ') {
            if (!this.caractereDeMascara(c[i])) {
                bui.append(c[i]);
            }
            ++i;
        }
        if (bui.toString().matches(PADRAO_ZERO)) {
            bui.delete(this.getPrimeiraPosicaoAposSinal(bui.toString()), bui.length());
            bui.append('0');
        }
        return bui.toString();
    }

    private String getMascara(String str) {
        StringBuilder bui = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (this.caractereDeSinal(c) || c == ' ') continue;
            bui.append(this.caractereDeMascara(c) ? c : (char)' ');
        }
        return bui.toString();
    }

    public String removeEspacosZerosEsquerda(String str) {
        int pos;
        StringBuilder bui = new StringBuilder();
        for (pos = 0; pos < str.length() && this.caractereDeSinal(str.charAt(pos)); ++pos) {
        }
        bui.append(str.substring(0, pos));
        while (pos < str.length() && (str.charAt(pos) == ' ' || str.charAt(pos) == '0')) {
            ++pos;
        }
        if (pos > 0 && (pos == str.length() || str.charAt(pos) == ',')) {
            --pos;
        }
        bui.append(str.substring(pos, str.length()));
        if (bui.length() > 0 && "<>".indexOf(bui.charAt(0)) > -1) {
            bui.insert(1, ' ');
        }
        return bui.toString();
    }

    private void fireModificouValor() {
        for (DocumentoListener ouvinte : (DocumentoListener[])this.listenerList.getListeners(DocumentoListener.class)) {
            ouvinte.modificouValor();
        }
    }
}

