/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.DocumentoListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;

public class DocumentoLimiteEstilo
extends DefaultStyledDocument {
    private JTextComponent text;
    private int limite;
    private String padrao;

    public DocumentoLimiteEstilo(JTextComponent text) {
        this(text, 0, null);
    }

    public DocumentoLimiteEstilo(JTextComponent text, int limite) {
        this(text, limite, null);
    }

    public DocumentoLimiteEstilo(JTextComponent text, int limite, String padrao) {
        this.text = text;
        this.limite = limite;
        this.padrao = padrao;
    }

    public DocumentoLimiteEstilo(JTextComponent text, int limite, String padrao, DocumentoListener ouvinte) {
        this(text, limite, padrao);
        this.addDocumentoListener(ouvinte);
    }

    public void addDocumentoListener(DocumentoListener ouvinte) {
        this.listenerList.add(DocumentoListener.class, ouvinte);
    }

    public void removeDocumentoListener(DocumentoListener ouvinte) {
        this.listenerList.remove(DocumentoListener.class, ouvinte);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null || this.padrao != null && !str.matches(this.padrao)) {
            return;
        }
        if (this.limite == 0) {
            int largComp = this.text.getWidth();
            int largStr = this.comprimento(this.getText(0, this.getLength()));
            String s = this.stringComprimento(str, largComp - largStr - 10);
            super.insertString(offset, s, attr);
        } else {
            int comp = this.getLength() + str.length();
            if (comp <= this.limite) {
                super.insertString(offset, str, attr);
            } else if (this.getLength() < this.limite) {
                super.insertString(offset, str.substring(0, this.limite - this.getLength()), attr);
            }
        }
        this.fireModificouValor();
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.fireModificouValor();
    }

    private int comprimento(String str) {
        if (this.text != null) {
            return this.text.getFontMetrics(this.text.getFont()).stringWidth(str);
        }
        return 0;
    }

    private void fireModificouValor() {
        for (DocumentoListener ouvinte : (DocumentoListener[])this.listenerList.getListeners(DocumentoListener.class)) {
            ouvinte.modificouValor();
        }
    }

    public String stringComprimento(String str, int comprimento) {
        int pos;
        for (pos = 0; pos < str.length() && this.comprimento(str.substring(0, pos)) < comprimento; ++pos) {
        }
        return str.substring(0, pos);
    }
}

