/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class DocumentoFixo
extends PlainDocument
implements CaretListener {
    String fixo;
    private JTextComponent text = null;
    boolean mudandoFixo = false;
    int qtdeCaracteres = 0;

    public DocumentoFixo(JTextComponent text) {
        this.text = text;
    }

    public DocumentoFixo(JTextComponent text, int qtdeCaracteres) {
        this.text = text;
        this.qtdeCaracteres = qtdeCaracteres;
    }

    public DocumentoFixo(JTextComponent text, String fixo, int qtdeCaracteres) {
        this.qtdeCaracteres = qtdeCaracteres;
        if (fixo != null && fixo.trim().length() > 0) {
            this.setFixo(text, fixo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixo(JTextComponent text, String fixo) {
        this.text = text;
        this.fixo = fixo;
        if (fixo != null && fixo.trim().length() > 0) {
            this.mudandoFixo = true;
            try {
                String textoAtual = this.getText(0, this.getLength());
                if (textoAtual != null && !textoAtual.startsWith(fixo) && textoAtual.trim().length() > 0 && this.fixo != null && fixo != null) {
                    this.replace(0, this.fixo.length(), fixo, null);
                } else if (textoAtual == null || textoAtual.trim().length() == 0) {
                    this.insertString(0, fixo, null);
                }
                this.text.addCaretListener(this);
                this.text.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        JTextField text = (JTextField)e.getSource();
                        if (DocumentoFixo.this.fixo.length() > 0 && text.getText().length() >= DocumentoFixo.this.fixo.length() - 1) {
                            text.setCaretPosition(DocumentoFixo.this.fixo.length() - 1);
                        }
                    }
                });
                this.setDocumentFilter(new DocumentFilter(){

                    @Override
                    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                        if (DocumentoFixo.this.fixo != null && DocumentoFixo.this.fixo.trim().length() > 0 && offset >= DocumentoFixo.this.fixo.length()) {
                            fb.remove(offset, length);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mudandoFixo = false;
            }
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int qtdeFinal = this.getLength() + str.length();
        if (this.qtdeCaracteres == 0 || qtdeFinal <= this.qtdeCaracteres) {
            if (this.fixo == null || offs >= this.fixo.length()) {
                super.insertString(offs, str, a);
            } else {
                super.insertString(this.getLength(), str, a);
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.fixo != null && e.getDot() < this.fixo.length() && !this.mudandoFixo) {
            try {
                this.text.setCaretPosition(this.fixo.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

