/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogoLista
extends JDialog
implements DisposeListener {
    JList jLItens;
    JScrollPane jSPArea = new JScrollPane();
    JPanel panelBarra = new JPanel();
    JPanel panelBotao = new JPanel();
    JButton jBCancelar = new JButton();
    JButton jBOk = new JButton();
    private String item = "";
    private boolean ok = false;

    public static DialogoLista novaInstancia(Object pai, String titulo) {
        if (pai instanceof Frame) {
            return new DialogoLista((Frame)pai, titulo, true);
        }
        if (pai instanceof Dialog) {
            return new DialogoLista((Dialog)pai, titulo, true);
        }
        return null;
    }

    public DialogoLista(Frame pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        try {
            this.jbInit();
            if (pai != null) {
                this.setLocation(ScreenUtil.getCentralizado(pai.getBounds(), this.getSize()));
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(pai, ex.getMessage(), ex.getStackTrace(), "DialogoLista: 61");
        }
    }

    public DialogoLista(Dialog pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        try {
            this.jbInit();
            if (pai != null) {
                this.setLocation(ScreenUtil.getCentralizado(pai.getBounds(), this.getSize()));
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(pai, ex.getMessage(), ex.getStackTrace(), "DialogoLista: 79");
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jSPArea, "Center");
        this.getContentPane().add((Component)this.panelBarra, "South");
        this.setResizable(false);
        this.setSize(new Dimension(380, 400));
        this.panelBarra.setBorder(BorderFactory.createEtchedBorder());
        this.panelBarra.setPreferredSize(new Dimension(10, 35));
        this.panelBarra.setLayout(new BorderLayout());
        this.panelBarra.add((Component)this.panelBotao, "East");
        this.jBOk.setText("OK");
        this.jBOk.setMnemonic('O');
        this.jBOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DialogoLista.this.item = DialogoLista.this.jLItens.getSelectedValue() != null ? (String)DialogoLista.this.jLItens.getSelectedValue() : "";
                DialogoLista.this.ok = true;
                DialogoLista.this.dispose();
            }
        });
        this.jBCancelar.setText("Cancelar");
        this.jBCancelar.setMnemonic('C');
        this.jBCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DialogoLista.this.item = "";
                DialogoLista.this.dispose();
            }
        });
        this.panelBotao.setPreferredSize(new Dimension(170, 10));
        this.panelBotao.setLayout(new FlowLayout(2, 3, 3));
        this.panelBotao.add((Component)this.jBOk, null);
        this.panelBotao.add((Component)this.jBCancelar, null);
    }

    public void setItens(String[] itens) {
        this.jLItens = new JList<String>(itens);
        this.jSPArea.setViewportView(this.jLItens);
    }

    public String getItemSelecionado() {
        return this.item;
    }

    public boolean ok() {
        return this.ok;
    }
}

