/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogoFonte
extends JDialog
implements ListSelectionListener,
ChangeListener,
DisposeListener {
    JPanel panelArea = new JPanel();
    JPanel panelBarra = new JPanel();
    JPanel panelBotoes = new JPanel();
    FlowLayout fLBotoes = new FlowLayout();
    JButton jBOk = new JButton();
    JButton jBCancelar = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLExe = new JLabel();
    JPanel panelEstilo = new JPanel();
    JScrollPane jSPFontes = new JScrollPane();
    JList jLFontes = new JList<String>(this.getFontes());
    JCheckBox jCBItalico = new JCheckBox();
    JCheckBox jCBNegrito = new JCheckBox();
    JComboBox jCBTamanho = new JComboBox();
    JLabel jLabel1 = new JLabel();
    private boolean atualizar = true;
    private boolean ok = false;

    public static DialogoFonte novaInstancia(Object pai, String titulo) {
        if (pai instanceof Frame) {
            return new DialogoFonte((Frame)pai, titulo, true);
        }
        if (pai instanceof Dialog) {
            return new DialogoFonte((Dialog)pai, titulo, true);
        }
        return null;
    }

    public DialogoFonte(Frame pai, String title, boolean modal) {
        super(pai, title, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        try {
            this.jbInit();
            if (pai != null) {
                this.setLocation(ScreenUtil.getCentralizado(pai.getBounds(), this.getSize()));
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(pai, ex.getMessage(), ex.getStackTrace(), "DialogoFonte: 72");
        }
    }

    public DialogoFonte(Dialog pai, String title, boolean modal) {
        super(pai, title, modal);
        try {
            this.jbInit();
            if (pai != null) {
                this.setLocation(ScreenUtil.getCentralizado(pai.getBounds(), this.getSize()));
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(pai, ex.getMessage(), ex.getStackTrace(), "DialogoFonte: 90");
        }
    }

    private void jbInit() throws Exception {
        this.setSize(400, 300);
        this.getContentPane().add((Component)this.panelArea, "Center");
        this.getContentPane().add((Component)this.panelBarra, "South");
        this.setResizable(false);
        this.panelBarra.setBorder(BorderFactory.createEtchedBorder());
        this.panelBarra.setPreferredSize(new Dimension(10, 35));
        this.panelBarra.setLayout(new BorderLayout());
        this.panelBarra.add((Component)this.panelBotoes, "East");
        this.jPanel1.setMinimumSize(new Dimension(10, 10));
        this.jPanel1.setPreferredSize(new Dimension(10, 70));
        this.jPanel1.setRequestFocusEnabled(true);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.add((Component)this.jLExe, "Center");
        this.jLExe.setPreferredSize(new Dimension(93, 25));
        this.jLExe.setHorizontalAlignment(0);
        this.jLExe.setText("aAbBcCdDeEfFgG");
        this.panelEstilo.setPreferredSize(new Dimension(100, 10));
        this.panelEstilo.setLayout(null);
        this.jCBItalico.setFont(new Font("Dialog", 2, 13));
        this.jCBItalico.setText("It\u00e1lico");
        this.jCBItalico.setBounds(new Rectangle(4, 4, 88, 22));
        this.jCBItalico.addChangeListener(this);
        this.jCBNegrito.setFont(new Font("Dialog", 1, 13));
        this.jCBNegrito.setSelected(false);
        this.jCBNegrito.setText("Negrito");
        this.jCBNegrito.setBounds(new Rectangle(4, 31, 88, 22));
        this.jCBNegrito.addChangeListener(this);
        this.jLabel1.setToolTipText("");
        this.jLabel1.setText("Tamanho");
        this.jLabel1.setBounds(new Rectangle(8, 57, 66, 14));
        this.panelBotoes.setPreferredSize(new Dimension(170, 10));
        this.panelBotoes.setLayout(new FlowLayout(2, 3, 3));
        this.panelBotoes.add((Component)this.jBOk, null);
        this.panelBotoes.add((Component)this.jBCancelar, null);
        this.jBOk.setMnemonic('O');
        this.jBOk.setText("Ok");
        this.jBOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoFonte.this.ok = true;
                DialogoFonte.this.dispose();
            }
        });
        this.jBCancelar.setMnemonic('C');
        this.jBCancelar.setText("Cancelar");
        this.jBCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoFonte.this.dispose();
            }
        });
        this.panelArea.setBorder(BorderFactory.createEtchedBorder());
        this.panelArea.setLayout(this.borderLayout1);
        this.panelArea.add((Component)this.jPanel1, "South");
        this.panelArea.add((Component)this.panelEstilo, "East");
        this.panelArea.add((Component)this.jSPFontes, "Center");
        this.panelEstilo.add((Component)this.jCBItalico, null);
        this.panelEstilo.add((Component)this.jCBTamanho, null);
        this.panelEstilo.add((Component)this.jCBNegrito, null);
        this.panelEstilo.add((Component)this.jLabel1, null);
        this.jSPFontes.getViewport().setView(this.jLFontes);
        this.jLFontes.addListSelectionListener(this);
        this.jCBTamanho.setBounds(new Rectangle(7, 73, 89, 23));
        for (int i = 3; i <= 100; ++i) {
            this.jCBTamanho.addItem(String.valueOf(i));
        }
        this.jCBTamanho.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (DialogoFonte.this.atualizar) {
                    DialogoFonte.this.setAtributos();
                }
            }
        });
    }

    public void setFonte(Font fonte) {
        if (fonte != null) {
            this.atualizar = false;
            this.jLFontes.setSelectedValue(fonte.getName(), false);
            this.setEstilo(fonte);
            this.jCBTamanho.setSelectedItem(String.valueOf(fonte.getSize()));
            this.jLExe.setFont(fonte);
            this.jLExe.setText(fonte.getName());
            this.atualizar = true;
        }
    }

    public Font getFonte() {
        return new Font((String)this.jLFontes.getSelectedValue(), this.getEstilo(), this.getTamanho());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.atualizar) {
            this.setAtributos();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.atualizar) {
            this.setAtributos();
        }
    }

    public boolean ok() {
        return this.ok;
    }

    private int getTamanho() {
        return Integer.parseInt((String)this.jCBTamanho.getSelectedItem());
    }

    private int getEstilo() {
        return this.jCBItalico.isSelected() ? (this.jCBNegrito.isSelected() ? 3 : 2) : (this.jCBNegrito.isSelected() ? 1 : 0);
    }

    private void setEstilo(Font fonte) {
        this.jCBItalico.setSelected(fonte.isItalic());
        this.jCBNegrito.setSelected(fonte.isBold());
    }

    private String[] getFontes() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    private void setAtributos() {
        this.jLExe.setText((String)this.jLFontes.getSelectedValue());
        this.jLExe.setFont(new Font(this.jLExe.getText(), this.getEstilo(), this.getTamanho()));
    }
}

