/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.HashList;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DialogoFiltro
extends JDialog
implements ActionListener,
DisposeListener,
ComponentListener {
    JScrollPane scrollFiltro = new JScrollPane();
    JPanel painelLocalizar = new JPanel(null);
    JLabel lblLocalizar = new JLabel("Localizar:");
    TTextField txtLocalizar = new TTextField();
    JButton btnSelecionar = new JButton("Selecionar");
    TabelaModelada tabela;
    JPanel panelFiltro = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createEtchedBorder());
    JComboBox comboCamposFiltro = new JComboBox();
    JComboBox comboFiltro = new JComboBox<String>(new String[]{"inicie com", "termine com", "contenha", "seja igual a"});
    TTextField textFiltro = new TTextField();
    protected JButton buttonFiltro = new JButton("Filtrar");
    protected JButton buttonMarcarTodos = new JButton("Marcar todos");
    protected JButton buttonDesmarcarTodos = new JButton("Desmarcar todos");
    protected JButton buttonOk = new JButton("OK");
    protected JButton buttonCancelar = new JButton("Cancelar");
    protected boolean ok = false;
    private String[] campos = null;
    private String[] colunas = null;

    public static DialogoFiltro novaInstancia(Object pai, String titulo) {
        if (pai instanceof Frame) {
            return new DialogoFiltro((Frame)pai, titulo, true);
        }
        if (pai instanceof Dialog) {
            return new DialogoFiltro((Dialog)pai, titulo, true);
        }
        return null;
    }

    public DialogoFiltro(Frame pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public DialogoFiltro(Dialog pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonMarcarTodos) {
            this.marcarDesmarcarTodos(true);
        } else if (o == this.buttonDesmarcarTodos) {
            this.marcarDesmarcarTodos(false);
        } else if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.setVisible(false);
        } else if (o == this.buttonFiltro) {
            this.filtrar();
        }
    }

    public boolean ok() {
        return this.ok;
    }

    protected void filtrar() {
        if (this.campos != null && this.colunas != null && this.campos.length == this.colunas.length && this.comboCamposFiltro.getSelectedIndex() > -1) {
            String string = this.campos[this.comboCamposFiltro.getSelectedIndex()];
        }
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro) {
        this.setDados(null, tabela, campos, colunas, tamanhoColunas, filtro, false, 0, true);
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, int colunaOrdenacao) {
        this.setDados(null, tabela, campos, colunas, tamanhoColunas, filtro, false, colunaOrdenacao, true);
    }

    public void setDados(Map<Integer, String[]> selecionados, String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro) {
        this.setDados(selecionados, tabela, campos, colunas, tamanhoColunas, filtro, false, 0, true);
    }

    public void setDados(Map<Integer, String[]> selecionados, String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, int colunaOrdenacao) {
        this.setDados(selecionados, tabela, campos, colunas, tamanhoColunas, filtro, false, colunaOrdenacao, true);
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, boolean considerarComoSelect) {
        this.setDados(null, tabela, campos, colunas, tamanhoColunas, filtro, considerarComoSelect, 0, true);
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, boolean considerarComoSelect, int colunaOrdenacao) {
        this.setDados(null, tabela, campos, colunas, tamanhoColunas, filtro, considerarComoSelect, colunaOrdenacao, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDados(Map<Integer, String[]> selecionados, String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, String filtro, boolean considerarComoSelect, int colunaOrdenacao, boolean executarAoAbrir) {
        if (tabela != null && campos != null && colunas != null && tamanhoColunas != null && campos.length == colunas.length && campos.length == tamanhoColunas.length) {
            Statement st;
            block22: {
                this.campos = campos;
                this.colunas = colunas;
                st = Conexao.getStatement();
                this.comboCamposFiltro.removeAllItems();
                for (String s : colunas) {
                    this.comboCamposFiltro.addItem(s);
                }
                try {
                    if (st == null) break block22;
                    StringBuilder bui = new StringBuilder();
                    if (!considerarComoSelect) {
                        bui.append("select ");
                        for (int i = 0; i < campos.length; ++i) {
                            if (i > 0) {
                                bui.append(", ");
                            }
                            bui.append(campos[i]);
                        }
                        bui.append(" from ");
                        bui.append(tabela);
                    } else {
                        bui.append(tabela);
                    }
                    if (!Funcoes.textoVazio(filtro)) {
                        bui.append(" where ");
                        bui.append(filtro);
                    }
                    if (tabela.equalsIgnoreCase("filiais_postocoleta") && !Variaveis.filiaisPermitidas.isEmpty()) {
                        if (bui.indexOf(" where ") < 0) {
                            bui.append(" where ");
                        } else {
                            bui.append(" and ");
                        }
                        StringBuilder tmp = new StringBuilder(" fil_codigo in (");
                        for (int i = 0; i < Variaveis.filiaisPermitidas.size(); ++i) {
                            int filial = Variaveis.filiaisPermitidas.get(i);
                            if (i > 0 && i <= Variaveis.filiaisPermitidas.size() - 1) {
                                tmp.append(",");
                            }
                            tmp.append(filial);
                        }
                        tmp.append(")");
                        bui.append((CharSequence)tmp);
                    }
                    ArrayList<Object[]> array = new ArrayList<Object[]>();
                    if (executarAoAbrir) {
                        List<Object> sel;
                        ResultSet res = Conexao.executeQuery(st, bui.toString());
                        Object[] linha = new Object[]{};
                        Integer[] chaves = selecionados == null ? new Integer[]{} : selecionados.keySet().toArray(new Integer[selecionados.keySet().size()]);
                        List<Object> list = sel = selecionados == null ? new ArrayList() : Item.getItens(chaves, selecionados);
                        while (res.next()) {
                            linha = new Object[campos.length + 1];
                            for (int i = 0; i < campos.length; ++i) {
                                Object tmp = res.getObject(campos[i]) instanceof Timestamp ? new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(res.getTimestamp(campos[i])) : (res.getObject(campos[i]) instanceof Date ? Funcoes.formataData(res.getDate(campos[i])) : res.getObject(campos[i]));
                                linha[i] = tmp == null ? "" : tmp;
                            }
                            linha[linha.length - 1] = sel.contains(Item.getItem(chaves, linha)) ? Boolean.TRUE : Boolean.FALSE;
                            array.add(linha);
                        }
                    }
                    final ArrayList<String> cols = new ArrayList<String>();
                    for (String c : colunas) {
                        cols.add(c);
                    }
                    cols.add("");
                    TabelaModelada tab = new TabelaModelada(cols){

                        @Override
                        public boolean isCellEditable(int row, int col) {
                            return cols.size() == col + 1;
                        }

                        public Class getColumnClass(int col) {
                            return this.getValueAt(0, col).getClass();
                        }
                    };
                    tab.setSortedData(array, colunaOrdenacao);
                    tab.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            TabelaModelada tabela = (TabelaModelada)e.getSource();
                            if (e.getKeyCode() == 32) {
                                int row = tabela.getSelectedRow();
                                int lastcol = tabela.getColumnCount() - 1;
                                if (row >= 0 && tabela.getSelectedColumn() != lastcol) {
                                    Boolean valor = (Boolean)tabela.getValueAt(row, lastcol);
                                    valor = new Boolean(valor == false);
                                    tabela.setValueAt(valor, row, lastcol);
                                }
                            }
                        }
                    });
                    TableColumnModel colModel = tab.getColumnModel();
                    if (colModel.getColumnCount() == tamanhoColunas.length + 1) {
                        for (int i = 0; i < tamanhoColunas.length; ++i) {
                            if (tamanhoColunas[i] <= 0) continue;
                            colModel.getColumn(i).setPreferredWidth(tamanhoColunas[i]);
                            colModel.getColumn(i).setMinWidth(tamanhoColunas[i]);
                            colModel.getColumn(i).setMaxWidth(tamanhoColunas[i]);
                        }
                        colModel.getColumn(tamanhoColunas.length).setPreferredWidth(20);
                        colModel.getColumn(tamanhoColunas.length).setMinWidth(20);
                        colModel.getColumn(tamanhoColunas.length).setMaxWidth(20);
                    }
                    tab.getTableHeader().setReorderingAllowed(false);
                    tab.setAutoResizeMode(3);
                    this.scrollFiltro.setViewportView(tab);
                    this.tabela = tab;
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoFiltro: 233");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    public void setDados(Map<Integer, String[]> selecionados, String[] campos, String[] colunas, int[] tamanhoColunas, ArrayList<Object[]> consultaFixa, int colunaOrdenacao) {
        if (campos != null && colunas != null && tamanhoColunas != null && campos.length == colunas.length && campos.length == tamanhoColunas.length) {
            this.campos = campos;
            this.colunas = colunas;
            this.comboCamposFiltro.removeAllItems();
            for (String s : colunas) {
                this.comboCamposFiltro.addItem(s);
            }
            try {
                if (consultaFixa != null) {
                    Integer[] chaves = selecionados == null ? new Integer[]{} : selecionados.keySet().toArray(new Integer[selecionados.keySet().size()]);
                    List<Object> sel = selecionados == null ? new ArrayList() : Item.getItens(chaves, selecionados);
                    ArrayList<Object[]> array = new ArrayList<Object[]>();
                    for (Object[] o : consultaFixa) {
                        Object[] linha = ArraysUtil.concatenar(o, new Object[1]);
                        linha[linha.length - 1] = sel.contains(Item.getItem(chaves, linha)) ? Boolean.TRUE : Boolean.FALSE;
                        array.add(linha);
                    }
                    final ArrayList<Object> cols = new ArrayList<Object>();
                    for (String c : colunas) {
                        cols.add(c);
                    }
                    cols.add("");
                    TabelaModelada tab = new TabelaModelada(cols){

                        @Override
                        public boolean isCellEditable(int row, int col) {
                            return cols.size() == col + 1;
                        }

                        public Class getColumnClass(int col) {
                            return this.getValueAt(0, col).getClass();
                        }
                    };
                    tab.setSortedData(array, colunaOrdenacao);
                    TableColumnModel colModel = tab.getColumnModel();
                    if (colModel.getColumnCount() == tamanhoColunas.length + 1) {
                        for (int i = 0; i < tamanhoColunas.length; ++i) {
                            if (tamanhoColunas[i] <= 0) continue;
                            colModel.getColumn(i).setPreferredWidth(tamanhoColunas[i]);
                            colModel.getColumn(i).setMinWidth(tamanhoColunas[i]);
                            colModel.getColumn(i).setMaxWidth(tamanhoColunas[i]);
                        }
                        colModel.getColumn(tamanhoColunas.length).setPreferredWidth(20);
                        colModel.getColumn(tamanhoColunas.length).setMinWidth(20);
                        colModel.getColumn(tamanhoColunas.length).setMaxWidth(20);
                    }
                    tab.getTableHeader().setReorderingAllowed(false);
                    tab.setAutoResizeMode(3);
                    this.scrollFiltro.setViewportView(tab);
                    this.tabela = tab;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoFiltro: 422");
            }
        }
    }

    public String[] getSelecionados(int coluna) {
        ArrayList<String> array = new ArrayList<String>();
        TableModel model = this.tabela.getModel();
        if (coluna > -1 && coluna < model.getColumnCount()) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!((Boolean)model.getValueAt(i, model.getColumnCount() - 1)).booleanValue()) continue;
                array.add(model.getValueAt(i, coluna).toString());
            }
        }
        return array.toArray(new String[array.size()]);
    }

    public String[] getNaoSelecionados(int coluna) {
        ArrayList<String> array = new ArrayList<String>();
        TableModel model = this.tabela.getModel();
        if (coluna > -1 && coluna < model.getColumnCount()) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (((Boolean)model.getValueAt(i, model.getColumnCount() - 1)).booleanValue()) continue;
                array.add(model.getValueAt(i, coluna).toString());
            }
        }
        return array.toArray(new String[array.size()]);
    }

    protected void marcarDesmarcarTodos(boolean valor) {
        TableModel model = this.tabela.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            model.setValueAt(new Boolean(valor), i, model.getColumnCount() - 1);
        }
    }

    public void setMostrarFiltro(boolean b) {
        this.panelFiltro.setVisible(b);
    }

    private void iniciar() {
        this.setName("DialogoFiltro");
        JPanel panelBarra = new JPanel(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scrollFiltro, "Center");
        this.getContentPane().add((Component)panelBarra, "South");
        this.getContentPane().add((Component)this.panelFiltro, "North");
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        this.comboCamposFiltro.setPreferredSize(new Dimension(130, 23));
        this.panelFiltro.add((Component)this.comboCamposFiltro, gb);
        this.comboCamposFiltro.setName("comboCamposFiltro");
        gb.gridx = 1;
        this.comboFiltro.setPreferredSize(new Dimension(120, 23));
        this.panelFiltro.add((Component)this.comboFiltro, gb);
        this.comboFiltro.setName("comboFiltro");
        gb.gridx = 3;
        this.panelFiltro.add((Component)this.buttonFiltro, gb);
        this.buttonFiltro.setName("buttonFiltro");
        gb.gridx = 2;
        gb.weightx = 1.0;
        gb.fill = 2;
        this.textFiltro.setPreferredSize(new Dimension(50, 23));
        this.textFiltro.setName("textFiltro");
        this.panelFiltro.add((Component)this.textFiltro, gb);
        panelBarra.setBorder(BorderFactory.createEtchedBorder());
        panelBarra.setPreferredSize(new Dimension(10, 65));
        panelBarra.setLayout(new BorderLayout());
        JPanel panelBarraSouth = new JPanel(new BorderLayout());
        panelBarra.add((Component)panelBarraSouth, "South");
        this.painelLocalizar = new JPanel(new GridBagLayout());
        this.painelLocalizar.setPreferredSize(new Dimension(50, 40));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(0, 5, 5, 0);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.painelLocalizar.add((Component)this.lblLocalizar, c);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        this.txtLocalizar.setPreferredSize(new Dimension(50, 23));
        this.painelLocalizar.add((Component)this.txtLocalizar, c);
        this.txtLocalizar.setName("txtLocalizar");
        c.insets = new Insets(0, 5, 5, 5);
        c.weightx = 0.0;
        c.fill = 0;
        c.gridx = 2;
        c.gridy = 0;
        this.painelLocalizar.add((Component)this.btnSelecionar, c);
        this.btnSelecionar.setName("btnSelecionar");
        panelBarra.add((Component)this.painelLocalizar, "North");
        JPanel panelTmp = new JPanel(new FlowLayout(0, 3, 3));
        panelBarraSouth.add((Component)panelTmp, "West");
        panelTmp.setPreferredSize(new Dimension(300, 30));
        panelTmp.add(this.buttonDesmarcarTodos);
        panelTmp.add(this.buttonMarcarTodos);
        panelTmp = new JPanel(new FlowLayout(2, 3, 3));
        panelBarraSouth.add((Component)panelTmp, "East");
        panelTmp.setPreferredSize(new Dimension(200, 10));
        panelTmp.add(this.buttonOk);
        panelTmp.add(this.buttonCancelar);
        this.buttonDesmarcarTodos.addActionListener(this);
        this.buttonDesmarcarTodos.setName("buttonDesmarcarTodos");
        this.buttonMarcarTodos.addActionListener(this);
        this.buttonMarcarTodos.setName("buttonMarcarTodos");
        this.buttonOk.addActionListener(this);
        this.buttonOk.setName("buttonOk");
        this.buttonCancelar.addActionListener(this);
        this.buttonCancelar.setName("buttonCancelar");
        this.btnSelecionar.setName("btnSelecionar");
        this.btnSelecionar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = DialogoFiltro.this.tabela.getSelectedRow();
                int lastcol = DialogoFiltro.this.tabela.getColumnCount() - 1;
                if (row >= 0 && row < DialogoFiltro.this.tabela.getRowCount() && DialogoFiltro.this.tabela.getColumnClass(lastcol) == Boolean.class) {
                    Boolean valor = (Boolean)DialogoFiltro.this.tabela.getValueAt(row, lastcol);
                    valor = new Boolean(valor == false);
                    DialogoFiltro.this.tabela.setValueAt(valor, row, lastcol);
                }
                ScreenUtil.requisitarFoco(DialogoFiltro.this.txtLocalizar);
            }
        });
        this.btnSelecionar.setMnemonic('S');
        this.btnSelecionar.setToolTipText("Bot\u00e3o que alterna a marca\u00e7\u00e3o da linha selecionada na tabela");
        this.setSize(new Dimension(500, 480));
        this.lblLocalizar.setDisplayedMnemonic('L');
        this.lblLocalizar.setLabelFor(this.txtLocalizar);
        Funcoes.montaEnter((JComponent)this.painelLocalizar);
        ScreenUtil.addDocumentListener(this.txtLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                DialogoFiltro.this.localizar(DialogoFiltro.this.txtLocalizar.getText());
            }
        });
        this.txtLocalizar.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DialogoFiltro.this.txtLocalizar.selectAll();
            }
        });
        this.txtLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getKeyCode() == 38 || e.getKeyCode() == 40) && DialogoFiltro.this.tabela.getRowCount() > 0) {
                    DialogoFiltro.this.tabela.grabFocus();
                }
            }
        });
        this.buttonCancelar.setMnemonic('C');
        this.buttonDesmarcarTodos.setMnemonic('D');
        this.buttonMarcarTodos.setMnemonic('M');
        this.buttonOk.setMnemonic('O');
        this.buttonFiltro.addActionListener(this);
        this.setMostrarFiltro(false);
        this.addComponentListener(this);
    }

    private void localizar(String valor) {
        Object cell;
        String prefix = valor.toLowerCase();
        int column = this.tabela.getColunaOrdenada();
        int rows = this.tabela.getRowCount();
        for (int i = 0; i < rows && ((cell = this.tabela.getValueAt(i, column)) instanceof String || cell instanceof Integer); ++i) {
            String value = cell.toString().toLowerCase();
            if (!value.startsWith(prefix)) continue;
            this.tabela.setRowSelectionInterval(i, i);
            TableUtil.scrollToCenter(this.tabela, i);
            break;
        }
    }

    public int getQtdeRegistros() {
        return this.tabela != null ? this.tabela.getRowCount() : 0;
    }

    public void setDados(Map<Integer, String[]> selecionados, Object[] arrayDados, String[] campos, String[] colunas, int[] tamanhoColunas) {
        this.campos = campos;
        this.colunas = colunas;
        this.comboCamposFiltro.removeAllItems();
        for (String s : colunas) {
            this.comboCamposFiltro.addItem(s);
        }
        try {
            ArrayList<Object[]> array = new ArrayList<Object[]>();
            Object[] linha = new Object[]{};
            Integer[] chaves = selecionados == null ? new Integer[]{} : selecionados.keySet().toArray(new Integer[selecionados.keySet().size()]);
            List<Object> sel = selecionados == null ? new ArrayList() : Item.getItens(chaves, selecionados);
            for (int i = 0; i < arrayDados.length; ++i) {
                linha = new Object[campos.length];
                Object tmp = arrayDados[i];
                linha[0] = tmp == null ? "" : tmp;
                linha[linha.length - 1] = sel.contains(Item.getItem(chaves, linha)) ? Boolean.TRUE : Boolean.FALSE;
                array.add(linha);
            }
            final ArrayList<String> cols = new ArrayList<String>();
            for (String c : colunas) {
                cols.add(c);
            }
            TabelaModelada tab = new TabelaModelada(cols){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return cols.size() == col + 1;
                }

                public Class getColumnClass(int col) {
                    return this.getValueAt(0, col).getClass();
                }
            };
            tab.setSortedData(array, 0);
            tab.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    TabelaModelada tabela = (TabelaModelada)e.getSource();
                    if (e.getKeyCode() == 32) {
                        int row = tabela.getSelectedRow();
                        int lastcol = tabela.getColumnCount() - 1;
                        if (row >= 0 && tabela.getSelectedColumn() != lastcol) {
                            Boolean valor = (Boolean)tabela.getValueAt(row, lastcol);
                            valor = new Boolean(valor == false);
                            tabela.setValueAt(valor, row, lastcol);
                        }
                    }
                }
            });
            TableColumnModel colModel = tab.getColumnModel();
            if (colModel.getColumnCount() == tamanhoColunas.length) {
                for (int i = 0; i < tamanhoColunas.length; ++i) {
                    if (tamanhoColunas[i] <= 0) continue;
                    colModel.getColumn(i).setPreferredWidth(tamanhoColunas[i]);
                    colModel.getColumn(i).setMinWidth(tamanhoColunas[i]);
                    colModel.getColumn(i).setMaxWidth(tamanhoColunas[i]);
                }
                colModel.getColumn(tamanhoColunas.length - 1).setPreferredWidth(20);
                colModel.getColumn(tamanhoColunas.length - 1).setMinWidth(20);
                colModel.getColumn(tamanhoColunas.length - 1).setMaxWidth(20);
            }
            tab.getTableHeader().setReorderingAllowed(false);
            tab.setAutoResizeMode(3);
            this.scrollFiltro.setViewportView(tab);
            this.tabela = tab;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoFiltro: 233");
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        ScreenUtil.requisitarFoco(this.txtLocalizar);
    }

    private static class Item {
        String[] itens = new String[0];

        private Item(String[] array) {
            if (array != null) {
                this.itens = new String[array.length];
                for (int i = 0; i < array.length; ++i) {
                    this.itens[i] = String.valueOf(array[i]);
                }
            }
        }

        public static List<Item> getItens(Integer[] chaves, Map<Integer, String[]> map) {
            HashList<Item> lista = new HashList<Item>();
            ArrayList<String[]> tmp = new ArrayList<String[]>();
            for (Integer chave : chaves) {
                tmp.add(map.get(chave));
            }
            String[][] str = (String[][])tmp.toArray((T[])new String[tmp.size()][]);
            String[] aux = new String[str.length];
            if (str.length > 0) {
                for (int col = 0; col < str[0].length; ++col) {
                    for (int lin = 0; lin < str.length; ++lin) {
                        aux[lin] = str[lin][col];
                    }
                    lista.add(new Item(aux));
                }
            }
            return lista;
        }

        public static Item getItem(Integer[] chaves, Object[] list) {
            String[] tmp = new String[chaves.length];
            for (int i = 0; i < chaves.length; ++i) {
                tmp[i] = String.valueOf(list[chaves[i]]);
            }
            return new Item(tmp);
        }

        public boolean equals(Object o) {
            boolean igual = false;
            if (o instanceof Item && ((Item)o).itens.length == this.itens.length) {
                igual = true;
                String[] tmp = ((Item)o).itens;
                for (int i = 0; i < tmp.length && igual; ++i) {
                    if (tmp[i].equalsIgnoreCase(this.itens[i])) continue;
                    igual = false;
                }
            }
            return igual;
        }

        public int hashCode() {
            int hash = 0;
            for (String s : this.itens) {
                hash += s.hashCode();
            }
            return hash;
        }
    }
}

