/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class DialogoCor
extends JDialog
implements DisposeListener {
    JPanel panelBarra = new JPanel();
    JPanel panelBotoes = new JPanel();
    JButton jBCancelar = new JButton();
    JButton jBOk = new JButton();
    JColorChooser jCCCores = new JColorChooser();
    private boolean ok = false;

    public static DialogoCor novaInstancia(Object pai, String titulo) {
        if (pai instanceof Frame) {
            return new DialogoCor((Frame)pai, titulo, true);
        }
        if (pai instanceof Dialog) {
            return new DialogoCor((Dialog)pai, titulo, true);
        }
        return null;
    }

    public DialogoCor(Frame pai, String title, boolean modal) {
        super(pai, title, modal);
        this.iniciar();
    }

    public DialogoCor(Dialog pai, String title, boolean modal) {
        super(pai, title, modal);
        try {
            this.iniciar();
            if (pai != null) {
                this.setLocation(ScreenUtil.getCentralizado(pai.getBounds(), this.getSize()));
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(pai, ex.getMessage(), ex.getStackTrace(), "DialogoCor: 68");
        }
    }

    public Color getCor() {
        return this.jCCCores.getColor();
    }

    public void setCor(Color cor) {
        this.jCCCores.setColor(cor);
    }

    public boolean ok() {
        return this.ok;
    }

    private void iniciar() {
        if (Laboratorio.getInstancia() != null) {
            Laboratorio.getInstancia().addDisposeListener(this);
        }
        this.setSize(new Dimension(450, 324));
        this.getContentPane().add((Component)this.jCCCores, "Center");
        this.getContentPane().add((Component)this.panelBarra, "South");
        this.panelBarra.setLayout(new BorderLayout());
        this.panelBarra.setPreferredSize(new Dimension(10, 35));
        this.panelBarra.setBorder(BorderFactory.createEtchedBorder());
        this.panelBarra.add((Component)this.panelBotoes, "East");
        this.panelBotoes.setPreferredSize(new Dimension(170, 10));
        this.panelBotoes.setLayout(new FlowLayout(2, 3, 3));
        this.panelBotoes.add((Component)this.jBOk, null);
        this.panelBotoes.add((Component)this.jBCancelar, null);
        this.jBOk.setMnemonic('O');
        this.jBOk.setText("Ok");
        this.jBOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoCor.this.ok = true;
                DialogoCor.this.dispose();
            }
        });
        this.jBCancelar.setMnemonic('C');
        this.jBCancelar.setText("Cancelar");
        this.jBCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoCor.this.dispose();
            }
        });
        ScreenUtil.centralizar(this);
    }
}

