/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Hashtable;

public class DadosResultSet {
    Hashtable dados = new Hashtable();

    public DadosResultSet() {
    }

    public DadosResultSet(ResultSet res) {
        this.carregar(res);
    }

    public DadosResultSet carregar(ResultSet res) {
        try {
            ResultSetMetaData meta = res.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                String colNome = meta.getColumnName(i);
                Object colValor = res.getObject(colNome);
                if (colValor == null) continue;
                if (this.tipoData(meta.getColumnType(i))) {
                    colValor = colValor.toString().replace('-', '/');
                }
                this.dados.put(colNome, colValor);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DadosResultSet: 51");
        }
        return this;
    }

    public void limpar() {
        this.dados.clear();
    }

    public Object getValor(String campo) {
        return this.dados.containsKey(campo) ? this.dados.get(campo) : null;
    }

    public String getString(String campo) {
        return this.dados.containsKey(campo) ? this.dados.get(campo).toString() : "";
    }

    public void setValor(String campo, Object valor) {
        if (campo != null && valor != null) {
            if (this.dados.containsKey(campo)) {
                this.dados.remove(campo);
            }
            this.dados.put(campo, valor);
        }
    }

    private boolean tipoData(int i) {
        return i == 91 || i == 92 || i == 93;
    }
}

